/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.glowroot.collector.GaugePoint;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.ConfigService;
import org.glowroot.config.GaugeConfig;
import org.glowroot.config.MBeanAttribute;
import org.glowroot.jvm.Availability;
import org.glowroot.jvm.HeapDumps;
import org.glowroot.jvm.LazyPlatformMBeanServer;
import org.glowroot.jvm.OptionalService;
import org.glowroot.jvm.ThreadAllocatedBytes;
import org.glowroot.local.store.GaugePointDao;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.Gauge;
import org.glowroot.local.ui.GaugePointRequest;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.MBeanAttributeMapRequest;
import org.glowroot.local.ui.MBeanTreeRequest;
import org.glowroot.local.ui.ObjectNames;
import org.glowroot.local.ui.POST;
import org.glowroot.local.ui.QueryStrings;
import org.glowroot.local.ui.RequestWithDirectory;
import org.glowroot.markers.UsedByJsonBinding;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Splitter;
import org.glowroot.shaded.google.common.base.StandardSystemProperty;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.io.CharStreams;
import org.glowroot.shaded.google.common.primitives.Ints;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class JvmJsonService {
    private static final Logger logger = LoggerFactory.getLogger(JvmJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create();
    private static final Ordering<ThreadInfo> threadInfoOrdering = new Ordering<ThreadInfo>(){

        @Override
        public int compare(@Nullable ThreadInfo left, @Nullable ThreadInfo right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            if (left.getThreadId() == Thread.currentThread().getId()) {
                return 1;
            }
            if (right.getThreadId() == Thread.currentThread().getId()) {
                return -1;
            }
            int result = Ints.compare(right.getStackTrace().length, left.getStackTrace().length);
            if (result == 0) {
                return left.getThreadName().compareToIgnoreCase(right.getThreadName());
            }
            return result;
        }
    };
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;
    private final GaugePointDao gaugePointDao;
    private final ConfigService configService;
    private final OptionalService<ThreadAllocatedBytes> threadAllocatedBytes;
    private final OptionalService<HeapDumps> heapDumps;
    @Nullable
    private final String processId;
    private final long fixedGaugeIntervalMillis;
    private final long fixedGaugeRollupMillis;

    JvmJsonService(LazyPlatformMBeanServer lazyPlatformMBeanServer, GaugePointDao gaugePointDao, ConfigService configService, OptionalService<ThreadAllocatedBytes> threadAllocatedBytes, OptionalService<HeapDumps> heapDumps, @Nullable String processId, long fixedGaugeIntervalSeconds, long fixedGaugeRollupSeconds) {
        this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
        this.gaugePointDao = gaugePointDao;
        this.configService = configService;
        this.threadAllocatedBytes = threadAllocatedBytes;
        this.heapDumps = heapDumps;
        this.processId = processId;
        this.fixedGaugeIntervalMillis = fixedGaugeIntervalSeconds * 1000L;
        this.fixedGaugeRollupMillis = fixedGaugeRollupSeconds * 1000L;
    }

    @GET(value="/backend/jvm/gauge-points")
    String getGaugePoints(String queryString) throws Exception {
        GaugePointRequest request = QueryStrings.decode(queryString, GaugePointRequest.class);
        double gapMillis = request.rollupLevel() == 0 ? (double)this.fixedGaugeIntervalMillis * 1.5 : (double)this.fixedGaugeRollupMillis * 1.5;
        ArrayList<List<Number[]>> series = Lists.newArrayList();
        for (String gaugeName : request.gaugeNames()) {
            ImmutableList<GaugePoint> gaugePoints = this.gaugePointDao.readGaugePoints(gaugeName, request.from(), request.to(), request.rollupLevel());
            series.add(JvmJsonService.convertToDataSeriesWithGaps(gaugePoints, gapMillis));
        }
        return mapper.writeValueAsString(series);
    }

    @GET(value="/backend/jvm/all-gauges")
    String getAllGaugeNames() throws IOException {
        ArrayList<Gauge> gauges = Lists.newArrayList();
        for (GaugeConfig gaugeConfig : this.configService.getGaugeConfigs()) {
            for (MBeanAttribute mbeanAttribute : gaugeConfig.mbeanAttributes()) {
                gauges.add(Gauge.of(gaugeConfig.mbeanObjectName() + "," + mbeanAttribute.name(), mbeanAttribute.everIncreasing(), gaugeConfig.display() + '/' + mbeanAttribute.name()));
            }
        }
        ImmutableList sortedGauges = Gauge.ordering.immutableSortedCopy(gauges);
        return mapper.writeValueAsString(sortedGauges);
    }

    @GET(value="/backend/jvm/mbean-tree")
    String getMBeanTree(String queryString) throws Exception {
        MBeanTreeRequest request = QueryStrings.decode(queryString, MBeanTreeRequest.class);
        Set<ObjectName> objectNames = this.lazyPlatformMBeanServer.queryNames(null, null);
        TreeMap<String, MBeanTreeInnerNode> sortedRootNodes = new TreeMap<String, MBeanTreeInnerNode>(String.CASE_INSENSITIVE_ORDER);
        for (ObjectName objectName : objectNames) {
            String domain = objectName.getDomain();
            MBeanTreeInnerNode node = (MBeanTreeInnerNode)sortedRootNodes.get(domain);
            if (node == null) {
                node = new MBeanTreeInnerNode(domain);
                sortedRootNodes.put(domain, node);
            }
            List<String> propertyValues = ObjectNames.getPropertyValues(objectName);
            for (int i = 0; i < propertyValues.size() - 1; ++i) {
                node = node.getOrCreateNode(propertyValues.get(i));
            }
            String name = objectName.toString();
            String value = propertyValues.get(propertyValues.size() - 1);
            if (((ImmutableList)request.expanded()).contains(name)) {
                Map<String, Object> sortedAttributeMap = this.getMBeanSortedAttributeMap(objectName);
                node.addLeafNode(new MBeanTreeLeafNode(value, name, true, sortedAttributeMap));
                continue;
            }
            node.addLeafNode(new MBeanTreeLeafNode(value, name, false, null));
        }
        return mapper.writeValueAsString(sortedRootNodes);
    }

    @GET(value="/backend/jvm/mbean-attribute-map")
    String getMBeanAttributeMap(String queryString) throws Exception {
        MBeanAttributeMapRequest request = QueryStrings.decode(queryString, MBeanAttributeMapRequest.class);
        ObjectName objectName = ObjectName.getInstance(request.objectName());
        Map<String, Object> attributeMap = this.getMBeanSortedAttributeMap(objectName);
        return mapper.writeValueAsString(attributeMap);
    }

    @POST(value="/backend/jvm/perform-gc")
    void performGC() throws IOException {
        ManagementFactory.getMemoryMXBean().gc();
    }

    @GET(value="/backend/jvm/thread-dump")
    String getThreadDump() throws IOException {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), Integer.MAX_VALUE);
        ImmutableList<ThreadInfo> sortedThreadInfos = threadInfoOrdering.immutableSortedCopy(Arrays.asList(threadInfos));
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartArray();
        long currentThreadId = Thread.currentThread().getId();
        for (ThreadInfo threadInfo : sortedThreadInfos) {
            jg.writeStartObject();
            jg.writeStringField("name", threadInfo.getThreadName());
            jg.writeStringField("state", threadInfo.getThreadState().name());
            jg.writeStringField("lockName", threadInfo.getLockName());
            jg.writeArrayFieldStart("stackTrace");
            boolean trimCurrentThreadStack = threadInfo.getThreadId() == currentThreadId;
            for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
                if (trimCurrentThreadStack && !stackTraceElement.getClassName().equals(JvmJsonService.class.getName())) continue;
                trimCurrentThreadStack = false;
                jg.writeString(stackTraceElement.toString());
            }
            jg.writeEndArray();
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/jvm/heap-dump-defaults")
    String getHeapDumpDefaults() throws Exception {
        String heapDumpPath = JvmJsonService.getHeapDumpPathFromCommandLine();
        if (Strings.isNullOrEmpty(heapDumpPath)) {
            String javaTempDir = MoreObjects.firstNonNull(StandardSystemProperty.JAVA_IO_TMPDIR.value(), ".");
            heapDumpPath = new File(javaTempDir).getAbsolutePath();
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeStringField("directory", heapDumpPath);
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @POST(value="/backend/jvm/check-disk-space")
    String checkDiskSpace(String content) throws IOException {
        RequestWithDirectory request = mapper.readValue(content, RequestWithDirectory.class);
        File dir = new File(request.directory());
        if (!dir.exists()) {
            return "{\"error\": \"Directory doesn't exist\"}";
        }
        if (!dir.isDirectory()) {
            return "{\"error\": \"Path is not a directory\"}";
        }
        long diskSpace = new File(request.directory()).getFreeSpace();
        return Long.toString(diskSpace);
    }

    @POST(value="/backend/jvm/dump-heap")
    String dumpHeap(String content) throws Exception {
        HeapDumps service = Preconditions.checkNotNull(this.heapDumps.getService(), "Heap dump service is not available: %s", this.heapDumps.getAvailability().getReason());
        RequestWithDirectory request = mapper.readValue(content, RequestWithDirectory.class);
        File dir = new File(request.directory());
        if (!dir.exists()) {
            return "{\"error\": \"Directory doesn't exist\"}";
        }
        if (!dir.isDirectory()) {
            return "{\"error\": \"Path is not a directory\"}";
        }
        String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        File file = new File(dir, "heap-dump-" + timestamp + ".hprof");
        int i = 1;
        while (file.exists()) {
            file = new File(dir, "heap-dump-" + timestamp + "-" + ++i + ".hprof");
        }
        service.dumpHeap(file.getAbsolutePath());
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeStringField("filename", file.getAbsolutePath());
        jg.writeNumberField("size", file.length());
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/jvm/process-info")
    String getProcess() throws Exception {
        int index;
        String command = System.getProperty("sun.java.command");
        String mainClass = null;
        AbstractCollection arguments = ImmutableList.of();
        if (command != null && (index = command.indexOf(32)) > 0) {
            mainClass = command.substring(0, index);
            arguments = Lists.newArrayList(Splitter.on(' ').split(command.substring(index + 1)));
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String jvm = StandardSystemProperty.JAVA_VM_NAME.value() + " (" + StandardSystemProperty.JAVA_VM_VERSION.value() + ", " + System.getProperty("java.vm.info") + ")";
        String java = "version " + StandardSystemProperty.JAVA_VERSION.value() + ", vendor " + StandardSystemProperty.JAVA_VM_VENDOR.value();
        String javaHome = StandardSystemProperty.JAVA_HOME.value();
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeNumberField("startTime", runtimeMXBean.getStartTime());
        jg.writeNumberField("uptime", runtimeMXBean.getUptime());
        jg.writeStringField("pid", MoreObjects.firstNonNull(this.processId, "<unknown>"));
        jg.writeStringField("mainClass", mainClass);
        jg.writeFieldName("mainClassArguments");
        mapper.writeValue(jg, arguments);
        jg.writeStringField("jvm", jvm);
        jg.writeStringField("java", java);
        jg.writeStringField("javaHome", javaHome);
        jg.writeFieldName("jvmArguments");
        mapper.writeValue(jg, runtimeMXBean.getInputArguments());
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/jvm/system-properties")
    String getSystemProperties() throws IOException {
        Properties properties = System.getProperties();
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName;
            String propertyValue;
            Object obj = e.nextElement();
            if (!(obj instanceof String) || (propertyValue = properties.getProperty(propertyName = (String)obj)) == null) continue;
            sortedProperties.put(propertyName, propertyValue);
        }
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartArray();
        for (Map.Entry entry : sortedProperties.entrySet()) {
            jg.writeStartObject();
            jg.writeStringField("name", (String)entry.getKey());
            jg.writeStringField("value", (String)entry.getValue());
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.close();
        return sb.toString();
    }

    @GET(value="/backend/jvm/capabilities")
    String getCapabilities() throws IOException {
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeFieldName("threadCpuTime");
        mapper.writeValue(jg, (Object)JvmJsonService.getThreadCpuTimeAvailability());
        jg.writeFieldName("threadContentionTime");
        mapper.writeValue(jg, (Object)JvmJsonService.getThreadContentionAvailability());
        jg.writeFieldName("threadAllocatedBytes");
        mapper.writeValue(jg, (Object)this.threadAllocatedBytes.getAvailability());
        jg.writeFieldName("heapDump");
        mapper.writeValue(jg, (Object)this.heapDumps.getAvailability());
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    private static List<Number[]> convertToDataSeriesWithGaps(ImmutableList<GaugePoint> gaugePoints, double gapMillis) {
        ArrayList<Number[]> points = Lists.newArrayList();
        GaugePoint lastGaugePoint = null;
        for (GaugePoint gaugePoint : gaugePoints) {
            if (lastGaugePoint != null && (double)(gaugePoint.captureTime() - lastGaugePoint.captureTime()) > gapMillis) {
                points.add(null);
            }
            points.add(new Number[]{gaugePoint.captureTime(), gaugePoint.value()});
            lastGaugePoint = gaugePoint;
        }
        return points;
    }

    private static Availability getThreadCpuTimeAvailability() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadCpuTimeSupported()) {
            return Availability.of(false, "java.lang.management.ThreadMXBean.isThreadCpuTimeSupported() returned false");
        }
        if (!threadMXBean.isThreadCpuTimeEnabled()) {
            return Availability.of(false, "java.lang.management.ThreadMXBean.isThreadCpuTimeEnabled() returned false");
        }
        return Availability.of(true, "");
    }

    private static Availability getThreadContentionAvailability() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadContentionMonitoringSupported()) {
            return Availability.of(false, "java.lang.management.ThreadMXBean.isThreadContentionMonitoringSupported() returned false");
        }
        if (!threadMXBean.isThreadContentionMonitoringEnabled()) {
            return Availability.of(false, "java.lang.management.ThreadMXBean.isThreadContentionMonitoringEnabled() returned false");
        }
        return Availability.of(true, "");
    }

    @Nullable
    private static String getHeapDumpPathFromCommandLine() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMXBean.getInputArguments()) {
            if (!arg.startsWith("-XX:HeapDumpPath=")) continue;
            return arg.substring("-XX:HeapDumpPath=".length());
        }
        return null;
    }

    private Map<String, Object> getMBeanSortedAttributeMap(ObjectName objectName) throws Exception {
        MBeanInfo mBeanInfo = this.lazyPlatformMBeanServer.getMBeanInfo(objectName);
        TreeMap<String, Object> sortedAttributeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (MBeanAttributeInfo attribute : mBeanInfo.getAttributes()) {
            Object value;
            try {
                value = this.lazyPlatformMBeanServer.getAttribute(objectName, attribute.getName());
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
                Throwable rootCause = this.getRootCause(e);
                value = "<" + rootCause.getClass().getName() + ": " + rootCause.getMessage() + ">";
            }
            sortedAttributeMap.put(attribute.getName(), this.getMBeanAttributeValue(value));
        }
        return sortedAttributeMap;
    }

    private Throwable getRootCause(Throwable t) {
        Throwable cause = t.getCause();
        if (cause == null) {
            return t;
        }
        return this.getRootCause(cause);
    }

    @Nullable
    private Object getMBeanAttributeValue(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CompositeData) {
            return this.getCompositeDataValue((CompositeData)value);
        }
        if (value instanceof TabularData) {
            return this.getTabularDataValue((TabularData)value);
        }
        if (value.getClass().isArray()) {
            return this.getArrayValue(value);
        }
        if (value instanceof Number) {
            return value;
        }
        return value.toString();
    }

    private Object getCompositeDataValue(CompositeData compositeData) {
        LinkedHashMap<String, Object> valueMap = Maps.newLinkedHashMap();
        for (String key : compositeData.getCompositeType().keySet()) {
            valueMap.put(key, this.getMBeanAttributeValue(compositeData.get(key)));
        }
        return valueMap;
    }

    private Object getTabularDataValue(TabularData tabularData) {
        LinkedHashMap rowMap = Maps.newLinkedHashMap();
        Set<String> attributeNames = tabularData.getTabularType().getRowType().keySet();
        for (Object key : tabularData.keySet()) {
            List keyList = (List)key;
            String keyString = Joiner.on(", ").join(keyList);
            CompositeData compositeData = tabularData.get(keyList.toArray());
            LinkedHashMap<String, Object> valueMap = Maps.newLinkedHashMap();
            for (String attributeName : attributeNames) {
                valueMap.put(attributeName, this.getMBeanAttributeValue(compositeData.get(attributeName)));
            }
            rowMap.put(keyString, valueMap);
        }
        return rowMap;
    }

    private Object getArrayValue(Object value) {
        int length = Array.getLength(value);
        ArrayList<Object> valueList = Lists.newArrayListWithCapacity(length);
        for (int i = 0; i < length; ++i) {
            Object val = Array.get(value, i);
            valueList.add(this.getMBeanAttributeValue(val));
        }
        return valueList;
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class RequestWithDirectoryBase {
        RequestWithDirectoryBase() {
        }

        abstract String directory();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class MBeanAttributeMapRequestBase {
        MBeanAttributeMapRequestBase() {
        }

        abstract String objectName();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class MBeanTreeRequestBase {
        MBeanTreeRequestBase() {
        }

        public abstract List<String> expanded();
    }

    @UsedByJsonBinding
    static class MBeanTreeLeafNode
    implements MBeanTreeNode {
        private final String nodeName;
        private final String objectName;
        private final boolean expanded;
        @Nullable
        private final Map<String, Object> attributeMap;

        private MBeanTreeLeafNode(String nodeName, String objectName, boolean expanded, @Nullable Map<String, Object> attributeMap) {
            this.nodeName = nodeName;
            this.objectName = objectName;
            this.expanded = expanded;
            this.attributeMap = attributeMap;
        }

        @Override
        public String getNodeName() {
            return this.nodeName;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        @Nullable
        public Map<String, Object> getAttributeMap() {
            return this.attributeMap;
        }
    }

    @UsedByJsonBinding
    static class MBeanTreeInnerNode
    implements MBeanTreeNode {
        private final String name;
        private final List<MBeanTreeNode> childNodes = Lists.newArrayList();
        private final Map<String, MBeanTreeInnerNode> innerNodes = Maps.newHashMap();

        private MBeanTreeInnerNode(String name) {
            this.name = name;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        public List<MBeanTreeNode> getChildNodes() {
            return MBeanTreeNode.ordering.sortedCopy(this.childNodes);
        }

        private MBeanTreeInnerNode getOrCreateNode(String name) {
            MBeanTreeInnerNode innerNode = this.innerNodes.get(name);
            if (innerNode == null) {
                innerNode = new MBeanTreeInnerNode(name);
                this.innerNodes.put(name, innerNode);
                this.childNodes.add(innerNode);
            }
            return innerNode;
        }

        private void addLeafNode(MBeanTreeLeafNode leafNode) {
            this.childNodes.add(leafNode);
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class GaugeBase {
        static final Ordering<Gauge> ordering = new Ordering<Gauge>(){

            @Override
            public int compare(@Nullable Gauge left, @Nullable Gauge right) {
                Preconditions.checkNotNull(left);
                Preconditions.checkNotNull(right);
                return left.display().compareToIgnoreCase(right.display());
            }
        };

        GaugeBase() {
        }

        public abstract String name();

        public abstract boolean everIncreasing();

        public abstract String display();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class GaugePointRequestBase {
        GaugePointRequestBase() {
        }

        abstract long from();

        abstract long to();

        abstract ImmutableList<String> gaugeNames();

        abstract int rollupLevel();
    }

    private static interface MBeanTreeNode {
        public static final Ordering<MBeanTreeNode> ordering = new Ordering<MBeanTreeNode>(){

            @Override
            public int compare(@Nullable MBeanTreeNode left, @Nullable MBeanTreeNode right) {
                Preconditions.checkNotNull(left);
                Preconditions.checkNotNull(right);
                return left.getNodeName().compareToIgnoreCase(right.getNodeName());
            }
        };

        public String getNodeName();
    }
}

