/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AnonymousAccess;
import org.glowroot.local.ui.LayoutBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class Layout
extends LayoutBase {
    private final boolean jvmHeapDump;
    private final String footerMessage;
    private final boolean adminPasswordEnabled;
    private final boolean readOnlyPasswordEnabled;
    private final AnonymousAccess anonymousAccess;
    private final ImmutableList<String> transactionTypes;
    private final String defaultTransactionType;
    private final ImmutableList<String> transactionCustomAttributes;
    private final long fixedAggregateIntervalSeconds;
    private final long fixedAggregateRollupSeconds;
    private final long fixedGaugeIntervalSeconds;
    private final long fixedGaugeRollupSeconds;
    private final String version;

    private Layout(Builder builder) {
        this.jvmHeapDump = builder.jvmHeapDump;
        this.footerMessage = builder.footerMessage;
        this.adminPasswordEnabled = builder.adminPasswordEnabled;
        this.readOnlyPasswordEnabled = builder.readOnlyPasswordEnabled;
        this.anonymousAccess = builder.anonymousAccess;
        this.transactionTypes = builder.transactionTypesBuilder.build();
        this.defaultTransactionType = builder.defaultTransactionType;
        this.transactionCustomAttributes = builder.transactionCustomAttributesBuilder.build();
        this.fixedAggregateIntervalSeconds = builder.fixedAggregateIntervalSeconds;
        this.fixedAggregateRollupSeconds = builder.fixedAggregateRollupSeconds;
        this.fixedGaugeIntervalSeconds = builder.fixedGaugeIntervalSeconds;
        this.fixedGaugeRollupSeconds = builder.fixedGaugeRollupSeconds;
        this.version = Preconditions.checkNotNull(super.version());
    }

    private Layout(Layout original, boolean jvmHeapDump, String footerMessage, boolean adminPasswordEnabled, boolean readOnlyPasswordEnabled, AnonymousAccess anonymousAccess, ImmutableList<String> transactionTypes, String defaultTransactionType, ImmutableList<String> transactionCustomAttributes, long fixedAggregateIntervalSeconds, long fixedAggregateRollupSeconds, long fixedGaugeIntervalSeconds, long fixedGaugeRollupSeconds) {
        this.jvmHeapDump = jvmHeapDump;
        this.footerMessage = footerMessage;
        this.adminPasswordEnabled = adminPasswordEnabled;
        this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
        this.anonymousAccess = anonymousAccess;
        this.transactionTypes = transactionTypes;
        this.defaultTransactionType = defaultTransactionType;
        this.transactionCustomAttributes = transactionCustomAttributes;
        this.fixedAggregateIntervalSeconds = fixedAggregateIntervalSeconds;
        this.fixedAggregateRollupSeconds = fixedAggregateRollupSeconds;
        this.fixedGaugeIntervalSeconds = fixedGaugeIntervalSeconds;
        this.fixedGaugeRollupSeconds = fixedGaugeRollupSeconds;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="jvmHeapDump")
    public boolean jvmHeapDump() {
        return this.jvmHeapDump;
    }

    @Override
    @JsonProperty(value="footerMessage")
    public String footerMessage() {
        return this.footerMessage;
    }

    @Override
    @JsonProperty(value="adminPasswordEnabled")
    public boolean adminPasswordEnabled() {
        return this.adminPasswordEnabled;
    }

    @Override
    @JsonProperty(value="readOnlyPasswordEnabled")
    public boolean readOnlyPasswordEnabled() {
        return this.readOnlyPasswordEnabled;
    }

    @Override
    @JsonProperty(value="anonymousAccess")
    public AnonymousAccess anonymousAccess() {
        return this.anonymousAccess;
    }

    @Override
    @JsonProperty(value="transactionTypes")
    public ImmutableList<String> transactionTypes() {
        return this.transactionTypes;
    }

    @Override
    @JsonProperty(value="defaultTransactionType")
    public String defaultTransactionType() {
        return this.defaultTransactionType;
    }

    @Override
    @JsonProperty(value="transactionCustomAttributes")
    public ImmutableList<String> transactionCustomAttributes() {
        return this.transactionCustomAttributes;
    }

    @Override
    @JsonProperty(value="fixedAggregateIntervalSeconds")
    public long fixedAggregateIntervalSeconds() {
        return this.fixedAggregateIntervalSeconds;
    }

    @Override
    @JsonProperty(value="fixedAggregateRollupSeconds")
    public long fixedAggregateRollupSeconds() {
        return this.fixedAggregateRollupSeconds;
    }

    @Override
    @JsonProperty(value="fixedGaugeIntervalSeconds")
    public long fixedGaugeIntervalSeconds() {
        return this.fixedGaugeIntervalSeconds;
    }

    @Override
    @JsonProperty(value="fixedGaugeRollupSeconds")
    public long fixedGaugeRollupSeconds() {
        return this.fixedGaugeRollupSeconds;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final Layout withJvmHeapDump(boolean value) {
        if (this.jvmHeapDump == value) {
            return this;
        }
        boolean newValue = value;
        return new Layout(this, newValue, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withFooterMessage(String value) {
        if (this.footerMessage == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Layout(this, this.jvmHeapDump, newValue, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withAdminPasswordEnabled(boolean value) {
        if (this.adminPasswordEnabled == value) {
            return this;
        }
        boolean newValue = value;
        return new Layout(this, this.jvmHeapDump, this.footerMessage, newValue, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withReadOnlyPasswordEnabled(boolean value) {
        if (this.readOnlyPasswordEnabled == value) {
            return this;
        }
        boolean newValue = value;
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, newValue, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withAnonymousAccess(AnonymousAccess value) {
        if (this.anonymousAccess == value) {
            return this;
        }
        AnonymousAccess newValue = Preconditions.checkNotNull(value);
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, newValue, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withTransactionTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, newValue, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withTransactionTypes(Iterable<String> elements) {
        if (this.transactionTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, newValue, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withDefaultTransactionType(String value) {
        if (this.defaultTransactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, newValue, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withTransactionCustomAttributes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, newValue, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withTransactionCustomAttributes(Iterable<String> elements) {
        if (this.transactionCustomAttributes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, newValue, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withFixedAggregateIntervalSeconds(long value) {
        if (this.fixedAggregateIntervalSeconds == value) {
            return this;
        }
        long newValue = value;
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, newValue, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withFixedAggregateRollupSeconds(long value) {
        if (this.fixedAggregateRollupSeconds == value) {
            return this;
        }
        long newValue = value;
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, newValue, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
    }

    public final Layout withFixedGaugeIntervalSeconds(long value) {
        if (this.fixedGaugeIntervalSeconds == value) {
            return this;
        }
        long newValue = value;
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, newValue, this.fixedGaugeRollupSeconds);
    }

    public final Layout withFixedGaugeRollupSeconds(long value) {
        if (this.fixedGaugeRollupSeconds == value) {
            return this;
        }
        long newValue = value;
        return new Layout(this, this.jvmHeapDump, this.footerMessage, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.transactionTypes, this.defaultTransactionType, this.transactionCustomAttributes, this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Layout && this.equalTo((Layout)another);
    }

    private boolean equalTo(Layout another) {
        return this.jvmHeapDump == another.jvmHeapDump && this.footerMessage.equals(another.footerMessage) && this.adminPasswordEnabled == another.adminPasswordEnabled && this.readOnlyPasswordEnabled == another.readOnlyPasswordEnabled && this.anonymousAccess.equals((Object)another.anonymousAccess) && this.transactionTypes.equals(another.transactionTypes) && this.defaultTransactionType.equals(another.defaultTransactionType) && this.transactionCustomAttributes.equals(another.transactionCustomAttributes) && this.fixedAggregateIntervalSeconds == another.fixedAggregateIntervalSeconds && this.fixedAggregateRollupSeconds == another.fixedAggregateRollupSeconds && this.fixedGaugeIntervalSeconds == another.fixedGaugeIntervalSeconds && this.fixedGaugeRollupSeconds == another.fixedGaugeRollupSeconds && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.jvmHeapDump);
        h = h * 17 + this.footerMessage.hashCode();
        h = h * 17 + Booleans.hashCode(this.adminPasswordEnabled);
        h = h * 17 + Booleans.hashCode(this.readOnlyPasswordEnabled);
        h = h * 17 + this.anonymousAccess.hashCode();
        h = h * 17 + this.transactionTypes.hashCode();
        h = h * 17 + this.defaultTransactionType.hashCode();
        h = h * 17 + this.transactionCustomAttributes.hashCode();
        h = h * 17 + Longs.hashCode(this.fixedAggregateIntervalSeconds);
        h = h * 17 + Longs.hashCode(this.fixedAggregateRollupSeconds);
        h = h * 17 + Longs.hashCode(this.fixedGaugeIntervalSeconds);
        h = h * 17 + Longs.hashCode(this.fixedGaugeRollupSeconds);
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Layout").add("jvmHeapDump", this.jvmHeapDump).add("footerMessage", this.footerMessage).add("adminPasswordEnabled", this.adminPasswordEnabled).add("readOnlyPasswordEnabled", this.readOnlyPasswordEnabled).add("anonymousAccess", (Object)this.anonymousAccess).add("transactionTypes", this.transactionTypes).add("defaultTransactionType", this.defaultTransactionType).add("transactionCustomAttributes", this.transactionCustomAttributes).add("fixedAggregateIntervalSeconds", this.fixedAggregateIntervalSeconds).add("fixedAggregateRollupSeconds", this.fixedAggregateRollupSeconds).add("fixedGaugeIntervalSeconds", this.fixedGaugeIntervalSeconds).add("fixedGaugeRollupSeconds", this.fixedGaugeRollupSeconds).add("version", this.version).toString();
    }

    @JsonCreator
    public static Layout fromAllAttributes(@JsonProperty(value="jvmHeapDump") @Nullable Boolean jvmHeapDump, @JsonProperty(value="footerMessage") @Nullable String footerMessage, @JsonProperty(value="adminPasswordEnabled") @Nullable Boolean adminPasswordEnabled, @JsonProperty(value="readOnlyPasswordEnabled") @Nullable Boolean readOnlyPasswordEnabled, @JsonProperty(value="anonymousAccess") @Nullable AnonymousAccess anonymousAccess, @JsonProperty(value="transactionTypes") @Nullable ImmutableList<String> transactionTypes, @JsonProperty(value="defaultTransactionType") @Nullable String defaultTransactionType, @JsonProperty(value="transactionCustomAttributes") @Nullable ImmutableList<String> transactionCustomAttributes, @JsonProperty(value="fixedAggregateIntervalSeconds") @Nullable Long fixedAggregateIntervalSeconds, @JsonProperty(value="fixedAggregateRollupSeconds") @Nullable Long fixedAggregateRollupSeconds, @JsonProperty(value="fixedGaugeIntervalSeconds") @Nullable Long fixedGaugeIntervalSeconds, @JsonProperty(value="fixedGaugeRollupSeconds") @Nullable Long fixedGaugeRollupSeconds) {
        Builder builder = Layout.builder();
        if (jvmHeapDump != null) {
            builder.jvmHeapDump(jvmHeapDump);
        }
        if (footerMessage != null) {
            builder.footerMessage(footerMessage);
        }
        if (adminPasswordEnabled != null) {
            builder.adminPasswordEnabled(adminPasswordEnabled);
        }
        if (readOnlyPasswordEnabled != null) {
            builder.readOnlyPasswordEnabled(readOnlyPasswordEnabled);
        }
        if (anonymousAccess != null) {
            builder.anonymousAccess(anonymousAccess);
        }
        if (transactionTypes != null) {
            builder.addAllTransactionTypes(transactionTypes);
        }
        if (defaultTransactionType != null) {
            builder.defaultTransactionType(defaultTransactionType);
        }
        if (transactionCustomAttributes != null) {
            builder.addAllTransactionCustomAttributes(transactionCustomAttributes);
        }
        if (fixedAggregateIntervalSeconds != null) {
            builder.fixedAggregateIntervalSeconds(fixedAggregateIntervalSeconds);
        }
        if (fixedAggregateRollupSeconds != null) {
            builder.fixedAggregateRollupSeconds(fixedAggregateRollupSeconds);
        }
        if (fixedGaugeIntervalSeconds != null) {
            builder.fixedGaugeIntervalSeconds(fixedGaugeIntervalSeconds);
        }
        if (fixedGaugeRollupSeconds != null) {
            builder.fixedGaugeRollupSeconds(fixedGaugeRollupSeconds);
        }
        return builder.build();
    }

    static Layout copyOf(LayoutBase instance) {
        if (instance instanceof Layout) {
            return (Layout)instance;
        }
        return Layout.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1023L;
        private static final long INITIALIZED_BIT_JVM_HEAP_DUMP = 1L;
        private static final long INITIALIZED_BIT_FOOTER_MESSAGE = 2L;
        private static final long INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED = 4L;
        private static final long INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED = 8L;
        private static final long INITIALIZED_BIT_ANONYMOUS_ACCESS = 16L;
        private static final long INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE = 32L;
        private static final long INITIALIZED_BIT_FIXED_AGGREGATE_INTERVAL_SECONDS = 64L;
        private static final long INITIALIZED_BIT_FIXED_AGGREGATE_ROLLUP_SECONDS = 128L;
        private static final long INITIALIZED_BIT_FIXED_GAUGE_INTERVAL_SECONDS = 256L;
        private static final long INITIALIZED_BIT_FIXED_GAUGE_ROLLUP_SECONDS = 512L;
        private long initializedBitset;
        private boolean jvmHeapDump;
        @Nullable
        private String footerMessage;
        private boolean adminPasswordEnabled;
        private boolean readOnlyPasswordEnabled;
        @Nullable
        private AnonymousAccess anonymousAccess;
        private ImmutableList.Builder<String> transactionTypesBuilder = ImmutableList.builder();
        @Nullable
        private String defaultTransactionType;
        private ImmutableList.Builder<String> transactionCustomAttributesBuilder = ImmutableList.builder();
        private long fixedAggregateIntervalSeconds;
        private long fixedAggregateRollupSeconds;
        private long fixedGaugeIntervalSeconds;
        private long fixedGaugeRollupSeconds;

        private Builder() {
        }

        public final Builder from(LayoutBase instance) {
            Preconditions.checkNotNull(instance);
            this.jvmHeapDump(instance.jvmHeapDump());
            this.footerMessage(instance.footerMessage());
            this.adminPasswordEnabled(instance.adminPasswordEnabled());
            this.readOnlyPasswordEnabled(instance.readOnlyPasswordEnabled());
            this.anonymousAccess(instance.anonymousAccess());
            this.addAllTransactionTypes(instance.transactionTypes());
            this.defaultTransactionType(instance.defaultTransactionType());
            this.addAllTransactionCustomAttributes(instance.transactionCustomAttributes());
            this.fixedAggregateIntervalSeconds(instance.fixedAggregateIntervalSeconds());
            this.fixedAggregateRollupSeconds(instance.fixedAggregateRollupSeconds());
            this.fixedGaugeIntervalSeconds(instance.fixedGaugeIntervalSeconds());
            this.fixedGaugeRollupSeconds(instance.fixedGaugeRollupSeconds());
            return this;
        }

        public final Builder jvmHeapDump(boolean jvmHeapDump) {
            this.jvmHeapDump = jvmHeapDump;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder footerMessage(String footerMessage) {
            this.footerMessage = Preconditions.checkNotNull(footerMessage);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder adminPasswordEnabled(boolean adminPasswordEnabled) {
            this.adminPasswordEnabled = adminPasswordEnabled;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder readOnlyPasswordEnabled(boolean readOnlyPasswordEnabled) {
            this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder anonymousAccess(AnonymousAccess anonymousAccess) {
            this.anonymousAccess = Preconditions.checkNotNull(anonymousAccess);
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder addTransactionTypes(String element) {
            this.transactionTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addTransactionTypes(String ... elements) {
            this.transactionTypesBuilder.add(elements);
            return this;
        }

        public final Builder transactionTypes(Iterable<String> elements) {
            this.transactionTypesBuilder = ImmutableList.builder();
            return this.addAllTransactionTypes(elements);
        }

        public final Builder addAllTransactionTypes(Iterable<String> elements) {
            this.transactionTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder defaultTransactionType(String defaultTransactionType) {
            this.defaultTransactionType = Preconditions.checkNotNull(defaultTransactionType);
            this.initializedBitset |= 0x20L;
            return this;
        }

        public final Builder addTransactionCustomAttributes(String element) {
            this.transactionCustomAttributesBuilder.add((Object)element);
            return this;
        }

        public final Builder addTransactionCustomAttributes(String ... elements) {
            this.transactionCustomAttributesBuilder.add(elements);
            return this;
        }

        public final Builder transactionCustomAttributes(Iterable<String> elements) {
            this.transactionCustomAttributesBuilder = ImmutableList.builder();
            return this.addAllTransactionCustomAttributes(elements);
        }

        public final Builder addAllTransactionCustomAttributes(Iterable<String> elements) {
            this.transactionCustomAttributesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder fixedAggregateIntervalSeconds(long fixedAggregateIntervalSeconds) {
            this.fixedAggregateIntervalSeconds = fixedAggregateIntervalSeconds;
            this.initializedBitset |= 0x40L;
            return this;
        }

        public final Builder fixedAggregateRollupSeconds(long fixedAggregateRollupSeconds) {
            this.fixedAggregateRollupSeconds = fixedAggregateRollupSeconds;
            this.initializedBitset |= 0x80L;
            return this;
        }

        public final Builder fixedGaugeIntervalSeconds(long fixedGaugeIntervalSeconds) {
            this.fixedGaugeIntervalSeconds = fixedGaugeIntervalSeconds;
            this.initializedBitset |= 0x100L;
            return this;
        }

        public final Builder fixedGaugeRollupSeconds(long fixedGaugeRollupSeconds) {
            this.fixedGaugeRollupSeconds = fixedGaugeRollupSeconds;
            this.initializedBitset |= 0x200L;
            return this;
        }

        public Layout build() {
            this.checkRequiredAttributes();
            return new Layout(this);
        }

        private boolean jvmHeapDumpIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean footerMessageIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean adminPasswordEnabledIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean readOnlyPasswordEnabledIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean anonymousAccessIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private boolean defaultTransactionTypeIsSet() {
            return (this.initializedBitset & 0x20L) != 0L;
        }

        private boolean fixedAggregateIntervalSecondsIsSet() {
            return (this.initializedBitset & 0x40L) != 0L;
        }

        private boolean fixedAggregateRollupSecondsIsSet() {
            return (this.initializedBitset & 0x80L) != 0L;
        }

        private boolean fixedGaugeIntervalSecondsIsSet() {
            return (this.initializedBitset & 0x100L) != 0L;
        }

        private boolean fixedGaugeRollupSecondsIsSet() {
            return (this.initializedBitset & 0x200L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1023L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.jvmHeapDumpIsSet()) {
                attributes.add("jvmHeapDump");
            }
            if (!this.footerMessageIsSet()) {
                attributes.add("footerMessage");
            }
            if (!this.adminPasswordEnabledIsSet()) {
                attributes.add("adminPasswordEnabled");
            }
            if (!this.readOnlyPasswordEnabledIsSet()) {
                attributes.add("readOnlyPasswordEnabled");
            }
            if (!this.anonymousAccessIsSet()) {
                attributes.add("anonymousAccess");
            }
            if (!this.defaultTransactionTypeIsSet()) {
                attributes.add("defaultTransactionType");
            }
            if (!this.fixedAggregateIntervalSecondsIsSet()) {
                attributes.add("fixedAggregateIntervalSeconds");
            }
            if (!this.fixedAggregateRollupSecondsIsSet()) {
                attributes.add("fixedAggregateRollupSeconds");
            }
            if (!this.fixedGaugeIntervalSecondsIsSet()) {
                attributes.add("fixedGaugeIntervalSeconds");
            }
            if (!this.fixedGaugeRollupSecondsIsSet()) {
                attributes.add("fixedGaugeRollupSeconds");
            }
            return "Cannot build Layout, some of required attributes are not set " + attributes;
        }
    }
}

