/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.util.List;
import javax.management.ObjectName;
import org.glowroot.shaded.google.common.collect.Lists;

class ObjectNames {
    static List<String> getPropertyValues(ObjectName objectName) throws IOException {
        return new ObjectNameParser(objectName).getPropertyValues();
    }

    private ObjectNames() {
    }

    private static class ObjectNameParser {
        private final char[] chars;
        private int index;
        private boolean inValue;
        private boolean inQuotedValue;
        private final StringBuilder currValue = new StringBuilder();
        private final List<String> values = Lists.newArrayList();

        private ObjectNameParser(ObjectName objectName) {
            this.chars = objectName.getKeyPropertyListString().toCharArray();
        }

        private List<String> getPropertyValues() {
            while (this.index < this.chars.length) {
                this.readNextChar();
            }
            if (this.inValue) {
                this.values.add(this.currValue.toString());
            }
            return this.values;
        }

        private void readNextChar() {
            char c;
            if (this.isStartOfValue(c = this.chars[this.index++])) {
                this.startValue();
            } else if (this.isEndOfValue(c)) {
                this.endValue();
            } else if (this.inQuotedValue && c == '\\') {
                char d;
                if ((d = this.chars[this.index++]) == 'n') {
                    d = '\n';
                }
                this.currValue.append(d);
            } else if (this.inValue) {
                this.currValue.append(c);
            }
        }

        private boolean isStartOfValue(char c) {
            return !this.inValue && c == '=';
        }

        private void startValue() {
            this.inValue = true;
            if (this.index < this.chars.length && this.chars[this.index] == '\"') {
                this.inQuotedValue = true;
                ++this.index;
            }
        }

        private boolean isEndOfValue(char c) {
            return this.isEndOfQuotedValue(c) || this.isEndOfNonQuotedValue(c);
        }

        private void endValue() {
            this.values.add(this.currValue.toString());
            this.inValue = false;
            this.inQuotedValue = false;
            this.currValue.setLength(0);
        }

        private boolean isEndOfQuotedValue(char c) {
            return this.inQuotedValue && c == '\"';
        }

        private boolean isEndOfNonQuotedValue(char c) {
            return this.inValue && !this.inQuotedValue && c == ',';
        }
    }
}

