/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.collector.Aggregate;
import org.glowroot.collector.AggregateCollector;
import org.glowroot.collector.AggregateIntervalCollector;
import org.glowroot.collector.ProfileAggregate;
import org.glowroot.collector.QueryAggregate;
import org.glowroot.collector.QueryComponent;
import org.glowroot.collector.TransactionSummary;
import org.glowroot.common.ScratchBuffer;
import org.glowroot.config.ConfigService;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.QueryResult;
import org.glowroot.local.store.TransactionSummaryQuery;
import org.glowroot.local.ui.AggregateMerging;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.transaction.model.ProfileNode;

class TransactionCommonService {
    private final AggregateDao aggregateDao;
    @Nullable
    private final AggregateCollector aggregateCollector;
    private final ConfigService configService;
    private final long fixedRollupMillis;

    TransactionCommonService(AggregateDao aggregateDao, @Nullable AggregateCollector aggregateCollector, ConfigService configService, long fixedRollupSeconds) {
        this.aggregateDao = aggregateDao;
        this.aggregateCollector = aggregateCollector;
        this.configService = configService;
        this.fixedRollupMillis = fixedRollupSeconds * 1000L;
    }

    TransactionSummary readOverallSummary(String transactionType, long from, long to) throws SQLException {
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        if (orderedIntervalCollectors.isEmpty()) {
            return this.aggregateDao.readOverallTransactionSummary(transactionType, from, to);
        }
        long revisedTo = TransactionCommonService.getRevisedTo(to, orderedIntervalCollectors);
        TransactionSummary overallSummary = this.aggregateDao.readOverallTransactionSummary(transactionType, from, revisedTo);
        for (AggregateIntervalCollector intervalCollector : orderedIntervalCollectors) {
            TransactionSummary liveOverallSummary = intervalCollector.getLiveOverallSummary(transactionType);
            if (liveOverallSummary == null) continue;
            overallSummary = TransactionCommonService.combineTransactionSummaries(null, overallSummary, liveOverallSummary);
        }
        return overallSummary;
    }

    QueryResult<TransactionSummary> readTransactionSummaries(TransactionSummaryQuery query) throws SQLException {
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        if (orderedIntervalCollectors.isEmpty()) {
            return this.aggregateDao.readTransactionSummaries(query);
        }
        long revisedTo = TransactionCommonService.getRevisedTo(query.to(), orderedIntervalCollectors);
        TransactionSummaryQuery revisedQuery = query.withTo(revisedTo);
        QueryResult<TransactionSummary> queryResult = this.aggregateDao.readTransactionSummaries(revisedQuery);
        if (orderedIntervalCollectors.isEmpty()) {
            return queryResult;
        }
        return TransactionCommonService.mergeInLiveTransactionSummaries(revisedQuery, queryResult, orderedIntervalCollectors);
    }

    boolean shouldHaveQueries(String transactionType, @Nullable String transactionName, long from, long to) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.shouldHaveOverallQueries(transactionType, from, to);
        }
        return this.aggregateDao.shouldHaveTransactionQueries(transactionType, transactionName, from, to);
    }

    boolean shouldHaveProfile(String transactionType, @Nullable String transactionName, long from, long to) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.shouldHaveOverallProfile(transactionType, from, to);
        }
        return this.aggregateDao.shouldHaveTransactionProfile(transactionType, transactionName, from, to);
    }

    List<Aggregate> getAggregates(String transactionType, @Nullable String transactionName, long from, long to, long liveCaptureTime) throws Exception {
        int rollupLevel = TransactionCommonService.getRollupLevel(from, to);
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        long revisedTo = TransactionCommonService.getRevisedTo(to, orderedIntervalCollectors);
        List<Aggregate> aggregates = this.getAggregatesFromDao(transactionType, transactionName, from, revisedTo, rollupLevel);
        if (rollupLevel == 0) {
            aggregates = Lists.newArrayList(aggregates);
            aggregates.addAll(TransactionCommonService.getLiveAggregates(transactionType, transactionName, orderedIntervalCollectors, liveCaptureTime));
            return aggregates;
        }
        long nonRolledUpFrom = from;
        if (!aggregates.isEmpty()) {
            long lastRolledUpTime = aggregates.get(aggregates.size() - 1).captureTime();
            nonRolledUpFrom = Math.max(nonRolledUpFrom, lastRolledUpTime + 1L);
        }
        ArrayList<Aggregate> orderedNonRolledUpAggregates = Lists.newArrayList();
        orderedNonRolledUpAggregates.addAll(this.getAggregatesFromDao(transactionType, transactionName, nonRolledUpFrom, revisedTo, 0));
        orderedNonRolledUpAggregates.addAll(TransactionCommonService.getLiveAggregates(transactionType, transactionName, orderedIntervalCollectors, liveCaptureTime));
        aggregates = Lists.newArrayList(aggregates);
        aggregates.addAll(this.rollUp(transactionType, transactionName, orderedNonRolledUpAggregates, liveCaptureTime));
        return aggregates;
    }

    Map<String, List<QueryComponent.AggregateQuery>> getQueries(String transactionType, @Nullable String transactionName, long from, long to) throws Exception {
        List<QueryAggregate> queryAggregates = this.getQueryAggregates(transactionType, transactionName, from, to);
        return AggregateMerging.getOrderedAndTruncatedQueries(queryAggregates, this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
    }

    ProfileNode getProfile(String transactionType, @Nullable String transactionName, long from, long to, double truncateLeafPercentage) throws Exception {
        List<ProfileAggregate> profileAggregate = this.getProfileAggregates(transactionType, transactionName, from, to);
        ProfileNode syntheticRootNode = AggregateMerging.getMergedProfile(profileAggregate);
        if (truncateLeafPercentage != 0.0) {
            int minSamples = (int)((double)syntheticRootNode.getSampleCount() * truncateLeafPercentage);
            TransactionCommonService.truncateLeafs(syntheticRootNode.getChildNodes(), minSamples);
        }
        return syntheticRootNode;
    }

    private List<AggregateIntervalCollector> getOrderedIntervalCollectorsInRange(long from, long to) {
        if (this.aggregateCollector == null) {
            return ImmutableList.of();
        }
        return this.aggregateCollector.getOrderedIntervalCollectorsInRange(from, to);
    }

    private List<Aggregate> getAggregatesFromDao(String transactionType, @Nullable String transactionName, long from, long to, int rollupLevel) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.readOverallAggregates(transactionType, from, to, rollupLevel);
        }
        return this.aggregateDao.readTransactionAggregates(transactionType, transactionName, from, to, rollupLevel);
    }

    private List<QueryAggregate> getQueryAggregates(String transactionType, @Nullable String transactionName, long from, long to) throws Exception {
        int rollupLevel = TransactionCommonService.getRollupLevel(from, to);
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        long revisedTo = TransactionCommonService.getRevisedTo(to, orderedIntervalCollectors);
        List<QueryAggregate> queryAggregates = this.getQueryAggregatesFromDao(transactionType, transactionName, from, revisedTo, rollupLevel);
        if (rollupLevel == 0) {
            queryAggregates = Lists.newArrayList(queryAggregates);
            queryAggregates.addAll(TransactionCommonService.getLiveQueryAggregates(transactionType, transactionName, orderedIntervalCollectors));
            return queryAggregates;
        }
        long nonRolledUpFrom = from;
        if (!queryAggregates.isEmpty()) {
            long lastRolledUpTime = queryAggregates.get(queryAggregates.size() - 1).captureTime();
            nonRolledUpFrom = Math.max(nonRolledUpFrom, lastRolledUpTime + 1L);
        }
        ArrayList<QueryAggregate> orderedNonRolledUpQueryAggregates = Lists.newArrayList();
        orderedNonRolledUpQueryAggregates.addAll(this.getQueryAggregatesFromDao(transactionType, transactionName, nonRolledUpFrom, revisedTo, 0));
        orderedNonRolledUpQueryAggregates.addAll(TransactionCommonService.getLiveQueryAggregates(transactionType, transactionName, orderedIntervalCollectors));
        queryAggregates = Lists.newArrayList(queryAggregates);
        queryAggregates.addAll(orderedNonRolledUpQueryAggregates);
        return queryAggregates;
    }

    private List<QueryAggregate> getQueryAggregatesFromDao(String transactionType, @Nullable String transactionName, long from, long to, int rollupLevel) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.readOverallQueryAggregates(transactionType, from, to, rollupLevel);
        }
        return this.aggregateDao.readTransactionQueryAggregates(transactionType, transactionName, from, to, rollupLevel);
    }

    private List<ProfileAggregate> getProfileAggregates(String transactionType, @Nullable String transactionName, long from, long to) throws Exception {
        int rollupLevel = TransactionCommonService.getRollupLevel(from, to);
        List<AggregateIntervalCollector> orderedIntervalCollectors = this.getOrderedIntervalCollectorsInRange(from, to);
        long revisedTo = TransactionCommonService.getRevisedTo(to, orderedIntervalCollectors);
        List<ProfileAggregate> profileAggregates = this.getProfileAggregatesFromDao(transactionType, transactionName, from, revisedTo, rollupLevel);
        if (rollupLevel == 0) {
            profileAggregates = Lists.newArrayList(profileAggregates);
            profileAggregates.addAll(TransactionCommonService.getLiveProfileAggregates(transactionType, transactionName, orderedIntervalCollectors));
            return profileAggregates;
        }
        long nonRolledUpFrom = from;
        if (!profileAggregates.isEmpty()) {
            long lastRolledUpTime = profileAggregates.get(profileAggregates.size() - 1).captureTime();
            nonRolledUpFrom = Math.max(nonRolledUpFrom, lastRolledUpTime + 1L);
        }
        ArrayList<ProfileAggregate> orderedNonRolledUpProfileAggregates = Lists.newArrayList();
        orderedNonRolledUpProfileAggregates.addAll(this.getProfileAggregatesFromDao(transactionType, transactionName, nonRolledUpFrom, revisedTo, 0));
        orderedNonRolledUpProfileAggregates.addAll(TransactionCommonService.getLiveProfileAggregates(transactionType, transactionName, orderedIntervalCollectors));
        profileAggregates = Lists.newArrayList(profileAggregates);
        profileAggregates.addAll(orderedNonRolledUpProfileAggregates);
        return profileAggregates;
    }

    private List<ProfileAggregate> getProfileAggregatesFromDao(String transactionType, @Nullable String transactionName, long from, long to, int rollupLevel) throws SQLException {
        if (transactionName == null) {
            return this.aggregateDao.readOverallProfileAggregates(transactionType, from, to, rollupLevel);
        }
        return this.aggregateDao.readTransactionProfileAggregates(transactionType, transactionName, from, to, rollupLevel);
    }

    private List<Aggregate> rollUp(String transactionType, @Nullable String transactionName, List<Aggregate> orderedNonRolledUpAggregates, long liveCaptureTime) throws Exception {
        ArrayList<Aggregate> rolledUpAggregates = Lists.newArrayList();
        ScratchBuffer scratchBuffer = new ScratchBuffer();
        AggregateDao.MergedAggregate currMergedAggregate = null;
        long currRollupTime = Long.MIN_VALUE;
        for (Aggregate nonRolledUpAggregate : orderedNonRolledUpAggregates) {
            long rollupTime = (long)Math.ceil((double)nonRolledUpAggregate.captureTime() / (double)this.fixedRollupMillis) * this.fixedRollupMillis;
            if (rollupTime != currRollupTime && currMergedAggregate != null) {
                rolledUpAggregates.add(currMergedAggregate.toAggregate(scratchBuffer));
                currMergedAggregate = new AggregateDao.MergedAggregate(Math.min(rollupTime, liveCaptureTime), transactionType, transactionName, this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
            }
            if (currMergedAggregate == null) {
                currMergedAggregate = new AggregateDao.MergedAggregate(Math.min(rollupTime, liveCaptureTime), transactionType, transactionName, this.configService.getAdvancedConfig().maxAggregateQueriesPerQueryType());
            }
            currRollupTime = rollupTime;
            currMergedAggregate.addTotalMicros(nonRolledUpAggregate.totalMicros());
            currMergedAggregate.addErrorCount(nonRolledUpAggregate.errorCount());
            currMergedAggregate.addTransactionCount(nonRolledUpAggregate.transactionCount());
            currMergedAggregate.addTotalCpuMicros(nonRolledUpAggregate.totalCpuMicros());
            currMergedAggregate.addTotalBlockedMicros(nonRolledUpAggregate.totalBlockedMicros());
            currMergedAggregate.addTotalWaitedMicros(nonRolledUpAggregate.totalWaitedMicros());
            currMergedAggregate.addTotalAllocatedKBytes(nonRolledUpAggregate.totalAllocatedKBytes());
            currMergedAggregate.addTimers(nonRolledUpAggregate.timers());
            currMergedAggregate.addHistogram(nonRolledUpAggregate.histogram());
        }
        if (currMergedAggregate != null) {
            rolledUpAggregates.add(currMergedAggregate.toAggregate(scratchBuffer));
        }
        return rolledUpAggregates;
    }

    private static int getRollupLevel(long from, long to) {
        if (to - from <= AggregateDao.ROLLUP_THRESHOLD_MILLIS) {
            return 0;
        }
        return 1;
    }

    private static long getRevisedTo(long to, List<AggregateIntervalCollector> orderedIntervalCollectors) {
        if (orderedIntervalCollectors.isEmpty()) {
            return to;
        }
        return orderedIntervalCollectors.get(0).getEndTime() - 1L;
    }

    private static QueryResult<TransactionSummary> mergeInLiveTransactionSummaries(TransactionSummaryQuery query, QueryResult<TransactionSummary> queryResult, List<AggregateIntervalCollector> intervalCollectors) {
        List<TransactionSummary> transactionSummaries = queryResult.records();
        HashMap<String, TransactionSummary> transactionSummaryMap = Maps.newHashMap();
        for (TransactionSummary transactionSummary : transactionSummaries) {
            String transactionName = transactionSummary.transactionName();
            Preconditions.checkNotNull(transactionName);
            transactionSummaryMap.put(transactionName, transactionSummary);
        }
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            List<TransactionSummary> liveTransactionSummaries = intervalCollector.getLiveTransactionSummaries(query.transactionType());
            for (TransactionSummary liveTransactionSummary : liveTransactionSummaries) {
                String transactionName = liveTransactionSummary.transactionName();
                Preconditions.checkNotNull(transactionName);
                TransactionSummary transactionSummary = (TransactionSummary)transactionSummaryMap.get(transactionName);
                if (transactionSummary == null) {
                    transactionSummaryMap.put(transactionName, liveTransactionSummary);
                    continue;
                }
                transactionSummaryMap.put(transactionName, TransactionCommonService.combineTransactionSummaries(transactionName, transactionSummary, liveTransactionSummary));
            }
        }
        transactionSummaries = TransactionCommonService.sortTransactionSummaries(transactionSummaryMap.values(), query.sortOrder());
        boolean moreAvailable = queryResult.moreAvailable();
        if (transactionSummaries.size() > query.limit()) {
            moreAvailable = true;
            transactionSummaries = transactionSummaries.subList(0, query.limit());
        }
        return new QueryResult<TransactionSummary>(transactionSummaries, moreAvailable);
    }

    private static List<Aggregate> getLiveAggregates(String transactionType, @Nullable String transactionName, List<AggregateIntervalCollector> intervalCollectors, long liveCaptureTime) throws IOException {
        ArrayList<Aggregate> aggregates = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            Aggregate liveAggregate = intervalCollector.getLiveAggregate(transactionType, transactionName, liveCaptureTime);
            if (liveAggregate == null) continue;
            aggregates.add(liveAggregate);
        }
        return aggregates;
    }

    private static List<QueryAggregate> getLiveQueryAggregates(String transactionType, @Nullable String transactionName, List<AggregateIntervalCollector> intervalCollectors) throws IOException {
        ArrayList<QueryAggregate> queryAggregates = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            QueryAggregate liveQueryAggregate = intervalCollector.getLiveQueryAggregate(transactionType, transactionName);
            if (liveQueryAggregate == null) continue;
            queryAggregates.add(liveQueryAggregate);
        }
        return queryAggregates;
    }

    private static List<ProfileAggregate> getLiveProfileAggregates(String transactionType, @Nullable String transactionName, List<AggregateIntervalCollector> intervalCollectors) throws IOException {
        ArrayList<ProfileAggregate> profileAggregates = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            ProfileAggregate liveProfileAggregate = intervalCollector.getLiveProfileAggregate(transactionType, transactionName);
            if (liveProfileAggregate == null) continue;
            profileAggregates.add(liveProfileAggregate);
        }
        return profileAggregates;
    }

    private static TransactionSummary combineTransactionSummaries(@Nullable String transactionName, TransactionSummary summary1, TransactionSummary summary2) {
        return TransactionSummary.builder().transactionName(transactionName).totalMicros(summary1.totalMicros() + summary2.totalMicros()).transactionCount(summary1.transactionCount() + summary2.transactionCount()).build();
    }

    private static void truncateLeafs(List<ProfileNode> rootNodes, int minSamples) {
        ProfileNode node;
        ArrayDeque<ProfileNode> toBeVisited = new ArrayDeque<ProfileNode>();
        toBeVisited.addAll(rootNodes);
        while ((node = (ProfileNode)toBeVisited.poll()) != null) {
            Iterator<ProfileNode> i = node.getChildNodes().iterator();
            while (i.hasNext()) {
                ProfileNode childNode = i.next();
                if (childNode.getSampleCount() < minSamples) {
                    i.remove();
                    node.setEllipsed();
                    continue;
                }
                toBeVisited.add(childNode);
            }
        }
    }

    private static List<TransactionSummary> sortTransactionSummaries(Iterable<TransactionSummary> transactionSummaries, AggregateDao.TransactionSummarySortOrder sortOrder) {
        switch (sortOrder) {
            case TOTAL_TIME: {
                return TransactionSummary.orderingByTotalTimeDesc.immutableSortedCopy(transactionSummaries);
            }
            case AVERAGE_TIME: {
                return TransactionSummary.orderingByAverageTimeDesc.immutableSortedCopy(transactionSummaries);
            }
            case THROUGHPUT: {
                return TransactionSummary.orderingByTransactionCountDesc.immutableSortedCopy(transactionSummaries);
            }
        }
        throw new AssertionError((Object)("Unexpected sort order: " + (Object)((Object)sortOrder)));
    }
}

