/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.HdrHistogram;

import java.util.concurrent.atomic.AtomicLong;
import org.glowroot.shaded.HdrHistogram.AtomicHistogram;
import org.glowroot.shaded.HdrHistogram.ConcurrentHistogram;
import org.glowroot.shaded.HdrHistogram.Histogram;
import org.glowroot.shaded.HdrHistogram.WriterReaderPhaser;

public class Recorder {
    private static AtomicLong instanceIdSequencer = new AtomicLong(1L);
    private final long instanceId = instanceIdSequencer.getAndIncrement();
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile Histogram activeHistogram;
    private Histogram inactiveHistogram;

    public Recorder(int numberOfSignificantValueDigits) {
        this.activeHistogram = new InternalConcurrentHistogram(this.instanceId, numberOfSignificantValueDigits);
        this.inactiveHistogram = new InternalConcurrentHistogram(this.instanceId, numberOfSignificantValueDigits);
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    public Recorder(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public Recorder(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.activeHistogram = new InternalAtomicHistogram(this.instanceId, lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.inactiveHistogram = new InternalAtomicHistogram(this.instanceId, lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordValue(long value) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValue(value);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    public synchronized Histogram getIntervalHistogram() {
        return this.getIntervalHistogram(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Histogram getIntervalHistogram(Histogram histogramToRecycle) {
        if (histogramToRecycle == null) {
            histogramToRecycle = this.inactiveHistogram instanceof InternalAtomicHistogram ? new InternalAtomicHistogram(this.instanceId, this.inactiveHistogram.getLowestDiscernibleValue(), this.inactiveHistogram.getHighestTrackableValue(), this.inactiveHistogram.getNumberOfSignificantValueDigits()) : new InternalConcurrentHistogram(this.instanceId, this.inactiveHistogram.getNumberOfSignificantValueDigits());
        }
        this.validateFitAsReplacementHistogram(histogramToRecycle);
        try {
            this.recordingPhaser.readerLock();
            this.inactiveHistogram = histogramToRecycle;
            this.performIntervalSample();
            Histogram histogram = this.inactiveHistogram;
            return histogram;
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public synchronized void getIntervalHistogramInto(Histogram targetHistogram) {
        this.performIntervalSample();
        this.inactiveHistogram.copyInto(targetHistogram);
    }

    public synchronized void reset() {
        this.performIntervalSample();
        this.performIntervalSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performIntervalSample() {
        this.inactiveHistogram.reset();
        try {
            this.recordingPhaser.readerLock();
            Histogram tempHistogram = this.inactiveHistogram;
            this.inactiveHistogram = this.activeHistogram;
            this.activeHistogram = tempHistogram;
            long now = System.currentTimeMillis();
            this.activeHistogram.setStartTimeStamp(now);
            this.inactiveHistogram.setEndTimeStamp(now);
            this.recordingPhaser.flipPhase(500000L);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    void validateFitAsReplacementHistogram(Histogram replacementHistogram) {
        boolean bad = true;
        if (replacementHistogram instanceof InternalAtomicHistogram) {
            if (this.activeHistogram instanceof InternalAtomicHistogram && ((InternalAtomicHistogram)replacementHistogram).containingInstanceId == ((InternalAtomicHistogram)this.activeHistogram).containingInstanceId) {
                bad = false;
            }
        } else if (replacementHistogram instanceof InternalConcurrentHistogram && this.activeHistogram instanceof InternalConcurrentHistogram && ((InternalConcurrentHistogram)replacementHistogram).containingInstanceId == ((InternalConcurrentHistogram)this.activeHistogram).containingInstanceId) {
            bad = false;
        }
        if (bad) {
            throw new IllegalArgumentException("replacement histogram must have been obtained via a previousgetIntervalHistogram() call from this " + this.getClass().getName() + " instance");
        }
    }

    private class InternalConcurrentHistogram
    extends ConcurrentHistogram {
        private final long containingInstanceId;

        private InternalConcurrentHistogram(long id, int numberOfSignificantValueDigits) {
            super(numberOfSignificantValueDigits);
            this.containingInstanceId = id;
        }
    }

    private class InternalAtomicHistogram
    extends AtomicHistogram {
        private final long containingInstanceId;

        private InternalAtomicHistogram(long id, long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
            super(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
            this.containingInstanceId = id;
        }
    }
}

