/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.fasterxml.jackson.core.io;

public final class NumberOutput {
    private static final char NC = '\u0000';
    private static int MILLION = 1000000;
    private static int BILLION = 1000000000;
    private static long TEN_BILLION_L = 10000000000L;
    private static long THOUSAND_L = 1000L;
    private static long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final String SMALLEST_LONG = String.valueOf(Long.MIN_VALUE);
    static final char[] LEAD_3 = new char[4000];
    static final char[] FULL_3 = new char[4000];
    static final byte[] FULL_TRIPLETS_B;
    static final String[] sSmallIntStrs;
    static final String[] sSmallIntStrs2;

    public static int outputInt(int v, char[] b, int off) {
        boolean hasBillions;
        if (v < 0) {
            if (v == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)v, b, off);
            }
            b[off++] = 45;
            v = -v;
        }
        if (v < MILLION) {
            if (v < 1000) {
                if (v < 10) {
                    b[off++] = (char)(48 + v);
                } else {
                    off = NumberOutput.leading3(v, b, off);
                }
            } else {
                int thousands = v / 1000;
                off = NumberOutput.leading3(thousands, b, off);
                off = NumberOutput.full3(v -= thousands * 1000, b, off);
            }
            return off;
        }
        boolean bl = hasBillions = v >= BILLION;
        if (hasBillions) {
            if ((v -= BILLION) >= BILLION) {
                v -= BILLION;
                b[off++] = 50;
            } else {
                b[off++] = 49;
            }
        }
        int newValue = v / 1000;
        int ones = v - newValue * 1000;
        v = newValue;
        int thousands = v - (newValue /= 1000) * 1000;
        off = hasBillions ? NumberOutput.full3(newValue, b, off) : NumberOutput.leading3(newValue, b, off);
        off = NumberOutput.full3(thousands, b, off);
        off = NumberOutput.full3(ones, b, off);
        return off;
    }

    public static int outputInt(int v, byte[] b, int off) {
        boolean hasB;
        if (v < 0) {
            if (v == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)v, b, off);
            }
            b[off++] = 45;
            v = -v;
        }
        if (v < MILLION) {
            if (v < 1000) {
                if (v < 10) {
                    b[off++] = (byte)(48 + v);
                } else {
                    off = NumberOutput.leading3(v, b, off);
                }
            } else {
                int thousands = v / 1000;
                off = NumberOutput.leading3(thousands, b, off);
                off = NumberOutput.full3(v -= thousands * 1000, b, off);
            }
            return off;
        }
        boolean bl = hasB = v >= BILLION;
        if (hasB) {
            if ((v -= BILLION) >= BILLION) {
                v -= BILLION;
                b[off++] = 50;
            } else {
                b[off++] = 49;
            }
        }
        int newValue = v / 1000;
        int ones = v - newValue * 1000;
        v = newValue;
        int thousands = v - (newValue /= 1000) * 1000;
        off = hasB ? NumberOutput.full3(newValue, b, off) : NumberOutput.leading3(newValue, b, off);
        off = NumberOutput.full3(thousands, b, off);
        off = NumberOutput.full3(ones, b, off);
        return off;
    }

    public static int outputLong(long v, char[] b, int off) {
        int triplet;
        if (v < 0L) {
            if (v > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)v, b, off);
            }
            if (v == Long.MIN_VALUE) {
                int len = SMALLEST_LONG.length();
                SMALLEST_LONG.getChars(0, len, b, off);
                return off + len;
            }
            b[off++] = 45;
            v = -v;
        } else if (v <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)v, b, off);
        }
        int origOffset = off;
        int ptr = off += NumberOutput.calcLongStrLength(v);
        while (v > MAX_INT_AS_LONG) {
            long newValue = v / THOUSAND_L;
            triplet = (int)(v - newValue * THOUSAND_L);
            NumberOutput.full3(triplet, b, ptr -= 3);
            v = newValue;
        }
        int ivalue = (int)v;
        while (ivalue >= 1000) {
            int newValue = ivalue / 1000;
            triplet = ivalue - newValue * 1000;
            NumberOutput.full3(triplet, b, ptr -= 3);
            ivalue = newValue;
        }
        NumberOutput.leading3(ivalue, b, origOffset);
        return off;
    }

    public static int outputLong(long v, byte[] b, int off) {
        int t;
        if (v < 0L) {
            if (v > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)v, b, off);
            }
            if (v == Long.MIN_VALUE) {
                int len = SMALLEST_LONG.length();
                for (int i = 0; i < len; ++i) {
                    b[off++] = (byte)SMALLEST_LONG.charAt(i);
                }
                return off;
            }
            b[off++] = 45;
            v = -v;
        } else if (v <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)v, b, off);
        }
        int origOff = off;
        int ptr = off += NumberOutput.calcLongStrLength(v);
        while (v > MAX_INT_AS_LONG) {
            long newV = v / THOUSAND_L;
            t = (int)(v - newV * THOUSAND_L);
            NumberOutput.full3(t, b, ptr -= 3);
            v = newV;
        }
        int ivalue = (int)v;
        while (ivalue >= 1000) {
            int newV = ivalue / 1000;
            t = ivalue - newV * 1000;
            NumberOutput.full3(t, b, ptr -= 3);
            ivalue = newV;
        }
        NumberOutput.leading3(ivalue, b, origOff);
        return off;
    }

    public static String toString(int v) {
        if (v < sSmallIntStrs.length) {
            if (v >= 0) {
                return sSmallIntStrs[v];
            }
            int v2 = -v - 1;
            if (v2 < sSmallIntStrs2.length) {
                return sSmallIntStrs2[v2];
            }
        }
        return Integer.toString(v);
    }

    public static String toString(long v) {
        if (v <= Integer.MAX_VALUE && v >= Integer.MIN_VALUE) {
            return NumberOutput.toString((int)v);
        }
        return Long.toString(v);
    }

    public static String toString(double v) {
        return Double.toString(v);
    }

    private static int leading3(int t, char[] b, int off) {
        char c;
        int digitOffset = t << 2;
        if ((c = LEAD_3[digitOffset++]) != '\u0000') {
            b[off++] = c;
        }
        if ((c = LEAD_3[digitOffset++]) != '\u0000') {
            b[off++] = c;
        }
        b[off++] = LEAD_3[digitOffset];
        return off;
    }

    private static int leading3(int t, byte[] b, int off) {
        char c;
        int digitOffset = t << 2;
        if ((c = LEAD_3[digitOffset++]) != '\u0000') {
            b[off++] = (byte)c;
        }
        if ((c = LEAD_3[digitOffset++]) != '\u0000') {
            b[off++] = (byte)c;
        }
        b[off++] = (byte)LEAD_3[digitOffset];
        return off;
    }

    private static int full3(int t, char[] b, int off) {
        int digitOffset = t << 2;
        b[off++] = FULL_3[digitOffset++];
        b[off++] = FULL_3[digitOffset++];
        b[off++] = FULL_3[digitOffset];
        return off;
    }

    private static int full3(int t, byte[] b, int off) {
        int digitOffset = t << 2;
        b[off++] = FULL_TRIPLETS_B[digitOffset++];
        b[off++] = FULL_TRIPLETS_B[digitOffset++];
        b[off++] = FULL_TRIPLETS_B[digitOffset];
        return off;
    }

    private static int calcLongStrLength(long v) {
        int len;
        long cmp = TEN_BILLION_L;
        for (len = 10; v >= cmp && len != 19; ++len) {
            cmp = (cmp << 3) + (cmp << 1);
        }
        return len;
    }

    static {
        int ix = 0;
        for (int i1 = 0; i1 < 10; ++i1) {
            char f1 = (char)(48 + i1);
            char l1 = i1 == 0 ? (char)'\u0000' : f1;
            for (int i2 = 0; i2 < 10; ++i2) {
                char f2 = (char)(48 + i2);
                char l2 = i1 == 0 && i2 == 0 ? (char)'\u0000' : f2;
                for (int i3 = 0; i3 < 10; ++i3) {
                    char f3 = (char)(48 + i3);
                    NumberOutput.LEAD_3[ix] = l1;
                    NumberOutput.LEAD_3[ix + 1] = l2;
                    NumberOutput.LEAD_3[ix + 2] = f3;
                    NumberOutput.FULL_3[ix] = f1;
                    NumberOutput.FULL_3[ix + 1] = f2;
                    NumberOutput.FULL_3[ix + 2] = f3;
                    ix += 4;
                }
            }
        }
        FULL_TRIPLETS_B = new byte[4000];
        for (int i = 0; i < 4000; ++i) {
            NumberOutput.FULL_TRIPLETS_B[i] = (byte)FULL_3[i];
        }
        sSmallIntStrs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        sSmallIntStrs2 = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    }
}

