/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.fasterxml.jackson.datatype.guava;

import java.lang.reflect.Type;
import org.glowroot.shaded.fasterxml.jackson.databind.JavaType;
import org.glowroot.shaded.fasterxml.jackson.databind.type.TypeBindings;
import org.glowroot.shaded.fasterxml.jackson.databind.type.TypeFactory;
import org.glowroot.shaded.fasterxml.jackson.databind.type.TypeModifier;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.collect.FluentIterable;
import org.glowroot.shaded.google.common.collect.Multimap;
import org.glowroot.shaded.google.common.collect.Range;

public class GuavaTypeModifier
extends TypeModifier {
    private static final Class<?>[] SINGLE_PARAM_TYPES = new Class[]{Range.class, Optional.class};

    @Override
    public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
        Class<?> raw = type.getRawClass();
        if (Multimap.class.isAssignableFrom(raw)) {
            JavaType keyType = type.containedType(0);
            JavaType contentType = type.containedType(1);
            if (keyType == null) {
                keyType = TypeFactory.unknownType();
            }
            if (contentType == null) {
                contentType = TypeFactory.unknownType();
            }
            return typeFactory.constructMapLikeType(type.getRawClass(), keyType, contentType);
        }
        if (FluentIterable.class.isAssignableFrom(raw)) {
            JavaType elemType;
            block10: {
                elemType = null;
                try {
                    JavaType[] types = typeFactory.findTypeParameters(type, Iterable.class);
                    if (types != null && types.length > 0) {
                        elemType = types[0];
                    }
                }
                catch (IllegalArgumentException e) {
                    String msg = e.getMessage();
                    if (msg != null && msg.contains("Type variable 'T' can not be resolved")) break block10;
                    throw e;
                }
            }
            if (elemType == null) {
                elemType = TypeFactory.unknownType();
            }
            return typeFactory.constructParametrizedType(FluentIterable.class, Iterable.class, elemType);
        }
        for (Class<?> target : SINGLE_PARAM_TYPES) {
            JavaType t;
            if (!target.isAssignableFrom(raw)) continue;
            JavaType[] types = typeFactory.findTypeParameters(type, target);
            JavaType javaType = t = types == null || types.length == 0 ? null : types[0];
            if (t == null) {
                t = TypeFactory.unknownType();
            }
            return typeFactory.constructParametrizedType(raw, target, t);
        }
        return type;
    }
}

