/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import org.glowroot.shaded.h2.command.ddl.SchemaCommand;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.schema.Schema;
import org.glowroot.shaded.h2.schema.Sequence;

public class CreateSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifNotExists;
    private boolean cycle;
    private Expression minValue;
    private Expression maxValue;
    private Expression start;
    private Expression increment;
    private Expression cacheSize;
    private boolean belongsToTable;

    public CreateSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setCycle(boolean bl) {
        this.cycle = bl;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.getSchema().findSequence(this.sequenceName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90035, this.sequenceName);
        }
        int n = this.getObjectId();
        Long l = this.getLong(this.start);
        Long l2 = this.getLong(this.increment);
        Long l3 = this.getLong(this.cacheSize);
        Long l4 = this.getLong(this.minValue);
        Long l5 = this.getLong(this.maxValue);
        Sequence sequence = new Sequence(this.getSchema(), n, this.sequenceName, l, l2, l3, l4, l5, this.cycle, this.belongsToTable);
        database.addSchemaObject(this.session, sequence);
        return 0;
    }

    private Long getLong(Expression expression) {
        if (expression == null) {
            return null;
        }
        return expression.optimize(this.session).getValue(this.session).getLong();
    }

    public void setStartWith(Expression expression) {
        this.start = expression;
    }

    public void setIncrement(Expression expression) {
        this.increment = expression;
    }

    public void setMinValue(Expression expression) {
        this.minValue = expression;
    }

    public void setMaxValue(Expression expression) {
        this.maxValue = expression;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    public void setCacheSize(Expression expression) {
        this.cacheSize = expression;
    }

    @Override
    public int getType() {
        return 29;
    }
}

