/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.expression;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.expression.Comparison;
import org.glowroot.shaded.h2.expression.Condition;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.expression.ExpressionColumn;
import org.glowroot.shaded.h2.expression.ExpressionVisitor;
import org.glowroot.shaded.h2.index.IndexCondition;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.table.ColumnResolver;
import org.glowroot.shaded.h2.table.TableFilter;
import org.glowroot.shaded.h2.util.StatementBuilder;
import org.glowroot.shaded.h2.value.Value;
import org.glowroot.shaded.h2.value.ValueBoolean;
import org.glowroot.shaded.h2.value.ValueNull;

public class ConditionInConstantSet
extends Condition {
    private Expression left;
    private int queryLevel;
    private final ArrayList<Expression> valueList;
    private final TreeSet<Value> valueSet;

    public ConditionInConstantSet(final Session session, Expression expression, ArrayList<Expression> arrayList) {
        this.left = expression;
        this.valueList = arrayList;
        this.valueSet = new TreeSet<Value>(new Comparator<Value>(){

            @Override
            public int compare(Value value, Value value2) {
                return session.getDatabase().compare(value, value2);
            }
        });
        int n = expression.getType();
        for (Expression expression2 : arrayList) {
            this.valueSet.add(expression2.getValue(session).convertTo(n));
        }
    }

    @Override
    public Value getValue(Session session) {
        boolean bl;
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        boolean bl2 = this.valueSet.contains(value);
        if (!bl2 && (bl = this.valueSet.contains(ValueNull.INSTANCE))) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl2);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, this.valueList));
            return;
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        statementBuilder.append(this.left.getSQL()).append(" IN(");
        for (Expression expression : this.valueList) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append("))").toString();
    }

    @Override
    public void updateAggregate(Session session) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.left.isEverything(expressionVisitor)) {
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        int n = this.left.getCost();
        return n;
    }

    Expression getAdditional(Session session, Comparison comparison) {
        Expression expression = comparison.getIfEquals(this.left);
        if (expression != null && expression.isConstant()) {
            this.valueList.add(expression);
            this.valueSet.add(expression.getValue(session).convertTo(this.left.getType()));
            return this;
        }
        return null;
    }
}

