/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.store;

import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import org.glowroot.shaded.h2.Driver;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.message.TraceSystem;

public class WriterThread
implements Runnable {
    private volatile WeakReference<Database> databaseRef;
    private int writeDelay;
    private Thread thread;
    private volatile boolean stop;

    private WriterThread(Database database, int n) {
        this.databaseRef = new WeakReference<Database>(database);
        this.writeDelay = n;
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
    }

    public static WriterThread create(Database database, int n) {
        try {
            WriterThread writerThread = new WriterThread(database, n);
            writerThread.thread = new Thread((Runnable)writerThread, "Glowroot-H2 Log Writer " + database.getShortName());
            Driver.setThreadContextClassLoader(writerThread.thread);
            writerThread.thread.setDaemon(true);
            return writerThread;
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Database database;
        while (!this.stop && (database = (Database)this.databaseRef.get()) != null) {
            int n;
            block11: {
                n = this.writeDelay;
                try {
                    if (database.isFileLockSerialized()) {
                        n = 5;
                        database.checkpointIfRequired();
                    } else {
                        database.flush();
                    }
                }
                catch (Exception exception) {
                    TraceSystem traceSystem = database.getTraceSystem();
                    if (traceSystem == null) break block11;
                    traceSystem.getTrace("database").error(exception, "flush");
                }
            }
            WriterThread writerThread = this;
            synchronized (writerThread) {
                int n2;
                for (n = Math.max(n, 5); !this.stop && n > 0; n -= n2) {
                    n2 = Math.min(n, 100);
                    try {
                        this.wait(n2);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.databaseRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        this.stop = true;
        WriterThread writerThread = this;
        synchronized (writerThread) {
            this.notify();
        }
    }

    public void startThread() {
        this.thread.start();
        this.thread = null;
    }
}

