/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.util;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glowroot.shaded.h2.Driver;
import org.glowroot.shaded.h2.jdbcx.JdbcDataSource;
import org.osgi.service.jdbc.DataSourceFactory;

public class OsgiDataSourceFactory
implements DataSourceFactory {
    private Driver driver;

    public OsgiDataSourceFactory(Driver driver) {
        this.driver = driver;
    }

    public DataSource createDataSource(Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(properties2);
        OsgiDataSourceFactory.rejectPoolingOptions(properties2);
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(jdbcDataSource, properties2);
        return jdbcDataSource;
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(properties2);
        OsgiDataSourceFactory.rejectPoolingOptions(properties2);
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(jdbcDataSource, properties2);
        return jdbcDataSource;
    }

    public XADataSource createXADataSource(Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(properties2);
        OsgiDataSourceFactory.rejectPoolingOptions(properties2);
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(jdbcDataSource, properties2);
        return jdbcDataSource;
    }

    public java.sql.Driver createDriver(Properties properties) throws SQLException {
        if (properties != null && !properties.isEmpty()) {
            throw new SQLException();
        }
        return this.driver;
    }

    private static void rejectUnsupportedOptions(Properties properties) throws SQLFeatureNotSupportedException {
        if (properties.containsKey("roleName")) {
            throw new SQLFeatureNotSupportedException("The roleName property is not supported by H2");
        }
        if (properties.containsKey("dataSourceName")) {
            throw new SQLFeatureNotSupportedException("The dataSourceName property is not supported by H2");
        }
    }

    private static void setupH2DataSource(JdbcDataSource jdbcDataSource, Properties properties) {
        if (properties.containsKey("user")) {
            jdbcDataSource.setUser((String)properties.remove("user"));
        }
        if (properties.containsKey("password")) {
            jdbcDataSource.setPassword((String)properties.remove("password"));
        }
        if (properties.containsKey("description")) {
            jdbcDataSource.setDescription((String)properties.remove("description"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (properties.containsKey("url")) {
            stringBuffer.append(properties.remove("url"));
            properties.remove("networkProtocol");
            properties.remove("serverName");
            properties.remove("portNumber");
            properties.remove("databaseName");
        } else {
            stringBuffer.append("jdbc:h2:");
            Object object = "";
            if (properties.containsKey("networkProtocol")) {
                object = (String)properties.remove("networkProtocol");
                stringBuffer.append((String)object).append(":");
            }
            if (properties.containsKey("serverName")) {
                stringBuffer.append("//").append(properties.remove("serverName"));
                if (properties.containsKey("portNumber")) {
                    stringBuffer.append(":").append(properties.remove("portNumber"));
                }
                stringBuffer.append("/");
            } else if (properties.containsKey("portNumber")) {
                stringBuffer.append("//localhost:").append(properties.remove("portNumber")).append("/");
            } else if (((String)object).equals("tcp") || ((String)object).equals("ssl")) {
                stringBuffer.append("//localhost/");
            }
            if (properties.containsKey("databaseName")) {
                stringBuffer.append(properties.remove("databaseName"));
            }
        }
        for (Object e : properties.keySet()) {
            stringBuffer.append(";").append(e).append("=").append(properties.get(e));
        }
        if (stringBuffer.length() > "jdbc:h2:".length()) {
            jdbcDataSource.setURL(stringBuffer.toString());
        }
    }

    private static void rejectPoolingOptions(Properties properties) throws SQLFeatureNotSupportedException {
        if (properties.containsKey("initialPoolSize") || properties.containsKey("maxIdleTime") || properties.containsKey("maxPoolSize") || properties.containsKey("maxStatements") || properties.containsKey("minPoolSize") || properties.containsKey("propertyCycle")) {
            throw new SQLFeatureNotSupportedException("Pooling properties are not supported by H2");
        }
    }
}

