/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.netty.channel.epoll;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.glowroot.shaded.netty.channel.Channel;
import org.glowroot.shaded.netty.channel.EventLoop;
import org.glowroot.shaded.netty.channel.epoll.AbstractEpollServerChannel;
import org.glowroot.shaded.netty.channel.epoll.EpollEventLoop;
import org.glowroot.shaded.netty.channel.epoll.EpollServerSocketChannelConfig;
import org.glowroot.shaded.netty.channel.epoll.EpollSocketChannel;
import org.glowroot.shaded.netty.channel.epoll.Native;
import org.glowroot.shaded.netty.channel.socket.ServerSocketChannel;
import org.glowroot.shaded.netty.channel.unix.FileDescriptor;

public final class EpollServerSocketChannel
extends AbstractEpollServerChannel
implements ServerSocketChannel {
    private final EpollServerSocketChannelConfig config = new EpollServerSocketChannelConfig(this);
    private volatile InetSocketAddress local;

    public EpollServerSocketChannel() {
        super(Native.socketStreamFd());
    }

    public EpollServerSocketChannel(FileDescriptor fd) {
        super(fd);
        this.local = Native.localAddress(fd.intValue());
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EpollEventLoop;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        InetSocketAddress addr = (InetSocketAddress)localAddress;
        EpollServerSocketChannel.checkResolvable(addr);
        int fd = this.fd().intValue();
        Native.bind(fd, addr);
        this.local = Native.localAddress(fd);
        Native.listen(fd, this.config.getBacklog());
        this.active = true;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public EpollServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected InetSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected Channel newChildChannel(int fd, byte[] address, int offset, int len) throws Exception {
        return new EpollSocketChannel(this, fd, Native.address(address, offset, len));
    }
}

