/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.ning.compress.lzf.parallel;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glowroot.shaded.ning.compress.lzf.LZFChunk;
import org.glowroot.shaded.ning.compress.lzf.parallel.BlockManager;
import org.glowroot.shaded.ning.compress.lzf.parallel.CompressTask;
import org.glowroot.shaded.ning.compress.lzf.parallel.WriteTask;

public class PLZFOutputStream
extends FilterOutputStream
implements WritableByteChannel {
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 65535;
    protected byte[] _outputBuffer;
    protected int _position = 0;
    protected boolean _outputStreamClosed = false;
    private BlockManager blockManager;
    private final ExecutorService compressExecutor;
    private final ExecutorService writeExecutor;
    volatile Exception writeException = null;

    public PLZFOutputStream(OutputStream outputStream) {
        this(outputStream, 65535, PLZFOutputStream.getNThreads());
    }

    protected PLZFOutputStream(OutputStream outputStream, int nThreads) {
        this(outputStream, 65535, nThreads);
    }

    protected PLZFOutputStream(OutputStream outputStream, int bufferSize, int nThreads) {
        super(outputStream);
        this.compressExecutor = new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ((ThreadPoolExecutor)this.compressExecutor).allowCoreThreadTimeOut(true);
        this.writeExecutor = Executors.newSingleThreadExecutor();
        this.blockManager = new BlockManager(nThreads * 2, bufferSize);
        this._outputBuffer = this.blockManager.getBlockFromPool();
    }

    protected static int getNThreads() {
        int nThreads = Runtime.getRuntime().availableProcessors();
        OperatingSystemMXBean jmx = ManagementFactory.getOperatingSystemMXBean();
        if (jmx != null) {
            int loadAverage = (int)jmx.getSystemLoadAverage();
            if (nThreads > 1 && loadAverage >= 1) {
                nThreads = Math.max(1, nThreads - loadAverage);
            }
        }
        return nThreads;
    }

    @Override
    public void write(int singleByte) throws IOException {
        this.checkNotClosed();
        if (this._position >= this._outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this._outputBuffer[this._position++] = (byte)singleByte;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        int BUFFER_LEN = this._outputBuffer.length;
        int free = BUFFER_LEN - this._position;
        if (free > length) {
            System.arraycopy(buffer, offset, this._outputBuffer, this._position, length);
            this._position += length;
            return;
        }
        System.arraycopy(buffer, offset, this._outputBuffer, this._position, free);
        offset += free;
        length -= free;
        this._position += free;
        this.writeCompressedBlock();
        while (length >= BUFFER_LEN) {
            System.arraycopy(buffer, offset, this._outputBuffer, 0, BUFFER_LEN);
            this._position = BUFFER_LEN;
            this.writeCompressedBlock();
            offset += BUFFER_LEN;
            length -= BUFFER_LEN;
        }
        if (length > 0) {
            System.arraycopy(buffer, offset, this._outputBuffer, 0, length);
        }
        this._position = length;
    }

    public void write(InputStream in) throws IOException {
        int read;
        this.writeCompressedBlock();
        while ((read = in.read(this._outputBuffer)) >= 0) {
            this._position = read;
            this.writeCompressedBlock();
        }
    }

    public void write(FileChannel in) throws IOException {
        MappedByteBuffer src = in.map(FileChannel.MapMode.READ_ONLY, 0L, in.size());
        this.write(src);
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        int r = src.remaining();
        if (r <= 0) {
            return r;
        }
        this.writeCompressedBlock();
        if (src.hasArray()) {
            this.write(src.array(), src.arrayOffset(), src.limit() - src.arrayOffset());
        } else {
            while (src.hasRemaining()) {
                int toRead = Math.min(src.remaining(), this._outputBuffer.length);
                src.get(this._outputBuffer, 0, toRead);
                this._position = toRead;
                this.writeCompressedBlock();
            }
        }
        return r;
    }

    @Override
    public void flush() throws IOException {
        this.checkNotClosed();
    }

    @Override
    public boolean isOpen() {
        return !this._outputStreamClosed;
    }

    @Override
    public void close() throws IOException {
        if (!this._outputStreamClosed) {
            byte[] buf;
            if (this._position > 0) {
                this.writeCompressedBlock();
            }
            if ((buf = this._outputBuffer) != null) {
                assert (this._position == 0);
                this.blockManager.releaseBlockToPool(this._outputBuffer);
                this._outputBuffer = null;
            }
            this.writeExecutor.shutdown();
            try {
                this.writeExecutor.awaitTermination(1L, TimeUnit.HOURS);
                int maxThreads = Runtime.getRuntime().availableProcessors();
                ArrayList<CompressTask> cleanupTasks = new ArrayList<CompressTask>(maxThreads);
                for (int i = 0; i < maxThreads; ++i) {
                    cleanupTasks.add(new CompressTask(null, -1, -1, null));
                }
                this.compressExecutor.invokeAll(cleanupTasks);
                this.compressExecutor.shutdown();
                this.compressExecutor.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            finally {
                super.flush();
                super.close();
                this._outputStreamClosed = true;
                this.compressExecutor.shutdownNow();
                this.writeExecutor.shutdownNow();
                this.blockManager = null;
                this.checkWriteException();
            }
        }
    }

    public OutputStream getUnderlyingOutputStream() {
        return this.out;
    }

    protected void writeCompressedBlock() throws IOException {
        if (this._position == 0) {
            return;
        }
        Future<LZFChunk> lzfFuture = this.compressExecutor.submit(new CompressTask(this._outputBuffer, 0, this._position, this.blockManager));
        this.writeExecutor.execute(new WriteTask(this.out, lzfFuture, this));
        this._outputBuffer = this.blockManager.getBlockFromPool();
        this._position = 0;
        this.checkWriteException();
    }

    protected void checkWriteException() throws IOException {
        if (this.writeException != null) {
            IOException ioe = this.writeException instanceof IOException ? (IOException)this.writeException : new IOException(this.writeException);
            this.writeException = null;
            throw ioe;
        }
    }

    protected void checkNotClosed() throws IOException {
        if (this._outputStreamClosed) {
            throw new IOException(this.getClass().getName() + " already closed");
        }
    }
}

