/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.classic.jul;

import org.glowroot.shaded.qos.logback.classic.Level;
import org.glowroot.shaded.qos.logback.classic.Logger;

public class JULHelper {
    public static final boolean isRegularNonRootLogger(org.glowroot.shaded.jul.Logger julLogger) {
        if (julLogger == null) {
            return false;
        }
        return !julLogger.getName().equals("");
    }

    public static final boolean isRoot(org.glowroot.shaded.jul.Logger julLogger) {
        if (julLogger == null) {
            return false;
        }
        return julLogger.getName().equals("");
    }

    public static org.glowroot.shaded.jul.Level asJULLevel(Level lbLevel) {
        if (lbLevel == null) {
            throw new IllegalArgumentException("Unexpected level [null]");
        }
        switch (lbLevel.levelInt) {
            case -2147483648: {
                return org.glowroot.shaded.jul.Level.ALL;
            }
            case 5000: {
                return org.glowroot.shaded.jul.Level.FINEST;
            }
            case 10000: {
                return org.glowroot.shaded.jul.Level.FINE;
            }
            case 20000: {
                return org.glowroot.shaded.jul.Level.INFO;
            }
            case 30000: {
                return org.glowroot.shaded.jul.Level.WARNING;
            }
            case 40000: {
                return org.glowroot.shaded.jul.Level.SEVERE;
            }
            case 0x7FFFFFFF: {
                return org.glowroot.shaded.jul.Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unexpected level [" + lbLevel + "]");
    }

    public static String asJULLoggerName(String loggerName) {
        if ("ROOT".equals(loggerName)) {
            return "";
        }
        return loggerName;
    }

    public static org.glowroot.shaded.jul.Logger asJULLogger(String loggerName) {
        String julLoggerName = JULHelper.asJULLoggerName(loggerName);
        return org.glowroot.shaded.jul.Logger.getLogger(julLoggerName);
    }

    public static org.glowroot.shaded.jul.Logger asJULLogger(Logger logger) {
        return JULHelper.asJULLogger(logger.getName());
    }
}

