/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.classic.util;

import org.glowroot.shaded.qos.logback.classic.LoggerContext;
import org.glowroot.shaded.qos.logback.core.spi.ContextAware;
import org.glowroot.shaded.qos.logback.core.spi.LifeCycle;
import org.glowroot.shaded.qos.logback.core.status.OnConsoleStatusListener;
import org.glowroot.shaded.qos.logback.core.status.StatusListener;
import org.glowroot.shaded.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    static void installIfAsked(LoggerContext loggerContext) {
        String slClass = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isEmpty(slClass)) {
            StatusListenerConfigHelper.addStatusListener(loggerContext, slClass);
        }
    }

    private static void addStatusListener(LoggerContext loggerContext, String listenerClass) {
        StatusListener listener = null;
        listener = "SYSOUT".equalsIgnoreCase(listenerClass) ? new OnConsoleStatusListener() : StatusListenerConfigHelper.createListenerPerClassName(loggerContext, listenerClass);
        StatusListenerConfigHelper.initAndAddListener(loggerContext, listener);
    }

    private static void initAndAddListener(LoggerContext loggerContext, StatusListener listener) {
        if (listener != null) {
            if (listener instanceof ContextAware) {
                ((ContextAware)((Object)listener)).setContext(loggerContext);
            }
            if (listener instanceof LifeCycle) {
                ((LifeCycle)((Object)listener)).start();
            }
            loggerContext.getStatusManager().add(listener);
        }
    }

    private static StatusListener createListenerPerClassName(LoggerContext loggerContext, String listenerClass) {
        try {
            return (StatusListener)OptionHelper.instantiateByClassName(listenerClass, StatusListener.class, loggerContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

