/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.core.rolling.helper;

import java.io.File;
import java.util.Date;
import org.glowroot.shaded.qos.logback.core.pattern.Converter;
import org.glowroot.shaded.qos.logback.core.pattern.LiteralConverter;
import org.glowroot.shaded.qos.logback.core.rolling.helper.ArchiveRemover;
import org.glowroot.shaded.qos.logback.core.rolling.helper.DateTokenConverter;
import org.glowroot.shaded.qos.logback.core.rolling.helper.FileFilterUtil;
import org.glowroot.shaded.qos.logback.core.rolling.helper.FileNamePattern;
import org.glowroot.shaded.qos.logback.core.rolling.helper.RollingCalendar;
import org.glowroot.shaded.qos.logback.core.spi.ContextAwareBase;

public abstract class DefaultArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 5529600000L;
    static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    int periodOffsetForDeletionTarget;
    final boolean parentClean;
    long lastHeartBeat = -1L;

    public DefaultArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rc;
        this.parentClean = this.computeParentCleaningFlag(fileNamePattern);
    }

    int computeElapsedPeriodsSinceLastClean(long nowInMillis) {
        long periodsElapsed = 0L;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            periodsElapsed = this.rc.periodsElapsed(nowInMillis, nowInMillis + 5529600000L);
            if (periodsElapsed > 336L) {
                periodsElapsed = 336L;
            }
        } else {
            periodsElapsed = this.rc.periodsElapsed(this.lastHeartBeat, nowInMillis);
            if (periodsElapsed < 1L) {
                this.addWarn("Unexpected periodsElapsed value " + periodsElapsed);
                periodsElapsed = 1L;
            }
        }
        return (int)periodsElapsed;
    }

    @Override
    public void clean(Date now) {
        long nowInMillis = now.getTime();
        int periodsElapsed = this.computeElapsedPeriodsSinceLastClean(nowInMillis);
        this.lastHeartBeat = nowInMillis;
        if (periodsElapsed > 1) {
            this.addInfo("periodsElapsed = " + periodsElapsed);
        }
        for (int i = 0; i < periodsElapsed; ++i) {
            this.cleanByPeriodOffset(now, this.periodOffsetForDeletionTarget - i);
        }
    }

    abstract void cleanByPeriodOffset(Date var1, int var2);

    boolean computeParentCleaningFlag(FileNamePattern fileNamePattern) {
        Converter<Object> p;
        DateTokenConverter dtc = fileNamePattern.getPrimaryDateTokenConverter();
        if (dtc.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (p = fileNamePattern.headTokenConverter; p != null && !(p instanceof DateTokenConverter); p = p.getNext()) {
        }
        while (p != null) {
            String s;
            if (p instanceof LiteralConverter && (s = p.convert(null)).indexOf(47) != -1) {
                return true;
            }
            p = p.getNext();
        }
        return false;
    }

    void removeFolderIfEmpty(File dir) {
        this.removeFolderIfEmpty(dir, 0);
    }

    private void removeFolderIfEmpty(File dir, int depth) {
        if (depth >= 3) {
            return;
        }
        if (dir.isDirectory() && FileFilterUtil.isEmptyDirectory(dir)) {
            this.addInfo("deleting folder [" + dir + "]");
            dir.delete();
            this.removeFolderIfEmpty(dir.getParentFile(), depth + 1);
        }
    }

    @Override
    public void setMaxHistory(int maxHistory) {
        this.periodOffsetForDeletionTarget = -maxHistory - 1;
    }
}

