/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import javax.annotation.Nullable;
import org.glowroot.api.PluginServices;
import org.glowroot.markers.UsedByReflection;
import org.glowroot.shaded.google.common.base.Supplier;
import org.glowroot.shaded.google.common.base.Suppliers;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.cache.CacheLoader;
import org.glowroot.shaded.google.common.cache.LoadingCache;

@UsedByReflection
public class PluginServicesRegistry {
    @Nullable
    private static volatile PluginServicesRegistry INSTANCE;
    private final LoadingCache<String, PluginServices> pluginServices;
    private final Supplier<PluginServices> pluginServicesWithoutPlugin;

    private PluginServicesRegistry(final PluginServicesFactory pluginServicesFactory) {
        this.pluginServices = CacheBuilder.newBuilder().build(new CacheLoader<String, PluginServices>(){

            @Override
            public PluginServices load(String pluginId) {
                return pluginServicesFactory.create(pluginId);
            }
        });
        this.pluginServicesWithoutPlugin = Suppliers.memoize(new Supplier<PluginServices>(){

            @Override
            public PluginServices get() {
                return pluginServicesFactory.create(null);
            }
        });
    }

    private PluginServices getPluginServices(@Nullable String pluginId) {
        if (pluginId == null) {
            return this.pluginServicesWithoutPlugin.get();
        }
        return this.pluginServices.getUnchecked(pluginId);
    }

    @Nullable
    @UsedByReflection
    public static PluginServices get(@Nullable String pluginId) {
        PluginServicesRegistry instanceLocal = INSTANCE;
        if (instanceLocal == null) {
            return null;
        }
        return instanceLocal.getPluginServices(pluginId);
    }

    static void initStaticState(PluginServicesFactory pluginServicesFactory) {
        INSTANCE = new PluginServicesRegistry(pluginServicesFactory);
    }

    static void clearStaticState() {
        INSTANCE = null;
    }

    static interface PluginServicesFactory {
        public PluginServices create(@Nullable String var1);
    }
}

