/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.api.PluginServices;
import org.glowroot.common.Clock;
import org.glowroot.config.ConfigModule;
import org.glowroot.config.ConfigService;
import org.glowroot.jvm.ThreadAllocatedBytes;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.transaction.AdviceCache;
import org.glowroot.transaction.ImmediateTraceStoreWatcher;
import org.glowroot.transaction.PluginServicesImpl;
import org.glowroot.transaction.PluginServicesRegistry;
import org.glowroot.transaction.TimerNameCache;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.UserProfileScheduler;
import org.glowroot.transaction.WeavingTimerServiceImpl;
import org.glowroot.weaving.AnalyzedWorld;
import org.glowroot.weaving.ExtraBootResourceFinder;
import org.glowroot.weaving.PreInitializeWeavingClasses;
import org.glowroot.weaving.WeavingClassFileTransformer;
import org.glowroot.weaving.WeavingTimerService;

public class TransactionModule {
    private final AnalyzedWorld analyzedWorld;
    private final TransactionRegistry transactionRegistry;
    private final AdviceCache adviceCache;
    private final WeavingTimerService weavingTimerService;
    private final ImmediateTraceStoreWatcher immedateTraceStoreWatcher;
    private final boolean timerWrapperMethods;
    private final boolean jvmRetransformClassesSupported;
    private final PluginServicesRegistry.PluginServicesFactory pluginServicesFactory;

    public TransactionModule(final Clock clock, final Ticker ticker, final ConfigModule configModule, final TransactionCollector transactionCollector, final @Nullable ThreadAllocatedBytes threadAllocatedBytes, @Nullable Instrumentation instrumentation, File dataDir, @Nullable ExtraBootResourceFinder extraBootResourceFinder, ScheduledExecutorService scheduledExecutor) throws Exception {
        ConfigService configService = configModule.getConfigService();
        this.transactionRegistry = new TransactionRegistry();
        this.adviceCache = new AdviceCache(configModule.getPluginDescriptors(), configModule.getPluginJars(), configService.getInstrumentationConfigs(), instrumentation, dataDir);
        this.analyzedWorld = new AnalyzedWorld(this.adviceCache.getAdvisorsSupplier(), this.adviceCache.getShimTypes(), this.adviceCache.getMixinTypes(), extraBootResourceFinder);
        final TimerNameCache timerNameCache = new TimerNameCache();
        this.weavingTimerService = new WeavingTimerServiceImpl(this.transactionRegistry, configService, timerNameCache);
        this.timerWrapperMethods = configModule.getConfigService().getAdvancedConfig().timerWrapperMethods();
        if (instrumentation != null) {
            WeavingClassFileTransformer transformer = new WeavingClassFileTransformer(this.adviceCache.getShimTypes(), this.adviceCache.getMixinTypes(), this.adviceCache.getAdvisorsSupplier(), this.analyzedWorld, this.weavingTimerService, this.timerWrapperMethods);
            PreInitializeWeavingClasses.preInitializeClasses();
            if (instrumentation.isRetransformClassesSupported()) {
                instrumentation.addTransformer(transformer, true);
                this.jvmRetransformClassesSupported = true;
            } else {
                instrumentation.addTransformer(transformer);
                this.jvmRetransformClassesSupported = false;
            }
        } else {
            this.jvmRetransformClassesSupported = false;
        }
        this.immedateTraceStoreWatcher = new ImmediateTraceStoreWatcher(scheduledExecutor, this.transactionRegistry, transactionCollector, configService, ticker);
        this.immedateTraceStoreWatcher.scheduleWithFixedDelay(scheduledExecutor, 0L, 1000L, TimeUnit.MILLISECONDS);
        final UserProfileScheduler userProfileScheduler = new UserProfileScheduler(scheduledExecutor, configService);
        final TransactionRegistry transactionRegistry = this.transactionRegistry;
        this.pluginServicesFactory = new PluginServicesRegistry.PluginServicesFactory(){

            @Override
            public PluginServices create(@Nullable String pluginId) {
                return PluginServicesImpl.create(transactionRegistry, transactionCollector, configModule.getConfigService(), timerNameCache, threadAllocatedBytes, userProfileScheduler, ticker, clock, configModule.getPluginDescriptors(), pluginId);
            }
        };
        PluginServicesRegistry.initStaticState(this.pluginServicesFactory);
    }

    public AnalyzedWorld getAnalyzedWorld() {
        return this.analyzedWorld;
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public AdviceCache getAdviceCache() {
        return this.adviceCache;
    }

    public WeavingTimerService getWeavingTimerService() {
        return this.weavingTimerService;
    }

    public boolean isTimerWrapperMethods() {
        return this.timerWrapperMethods;
    }

    public boolean isJvmRetransformClassesSupported() {
        return this.jvmRetransformClassesSupported;
    }

    @OnlyUsedByTests
    public void reopen() {
        PluginServicesRegistry.initStaticState(this.pluginServicesFactory);
    }

    @OnlyUsedByTests
    public void close() {
        this.immedateTraceStoreWatcher.cancel();
        PluginServicesRegistry.clearStaticState();
    }
}

