/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.Collection;
import javax.annotation.Nullable;
import org.glowroot.api.FastThreadLocal;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.transaction.model.Transaction;

public class TransactionRegistry {
    private final Collection<Transaction> transactions = Sets.newConcurrentHashSet();
    private final FastThreadLocal<Transaction> currentTransaction = new FastThreadLocal();

    @Nullable
    Transaction getCurrentTransaction() {
        return this.currentTransaction.get();
    }

    void addTransaction(Transaction transaction) {
        this.currentTransaction.set(transaction);
        this.transactions.add(transaction);
    }

    void removeTransaction(Transaction transaction) {
        this.currentTransaction.set(null);
        this.transactions.remove(transaction);
    }

    public Collection<Transaction> getTransactions() {
        return this.transactions;
    }
}

