/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import javax.annotation.Nullable;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.TimerNameImpl;

class NestedTimerMap {
    @Nullable
    private final Entry[] table = new Entry[16];

    NestedTimerMap() {
    }

    @Nullable
    TimerImpl get(TimerNameImpl timerName) {
        int bucket = timerName.specialHashCode() & this.table.length - 1;
        Entry entry = this.table[bucket];
        while (entry != null) {
            if (entry.timerName == timerName) {
                return entry.timer;
            }
            entry = entry.nextEntry;
        }
        return null;
    }

    void put(TimerNameImpl timerName, TimerImpl timer) {
        Entry nextEntry;
        Entry newEntry = new Entry(timerName, timer);
        int bucket = timerName.specialHashCode() & this.table.length - 1;
        Entry entry = this.table[bucket];
        if (entry == null) {
            this.table[bucket] = newEntry;
            return;
        }
        while ((nextEntry = entry.nextEntry) != null) {
            entry = nextEntry;
        }
        entry.nextEntry = newEntry;
    }

    private static class Entry {
        private final TimerNameImpl timerName;
        private final TimerImpl timer;
        @Nullable
        private Entry nextEntry;

        private Entry(TimerNameImpl timerName, TimerImpl timer) {
            this.timerName = timerName;
            this.timer = timer;
        }
    }
}

