/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.io.IOException;
import org.glowroot.api.Timer;
import org.glowroot.common.Tickers;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.google.common.base.Ticker;

public class QueryData
implements Timer {
    private static final Ticker ticker = Tickers.getTicker();
    private long totalTime;
    private long executionCount;
    private long totalRows;
    private long startTick;
    private int selfNestingLevel;

    public void writeValue(String queryType, String queryText, JsonGenerator jg) throws IOException {
        boolean active;
        jg.writeStartObject();
        jg.writeStringField("queryType", queryType);
        jg.writeStringField("queryText", queryText);
        boolean bl = active = this.selfNestingLevel > 0;
        if (active) {
            long theTotalTime = this.totalTime;
            long theTotalRows = this.totalRows;
            long theStartTick = this.startTick;
            long curr = ticker.read() - theStartTick;
            jg.writeNumberField("totalTime", theTotalTime + curr);
            jg.writeNumberField("executionCount", this.executionCount);
            jg.writeNumberField("totalRows", theTotalRows);
            jg.writeBooleanField("active", true);
        } else {
            jg.writeNumberField("totalTime", this.totalTime);
            jg.writeNumberField("executionCount", this.executionCount);
            jg.writeNumberField("totalRows", this.totalRows);
        }
        jg.writeEndObject();
    }

    public void start(long startTick, long batchSize) {
        if (this.selfNestingLevel++ == 0) {
            this.startTick = startTick;
            this.executionCount += batchSize;
        }
    }

    @Override
    public void stop() {
        if (--this.selfNestingLevel == 0) {
            this.endInternal(ticker.read());
        }
    }

    public void end(long endTick) {
        if (--this.selfNestingLevel == 0) {
            this.endInternal(endTick);
        }
    }

    public void incrementRowCount(long inc) {
        this.totalRows += inc;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public void extend(long startTick) {
        if (this.selfNestingLevel++ == 0) {
            this.startTick = startTick;
        }
    }

    public void extend() {
        if (this.selfNestingLevel++ == 0) {
            this.startTick = ticker.read();
        }
    }

    boolean isActive() {
        return this.selfNestingLevel > 0;
    }

    private void endInternal(long endTick) {
        this.totalTime += endTick - this.startTick;
    }
}

