/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Strings;

class TraceUniqueId {
    private static final AtomicLong idCounter = new AtomicLong();
    private static final long HEX_DIGITS = 16L;
    private static final long MAX_ID = (long)Math.pow(16.0, 6.0);
    private final long traceStartTime;
    private final long id;

    public TraceUniqueId(long traceStartTime) {
        this.traceStartTime = traceStartTime;
        this.id = idCounter.getAndIncrement();
    }

    public String get() {
        return TraceUniqueId.twelveDigitHex(this.traceStartTime) + BigInteger.valueOf(this.id % MAX_ID).toString(16);
    }

    @VisibleForTesting
    static String twelveDigitHex(long x) {
        String s = BigInteger.valueOf(x).toString(16);
        if (s.length() == 11) {
            return '0' + s;
        }
        if (s.length() == 12) {
            return s;
        }
        if (s.length() > 12) {
            return s.substring(s.length() - 12);
        }
        return Strings.padStart(s, 12, '0');
    }
}

