/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceMatcherBase;

@ParametersAreNonnullByDefault
@Immutable
final class AdviceMatcher
extends AdviceMatcherBase {
    private final Advice advice;

    private AdviceMatcher(Advice advice) {
        this.advice = Preconditions.checkNotNull(advice);
    }

    private AdviceMatcher(Builder builder) {
        this.advice = builder.advice;
    }

    private AdviceMatcher(AdviceMatcher original, Advice advice) {
        this.advice = advice;
    }

    @Override
    public Advice advice() {
        return this.advice;
    }

    public final AdviceMatcher withAdvice(Advice value) {
        if (this.advice == value) {
            return this;
        }
        Advice newValue = Preconditions.checkNotNull(value);
        return new AdviceMatcher(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AdviceMatcher && this.equalTo((AdviceMatcher)another);
    }

    private boolean equalTo(AdviceMatcher another) {
        return this.advice.equals(another.advice);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.advice.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AdviceMatcher").add("advice", this.advice).toString();
    }

    public static AdviceMatcher of(Advice advice) {
        return new AdviceMatcher(advice);
    }

    static AdviceMatcher copyOf(AdviceMatcherBase instance) {
        if (instance instanceof AdviceMatcher) {
            return (AdviceMatcher)instance;
        }
        return AdviceMatcher.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_ADVICE = 1L;
        private long initializedBitset;
        @Nullable
        private Advice advice;

        private Builder() {
        }

        public final Builder from(AdviceMatcherBase instance) {
            Preconditions.checkNotNull(instance);
            this.advice(instance.advice());
            return this;
        }

        public final Builder advice(Advice advice) {
            this.advice = Preconditions.checkNotNull(advice);
            this.initializedBitset |= 1L;
            return this;
        }

        public AdviceMatcher build() {
            this.checkRequiredAttributes();
            return new AdviceMatcher(this);
        }

        private boolean adviceIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.adviceIsSet()) {
                attributes.add("advice");
            }
            return "Cannot build AdviceMatcher, some of required attributes are not set " + attributes;
        }
    }
}

