/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.common.Reflections;
import org.glowroot.markers.UsedByGeneratedBytecode;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.GeneratedBytecodeUtil;

@UsedByGeneratedBytecode
public class BootstrapMetaHolders {
    private static final Map<String, Integer> classMetaHolderIndexes = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> methodMetaHolderIndexes = new ConcurrentHashMap<String, Integer>();
    private static final List<ClassMetaHolder> classMetaHolders = Lists.newCopyOnWriteArrayList();
    private static final List<MethodMetaHolder> methodMetaHolders = Lists.newCopyOnWriteArrayList();

    private BootstrapMetaHolders() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int reserveClassMetaHolderIndex(String metaHolderInternalName, String classMetaFieldName) {
        List<ClassMetaHolder> list = classMetaHolders;
        synchronized (list) {
            String key = metaHolderInternalName + '.' + classMetaFieldName;
            Integer index = classMetaHolderIndexes.get(key);
            if (index == null) {
                classMetaHolders.add(null);
                index = classMetaHolders.size() - 1;
                classMetaHolderIndexes.put(key, index);
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int reserveMethodMetaHolderIndex(String metaHolderInternalName, String methodMetaFieldName) {
        List<MethodMetaHolder> list = methodMetaHolders;
        synchronized (list) {
            methodMetaHolders.add(null);
            int index = methodMetaHolders.size() - 1;
            methodMetaHolderIndexes.put(metaHolderInternalName + '.' + methodMetaFieldName, index);
            return index;
        }
    }

    public static void createClassMetaHolder(String metaHolderInternalName, String classMetaFieldName, Type classMetaType, Type type) {
        String key = metaHolderInternalName + '.' + classMetaFieldName;
        Integer index = classMetaHolderIndexes.get(key);
        Preconditions.checkNotNull(index, "ClassMetaHolder was not reserved for key: " + key);
        ClassMetaHolder classMetaHolder = new ClassMetaHolder(classMetaType, type);
        classMetaHolders.set(index, classMetaHolder);
    }

    public static void createMethodMetaHolder(String metaHolderInternalName, String methodMetaFieldName, Type methodMetaType, Type type, Type returnType, List<Type> parameterTypes) {
        String key = metaHolderInternalName + '.' + methodMetaFieldName;
        Integer index = methodMetaHolderIndexes.get(key);
        Preconditions.checkNotNull(index, "MethodMetaHolder was not reserved for key: " + key);
        MethodMetaHolder methodMetaHolder = new MethodMetaHolder(methodMetaType, type, returnType, parameterTypes);
        methodMetaHolders.set(index, methodMetaHolder);
    }

    @UsedByGeneratedBytecode
    public static Object getClassMeta(int index) throws Exception {
        ClassMetaHolder classMetaHolder = classMetaHolders.get(index);
        Preconditions.checkNotNull(classMetaHolder, "ClassMetaHolder was not instantiated for index: " + index);
        return classMetaHolder.getClassMeta();
    }

    @UsedByGeneratedBytecode
    public static Object getMethodMeta(int index) throws Exception {
        MethodMetaHolder methodMetaHolder = methodMetaHolders.get(index);
        Preconditions.checkNotNull(methodMetaHolder, "MethodMetaHolder was not instantiated for index: " + index);
        return methodMetaHolder.getMethodMeta();
    }

    private static Class<?> getType(Type type) throws ClassNotFoundException {
        switch (type.getSort()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 9: {
                return GeneratedBytecodeUtil.getArrayClass(BootstrapMetaHolders.getType(type.getElementType()), type.getDimensions());
            }
        }
        return Class.forName(type.getClassName(), false, null);
    }

    private static class MethodMetaHolder {
        private final Type methodMetaType;
        private final Type type;
        private final Type returnType;
        private final List<Type> parameterTypes;
        @MonotonicNonNull
        private volatile Object methodMeta;

        private MethodMetaHolder(Type methodMetaType, Type type, Type returnType, List<Type> parameterTypes) {
            this.methodMetaType = methodMetaType;
            this.type = type;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getMethodMeta() throws Exception {
            Object methodMetaLocal = this.methodMeta;
            if (methodMetaLocal != null) {
                return methodMetaLocal;
            }
            MethodMetaHolder methodMetaHolder = this;
            synchronized (methodMetaHolder) {
                if (this.methodMeta == null) {
                    Class classMetaClass = BootstrapMetaHolders.getType(this.methodMetaType);
                    Class wovenClass = BootstrapMetaHolders.getType(this.type);
                    Class returnClass = BootstrapMetaHolders.getType(this.returnType);
                    Class[] parameterClasses = new Class[this.parameterTypes.size()];
                    for (int i = 0; i < this.parameterTypes.size(); ++i) {
                        parameterClasses[i] = BootstrapMetaHolders.getType(this.parameterTypes.get(i));
                    }
                    Constructor constructor = Reflections.getConstructor(classMetaClass, Class.class, Class.class, Class[].class);
                    this.methodMeta = Reflections.invoke(constructor, wovenClass, returnClass, parameterClasses);
                }
            }
            return this.methodMeta;
        }
    }

    private static class ClassMetaHolder {
        private final Type classMetaType;
        private final Type type;
        @MonotonicNonNull
        private volatile Object classMeta;

        private ClassMetaHolder(Type classMetaType, Type type) {
            this.classMetaType = classMetaType;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getClassMeta() throws Exception {
            Object classMetaLocal = this.classMeta;
            if (classMetaLocal != null) {
                return classMetaLocal;
            }
            ClassMetaHolder classMetaHolder = this;
            synchronized (classMetaHolder) {
                if (this.classMeta == null) {
                    Class classMetaClass = BootstrapMetaHolders.getType(this.classMetaType);
                    Class wovenClass = BootstrapMetaHolders.getType(this.type);
                    Constructor constructor = Reflections.getConstructor(classMetaClass, Class.class);
                    this.classMeta = Reflections.invoke(constructor, wovenClass);
                }
            }
            return this.classMeta;
        }
    }
}

