/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.glowroot.common.Reflections;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.io.Closer;
import org.glowroot.weaving.LazyDefinedClass;

public class ClassLoaders {
    private ClassLoaders() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defineClassesInBootstrapClassLoader(Collection<LazyDefinedClass> lazyDefinedClasses, Instrumentation instrumentation, File generatedJarFile) throws IOException {
        Closer closer = Closer.create();
        try {
            FileOutputStream out = closer.register(new FileOutputStream(generatedJarFile));
            JarOutputStream jarOut = closer.register(new JarOutputStream(out));
            ClassLoaders.generate(lazyDefinedClasses, jarOut);
        }
        catch (Throwable t) {
            closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(generatedJarFile));
    }

    public static void defineClassesInClassLoader(Collection<LazyDefinedClass> lazyDefinedClasses, ClassLoader loader) throws Exception {
        for (LazyDefinedClass lazyDefinedClass : lazyDefinedClasses) {
            ClassLoaders.defineClass(lazyDefinedClass, loader);
        }
    }

    static Class<?> defineClass(LazyDefinedClass lazyDefinedClass, ClassLoader loader) throws Exception {
        for (LazyDefinedClass dependency : lazyDefinedClass.dependencies()) {
            ClassLoaders.defineClass(dependency, loader);
        }
        return ClassLoaders.defineClass(lazyDefinedClass.type().getClassName(), lazyDefinedClass.bytes(), loader);
    }

    static Class<?> defineClass(String name, byte[] bytes, ClassLoader loader) throws Exception {
        Method defineClassMethod = Reflections.getDeclaredMethod(ClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        Class definedClass = (Class)Reflections.invoke(defineClassMethod, (Object)loader, name, bytes, 0, bytes.length);
        Preconditions.checkNotNull(definedClass);
        return definedClass;
    }

    public static void createDirectoryOrCleanPreviousContentsWithPrefix(File dir, String prefix) throws IOException {
        ClassLoaders.deleteIfRegularFile(dir);
        if (dir.exists()) {
            ClassLoaders.deleteFilesWithPrefix(dir, prefix);
        } else {
            ClassLoaders.createDirectory(dir);
        }
    }

    private static void generate(Collection<LazyDefinedClass> lazyDefinedClasses, JarOutputStream jarOut) throws IOException {
        for (LazyDefinedClass lazyDefinedClass : lazyDefinedClasses) {
            JarEntry jarEntry = new JarEntry(lazyDefinedClass.type().getInternalName() + ".class");
            jarOut.putNextEntry(jarEntry);
            jarOut.write(lazyDefinedClass.bytes());
            jarOut.closeEntry();
            ClassLoaders.generate(lazyDefinedClass.dependencies(), jarOut);
        }
    }

    private static void deleteIfRegularFile(File file) throws IOException {
        if (file.isFile() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    private static void deleteFilesWithPrefix(File dir, String prefix) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Could not get listing for directory: " + dir.getAbsolutePath());
        }
        for (File file : files) {
            if (!file.getName().startsWith(prefix) || file.delete()) continue;
            throw new IOException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    private static void createDirectory(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException("Could not create directory: " + dir.getAbsolutePath());
        }
    }
}

