/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.LazyDefinedClassBase;

@ParametersAreNonnullByDefault
@Immutable
public final class LazyDefinedClass
extends LazyDefinedClassBase {
    private final Type type;
    private final byte[] bytes;
    private final ImmutableList<LazyDefinedClass> dependencies;

    private LazyDefinedClass(Builder builder) {
        this.type = builder.type;
        this.bytes = builder.bytes;
        this.dependencies = builder.dependenciesBuilder.build();
    }

    private LazyDefinedClass(LazyDefinedClass original, Type type, byte[] bytes, ImmutableList<LazyDefinedClass> dependencies) {
        this.type = type;
        this.bytes = bytes;
        this.dependencies = dependencies;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    @Override
    public ImmutableList<LazyDefinedClass> dependencies() {
        return this.dependencies;
    }

    public final LazyDefinedClass withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value);
        return new LazyDefinedClass(this, newValue, this.bytes, this.dependencies);
    }

    public final LazyDefinedClass withBytes(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new LazyDefinedClass(this, this.type, newValue, this.dependencies);
    }

    public final LazyDefinedClass withDependencies(LazyDefinedClass ... elements) {
        ImmutableList<LazyDefinedClass> newValue = ImmutableList.copyOf(elements);
        return new LazyDefinedClass(this, this.type, this.bytes, newValue);
    }

    public final LazyDefinedClass withDependencies(Iterable<? extends LazyDefinedClass> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        ImmutableList<LazyDefinedClass> newValue = ImmutableList.copyOf(elements);
        return new LazyDefinedClass(this, this.type, this.bytes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof LazyDefinedClass && this.equalTo((LazyDefinedClass)another);
    }

    private boolean equalTo(LazyDefinedClass another) {
        return this.type.equals(another.type) && Arrays.equals(this.bytes, another.bytes) && this.dependencies.equals(another.dependencies);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Arrays.hashCode(this.bytes);
        h = h * 17 + this.dependencies.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("LazyDefinedClass").add("type", this.type).add("bytes", Arrays.toString(this.bytes)).add("dependencies", this.dependencies).toString();
    }

    public static LazyDefinedClass copyOf(LazyDefinedClassBase instance) {
        if (instance instanceof LazyDefinedClass) {
            return (LazyDefinedClass)instance;
        }
        return LazyDefinedClass.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_TYPE = 1L;
        private static final long INITIALIZED_BIT_BYTES = 2L;
        private long initializedBitset;
        @Nullable
        private Type type;
        @Nullable
        private byte[] bytes;
        private ImmutableList.Builder<LazyDefinedClass> dependenciesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(LazyDefinedClassBase instance) {
            Preconditions.checkNotNull(instance);
            this.type(instance.type());
            this.bytes(instance.bytes());
            this.addAllDependencies(instance.dependencies());
            return this;
        }

        public final Builder type(Type type) {
            this.type = Preconditions.checkNotNull(type);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder bytes(byte ... elements) {
            this.bytes = (byte[])elements.clone();
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addDependencies(LazyDefinedClass element) {
            this.dependenciesBuilder.add((Object)element);
            return this;
        }

        public final Builder addDependencies(LazyDefinedClass ... elements) {
            this.dependenciesBuilder.add(elements);
            return this;
        }

        public final Builder dependencies(Iterable<? extends LazyDefinedClass> elements) {
            this.dependenciesBuilder = ImmutableList.builder();
            return this.addAllDependencies(elements);
        }

        public final Builder addAllDependencies(Iterable<? extends LazyDefinedClass> elements) {
            this.dependenciesBuilder.addAll(elements);
            return this;
        }

        public LazyDefinedClass build() {
            this.checkRequiredAttributes();
            return new LazyDefinedClass(this);
        }

        private boolean typeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean bytesIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.bytesIsSet()) {
                attributes.add("bytes");
            }
            return "Cannot build LazyDefinedClass, some of required attributes are not set " + attributes;
        }
    }
}

