/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.MixinTypeBase;

@ParametersAreNonnullByDefault
@Immutable
public final class MixinType
extends MixinTypeBase {
    private final Type implementation;
    private final ImmutableList<String> targets;
    private final ImmutableList<Type> interfaces;
    @Nullable
    private final String initMethodName;
    private final byte[] implementationBytes;

    private MixinType(Builder builder) {
        this.implementation = builder.implementation;
        this.targets = builder.targetsBuilder.build();
        this.interfaces = builder.interfacesBuilder.build();
        this.initMethodName = builder.initMethodName;
        this.implementationBytes = builder.implementationBytes;
    }

    private MixinType(MixinType original, Type implementation, ImmutableList<String> targets, ImmutableList<Type> interfaces, @Nullable String initMethodName, byte[] implementationBytes) {
        this.implementation = implementation;
        this.targets = targets;
        this.interfaces = interfaces;
        this.initMethodName = initMethodName;
        this.implementationBytes = implementationBytes;
    }

    @Override
    public Type implementation() {
        return this.implementation;
    }

    @Override
    public ImmutableList<String> targets() {
        return this.targets;
    }

    @Override
    public ImmutableList<Type> interfaces() {
        return this.interfaces;
    }

    @Override
    @Nullable
    public String initMethodName() {
        return this.initMethodName;
    }

    @Override
    public byte[] implementationBytes() {
        return (byte[])this.implementationBytes.clone();
    }

    public final MixinType withImplementation(Type value) {
        if (this.implementation == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value);
        return new MixinType(this, newValue, this.targets, this.interfaces, this.initMethodName, this.implementationBytes);
    }

    public final MixinType withTargets(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MixinType(this, this.implementation, newValue, this.interfaces, this.initMethodName, this.implementationBytes);
    }

    public final MixinType withTargets(Iterable<String> elements) {
        if (this.targets == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MixinType(this, this.implementation, newValue, this.interfaces, this.initMethodName, this.implementationBytes);
    }

    public final MixinType withInterfaces(Type ... elements) {
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new MixinType(this, this.implementation, this.targets, newValue, this.initMethodName, this.implementationBytes);
    }

    public final MixinType withInterfaces(Iterable<? extends Type> elements) {
        if (this.interfaces == elements) {
            return this;
        }
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new MixinType(this, this.implementation, this.targets, newValue, this.initMethodName, this.implementationBytes);
    }

    public final MixinType withInitMethodName(@Nullable String value) {
        if (this.initMethodName == value) {
            return this;
        }
        String newValue = value;
        return new MixinType(this, this.implementation, this.targets, this.interfaces, newValue, this.implementationBytes);
    }

    public final MixinType withImplementationBytes(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new MixinType(this, this.implementation, this.targets, this.interfaces, this.initMethodName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MixinType && this.equalTo((MixinType)another);
    }

    private boolean equalTo(MixinType another) {
        return this.implementation.equals(another.implementation) && this.targets.equals(another.targets) && this.interfaces.equals(another.interfaces) && Objects.equal(this.initMethodName, another.initMethodName) && Arrays.equals(this.implementationBytes, another.implementationBytes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.implementation.hashCode();
        h = h * 17 + this.targets.hashCode();
        h = h * 17 + this.interfaces.hashCode();
        h = h * 17 + Objects.hashCode(this.initMethodName);
        h = h * 17 + Arrays.hashCode(this.implementationBytes);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MixinType").add("implementation", this.implementation).add("targets", this.targets).add("interfaces", this.interfaces).add("initMethodName", this.initMethodName).add("implementationBytes", Arrays.toString(this.implementationBytes)).toString();
    }

    public static MixinType copyOf(MixinTypeBase instance) {
        if (instance instanceof MixinType) {
            return (MixinType)instance;
        }
        return MixinType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_IMPLEMENTATION = 1L;
        private static final long INITIALIZED_BIT_IMPLEMENTATION_BYTES = 2L;
        private long initializedBitset;
        @Nullable
        private Type implementation;
        private ImmutableList.Builder<String> targetsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<Type> interfacesBuilder = ImmutableList.builder();
        @Nullable
        private String initMethodName;
        @Nullable
        private byte[] implementationBytes;

        private Builder() {
        }

        public final Builder from(MixinTypeBase instance) {
            Preconditions.checkNotNull(instance);
            this.implementation(instance.implementation());
            this.addAllTargets(instance.targets());
            this.addAllInterfaces(instance.interfaces());
            String initMethodNameValue = instance.initMethodName();
            if (initMethodNameValue != null) {
                this.initMethodName(initMethodNameValue);
            }
            this.implementationBytes(instance.implementationBytes());
            return this;
        }

        public final Builder implementation(Type implementation) {
            this.implementation = Preconditions.checkNotNull(implementation);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addTargets(String element) {
            this.targetsBuilder.add((Object)element);
            return this;
        }

        public final Builder addTargets(String ... elements) {
            this.targetsBuilder.add(elements);
            return this;
        }

        public final Builder targets(Iterable<String> elements) {
            this.targetsBuilder = ImmutableList.builder();
            return this.addAllTargets(elements);
        }

        public final Builder addAllTargets(Iterable<String> elements) {
            this.targetsBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addInterfaces(Type element) {
            this.interfacesBuilder.add((Object)element);
            return this;
        }

        public final Builder addInterfaces(Type ... elements) {
            this.interfacesBuilder.add(elements);
            return this;
        }

        public final Builder interfaces(Iterable<? extends Type> elements) {
            this.interfacesBuilder = ImmutableList.builder();
            return this.addAllInterfaces(elements);
        }

        public final Builder addAllInterfaces(Iterable<? extends Type> elements) {
            this.interfacesBuilder.addAll(elements);
            return this;
        }

        public final Builder initMethodName(@Nullable String initMethodName) {
            this.initMethodName = initMethodName;
            return this;
        }

        public final Builder implementationBytes(byte ... elements) {
            this.implementationBytes = (byte[])elements.clone();
            this.initializedBitset |= 2L;
            return this;
        }

        public MixinType build() {
            this.checkRequiredAttributes();
            return new MixinType(this);
        }

        private boolean implementationIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean implementationBytesIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.implementationIsSet()) {
                attributes.add("implementation");
            }
            if (!this.implementationBytesIsSet()) {
                attributes.add("implementationBytes");
            }
            return "Cannot build MixinType, some of required attributes are not set " + attributes;
        }
    }
}

