/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.security.CodeSource;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.weaving.AnalyzedWorld;

@ParametersAreNonnullByDefault
@Immutable
final class ParseContext
extends AnalyzedWorld.ParseContextBase {
    private final String className;
    @Nullable
    private final CodeSource codeSource;

    private ParseContext(String className, @Nullable CodeSource codeSource) {
        this.className = Preconditions.checkNotNull(className);
        this.codeSource = codeSource;
    }

    private ParseContext(Builder builder) {
        this.className = builder.className;
        this.codeSource = builder.codeSource;
    }

    private ParseContext(ParseContext original, String className, @Nullable CodeSource codeSource) {
        this.className = className;
        this.codeSource = codeSource;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    @Nullable
    public CodeSource codeSource() {
        return this.codeSource;
    }

    public final ParseContext withClassName(String value) {
        if (this.className == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ParseContext(this, newValue, this.codeSource);
    }

    public final ParseContext withCodeSource(@Nullable CodeSource value) {
        if (this.codeSource == value) {
            return this;
        }
        CodeSource newValue = value;
        return new ParseContext(this, this.className, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ParseContext && this.equalTo((ParseContext)another);
    }

    private boolean equalTo(ParseContext another) {
        return this.className.equals(another.className) && Objects.equal(this.codeSource, another.codeSource);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.className.hashCode();
        h = h * 17 + Objects.hashCode(this.codeSource);
        return h;
    }

    public static ParseContext of(String className, @Nullable CodeSource codeSource) {
        return new ParseContext(className, codeSource);
    }

    static ParseContext copyOf(AnalyzedWorld.ParseContextBase instance) {
        if (instance instanceof ParseContext) {
            return (ParseContext)instance;
        }
        return ParseContext.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_CLASS_NAME = 1L;
        private long initializedBitset;
        @Nullable
        private String className;
        @Nullable
        private CodeSource codeSource;

        private Builder() {
        }

        public final Builder from(AnalyzedWorld.ParseContextBase instance) {
            Preconditions.checkNotNull(instance);
            this.className(instance.className());
            CodeSource codeSourceValue = instance.codeSource();
            if (codeSourceValue != null) {
                this.codeSource(codeSourceValue);
            }
            return this;
        }

        public final Builder className(String className) {
            this.className = Preconditions.checkNotNull(className);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder codeSource(@Nullable CodeSource codeSource) {
            this.codeSource = codeSource;
            return this;
        }

        public ParseContext build() {
            this.checkRequiredAttributes();
            return new ParseContext(this);
        }

        private boolean classNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            return "Cannot build ParseContext, some of required attributes are not set " + attributes;
        }
    }
}

