/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.api.weaving.BindParameter;
import org.glowroot.api.weaving.BindTraveler;
import org.glowroot.api.weaving.IsEnabled;
import org.glowroot.api.weaving.OnAfter;
import org.glowroot.api.weaving.OnBefore;
import org.glowroot.api.weaving.OnReturn;
import org.glowroot.api.weaving.OnThrow;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.objectweb.asm.AnnotationVisitor;
import org.glowroot.shaded.objectweb.asm.Label;
import org.glowroot.shaded.objectweb.asm.MethodVisitor;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.objectweb.asm.commons.AdviceAdapter;
import org.glowroot.shaded.objectweb.asm.commons.Method;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceFlowOuterHolder;
import org.glowroot.weaving.AdviceParameter;
import org.glowroot.weaving.BootstrapMetaHolders;
import org.glowroot.weaving.CatchHandler;
import org.glowroot.weaving.ParameterKind;
import org.immutables.value.Value;

class WeavingMethodVisitor
extends AdviceAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WeavingMethodVisitor.class);
    private static final Type adviceFlowOuterHolderType = Type.getType(AdviceFlowOuterHolder.class);
    private static final Type adviceFlowHolderType = Type.getType(AdviceFlowOuterHolder.AdviceFlowHolder.class);
    private static final Type objectType = Type.getObjectType("java/lang/Object");
    private final int access;
    private final String name;
    private final Type owner;
    private final ImmutableList<Advice> advisors;
    private final Type[] argumentTypes;
    private final Type returnType;
    @Nullable
    private final String metaHolderInternalName;
    @Nullable
    private final Integer methodMetaGroupUniqueNum;
    private final boolean bootstrapClassLoader;
    private final boolean needsOnReturn;
    private final boolean needsOnThrow;
    @Nullable
    private final MethodVisitor outerMethodVisitor;
    private final Map<Advice, Integer> adviceFlowHolderLocals = Maps.newHashMap();
    private final Map<Advice, Integer> originalAdviceFlowLocals = Maps.newHashMap();
    private final Map<Advice, Integer> enabledLocals = Maps.newHashMap();
    private final Map<Advice, Integer> travelerLocals = Maps.newHashMap();
    private final List<CatchHandler> catchHandlers = Lists.newArrayList();
    @MonotonicNonNull
    private Integer returnOpcode;
    @MonotonicNonNull
    private Label methodStartLabel;
    @MonotonicNonNull
    private Label onReturnLabel;
    @MonotonicNonNull
    private Label catchStartLabel;
    private boolean visitedLocalVariableThis;
    private int[] savedArgLocals = new int[0];

    WeavingMethodVisitor(MethodVisitor mv, int access, String name, String desc, Type owner, Iterable<Advice> advisors, @Nullable String metaHolderInternalName, @Nullable Integer methodMetaGroupUniqueNum, boolean bootstrapClassLoader, @Nullable MethodVisitor outerMethodVisitor) {
        super(327680, mv, access, name, desc);
        this.access = access;
        this.name = name;
        this.owner = owner;
        this.advisors = ImmutableList.copyOf(advisors);
        this.argumentTypes = Type.getArgumentTypes(desc);
        this.returnType = Type.getReturnType(desc);
        this.metaHolderInternalName = metaHolderInternalName;
        this.methodMetaGroupUniqueNum = methodMetaGroupUniqueNum;
        this.bootstrapClassLoader = bootstrapClassLoader;
        boolean needsOnReturn = false;
        boolean needsOnThrow = false;
        for (Advice advice : advisors) {
            if (advice.pointcut().ignoreSelfNested() || advice.onAfterAdvice() != null) {
                needsOnReturn = true;
                needsOnThrow = true;
                break;
            }
            if (advice.onReturnAdvice() != null) {
                needsOnReturn = true;
            }
            if (advice.onThrowAdvice() == null) continue;
            needsOnThrow = true;
        }
        this.needsOnReturn = needsOnReturn;
        this.needsOnThrow = needsOnThrow;
        this.outerMethodVisitor = outerMethodVisitor;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.outerMethodVisitor != null) {
            return this.outerMethodVisitor.visitAnnotation(desc, visible);
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    protected void onMethodEnter() {
        this.methodStartLabel = new Label();
        this.visitLabel(this.methodStartLabel);
        for (Advice advice : this.advisors) {
            this.defineAndEvaluateEnabledLocalVar(advice);
            this.defineTravelerLocalVar(advice);
        }
        this.saveArgsForMethodExit();
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advice advice;
            advice = (Advice)this.advisors.get(i);
            this.invokeOnBefore(advice, this.travelerLocals.get(advice));
            if (advice.onAfterAdvice() == null && advice.onThrowAdvice() == null) continue;
            Label catchStartLabel = new Label();
            this.visitLabel(catchStartLabel);
            this.catchHandlers.add(CatchHandler.of(catchStartLabel, this.advisors.subList(0, i + 1)));
        }
        if (this.needsOnReturn) {
            this.onReturnLabel = new Label();
        }
        if (this.needsOnThrow && this.catchHandlers.isEmpty()) {
            this.catchStartLabel = new Label();
            this.visitLabel(this.catchStartLabel);
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.needsOnReturn && WeavingMethodVisitor.isReturnOpcode(opcode)) {
            Preconditions.checkNotNull(this.onReturnLabel, "Call to onMethodEnter() is required");
            this.returnOpcode = opcode;
            this.visitJumpInsn(167, this.onReturnLabel);
        } else {
            super.visitInsn(opcode);
        }
    }

    private static boolean isReturnOpcode(int opcode) {
        return opcode >= 172 && opcode <= 177;
    }

    @Override
    public void visitLocalVariable(String name, String desc, @Nullable String signature, Label start, Label end, int index) {
        if (!name.equals("this") || this.visitedLocalVariableThis) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
            return;
        }
        this.visitedLocalVariableThis = true;
        Preconditions.checkNotNull(this.methodStartLabel, "Call to onMethodEnter() is required");
        Label outerEndLabel = new Label();
        this.visitLabel(outerEndLabel);
        super.visitLocalVariable(name, desc, signature, this.methodStartLabel, outerEndLabel, index);
        for (int i = 0; i < this.advisors.size(); ++i) {
            Integer travelerLocalIndex;
            Integer enabledLocalIndex;
            Integer adviceFlowLocalIndex;
            Advice advice = (Advice)this.advisors.get(i);
            Integer adviceFlowHolderLocalIndex = this.adviceFlowHolderLocals.get(advice);
            if (adviceFlowHolderLocalIndex != null) {
                super.visitLocalVariable("glowroot$advice$flow$holder$" + i, adviceFlowHolderType.getDescriptor(), null, this.methodStartLabel, outerEndLabel, adviceFlowHolderLocalIndex);
            }
            if ((adviceFlowLocalIndex = this.originalAdviceFlowLocals.get(advice)) != null) {
                super.visitLocalVariable("glowroot$advice$flow$" + i, Type.BOOLEAN_TYPE.getDescriptor(), null, this.methodStartLabel, outerEndLabel, adviceFlowLocalIndex);
            }
            if ((enabledLocalIndex = this.enabledLocals.get(advice)) != null) {
                super.visitLocalVariable("glowroot$enabled$" + i, Type.BOOLEAN_TYPE.getDescriptor(), null, this.methodStartLabel, outerEndLabel, enabledLocalIndex);
            }
            if ((travelerLocalIndex = this.travelerLocals.get(advice)) == null) continue;
            Type travelerType = advice.travelerType();
            if (travelerType == null) {
                logger.error("visitLocalVariable(): traveler local index is not null, but traveler type is null");
                continue;
            }
            super.visitLocalVariable("glowroot$traveler$" + i, travelerType.getDescriptor(), null, this.methodStartLabel, outerEndLabel, travelerLocalIndex);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label catchEndLabel = new Label();
        if (this.needsOnThrow) {
            this.visitLabel(catchEndLabel);
        }
        if (this.needsOnReturn && this.returnOpcode != null) {
            Preconditions.checkNotNull(this.onReturnLabel, "Call to onMethodEnter() is required");
            this.visitLabel(this.onReturnLabel);
            for (Advice advice : Lists.reverse(this.advisors)) {
                this.visitOnReturnAdvice(advice, this.returnOpcode);
                this.visitOnAfterAdvice(advice);
            }
            this.resetAdviceFlowIfNecessary();
            super.visitInsn(this.returnOpcode);
        }
        if (this.needsOnThrow) {
            this.visitCatchHandlers(catchEndLabel);
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    private void visitCatchHandlers(Label catchEndLabel) {
        if (this.catchHandlers.isEmpty()) {
            Preconditions.checkNotNull(this.catchStartLabel, "Call to onMethodEnter() is required");
            Label catchHandlerLabel = new Label();
            this.visitTryCatchBlock(this.catchStartLabel, catchEndLabel, catchHandlerLabel, "java/lang/Throwable");
            this.visitLabel(catchHandlerLabel);
            this.resetAdviceFlowIfNecessary();
            this.visitInsn(191);
        } else {
            for (CatchHandler catchHandler : Lists.reverse(this.catchHandlers)) {
                Label catchHandlerLabel = new Label();
                this.visitTryCatchBlock(catchHandler.catchStartLabel(), catchEndLabel, catchHandlerLabel, "java/lang/Throwable");
                this.visitLabel(catchHandlerLabel);
                for (Advice advice : Lists.reverse(catchHandler.advisors())) {
                    this.visitOnThrowAdvice(advice);
                }
                for (Advice advice : Lists.reverse(catchHandler.advisors())) {
                    this.visitOnAfterAdvice(advice);
                }
                this.resetAdviceFlowIfNecessary();
                this.visitInsn(191);
            }
        }
    }

    private void defineAndEvaluateEnabledLocalVar(Advice advice) {
        Integer enabledLocal = null;
        Method isEnabledAdvice = advice.isEnabledAdvice();
        if (isEnabledAdvice != null) {
            this.loadMethodParameters(advice.isEnabledParameters(), 0, -1, advice.adviceType(), IsEnabled.class, false);
            this.visitMethodInsn(184, advice.adviceType().getInternalName(), isEnabledAdvice.getName(), isEnabledAdvice.getDescriptor(), false);
            enabledLocal = this.newLocal(Type.BOOLEAN_TYPE);
            this.enabledLocals.put(advice, enabledLocal);
            this.storeLocal(enabledLocal);
        }
        if (advice.pointcut().ignoreSelfNested()) {
            int adviceFlowHolderLocal = this.newLocal(adviceFlowHolderType);
            this.adviceFlowHolderLocals.put(advice, adviceFlowHolderLocal);
            this.visitInsn(1);
            this.storeLocal(adviceFlowHolderLocal);
            int originalAdviceFlowLocal = this.newLocal(Type.BOOLEAN_TYPE);
            this.originalAdviceFlowLocals.put(advice, originalAdviceFlowLocal);
            this.visitInsn(3);
            this.storeLocal(originalAdviceFlowLocal);
            Label setAdviceFlowBlockEnd = new Label();
            if (enabledLocal != null) {
                this.loadLocal(enabledLocal);
                this.visitJumpInsn(153, setAdviceFlowBlockEnd);
            } else {
                enabledLocal = this.newLocal(Type.BOOLEAN_TYPE);
                this.enabledLocals.put(advice, enabledLocal);
                this.visitInsn(3);
                this.storeLocal(enabledLocal);
            }
            this.visitFieldInsn(178, advice.adviceType().getInternalName(), "glowroot$advice$flow$outer$holder", adviceFlowOuterHolderType.getDescriptor());
            this.visitMethodInsn(182, adviceFlowOuterHolderType.getInternalName(), "getInnerHolder", "()" + adviceFlowHolderType.getDescriptor(), false);
            this.visitInsn(89);
            this.storeLocal(adviceFlowHolderLocal);
            this.visitMethodInsn(182, adviceFlowHolderType.getInternalName(), "isTop", "()Z", false);
            Label isTopBlockStart = new Label();
            this.visitInsn(89);
            this.storeLocal(originalAdviceFlowLocal);
            this.visitJumpInsn(154, isTopBlockStart);
            this.visitInsn(3);
            this.storeLocal(enabledLocal);
            this.visitJumpInsn(167, setAdviceFlowBlockEnd);
            this.visitLabel(isTopBlockStart);
            this.loadLocal(adviceFlowHolderLocal);
            this.visitInsn(3);
            this.visitMethodInsn(182, adviceFlowHolderType.getInternalName(), "setTop", "(Z)V", false);
            this.visitInsn(4);
            this.storeLocal(enabledLocal);
            this.visitLabel(setAdviceFlowBlockEnd);
        }
    }

    private void defineTravelerLocalVar(Advice advice) {
        Method onBeforeAdvice = advice.onBeforeAdvice();
        if (onBeforeAdvice == null) {
            return;
        }
        Type travelerType = advice.travelerType();
        if (travelerType == null) {
            return;
        }
        int travelerLocal = this.newLocal(travelerType);
        this.pushDefault(travelerType);
        this.storeLocal(travelerLocal);
        this.travelerLocals.put(advice, travelerLocal);
    }

    private void invokeOnBefore(Advice advice, @Nullable Integer travelerLocal) {
        Method onBeforeAdvice = advice.onBeforeAdvice();
        if (onBeforeAdvice == null) {
            return;
        }
        Integer enabledLocal = this.enabledLocals.get(advice);
        Label onBeforeBlockEnd = null;
        if (enabledLocal != null) {
            onBeforeBlockEnd = new Label();
            this.loadLocal(enabledLocal);
            this.visitJumpInsn(153, onBeforeBlockEnd);
        }
        this.loadMethodParameters(advice.onBeforeParameters(), 0, -1, advice.adviceType(), OnBefore.class, false);
        this.visitMethodInsn(184, advice.adviceType().getInternalName(), onBeforeAdvice.getName(), onBeforeAdvice.getDescriptor(), false);
        if (travelerLocal != null) {
            this.storeLocal(travelerLocal);
        }
        if (onBeforeBlockEnd != null) {
            this.visitLabel(onBeforeBlockEnd);
        }
    }

    private void saveArgsForMethodExit() {
        int numSavedArgs = this.getNumSavedArgsNeeded();
        if (numSavedArgs == 0) {
            return;
        }
        this.savedArgLocals = new int[numSavedArgs];
        for (int i = 0; i < numSavedArgs; ++i) {
            this.savedArgLocals[i] = this.newLocal(this.argumentTypes[i]);
            this.loadArg(i);
            this.storeLocal(this.savedArgLocals[i]);
        }
    }

    private int getNumSavedArgsNeeded() {
        int numSaveArgsNeeded = 0;
        for (Advice advice : this.advisors) {
            numSaveArgsNeeded = Math.max(numSaveArgsNeeded, this.getNum(advice.onReturnParameters()));
            numSaveArgsNeeded = Math.max(numSaveArgsNeeded, this.getNum(advice.onAfterParameters()));
            numSaveArgsNeeded = Math.max(numSaveArgsNeeded, this.getNum(advice.onThrowParameters()));
        }
        return numSaveArgsNeeded;
    }

    private int getNum(ImmutableList<AdviceParameter> adviceParameters) {
        int numSaveArgsNeeded = 0;
        for (AdviceParameter parameter : adviceParameters) {
            if (parameter.kind() == ParameterKind.METHOD_ARG_ARRAY) {
                return this.argumentTypes.length;
            }
            if (parameter.kind() != ParameterKind.METHOD_ARG) continue;
            ++numSaveArgsNeeded;
        }
        return numSaveArgsNeeded;
    }

    private void visitOnReturnAdvice(Advice advice, int opcode) {
        Method onReturnAdvice = advice.onReturnAdvice();
        if (onReturnAdvice == null) {
            return;
        }
        Integer enabledLocal = this.enabledLocals.get(advice);
        Label onReturnBlockEnd = null;
        if (enabledLocal != null) {
            onReturnBlockEnd = new Label();
            this.loadLocal(enabledLocal);
            this.visitJumpInsn(153, onReturnBlockEnd);
        }
        this.weaveOnReturnAdvice(opcode, advice, onReturnAdvice);
        if (onReturnBlockEnd != null) {
            this.visitLabel(onReturnBlockEnd);
        }
    }

    private void weaveOnReturnAdvice(int opcode, Advice advice, Method onReturnAdvice) {
        boolean leaveReturnValueOnStack;
        boolean bl = leaveReturnValueOnStack = onReturnAdvice.getReturnType().getSort() == 0;
        if (onReturnAdvice.getArgumentTypes().length > 0) {
            int startIndex = 0;
            AdviceParameter parameter = (AdviceParameter)advice.onReturnParameters().get(0);
            switch (parameter.kind()) {
                case RETURN: {
                    this.loadNonOptionalReturnValue(opcode, parameter, leaveReturnValueOnStack);
                    startIndex = 1;
                    break;
                }
                case OPTIONAL_RETURN: {
                    this.loadOptionalReturnValue(opcode, leaveReturnValueOnStack);
                    startIndex = 1;
                    break;
                }
            }
            this.loadMethodParameters(advice.onReturnParameters(), startIndex, this.travelerLocals.get(advice), advice.adviceType(), OnReturn.class, true);
        }
        this.visitMethodInsn(184, advice.adviceType().getInternalName(), onReturnAdvice.getName(), onReturnAdvice.getDescriptor(), false);
    }

    private void loadNonOptionalReturnValue(int opcode, AdviceParameter parameter, boolean dup) {
        if (opcode == 177) {
            logger.warn("cannot use @BindReturn on a @Pointcut returning void");
            this.pushDefault(parameter.type());
        } else {
            boolean primitive = parameter.type().getSort() < 9;
            this.loadReturnValue(opcode, dup, !primitive);
        }
    }

    private void loadOptionalReturnValue(int opcode, boolean dup) {
        if (opcode == 177) {
            this.visitMethodInsn(184, "org/glowroot/weaving/VoidReturn", "getInstance", "()Lorg/glowroot/api/OptionalReturn;", false);
        } else {
            this.loadReturnValue(opcode, dup, true);
            this.visitMethodInsn(184, "org/glowroot/weaving/NonVoidReturn", "create", "(Ljava/lang/Object;)Lorg/glowroot/api/OptionalReturn;", false);
        }
    }

    private void loadReturnValue(int opcode, boolean dup, boolean autobox) {
        if (dup) {
            if (opcode == 173 || opcode == 175) {
                this.visitInsn(92);
            } else {
                this.visitInsn(89);
            }
        }
        if (autobox && opcode != 176 && opcode != 191) {
            this.box(this.returnType);
        }
    }

    private void visitOnThrowAdvice(Advice advice) {
        Method onThrowAdvice = advice.onThrowAdvice();
        if (onThrowAdvice == null) {
            return;
        }
        Integer enabledLocal = this.enabledLocals.get(advice);
        Label onThrowBlockEnd = null;
        if (enabledLocal != null) {
            onThrowBlockEnd = new Label();
            this.loadLocal(enabledLocal);
            this.visitJumpInsn(153, onThrowBlockEnd);
        }
        if (onThrowAdvice.getArgumentTypes().length == 0) {
            this.visitMethodInsn(184, advice.adviceType().getInternalName(), onThrowAdvice.getName(), onThrowAdvice.getDescriptor(), false);
        } else {
            int startIndex = 0;
            if (((AdviceParameter)advice.onThrowParameters().get(0)).kind() == ParameterKind.THROWABLE) {
                this.visitInsn(89);
                ++startIndex;
            }
            this.loadMethodParameters(advice.onThrowParameters(), startIndex, this.travelerLocals.get(advice), advice.adviceType(), OnThrow.class, true);
            this.visitMethodInsn(184, advice.adviceType().getInternalName(), onThrowAdvice.getName(), onThrowAdvice.getDescriptor(), false);
        }
        if (onThrowBlockEnd != null) {
            this.visitLabel(onThrowBlockEnd);
        }
    }

    private void visitOnAfterAdvice(Advice advice) {
        Method onAfterAdvice = advice.onAfterAdvice();
        if (onAfterAdvice == null) {
            return;
        }
        Integer enabledLocal = this.enabledLocals.get(advice);
        Label onAfterBlockEnd = null;
        if (enabledLocal != null) {
            onAfterBlockEnd = new Label();
            this.loadLocal(enabledLocal);
            this.visitJumpInsn(153, onAfterBlockEnd);
        }
        this.loadMethodParameters(advice.onAfterParameters(), 0, this.travelerLocals.get(advice), advice.adviceType(), OnAfter.class, true);
        this.visitMethodInsn(184, advice.adviceType().getInternalName(), onAfterAdvice.getName(), onAfterAdvice.getDescriptor(), false);
        if (onAfterBlockEnd != null) {
            this.visitLabel(onAfterBlockEnd);
        }
    }

    private void resetAdviceFlowIfNecessary() {
        for (Advice advice : this.advisors) {
            if (!advice.pointcut().ignoreSelfNested()) continue;
            Integer enabledLocal = this.enabledLocals.get(advice);
            Integer originalAdviceFlowLocal = this.originalAdviceFlowLocals.get(advice);
            Integer adviceFlowHolderLocal = this.adviceFlowHolderLocals.get(advice);
            Preconditions.checkNotNull(enabledLocal, "enabledLocal is null");
            Preconditions.checkNotNull(originalAdviceFlowLocal, "originalAdviceFlowLocal is null");
            Preconditions.checkNotNull(adviceFlowHolderLocal, "adviceFlowHolderLocal is null");
            Label setAdviceFlowBlockEnd = new Label();
            this.loadLocal(enabledLocal);
            this.visitJumpInsn(153, setAdviceFlowBlockEnd);
            this.loadLocal(originalAdviceFlowLocal);
            this.visitJumpInsn(153, setAdviceFlowBlockEnd);
            this.loadLocal(adviceFlowHolderLocal);
            this.visitInsn(4);
            this.visitMethodInsn(182, adviceFlowHolderType.getInternalName(), "setTop", "(Z)V", false);
            this.visitLabel(setAdviceFlowBlockEnd);
        }
    }

    private void loadMethodParameters(List<AdviceParameter> parameters, int startIndex, @Nullable Integer travelerLocal, Type adviceType, Class<? extends Annotation> annotationType, boolean useSavedArgs) {
        int argIndex = 0;
        block9: for (int i = startIndex; i < parameters.size(); ++i) {
            AdviceParameter parameter = parameters.get(i);
            switch (parameter.kind()) {
                case RECEIVER: {
                    this.loadTarget();
                    continue block9;
                }
                case METHOD_ARG: {
                    this.loadMethodParameter(adviceType, annotationType, argIndex++, parameter, useSavedArgs);
                    continue block9;
                }
                case METHOD_ARG_ARRAY: {
                    this.loadArgArray(useSavedArgs);
                    continue block9;
                }
                case METHOD_NAME: {
                    this.loadMethodName();
                    continue block9;
                }
                case TRAVELER: {
                    this.loadTraveler(travelerLocal, adviceType, annotationType, parameter);
                    continue block9;
                }
                case CLASS_META: {
                    Preconditions.checkNotNull(this.metaHolderInternalName);
                    this.loadClassMeta(parameter);
                    continue block9;
                }
                case METHOD_META: {
                    Preconditions.checkNotNull(this.metaHolderInternalName);
                    Preconditions.checkNotNull(this.methodMetaGroupUniqueNum);
                    this.loadMethodMeta(parameter);
                    continue block9;
                }
                default: {
                    logger.warn("the @{} method in {} has an unexpected parameter kind {} at index {}", new Object[]{annotationType.getSimpleName(), adviceType.getClassName(), parameter.kind(), i});
                    this.pushDefault(parameter.type());
                }
            }
        }
    }

    private void loadTarget() {
        if (!Modifier.isStatic(this.access)) {
            this.visitVarInsn(25, 0);
        } else {
            this.visitLdcInsn(this.owner.getClassName());
            this.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
        }
    }

    private void loadMethodParameter(Type adviceType, Class<? extends Annotation> annotationType, int argIndex, AdviceParameter parameter, boolean useSavedArg) {
        boolean primitive;
        if (argIndex >= this.argumentTypes.length) {
            logger.warn("the @{} method in {} has more @{} arguments than the number of args in the target method", annotationType.getSimpleName(), adviceType.getClassName(), BindParameter.class.getSimpleName());
            this.pushDefault(parameter.type());
            return;
        }
        if (useSavedArg) {
            this.loadLocal(this.savedArgLocals[argIndex]);
        } else {
            this.loadArg(argIndex);
        }
        boolean bl = primitive = parameter.type().getSort() < 9;
        if (!primitive) {
            this.box(this.argumentTypes[argIndex]);
        }
    }

    private void loadArgArray(boolean useSavedArgs) {
        this.push(this.argumentTypes.length);
        this.newArray(objectType);
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.dup();
            this.push(i);
            if (useSavedArgs) {
                this.loadLocal(this.savedArgLocals[i]);
            } else {
                this.loadArg(i);
            }
            this.box(this.argumentTypes[i]);
            this.arrayStore(objectType);
        }
    }

    private void loadMethodName() {
        if (this.name.contains("$glowroot$timer$")) {
            this.visitLdcInsn(this.name.substring(0, this.name.indexOf("$glowroot$timer$")));
        } else {
            this.visitLdcInsn(this.name);
        }
    }

    private void loadTraveler(@Nullable Integer travelerLocal, Type adviceType, Class<? extends Annotation> annotationType, AdviceParameter parameter) {
        if (travelerLocal == null) {
            logger.warn("the @{} method in {} requested @{} but @{} returns void", annotationType.getSimpleName(), adviceType.getClassName(), BindTraveler.class.getSimpleName(), OnBefore.class.getSimpleName());
            this.pushDefault(parameter.type());
        } else {
            this.loadLocal(travelerLocal);
        }
    }

    @RequiresNonNull(value={"metaHolderInternalName"})
    private void loadClassMeta(AdviceParameter parameter) {
        Type classMetaFieldType = parameter.type();
        String classMetaFieldName = "glowroot$class$meta$" + classMetaFieldType.getInternalName().replace('/', '$');
        if (this.bootstrapClassLoader) {
            int index = BootstrapMetaHolders.reserveClassMetaHolderIndex(this.metaHolderInternalName, classMetaFieldName);
            this.push(index);
            this.visitMethodInsn(184, "org/glowroot/weaving/BootstrapMetaHolders", "getClassMeta", "(I)Ljava/lang/Object;", false);
        } else {
            this.visitFieldInsn(178, this.metaHolderInternalName, classMetaFieldName, classMetaFieldType.getDescriptor());
        }
    }

    @RequiresNonNull(value={"metaHolderInternalName", "methodMetaGroupUniqueNum"})
    private void loadMethodMeta(AdviceParameter parameter) {
        Type methodMetaFieldType = parameter.type();
        String methodMetaFieldName = "glowroot$method$meta$" + this.methodMetaGroupUniqueNum + '$' + methodMetaFieldType.getInternalName().replace('/', '$');
        if (this.bootstrapClassLoader) {
            int index = BootstrapMetaHolders.reserveMethodMetaHolderIndex(this.metaHolderInternalName, methodMetaFieldName);
            this.push(index);
            this.visitMethodInsn(184, "org/glowroot/weaving/BootstrapMetaHolders", "getMethodMeta", "(I)Ljava/lang/Object;", false);
        } else {
            this.visitFieldInsn(178, this.metaHolderInternalName, methodMetaFieldName, methodMetaFieldType.getDescriptor());
        }
    }

    private void pushDefault(Type type) {
        switch (type.getSort()) {
            case 1: {
                this.push(false);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.visitInsn(3);
                break;
            }
            case 6: {
                this.visitInsn(11);
                break;
            }
            case 7: {
                this.visitInsn(9);
                break;
            }
            case 8: {
                this.visitInsn(14);
                break;
            }
            default: {
                this.visitInsn(1);
            }
        }
    }

    @Value.Immutable
    static abstract class CatchHandlerBase {
        CatchHandlerBase() {
        }

        abstract Label catchStartLabel();

        abstract List<Advice> advisors();
    }
}

