/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.analysis.TokenFilter;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.util.AttributeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/analysis/CachingTokenFilter;", "Lorg/gnit/lucenekmp/analysis/TokenFilter;", "input", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "<init>", "(Lorg/gnit/lucenekmp/analysis/TokenStream;)V", "cache", "", "Lorg/gnit/lucenekmp/util/AttributeSource$State;", "iterator", "", "finalState", "reset", "", "incrementToken", "", "end", "fillCache", "isCached", "()Z", "core"})
public final class CachingTokenFilter
extends TokenFilter {
    @Nullable
    private List<AttributeSource.State> cache;
    @Nullable
    private Iterator<AttributeSource.State> iterator;
    @Nullable
    private AttributeSource.State finalState;

    public CachingTokenFilter(@NotNull TokenStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super(input);
    }

    @Override
    public void reset() throws IOException {
        if (this.cache == null) {
            this.getInput().reset();
        } else {
            List<AttributeSource.State> list = this.cache;
            Intrinsics.checkNotNull(list);
            this.iterator = list.iterator();
        }
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.cache == null) {
            this.cache = new ArrayList(64);
            this.fillCache();
            List<AttributeSource.State> list = this.cache;
            Intrinsics.checkNotNull(list);
            this.iterator = list.iterator();
        }
        Iterator<AttributeSource.State> iterator2 = this.iterator;
        Intrinsics.checkNotNull(iterator2);
        if (!iterator2.hasNext()) {
            return false;
        }
        Iterator<AttributeSource.State> iterator3 = this.iterator;
        Intrinsics.checkNotNull(iterator3);
        this.restoreState(iterator3.next());
        return true;
    }

    @Override
    public void end() {
        if (this.finalState != null) {
            this.restoreState(this.finalState);
        }
    }

    private final void fillCache() throws IOException {
        while (this.getInput().incrementToken()) {
            List<AttributeSource.State> list = this.cache;
            Intrinsics.checkNotNull(list);
            AttributeSource.State state2 = this.captureState();
            Intrinsics.checkNotNull((Object)state2);
            list.add(state2);
        }
        this.getInput().end();
        this.finalState = this.captureState();
    }

    public final boolean isCached() {
        return this.cache != null;
    }
}

