/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis;

import java.io.IOException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.gnit.lucenekmp.analysis.Analyzer;
import org.gnit.lucenekmp.analysis.CharArraySet;
import org.gnit.lucenekmp.analysis.WordlistLoader;
import org.gnit.lucenekmp.jdkport.Files;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.jdkport.StandardCharsets;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0015\b\u0004\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/analysis/StopwordAnalyzerBase;", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "stopwords", "Lorg/gnit/lucenekmp/analysis/CharArraySet;", "<init>", "(Lorg/gnit/lucenekmp/analysis/CharArraySet;)V", "getStopwords", "()Lorg/gnit/lucenekmp/analysis/CharArraySet;", "Companion", "core"})
public abstract class StopwordAnalyzerBase
extends Analyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharArraySet stopwords;

    protected StopwordAnalyzerBase(@Nullable CharArraySet stopwords) {
        super(null, 1, null);
        this.stopwords = stopwords == null ? CharArraySet.Companion.getEMPTY_SET() : CharArraySet.Companion.unmodifiableSet(CharArraySet.Companion.copy((Set)((Object)stopwords)));
    }

    public /* synthetic */ StopwordAnalyzerBase(CharArraySet charArraySet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            charArraySet = null;
        }
        this(charArraySet);
    }

    @NotNull
    public final CharArraySet getStopwords() {
        return this.stopwords;
    }

    protected StopwordAnalyzerBase() {
        this((CharArraySet)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/analysis/StopwordAnalyzerBase$Companion;", "", "<init>", "()V", "loadStopwordSet", "Lorg/gnit/lucenekmp/analysis/CharArraySet;", "stopwords", "Lokio/Path;", "Lorg/gnit/lucenekmp/jdkport/Reader;", "core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected final CharArraySet loadStopwordSet(@NotNull Path stopwords) throws IOException {
            Intrinsics.checkNotNullParameter((Object)stopwords, (String)"stopwords");
            AutoCloseable autoCloseable = Files.INSTANCE.newBufferedReader(stopwords, StandardCharsets.Companion.getUTF_8());
            Throwable throwable = null;
            try {
                Reader reader2 = (Reader)autoCloseable;
                boolean bl = false;
                CharArraySet charArraySet = WordlistLoader.INSTANCE.getWordSet(reader2);
                return charArraySet;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CharArraySet loadStopwordSet(@NotNull Reader stopwords) throws IOException {
            CharArraySet charArraySet;
            Intrinsics.checkNotNullParameter((Object)stopwords, (String)"stopwords");
            try {
                charArraySet = WordlistLoader.INSTANCE.getWordSet(stopwords);
            }
            catch (Throwable throwable) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[]{stopwords};
                IOUtils.INSTANCE.close(autoCloseableArray);
                throw throwable;
            }
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{stopwords};
            IOUtils.INSTANCE.close(autoCloseableArray);
            return charArraySet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

