/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.CharacterUtils;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.analysis.Tokenizer;
import org.gnit.lucenekmp.analysis.tokenattributes.CharTermAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.OffsetAttribute;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.util.AttributeFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH$J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/analysis/util/CharTokenizer;", "Lorg/gnit/lucenekmp/analysis/Tokenizer;", "<init>", "()V", "factory", "Lorg/gnit/lucenekmp/util/AttributeFactory;", "(Lorg/gnit/lucenekmp/util/AttributeFactory;)V", "maxTokenLen", "", "(Lorg/gnit/lucenekmp/util/AttributeFactory;I)V", "offset", "bufferIndex", "dataLen", "finalOffset", "termAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/CharTermAttribute;", "offsetAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/OffsetAttribute;", "ioBuffer", "Lorg/gnit/lucenekmp/analysis/CharacterUtils$CharacterBuffer;", "isTokenChar", "", "c", "incrementToken", "end", "", "reset", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCharTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharTokenizer.kt\norg/gnit/lucenekmp/analysis/util/CharTokenizer\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n3#2,8:247\n3#2,8:256\n10#3:255\n10#3:264\n1#4:265\n*S KotlinDebug\n*F\n+ 1 CharTokenizer.kt\norg/gnit/lucenekmp/analysis/util/CharTokenizer\n*L\n116#1:247,8\n135#1:256,8\n116#1:255\n135#1:264\n*E\n"})
public abstract class CharTokenizer
extends Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int offset;
    private int bufferIndex;
    private int dataLen;
    private int finalOffset;
    private final int maxTokenLen;
    @NotNull
    private final CharTermAttribute termAtt;
    @NotNull
    private final OffsetAttribute offsetAtt;
    @NotNull
    private final CharacterUtils.CharacterBuffer ioBuffer;
    public static final int DEFAULT_MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 4096;

    public CharTokenizer() {
        this.termAtt = (CharTermAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(CharTermAttribute.class));
        this.offsetAtt = (OffsetAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(OffsetAttribute.class));
        this.ioBuffer = CharacterUtils.INSTANCE.newCharacterBuffer(4096);
        this.maxTokenLen = 255;
    }

    public CharTokenizer(@NotNull AttributeFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(factory);
        this.termAtt = (CharTermAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(CharTermAttribute.class));
        this.offsetAtt = (OffsetAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(OffsetAttribute.class));
        this.ioBuffer = CharacterUtils.INSTANCE.newCharacterBuffer(4096);
        this.maxTokenLen = 255;
    }

    public CharTokenizer(@NotNull AttributeFactory factory, int maxTokenLen) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(factory);
        this.termAtt = (CharTermAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(CharTermAttribute.class));
        this.offsetAtt = (OffsetAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(OffsetAttribute.class));
        this.ioBuffer = CharacterUtils.INSTANCE.newCharacterBuffer(4096);
        if (!(maxTokenLen <= 0x100000 && maxTokenLen > 0)) {
            boolean bl = false;
            String string = "maxTokenLen must be greater than 0 and less than 1048576 passed: " + maxTokenLen;
            throw new IllegalArgumentException(string.toString());
        }
        this.maxTokenLen = maxTokenLen;
    }

    protected abstract boolean isTokenChar(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean incrementToken() throws IOException {
        void it;
        int n;
        int charCount;
        this.clearAttributes();
        int length = 0;
        int start = -1;
        int end = -1;
        char[] buffer = this.termAtt.buffer();
        while (true) {
            if (this.bufferIndex >= this.dataLen) {
                this.offset += this.dataLen;
                CharacterUtils.fill$default(CharacterUtils.INSTANCE, this.ioBuffer, this.getInput(), 0, 4, null);
                if (this.ioBuffer.getLength() == 0) {
                    this.dataLen = 0;
                    if (length > 0) break;
                    this.finalOffset = this.correctOffset(this.offset);
                    return false;
                }
                this.dataLen = this.ioBuffer.getLength();
                this.bufferIndex = 0;
            }
            int c = Character.Companion.codePointAt(this.ioBuffer.getBuffer(), this.bufferIndex, this.ioBuffer.getLength());
            charCount = Character.Companion.charCount(c);
            this.bufferIndex += charCount;
            if (this.isTokenChar(c)) {
                if (length == 0) {
                    boolean condition$iv = start == -1;
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    end = start = this.offset + this.bufferIndex - charCount;
                } else if (length >= buffer.length - 1) {
                    buffer = this.termAtt.resizeBuffer(2 + length);
                }
                end += charCount;
                if ((length += Character.Companion.toChars(c, buffer, length)) < this.maxTokenLen) continue;
                break;
            }
            if (length > 0) break;
        }
        this.termAtt.setLength(length);
        boolean condition$iv = start != -1;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        charCount = n = this.correctOffset(end);
        int n2 = this.correctOffset(start);
        OffsetAttribute offsetAttribute = this.offsetAtt;
        boolean bl = false;
        this.finalOffset = it;
        Unit unit = Unit.INSTANCE;
        offsetAttribute.setOffset(n2, n);
        return true;
    }

    @Override
    public void end() throws IOException {
        super.end();
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bufferIndex = 0;
        this.offset = 0;
        this.dataLen = 0;
        this.finalOffset = 0;
        this.ioBuffer.reset();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\u001a\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\"\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/analysis/util/CharTokenizer$Companion;", "", "<init>", "()V", "fromTokenCharPredicate", "Lorg/gnit/lucenekmp/analysis/util/CharTokenizer;", "tokenCharPredicate", "Lkotlin/Function1;", "", "", "factory", "Lorg/gnit/lucenekmp/util/AttributeFactory;", "fromSeparatorCharPredicate", "separatorCharPredicate", "DEFAULT_MAX_WORD_LEN", "IO_BUFFER_SIZE", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CharTokenizer fromTokenCharPredicate(@NotNull Function1<? super Integer, Boolean> tokenCharPredicate) {
            Intrinsics.checkNotNullParameter(tokenCharPredicate, (String)"tokenCharPredicate");
            return this.fromTokenCharPredicate(TokenStream.Companion.getDEFAULT_TOKEN_ATTRIBUTE_FACTORY(), tokenCharPredicate);
        }

        @NotNull
        public final CharTokenizer fromTokenCharPredicate(@NotNull AttributeFactory factory, @NotNull Function1<? super Integer, Boolean> tokenCharPredicate) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter(tokenCharPredicate, (String)"tokenCharPredicate");
            return new CharTokenizer(factory, tokenCharPredicate){
                final /* synthetic */ Function1<Integer, Boolean> $tokenCharPredicate;
                {
                    this.$tokenCharPredicate = $tokenCharPredicate;
                    super($factory);
                }

                protected boolean isTokenChar(int c) {
                    return (Boolean)this.$tokenCharPredicate.invoke((Object)c);
                }
            };
        }

        @NotNull
        public final CharTokenizer fromSeparatorCharPredicate(@NotNull Function1<? super Integer, Boolean> separatorCharPredicate) {
            Intrinsics.checkNotNullParameter(separatorCharPredicate, (String)"separatorCharPredicate");
            return this.fromSeparatorCharPredicate(TokenStream.Companion.getDEFAULT_TOKEN_ATTRIBUTE_FACTORY(), separatorCharPredicate);
        }

        @NotNull
        public final CharTokenizer fromSeparatorCharPredicate(@NotNull AttributeFactory factory, @NotNull Function1<? super Integer, Boolean> separatorCharPredicate) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter(separatorCharPredicate, (String)"separatorCharPredicate");
            return this.fromTokenCharPredicate(factory, (Function1<? super Integer, Boolean>)((Function1)arg_0 -> Companion.fromSeparatorCharPredicate$lambda$0(separatorCharPredicate, arg_0)));
        }

        private static final boolean fromSeparatorCharPredicate$lambda$0(Function1 $separatorCharPredicate, int tested) {
            return (Boolean)$separatorCharPredicate.invoke((Object)tested) == false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

