/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.io.IOException;
import java.util.Arrays;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexFormatTooNewException;
import org.gnit.lucenekmp.index.IndexFormatTooOldException;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.StandardCharsets;
import org.gnit.lucenekmp.jdkport.StringExtKt;
import org.gnit.lucenekmp.store.BufferedChecksumIndexInput;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.StringHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J.\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ(\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J(\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J<\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\fJ\u001e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u001eJ\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\fJ\u000e\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020(J\u0018\u0010&\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*J\u000e\u0010+\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u001eJ\u0016\u0010+\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020'J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001eH\u0002J\u000e\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u001eJ\u000e\u00100\u001a\u00020'2\u0006\u0010/\u001a\u00020\u001eJ\u000e\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020$J\u0016\u00103\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0005J\u0016\u00105\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u00106\u001a\u00020'J\u000e\u00107\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u00108\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/gnit/lucenekmp/codecs/CodecUtil;", "", "<init>", "()V", "CODEC_MAGIC", "", "FOOTER_MAGIC", "writeHeader", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "codec", "", "version", "writeIndexHeader", "id", "", "suffix", "headerLength", "indexHeaderLength", "checkHeader", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "minVersion", "maxVersion", "checkHeaderNoMagic", "checkIndexHeader", "expectedID", "expectedSuffix", "verifyAndCopyIndexHeader", "Lorg/gnit/lucenekmp/store/IndexInput;", "readIndexHeader", "readFooter", "checkIndexHeaderID", "checkIndexHeaderSuffix", "writeFooter", "Lorg/gnit/lucenekmp/store/IndexOutput;", "footerLength", "checkFooter", "", "Lorg/gnit/lucenekmp/store/ChecksumIndexInput;", "priorException", "", "retrieveChecksum", "expectedLength", "validateFooter", "checksumEntireFile", "input", "readCRC", "writeCRC", "output", "writeBEInt", "i", "writeBELong", "l", "readBEInt", "readBELong", "core"})
@SourceDebugExtension(value={"SMAP\nCodecUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodecUtil.kt\norg/gnit/lucenekmp/codecs/CodecUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,695:1\n1#2:696\n*E\n"})
public final class CodecUtil {
    @NotNull
    public static final CodecUtil INSTANCE = new CodecUtil();
    public static final int CODEC_MAGIC = 1071082519;
    public static final int FOOTER_MAGIC = -1071082520;

    private CodecUtil() {
    }

    public final void writeHeader(@NotNull DataOutput out, @NotNull String codec, int version) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        BytesRef bytes = new BytesRef(codec);
        if (!(bytes.getLength() == codec.length() && bytes.getLength() < 128)) {
            boolean bl = false;
            String string = "codec must be simple ASCII, less than 128 characters in length [got " + codec + "]";
            throw new IllegalArgumentException(string.toString());
        }
        this.writeBEInt(out, 1071082519);
        out.writeString(codec);
        this.writeBEInt(out, version);
    }

    public final void writeIndexHeader(@NotNull DataOutput out, @NotNull String codec, int version, @NotNull byte[] id, @NotNull String suffix) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        if (!(id.length == 16)) {
            boolean bl = false;
            String string = "Invalid id: " + StringHelper.INSTANCE.idToString(id);
            throw new IllegalArgumentException(string.toString());
        }
        this.writeHeader(out, codec, version);
        out.writeBytes(id, 0, id.length);
        BytesRef suffixBytes = new BytesRef(suffix);
        if (!(suffixBytes.getLength() == suffix.length() && suffixBytes.getLength() < 256)) {
            boolean bl = false;
            String string = "suffix must be simple ASCII, less than 256 characters in length [got " + suffix + "]";
            throw new IllegalArgumentException(string.toString());
        }
        out.writeByte((byte)suffixBytes.getLength());
        out.writeBytes(suffixBytes.getBytes(), suffixBytes.getOffset(), suffixBytes.getLength());
    }

    public final int headerLength(@NotNull String codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        return 9 + codec.length();
    }

    public final int indexHeaderLength(@NotNull String codec, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return this.headerLength(codec) + 16 + 1 + suffix.length();
    }

    public final int checkHeader(@NotNull DataInput in, @Nullable String codec, int minVersion, int maxVersion) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int actualHeader = this.readBEInt(in);
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualHeader + " vs expected header=1071082519", in);
        }
        return this.checkHeaderNoMagic(in, codec, minVersion, maxVersion);
    }

    public final int checkHeaderNoMagic(@NotNull DataInput in, @Nullable String codec, int minVersion, int maxVersion) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        String actualCodec = in.readString();
        if (!Intrinsics.areEqual((Object)actualCodec, (Object)codec)) {
            throw new CorruptIndexException("codec mismatch: actual codec=" + actualCodec + " vs expected codec=" + codec, in);
        }
        int actualVersion = this.readBEInt(in);
        if (actualVersion < minVersion) {
            throw new IndexFormatTooOldException(in, actualVersion, minVersion, maxVersion);
        }
        if (actualVersion > maxVersion) {
            throw new IndexFormatTooNewException(in, actualVersion, minVersion, maxVersion);
        }
        return actualVersion;
    }

    public final int checkIndexHeader(@NotNull DataInput in, @Nullable String codec, int minVersion, int maxVersion, @Nullable byte[] expectedID, @Nullable String expectedSuffix) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int version = this.checkHeader(in, codec, minVersion, maxVersion);
        this.checkIndexHeaderID(in, expectedID);
        this.checkIndexHeaderSuffix(in, expectedSuffix);
        return version;
    }

    public final void verifyAndCopyIndexHeader(@NotNull IndexInput in, @NotNull DataOutput out, @NotNull byte[] expectedID) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)expectedID, (String)"expectedID");
        if (in.length() < (long)(this.footerLength() + this.headerLength(""))) {
            throw new CorruptIndexException("compound sub-files must have a valid codec header and footer: file is too small (" + in.length() + " bytes)", in);
        }
        int actualHeader = this.readBEInt(in);
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("compound sub-files must have a valid codec header and footer: codec header mismatch: actual header=" + actualHeader + " vs expected header=1071082519", in);
        }
        String codec = in.readString();
        int version = this.readBEInt(in);
        this.checkIndexHeaderID(in, expectedID);
        int suffixLength = in.readByte() & 0xFF;
        byte[] suffixBytes = new byte[suffixLength];
        in.readBytes(suffixBytes, 0, suffixLength);
        this.writeBEInt(out, 1071082519);
        out.writeString(codec);
        this.writeBEInt(out, version);
        out.writeBytes(expectedID, 0, expectedID.length);
        out.writeByte((byte)suffixLength);
        out.writeBytes(suffixBytes, 0, suffixLength);
    }

    @NotNull
    public final byte[] readIndexHeader(@NotNull IndexInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        in.seek(0L);
        int actualHeader = this.readBEInt(in);
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualHeader + " vs expected header=1071082519", in);
        }
        String codec = in.readString();
        this.readBEInt(in);
        in.seek(in.getFilePointer() + (long)16);
        int suffixLength = in.readByte() & 0xFF;
        byte[] bytes = new byte[this.headerLength(codec) + 16 + 1 + suffixLength];
        in.seek(0L);
        in.readBytes(bytes, 0, bytes.length);
        return bytes;
    }

    @NotNull
    public final byte[] readFooter(@NotNull IndexInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (in.length() < (long)this.footerLength()) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): length=" + in.length() + " but footerLength==" + this.footerLength(), in);
        }
        in.seek(in.length() - (long)this.footerLength());
        this.validateFooter(in);
        in.seek(in.length() - (long)this.footerLength());
        byte[] bytes = new byte[this.footerLength()];
        in.readBytes(bytes, 0, bytes.length);
        return bytes;
    }

    @NotNull
    public final byte[] checkIndexHeaderID(@NotNull DataInput in, @Nullable byte[] expectedID) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        byte[] id = new byte[16];
        in.readBytes(id, 0, id.length);
        if (!Arrays.equals(id, expectedID)) {
            throw new CorruptIndexException("file mismatch, expected id=" + StringHelper.INSTANCE.idToString(expectedID) + ", got=" + StringHelper.INSTANCE.idToString(id), in);
        }
        return id;
    }

    @NotNull
    public final String checkIndexHeaderSuffix(@NotNull DataInput in, @Nullable String expectedSuffix) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int suffixLength = in.readByte() & 0xFF;
        byte[] suffixBytes = new byte[suffixLength];
        in.readBytes(suffixBytes, 0, suffixBytes.length);
        String suffix = StringExtKt.fromByteArray(StringCompanionObject.INSTANCE, suffixBytes, StandardCharsets.Companion.getUTF_8());
        if (!Intrinsics.areEqual((Object)suffix, (Object)expectedSuffix)) {
            throw new CorruptIndexException("file mismatch, expected suffix=" + expectedSuffix + ", got=" + suffix, in);
        }
        return suffix;
    }

    public final void writeFooter(@NotNull IndexOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.writeBEInt(out, -1071082520);
        this.writeBEInt(out, 0);
        this.writeCRC(out);
    }

    public final int footerLength() {
        return 16;
    }

    public final long checkFooter(@NotNull ChecksumIndexInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.validateFooter(in);
        long actualChecksum = in.getChecksum();
        long expectedChecksum = this.readCRC(in);
        if (expectedChecksum != actualChecksum) {
            throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + LongExtKt.toHexString(LongCompanionObject.INSTANCE, expectedChecksum) + " actual=" + LongExtKt.toHexString(LongCompanionObject.INSTANCE, actualChecksum), in);
        }
        return actualChecksum;
    }

    public final void checkFooter(@NotNull ChecksumIndexInput in, @Nullable Throwable priorException) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (priorException != null) {
            try {
                long remaining = in.length() - in.getFilePointer();
                if (remaining < (long)this.footerLength()) {
                    throw new CorruptIndexException("checksum status indeterminate: remaining=" + remaining + "; please run checkindex for more details", in);
                }
                in.skipBytes(remaining - (long)this.footerLength());
                long checksum = this.checkFooter(in);
                if (!(priorException instanceof IndexFormatTooOldException)) {
                    ExceptionsKt.addSuppressed((Throwable)priorException, (Throwable)new CorruptIndexException("checksum passed (" + LongExtKt.toHexString(LongCompanionObject.INSTANCE, checksum) + "). possibly transient resource issue, or a Lucene or JVM bug", in));
                }
            }
            catch (CorruptIndexException corruptException) {
                ExceptionsKt.addSuppressed((Throwable)corruptException, (Throwable)priorException);
                throw corruptException;
            }
            catch (Throwable t) {
                ExceptionsKt.addSuppressed((Throwable)priorException, (Throwable)new CorruptIndexException("checksum status indeterminate: unexpected exception", in, t));
            }
            IOUtils.INSTANCE.rethrowAlways(priorException);
            throw new KotlinNothingValueException();
        }
        this.checkFooter(in);
    }

    public final long retrieveChecksum(@NotNull IndexInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (in.length() < (long)this.footerLength()) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): length=" + in.length() + " but footerLength==" + this.footerLength(), in);
        }
        in.seek(in.length() - (long)this.footerLength());
        this.validateFooter(in);
        return this.readCRC(in);
    }

    public final long retrieveChecksum(@NotNull IndexInput in, long expectedLength) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!(expectedLength >= (long)this.footerLength())) {
            boolean bl = false;
            String string = "expectedLength cannot be less than the footer length";
            throw new IllegalArgumentException(string.toString());
        }
        if (in.length() < expectedLength) {
            throw new CorruptIndexException("truncated file: length=" + in.length() + " but expectedLength==" + expectedLength, in);
        }
        if (in.length() > expectedLength) {
            throw new CorruptIndexException("file too long: length=" + in.length() + " but expectedLength==" + expectedLength, in);
        }
        return this.retrieveChecksum(in);
    }

    private final void validateFooter(IndexInput in) throws IOException {
        long expected;
        long remaining = in.length() - in.getFilePointer();
        if (remaining < (expected = (long)this.footerLength())) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): remaining=" + remaining + ", expected=" + expected + ", fp=" + in.getFilePointer(), in);
        }
        if (remaining > expected) {
            throw new CorruptIndexException("misplaced codec footer (file extended?): remaining=" + remaining + ", expected=" + expected + ", fp=" + in.getFilePointer(), in);
        }
        int magic = this.readBEInt(in);
        if (magic != -1071082520) {
            throw new CorruptIndexException("codec footer mismatch (file truncated?): actual footer=" + magic + " vs expected footer=-1071082520", in);
        }
        int algorithmID = this.readBEInt(in);
        if (algorithmID != 0) {
            throw new CorruptIndexException("codec footer mismatch: unknown algorithmID: " + algorithmID, in);
        }
    }

    public final long checksumEntireFile(@NotNull IndexInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        IndexInput clone = input.clone();
        clone.seek(0L);
        ChecksumIndexInput in = new BufferedChecksumIndexInput(clone);
        if (!(in.getFilePointer() == 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (in.length() < (long)this.footerLength()) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): length=" + in.length() + " but footerLength==" + this.footerLength(), input);
        }
        in.seek(in.length() - (long)this.footerLength());
        return this.checkFooter(in);
    }

    public final long readCRC(@NotNull IndexInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long value = this.readBELong(input);
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            throw new CorruptIndexException("Illegal CRC-32 checksum: " + value, input);
        }
        return value;
    }

    public final void writeCRC(@NotNull IndexOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        long value = output.getChecksum();
        if (!((value & 0xFFFFFFFF00000000L) == 0L)) {
            boolean bl = false;
            String string = "Illegal CRC-32 checksum: " + value + " (resource=" + output + ")";
            throw new IllegalStateException(string.toString());
        }
        this.writeBELong(output, value);
    }

    public final void writeBEInt(@NotNull DataOutput out, int i) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeByte((byte)(i >> 24));
        out.writeByte((byte)(i >> 16));
        out.writeByte((byte)(i >> 8));
        out.writeByte((byte)i);
    }

    public final void writeBELong(@NotNull DataOutput out, long l) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.writeBEInt(out, (int)(l >> 32));
        this.writeBEInt(out, (int)l);
    }

    public final int readBEInt(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int b1 = in.readByte() & 0xFF;
        int b2 = in.readByte() & 0xFF;
        int b3 = in.readByte() & 0xFF;
        int b4 = in.readByte() & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public final long readBELong(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int hi = this.readBEInt(in);
        int lo = this.readBEInt(in);
        return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
    }
}

