/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.index.BaseTermsEnum;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.DocIDMerger;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.EmptyDocValuesProducer;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.FilteredTermsEnum;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.OrdinalMap;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.AttributeSource;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.LongBitSet;
import org.gnit.lucenekmp.util.LongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000  2\u00060\u0001j\u0002`\u0002:\b\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "addNumericField", "", "field", "Lorg/gnit/lucenekmp/index/FieldInfo;", "valuesProducer", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "addBinaryField", "addSortedField", "addSortedNumericField", "addSortedSetField", "merge", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "mergeNumericField", "mergeFieldInfo", "mergeBinaryField", "mergeSortedNumericField", "mergeSortedField", "fieldInfo", "mergeSortedSetField", "NumericDocValuesSub", "BinaryDocValuesSub", "SortedNumericDocValuesSub", "MergedTermsEnum", "SortedDocValuesSub", "SortedSetDocValuesSub", "BitsFilteredTermsEnum", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocValuesConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocValuesConsumer.kt\norg/gnit/lucenekmp/codecs/DocValuesConsumer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,953:1\n37#2:954\n36#2,3:955\n1#3:958\n*S KotlinDebug\n*F\n+ 1 DocValuesConsumer.kt\norg/gnit/lucenekmp/codecs/DocValuesConsumer\n*L\n509#1:954\n509#1:955,3\n*E\n"})
public abstract class DocValuesConsumer
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected DocValuesConsumer() {
    }

    public abstract void addNumericField(@NotNull FieldInfo var1, @NotNull DocValuesProducer var2) throws IOException;

    public abstract void addBinaryField(@NotNull FieldInfo var1, @NotNull DocValuesProducer var2) throws IOException;

    public abstract void addSortedField(@NotNull FieldInfo var1, @NotNull DocValuesProducer var2) throws IOException;

    public abstract void addSortedNumericField(@NotNull FieldInfo var1, @NotNull DocValuesProducer var2) throws IOException;

    public abstract void addSortedSetField(@NotNull FieldInfo var1, @NotNull DocValuesProducer var2) throws IOException;

    public void merge(@NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        DocValuesProducer[] docValuesProducerArray = mergeState.getDocValuesProducers();
        int n = docValuesProducerArray.length;
        for (int i = 0; i < n; ++i) {
            DocValuesProducer docValuesProducer;
            DocValuesProducer docValuesProducer2 = docValuesProducer = docValuesProducerArray[i];
            if (docValuesProducer2 == null) continue;
            docValuesProducer2.checkIntegrity();
        }
        FieldInfos fieldInfos = mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        for (FieldInfo mergeFieldInfo : fieldInfos) {
            DocValuesType type = mergeFieldInfo.getDocValuesType();
            if (type == DocValuesType.NONE) continue;
            if (type == DocValuesType.NUMERIC) {
                this.mergeNumericField(mergeFieldInfo, mergeState);
                continue;
            }
            if (type == DocValuesType.BINARY) {
                this.mergeBinaryField(mergeFieldInfo, mergeState);
                continue;
            }
            if (type == DocValuesType.SORTED) {
                this.mergeSortedField(mergeFieldInfo, mergeState);
                continue;
            }
            if (type == DocValuesType.SORTED_SET) {
                this.mergeSortedSetField(mergeFieldInfo, mergeState);
                continue;
            }
            if (type == DocValuesType.SORTED_NUMERIC) {
                this.mergeSortedNumericField(mergeFieldInfo, mergeState);
                continue;
            }
            throw new AssertionError((Object)("type=" + type));
        }
    }

    public final void mergeNumericField(@NotNull FieldInfo mergeFieldInfo, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeFieldInfo, (String)"mergeFieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        this.addNumericField(mergeFieldInfo, new EmptyDocValuesProducer(mergeFieldInfo, mergeState){
            final /* synthetic */ FieldInfo $mergeFieldInfo;
            final /* synthetic */ MergeState $mergeState;
            {
                this.$mergeFieldInfo = $mergeFieldInfo;
                this.$mergeState = $mergeState;
            }

            public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
                Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                if (!(fieldInfo == this.$mergeFieldInfo)) {
                    boolean $i$a$-require-DocValuesConsumer$mergeNumericField$1$getNumeric$22 = false;
                    String $i$a$-require-DocValuesConsumer$mergeNumericField$1$getNumeric$22 = "wrong fieldInfo";
                    throw new IllegalArgumentException($i$a$-require-DocValuesConsumer$mergeNumericField$1$getNumeric$22.toString());
                }
                List subs = new ArrayList<E>();
                MergeState.DocMap[] docMapArray = this.$mergeState.getDocMaps();
                Intrinsics.checkNotNull((Object)docMapArray);
                if (!(docMapArray.length == this.$mergeState.getDocValuesProducers().length)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int n = this.$mergeState.getDocValuesProducers().length;
                for (int i = 0; i < n; ++i) {
                    NumericDocValues values2 = null;
                    DocValuesProducer docValuesProducer = this.$mergeState.getDocValuesProducers()[i];
                    if (docValuesProducer != null) {
                        FieldInfos fieldInfos = this.$mergeState.getFieldInfos()[i];
                        Intrinsics.checkNotNull((Object)fieldInfos);
                        FieldInfo readerFieldInfo = fieldInfos.fieldInfo(this.$mergeFieldInfo.getName());
                        if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.NUMERIC) {
                            values2 = docValuesProducer.getNumeric(readerFieldInfo);
                        }
                    }
                    if (values2 == null) continue;
                    subs.add(new NumericDocValuesSub(this.$mergeState.getDocMaps()[i], values2));
                }
                return org.gnit.lucenekmp.codecs.DocValuesConsumer$Companion.access$mergeNumericValues(DocValuesConsumer.Companion, subs, this.$mergeState.getNeedsIndexSort());
            }
        });
    }

    public final void mergeBinaryField(@NotNull FieldInfo mergeFieldInfo, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeFieldInfo, (String)"mergeFieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        this.addBinaryField(mergeFieldInfo, new EmptyDocValuesProducer(mergeFieldInfo, mergeState){
            final /* synthetic */ FieldInfo $mergeFieldInfo;
            final /* synthetic */ MergeState $mergeState;
            {
                this.$mergeFieldInfo = $mergeFieldInfo;
                this.$mergeState = $mergeState;
            }

            public BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
                Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                if (!(fieldInfo == this.$mergeFieldInfo)) {
                    boolean $i$a$-require-DocValuesConsumer$mergeBinaryField$1$getBinary$22 = false;
                    String $i$a$-require-DocValuesConsumer$mergeBinaryField$1$getBinary$22 = "wrong fieldInfo";
                    throw new IllegalArgumentException($i$a$-require-DocValuesConsumer$mergeBinaryField$1$getBinary$22.toString());
                }
                List subs = new ArrayList<E>();
                long cost = 0L;
                int n = this.$mergeState.getDocValuesProducers().length;
                for (int i = 0; i < n; ++i) {
                    DocIdSetIterator values2 = null;
                    DocValuesProducer docValuesProducer = this.$mergeState.getDocValuesProducers()[i];
                    if (docValuesProducer != null) {
                        FieldInfos fieldInfos = this.$mergeState.getFieldInfos()[i];
                        Intrinsics.checkNotNull((Object)fieldInfos);
                        FieldInfo readerFieldInfo = fieldInfos.fieldInfo(this.$mergeFieldInfo.getName());
                        if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                            values2 = docValuesProducer.getBinary(readerFieldInfo);
                        }
                    }
                    if (values2 == null) continue;
                    cost += values2.cost();
                    MergeState.DocMap[] docMapArray = this.$mergeState.getDocMaps();
                    Intrinsics.checkNotNull((Object)docMapArray);
                    subs.add(new BinaryDocValuesSub(docMapArray[i], (BinaryDocValues)values2));
                }
                DocIDMerger<BinaryDocValuesSub> docIDMerger = DocIDMerger.Companion.of(subs, this.$mergeState.getNeedsIndexSort());
                long finalCost = cost;
                return new BinaryDocValues(docIDMerger, finalCost){
                    private BinaryDocValuesSub current;
                    private int docID;
                    final /* synthetic */ DocIDMerger<BinaryDocValuesSub> $docIDMerger;
                    final /* synthetic */ long $finalCost;
                    {
                        this.$docIDMerger = $docIDMerger;
                        this.$finalCost = $finalCost;
                        this.docID = -1;
                    }

                    public int docID() {
                        return this.docID;
                    }

                    public int nextDoc() throws IOException {
                        block0: {
                            BinaryDocValuesSub binaryDocValuesSub = this.current = this.$docIDMerger.next();
                            if (binaryDocValuesSub == null) break block0;
                            BinaryDocValuesSub it = binaryDocValuesSub;
                            boolean bl = false;
                            this.docID = it.getMappedDocID();
                        }
                        return this.docID;
                    }

                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public long cost() {
                        return this.$finalCost;
                    }

                    public BytesRef binaryValue() throws IOException {
                        BinaryDocValuesSub binaryDocValuesSub = this.current;
                        Intrinsics.checkNotNull((Object)binaryDocValuesSub);
                        return binaryDocValuesSub.getValues().binaryValue();
                    }
                };
            }
        });
    }

    public final void mergeSortedNumericField(@NotNull FieldInfo mergeFieldInfo, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeFieldInfo, (String)"mergeFieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        this.addSortedNumericField(mergeFieldInfo, new EmptyDocValuesProducer(mergeFieldInfo, mergeState){
            final /* synthetic */ FieldInfo $mergeFieldInfo;
            final /* synthetic */ MergeState $mergeState;
            {
                this.$mergeFieldInfo = $mergeFieldInfo;
                this.$mergeState = $mergeState;
            }

            public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfo) throws IOException {
                Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                if (!(fieldInfo == this.$mergeFieldInfo)) {
                    boolean $i$a$-require-DocValuesConsumer$mergeSortedNumericField$1$getSortedNumeric$22 = false;
                    String $i$a$-require-DocValuesConsumer$mergeSortedNumericField$1$getSortedNumeric$22 = "wrong FieldInfo";
                    throw new IllegalArgumentException($i$a$-require-DocValuesConsumer$mergeSortedNumericField$1$getSortedNumeric$22.toString());
                }
                List subs = new ArrayList<E>();
                long cost = 0L;
                boolean allSingletons = true;
                int n = this.$mergeState.getDocValuesProducers().length;
                for (int i = 0; i < n; ++i) {
                    DocValuesProducer docValuesProducer = this.$mergeState.getDocValuesProducers()[i];
                    SortedNumericDocValues values2 = null;
                    if (docValuesProducer != null) {
                        FieldInfos fieldInfos = this.$mergeState.getFieldInfos()[i];
                        Intrinsics.checkNotNull((Object)fieldInfos);
                        FieldInfo readerFieldInfo = fieldInfos.fieldInfo(this.$mergeFieldInfo.getName());
                        if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                            values2 = docValuesProducer.getSortedNumeric(readerFieldInfo);
                        }
                    }
                    if (values2 == null) {
                        values2 = DocValues.INSTANCE.emptySortedNumeric();
                    }
                    cost += values2.cost();
                    if (allSingletons && DocValues.INSTANCE.unwrapSingleton(values2) == null) {
                        allSingletons = false;
                    }
                    MergeState.DocMap[] docMapArray = this.$mergeState.getDocMaps();
                    Intrinsics.checkNotNull((Object)docMapArray);
                    subs.add(new SortedNumericDocValuesSub(docMapArray[i], values2));
                }
                if (allSingletons) {
                    List singleValuedSubs = new ArrayList<E>();
                    for (SortedNumericDocValuesSub sub : subs) {
                        NumericDocValues singleValuedValues;
                        if (DocValues.INSTANCE.unwrapSingleton(sub.getValues()) == null) {
                            String string = "Required value was null.";
                            throw new IllegalStateException(string.toString());
                        }
                        singleValuedSubs.add(new NumericDocValuesSub(sub.getDocMap(), singleValuedValues));
                    }
                    return DocValues.INSTANCE.singleton(org.gnit.lucenekmp.codecs.DocValuesConsumer$Companion.access$mergeNumericValues(DocValuesConsumer.Companion, singleValuedSubs, this.$mergeState.getNeedsIndexSort()));
                }
                long finalCost = cost;
                DocIDMerger<SortedNumericDocValuesSub> docIDMerger = DocIDMerger.Companion.of(subs, this.$mergeState.getNeedsIndexSort());
                return new SortedNumericDocValues(docIDMerger, finalCost){
                    private int docID;
                    private SortedNumericDocValuesSub currentSub;
                    final /* synthetic */ DocIDMerger<SortedNumericDocValuesSub> $docIDMerger;
                    final /* synthetic */ long $finalCost;
                    {
                        this.$docIDMerger = $docIDMerger;
                        this.$finalCost = $finalCost;
                        this.docID = -1;
                    }

                    public int docID() {
                        return this.docID;
                    }

                    public int nextDoc() throws IOException {
                        block0: {
                            SortedNumericDocValuesSub sortedNumericDocValuesSub = this.currentSub = this.$docIDMerger.next();
                            if (sortedNumericDocValuesSub == null) break block0;
                            SortedNumericDocValuesSub it = sortedNumericDocValuesSub;
                            boolean bl = false;
                            this.docID = it.getMappedDocID();
                        }
                        return this.docID;
                    }

                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public int docValueCount() {
                        SortedNumericDocValuesSub sortedNumericDocValuesSub = this.currentSub;
                        Intrinsics.checkNotNull((Object)sortedNumericDocValuesSub);
                        return sortedNumericDocValuesSub.getValues().docValueCount();
                    }

                    public long cost() {
                        return this.$finalCost;
                    }

                    public long nextValue() throws IOException {
                        SortedNumericDocValuesSub sortedNumericDocValuesSub = this.currentSub;
                        Intrinsics.checkNotNull((Object)sortedNumericDocValuesSub);
                        return sortedNumericDocValuesSub.getValues().nextValue();
                    }
                };
            }
        });
    }

    public final void mergeSortedField(@NotNull FieldInfo fieldInfo, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        List toMerge = new ArrayList();
        int n = mergeState.getDocValuesProducers().length;
        for (int i = 0; i < n; ++i) {
            SortedDocValues values2 = null;
            DocValuesProducer docValuesProducer = mergeState.getDocValuesProducers()[i];
            if (docValuesProducer != null) {
                FieldInfos fieldInfos = mergeState.getFieldInfos()[i];
                Intrinsics.checkNotNull((Object)fieldInfos);
                FieldInfo readerFieldInfo = fieldInfos.fieldInfo(fieldInfo.getName());
                if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                    values2 = docValuesProducer.getSorted(readerFieldInfo);
                }
            }
            if (values2 == null) {
                values2 = DocValues.INSTANCE.emptySorted();
            }
            toMerge.add(values2);
        }
        int numReaders = toMerge.size();
        Collection $this$toTypedArray$iv = toMerge;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SortedDocValues[] dvs = thisCollection$iv.toArray(new SortedDocValues[0]);
        TermsEnum[] liveTerms = new TermsEnum[dvs.length];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < numReaders; ++sub) {
            SortedDocValues dv = dvs[sub];
            Bits liveDocs2 = mergeState.getLiveDocs()[sub];
            if (liveDocs2 == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet(dv.getValueCount());
            int docID = 0;
            while (true) {
                int ord;
                int n2;
                int it = n2 = dv.nextDoc();
                boolean bl = false;
                docID = it;
                if (n2 == Integer.MAX_VALUE) break;
                if (!liveDocs2.get(docID) || (ord = dv.ordValue()) < 0) continue;
                bitset.set(ord);
            }
            TermsEnum termsEnum = dv.termsEnum();
            Intrinsics.checkNotNull((Object)termsEnum);
            liveTerms[sub] = new BitsFilteredTermsEnum(termsEnum, bitset);
            weights[sub] = bitset.cardinality();
        }
        OrdinalMap map2 = OrdinalMap.Companion.build(null, liveTerms, weights, 0.0f);
        this.addSortedField(fieldInfo, new EmptyDocValuesProducer(fieldInfo, mergeState, map2){
            final /* synthetic */ FieldInfo $fieldInfo;
            final /* synthetic */ MergeState $mergeState;
            final /* synthetic */ OrdinalMap $map;
            {
                this.$fieldInfo = $fieldInfo;
                this.$mergeState = $mergeState;
                this.$map = $map;
            }

            public SortedDocValues getSorted(FieldInfo fieldInfoIn) throws IOException {
                Intrinsics.checkNotNullParameter((Object)fieldInfoIn, (String)"fieldInfoIn");
                if (!(fieldInfoIn == this.$fieldInfo)) {
                    boolean $i$a$-require-DocValuesConsumer$mergeSortedField$2$getSorted$22 = false;
                    String $i$a$-require-DocValuesConsumer$mergeSortedField$2$getSorted$22 = "wrong FieldInfo";
                    throw new IllegalArgumentException($i$a$-require-DocValuesConsumer$mergeSortedField$2$getSorted$22.toString());
                }
                List subs = new ArrayList<E>();
                int n = this.$mergeState.getDocValuesProducers().length;
                for (int i = 0; i < n; ++i) {
                    SortedDocValues values2 = null;
                    DocValuesProducer docValuesProducer = this.$mergeState.getDocValuesProducers()[i];
                    if (docValuesProducer != null) {
                        FieldInfos fieldInfos = this.$mergeState.getFieldInfos()[i];
                        Intrinsics.checkNotNull((Object)fieldInfos);
                        FieldInfo readerFieldInfo = fieldInfos.fieldInfo(this.$fieldInfo.getName());
                        if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                            values2 = docValuesProducer.getSorted(readerFieldInfo);
                        }
                    }
                    if (values2 == null) {
                        values2 = DocValues.INSTANCE.emptySorted();
                    }
                    MergeState.DocMap[] docMapArray = this.$mergeState.getDocMaps();
                    Intrinsics.checkNotNull((Object)docMapArray);
                    subs.add(new SortedDocValuesSub(docMapArray[i], values2, this.$map.getGlobalOrds(i)));
                }
                return org.gnit.lucenekmp.codecs.DocValuesConsumer$Companion.access$mergeSortedValues(DocValuesConsumer.Companion, subs, this.$mergeState.getNeedsIndexSort(), this.$map);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public final void mergeSortedSetField(@NotNull FieldInfo mergeFieldInfo, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeFieldInfo, (String)"mergeFieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        toMerge = new ArrayList<E>();
        var5_6 = mergeState.getDocValuesProducers().length;
        for (i = 0; i < var5_6; ++i) {
            values = null;
            docValuesProducer = mergeState.getDocValuesProducers()[i];
            if (docValuesProducer != null) {
                v0 = mergeState.getFieldInfos()[i];
                Intrinsics.checkNotNull((Object)v0);
                fieldInfo = v0.fieldInfo(mergeFieldInfo.getName());
                if (fieldInfo != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                    values = docValuesProducer.getSortedSet(fieldInfo);
                }
            }
            if (values == null) {
                values = DocValues.INSTANCE.emptySortedSet();
            }
            toMerge.add(values);
        }
        liveTerms = new TermsEnum[toMerge.size()];
        weights = new long[liveTerms.length];
        var7_12 = liveTerms.length;
        for (sub = 0; sub < var7_12; ++sub) {
            dv = (SortedSetDocValues)toMerge.get(sub);
            liveDocs = mergeState.getLiveDocs()[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            bitset = new LongBitSet(dv.getValueCount());
            docID = 0;
            block2: while (true) {
                it = var12_17 = dv.nextDoc();
                $i$a$-also-DocValuesConsumer$mergeSortedSetField$1 = false;
                docID = it;
                if (var12_17 == 0x7FFFFFFF) break;
                if (!liveDocs.get(docID)) continue;
                i = 0;
                var13_18 = dv.docValueCount();
                while (true) {
                    if (i < var13_18) ** break;
                    continue block2;
                    bitset.set(dv.nextOrd());
                    ++i;
                }
                break;
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        map = OrdinalMap.Companion.build(null, liveTerms, weights, 0.0f);
        this.addSortedSetField(mergeFieldInfo, new EmptyDocValuesProducer(mergeFieldInfo, mergeState, map, toMerge){
            final /* synthetic */ FieldInfo $mergeFieldInfo;
            final /* synthetic */ MergeState $mergeState;
            final /* synthetic */ OrdinalMap $map;
            final /* synthetic */ List<SortedSetDocValues> $toMerge;
            {
                this.$mergeFieldInfo = $mergeFieldInfo;
                this.$mergeState = $mergeState;
                this.$map = $map;
                this.$toMerge = $toMerge;
            }

            public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
                Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                if (!(fieldInfo == this.$mergeFieldInfo)) {
                    boolean $i$a$-require-DocValuesConsumer$mergeSortedSetField$2$getSortedSet$22 = false;
                    String $i$a$-require-DocValuesConsumer$mergeSortedSetField$2$getSortedSet$22 = "wrong FieldInfo";
                    throw new IllegalArgumentException($i$a$-require-DocValuesConsumer$mergeSortedSetField$2$getSortedSet$22.toString());
                }
                List subs = new ArrayList<E>();
                long cost = 0L;
                boolean allSingletons = true;
                int n = this.$mergeState.getDocValuesProducers().length;
                for (int i = 0; i < n; ++i) {
                    SortedSetDocValues values2 = null;
                    DocValuesProducer docValuesProducer = this.$mergeState.getDocValuesProducers()[i];
                    if (docValuesProducer != null) {
                        FieldInfos fieldInfos = this.$mergeState.getFieldInfos()[i];
                        Intrinsics.checkNotNull((Object)fieldInfos);
                        FieldInfo readerFieldInfo = fieldInfos.fieldInfo(this.$mergeFieldInfo.getName());
                        if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                            values2 = docValuesProducer.getSortedSet(readerFieldInfo);
                        }
                    }
                    if (values2 == null) {
                        values2 = DocValues.INSTANCE.emptySortedSet();
                    }
                    cost += values2.cost();
                    if (allSingletons && DocValues.INSTANCE.unwrapSingleton(values2) == null) {
                        allSingletons = false;
                    }
                    MergeState.DocMap[] docMapArray = this.$mergeState.getDocMaps();
                    Intrinsics.checkNotNull((Object)docMapArray);
                    subs.add(new SortedSetDocValuesSub(docMapArray[i], values2, this.$map.getGlobalOrds(i)));
                }
                if (allSingletons) {
                    List singleValuedSubs = new ArrayList<E>();
                    for (SortedSetDocValuesSub sub : subs) {
                        SortedDocValues singleValuedValues;
                        if (DocValues.INSTANCE.unwrapSingleton(sub.getValues()) == null) {
                            String string = "Required value was null.";
                            throw new IllegalStateException(string.toString());
                        }
                        singleValuedSubs.add(new SortedDocValuesSub(sub.getDocMap(), singleValuedValues, sub.getMap()));
                    }
                    return DocValues.INSTANCE.singleton(org.gnit.lucenekmp.codecs.DocValuesConsumer$Companion.access$mergeSortedValues(DocValuesConsumer.Companion, singleValuedSubs, this.$mergeState.getNeedsIndexSort(), this.$map));
                }
                DocIDMerger<SortedSetDocValuesSub> docIDMerger = DocIDMerger.Companion.of(subs, this.$mergeState.getNeedsIndexSort());
                long finalCost = cost;
                return new SortedSetDocValues(docIDMerger, finalCost, this.$map, this.$toMerge){
                    private int docID;
                    private SortedSetDocValuesSub currentSub;
                    final /* synthetic */ DocIDMerger<SortedSetDocValuesSub> $docIDMerger;
                    final /* synthetic */ long $finalCost;
                    final /* synthetic */ OrdinalMap $map;
                    final /* synthetic */ List<SortedSetDocValues> $toMerge;
                    {
                        this.$docIDMerger = $docIDMerger;
                        this.$finalCost = $finalCost;
                        this.$map = $map;
                        this.$toMerge = $toMerge;
                        this.docID = -1;
                    }

                    public int docID() {
                        return this.docID;
                    }

                    public int nextDoc() throws IOException {
                        block0: {
                            SortedSetDocValuesSub sortedSetDocValuesSub = this.currentSub = this.$docIDMerger.next();
                            if (sortedSetDocValuesSub == null) break block0;
                            SortedSetDocValuesSub it = sortedSetDocValuesSub;
                            boolean bl = false;
                            this.docID = it.getMappedDocID();
                        }
                        return this.docID;
                    }

                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public long nextOrd() throws IOException {
                        SortedSetDocValuesSub sortedSetDocValuesSub = this.currentSub;
                        Intrinsics.checkNotNull((Object)sortedSetDocValuesSub);
                        long subOrd = sortedSetDocValuesSub.getValues().nextOrd();
                        SortedSetDocValuesSub sortedSetDocValuesSub2 = this.currentSub;
                        Intrinsics.checkNotNull((Object)sortedSetDocValuesSub2);
                        return sortedSetDocValuesSub2.getMap().get(subOrd);
                    }

                    public int docValueCount() {
                        SortedSetDocValuesSub sortedSetDocValuesSub = this.currentSub;
                        Intrinsics.checkNotNull((Object)sortedSetDocValuesSub);
                        return sortedSetDocValuesSub.getValues().docValueCount();
                    }

                    public long cost() {
                        return this.$finalCost;
                    }

                    public BytesRef lookupOrd(long ord) throws IOException {
                        int segmentNumber = this.$map.getFirstSegmentNumber(ord);
                        long segmentOrd = this.$map.getFirstSegmentOrd(ord);
                        return this.$toMerge.get(segmentNumber).lookupOrd(segmentOrd);
                    }

                    public long getValueCount() {
                        return this.$map.getValueCount();
                    }

                    public TermsEnum termsEnum() throws IOException {
                        TermsEnum[] subs = new TermsEnum[this.$toMerge.size()];
                        int n = subs.length;
                        for (int sub = 0; sub < n; ++sub) {
                            subs[sub] = this.$toMerge.get(sub).termsEnum();
                        }
                        return new MergedTermsEnum(this.$map, subs);
                    }
                };
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$BinaryDocValuesSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "values", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/index/BinaryDocValues;)V", "getValues", "()Lorg/gnit/lucenekmp/index/BinaryDocValues;", "nextDoc", "", "core"})
    private static final class BinaryDocValuesSub
    extends DocIDMerger.Sub {
        @NotNull
        private final BinaryDocValues values;

        public BinaryDocValuesSub(@NotNull MergeState.DocMap docMap, @NotNull BinaryDocValues values2) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            super(docMap);
            this.values = values2;
            if (!(this.values.docID() == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final BinaryDocValues getValues() {
            return this.values;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$BitsFilteredTermsEnum;", "Lorg/gnit/lucenekmp/index/FilteredTermsEnum;", "in", "Lorg/gnit/lucenekmp/index/TermsEnum;", "liveTerms", "Lorg/gnit/lucenekmp/util/LongBitSet;", "<init>", "(Lorg/gnit/lucenekmp/index/TermsEnum;Lorg/gnit/lucenekmp/util/LongBitSet;)V", "getLiveTerms", "()Lorg/gnit/lucenekmp/util/LongBitSet;", "accept", "Lorg/gnit/lucenekmp/index/FilteredTermsEnum$AcceptStatus;", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    public static final class BitsFilteredTermsEnum
    extends FilteredTermsEnum {
        @NotNull
        private final LongBitSet liveTerms;

        public BitsFilteredTermsEnum(@NotNull TermsEnum in, @NotNull LongBitSet liveTerms) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)liveTerms, (String)"liveTerms");
            super(in, false);
            this.liveTerms = liveTerms;
        }

        @NotNull
        public final LongBitSet getLiveTerms() {
            return this.liveTerms;
        }

        @Override
        @NotNull
        protected FilteredTermsEnum.AcceptStatus accept(@NotNull BytesRef term) throws IOException {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            return this.liveTerms.get(this.ord()) ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.NO;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u0013\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$Companion;", "", "<init>", "()V", "mergeNumericValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "subs", "", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$NumericDocValuesSub;", "indexIsSorted", "", "mergeSortedValues", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$SortedDocValuesSub;", "map", "Lorg/gnit/lucenekmp/index/OrdinalMap;", "isSingleValued", "docToValueCount", "", "", "singletonView", "values", "missingValue", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final NumericDocValues mergeNumericValues(List<NumericDocValuesSub> subs, boolean indexIsSorted) throws IOException {
            long cost = 0L;
            for (NumericDocValuesSub sub : subs) {
                cost += sub.getValues().cost();
            }
            long finalCost = cost;
            DocIDMerger<NumericDocValuesSub> docIDMerger = DocIDMerger.Companion.of(subs, indexIsSorted);
            return new NumericDocValues(docIDMerger, finalCost){
                private int docID;
                private NumericDocValuesSub current;
                final /* synthetic */ DocIDMerger<NumericDocValuesSub> $docIDMerger;
                final /* synthetic */ long $finalCost;
                {
                    this.$docIDMerger = $docIDMerger;
                    this.$finalCost = $finalCost;
                    this.docID = -1;
                }

                public int docID() {
                    return this.docID;
                }

                public int nextDoc() throws IOException {
                    this.current = this.$docIDMerger.next();
                    if (this.current == null) {
                        this.docID = Integer.MAX_VALUE;
                    } else {
                        NumericDocValuesSub numericDocValuesSub = this.current;
                        Intrinsics.checkNotNull((Object)numericDocValuesSub);
                        this.docID = numericDocValuesSub.getMappedDocID();
                    }
                    return this.docID;
                }

                public int advance(int target) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public boolean advanceExact(int target) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public long cost() {
                    return this.$finalCost;
                }

                public long longValue() throws IOException {
                    NumericDocValuesSub numericDocValuesSub = this.current;
                    Intrinsics.checkNotNull((Object)numericDocValuesSub);
                    return numericDocValuesSub.getValues().longValue();
                }
            };
        }

        private final SortedDocValues mergeSortedValues(List<SortedDocValuesSub> subs, boolean indexIsSorted, OrdinalMap map2) throws IOException {
            long cost = 0L;
            for (SortedDocValuesSub sub : subs) {
                cost += sub.getValues().cost();
            }
            long finalCost = cost;
            DocIDMerger<SortedDocValuesSub> docIDMerger = DocIDMerger.Companion.of(subs, indexIsSorted);
            return new SortedDocValues(docIDMerger, finalCost, map2, subs){
                private int docID;
                private SortedDocValuesSub current;
                final /* synthetic */ DocIDMerger<SortedDocValuesSub> $docIDMerger;
                final /* synthetic */ long $finalCost;
                final /* synthetic */ OrdinalMap $map;
                final /* synthetic */ List<SortedDocValuesSub> $subs;
                {
                    this.$docIDMerger = $docIDMerger;
                    this.$finalCost = $finalCost;
                    this.$map = $map;
                    this.$subs = $subs;
                    this.docID = -1;
                }

                public int docID() {
                    return this.docID;
                }

                public int nextDoc() throws IOException {
                    this.current = this.$docIDMerger.next();
                    if (this.current == null) {
                        this.docID = Integer.MAX_VALUE;
                    } else {
                        SortedDocValuesSub sortedDocValuesSub = this.current;
                        Intrinsics.checkNotNull((Object)sortedDocValuesSub);
                        this.docID = sortedDocValuesSub.getMappedDocID();
                    }
                    return this.docID;
                }

                public int ordValue() throws IOException {
                    SortedDocValuesSub sortedDocValuesSub = this.current;
                    Intrinsics.checkNotNull((Object)sortedDocValuesSub);
                    int subOrd = sortedDocValuesSub.getValues().ordValue();
                    if (!(subOrd != -1)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    SortedDocValuesSub sortedDocValuesSub2 = this.current;
                    Intrinsics.checkNotNull((Object)sortedDocValuesSub2);
                    return (int)sortedDocValuesSub2.getMap().get(subOrd);
                }

                public int advance(int target) {
                    throw new UnsupportedOperationException();
                }

                public boolean advanceExact(int target) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public long cost() {
                    return this.$finalCost;
                }

                public int getValueCount() {
                    return (int)this.$map.getValueCount();
                }

                public BytesRef lookupOrd(int ord) throws IOException {
                    int segmentNumber = this.$map.getFirstSegmentNumber(ord);
                    int segmentOrd = (int)this.$map.getFirstSegmentOrd(ord);
                    return this.$subs.get(segmentNumber).getValues().lookupOrd(segmentOrd);
                }

                public TermsEnum termsEnum() throws IOException {
                    TermsEnum[] termsEnumSubs = new TermsEnum[this.$subs.size()];
                    int n = termsEnumSubs.length;
                    for (int sub = 0; sub < n; ++sub) {
                        termsEnumSubs[sub] = this.$subs.get(sub).getValues().termsEnum();
                    }
                    return new MergedTermsEnum(this.$map, termsEnumSubs);
                }
            };
        }

        public final boolean isSingleValued(@NotNull Iterable<? extends Number> docToValueCount) {
            Intrinsics.checkNotNullParameter(docToValueCount, (String)"docToValueCount");
            for (Number number : docToValueCount) {
                if (number.longValue() <= 1L) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public final Iterable<Number> singletonView(@NotNull Iterable<? extends Number> docToValueCount, @NotNull Iterable<? extends Number> values2, @NotNull Number missingValue) {
            Intrinsics.checkNotNullParameter(docToValueCount, (String)"docToValueCount");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)missingValue, (String)"missingValue");
            if (!this.isSingleValued(docToValueCount)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Iterable<Number>(docToValueCount, values2, missingValue){
                final /* synthetic */ Iterable<Number> $docToValueCount;
                final /* synthetic */ Iterable<Number> $values;
                final /* synthetic */ Number $missingValue;
                {
                    this.$docToValueCount = $docToValueCount;
                    this.$values = $values;
                    this.$missingValue = $missingValue;
                }

                public Iterator<Number> iterator() {
                    Iterator<Number> countIterator = this.$docToValueCount.iterator();
                    Iterator<Number> valuesIterator = this.$values.iterator();
                    return new Iterator<Number>(countIterator, this.$missingValue, valuesIterator){
                        final /* synthetic */ Iterator<Number> $countIterator;
                        final /* synthetic */ Number $missingValue;
                        final /* synthetic */ Iterator<Number> $valuesIterator;
                        {
                            this.$countIterator = $countIterator;
                            this.$missingValue = $missingValue;
                            this.$valuesIterator = $valuesIterator;
                        }

                        public boolean hasNext() {
                            return this.$countIterator.hasNext();
                        }

                        public Number next() {
                            int count = this.$countIterator.next().intValue();
                            if (count == 0) {
                                return this.$missingValue;
                            }
                            return this.$valuesIterator.next();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        public static final /* synthetic */ NumericDocValues access$mergeNumericValues(Companion $this, List subs, boolean indexIsSorted) {
            return $this.mergeNumericValues(subs, indexIsSorted);
        }

        public static final /* synthetic */ SortedDocValues access$mergeSortedValues(Companion $this, List subs, boolean indexIsSorted, OrdinalMap map2) {
            return $this.mergeSortedValues(subs, indexIsSorted, map2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$MergedTermsEnum;", "Lorg/gnit/lucenekmp/index/BaseTermsEnum;", "ordinalMap", "Lorg/gnit/lucenekmp/index/OrdinalMap;", "subs", "", "Lorg/gnit/lucenekmp/index/TermsEnum;", "<init>", "(Lorg/gnit/lucenekmp/index/OrdinalMap;[Lorg/gnit/lucenekmp/index/TermsEnum;)V", "[Lorg/gnit/lucenekmp/index/TermsEnum;", "valueCount", "", "ord", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "next", "attributes", "Lorg/gnit/lucenekmp/util/AttributeSource;", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "text", "seekExact", "", "docFreq", "", "totalTermFreq", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "flags", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "termState", "Lorg/gnit/lucenekmp/index/TermState;", "core"})
    private static final class MergedTermsEnum
    extends BaseTermsEnum {
        @NotNull
        private final OrdinalMap ordinalMap;
        @NotNull
        private final TermsEnum[] subs;
        private final long valueCount;
        private long ord;
        @Nullable
        private BytesRef term;

        public MergedTermsEnum(@NotNull OrdinalMap ordinalMap, @NotNull TermsEnum[] subs) {
            Intrinsics.checkNotNullParameter((Object)ordinalMap, (String)"ordinalMap");
            Intrinsics.checkNotNullParameter((Object)subs, (String)"subs");
            this.ordinalMap = ordinalMap;
            this.subs = subs;
            this.valueCount = this.ordinalMap.getValueCount();
            this.ord = -1L;
        }

        @Override
        @Nullable
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            return this.ord;
        }

        @Override
        @Nullable
        public BytesRef next() throws IOException {
            ++this.ord;
            if (this.ord >= this.valueCount) {
                return null;
            }
            int subNum = this.ordinalMap.getFirstSegmentNumber(this.ord);
            TermsEnum sub = this.subs[subNum];
            long subOrd = this.ordinalMap.getFirstSegmentOrd(this.ord);
            do {
                this.term = sub.next();
            } while (sub.ord() < subOrd);
            if (!(sub.ord() == subOrd)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.term;
        }

        @Override
        @NotNull
        public AttributeSource attributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public TermsEnum.SeekStatus seekCeil(@NotNull BytesRef text) throws IOException {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            throw new UnsupportedOperationException();
        }

        @Override
        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public TermState termState() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$NumericDocValuesSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "values", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/index/NumericDocValues;)V", "getValues", "()Lorg/gnit/lucenekmp/index/NumericDocValues;", "nextDoc", "", "core"})
    private static final class NumericDocValuesSub
    extends DocIDMerger.Sub {
        @NotNull
        private final NumericDocValues values;

        public NumericDocValuesSub(@NotNull MergeState.DocMap docMap, @NotNull NumericDocValues values2) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            super(docMap);
            this.values = values2;
            if (!(this.values.docID() == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final NumericDocValues getValues() {
            return this.values;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$SortedDocValuesSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "values", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "map", "Lorg/gnit/lucenekmp/util/LongValues;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/index/SortedDocValues;Lorg/gnit/lucenekmp/util/LongValues;)V", "getValues", "()Lorg/gnit/lucenekmp/index/SortedDocValues;", "getMap", "()Lorg/gnit/lucenekmp/util/LongValues;", "nextDoc", "", "core"})
    private static final class SortedDocValuesSub
    extends DocIDMerger.Sub {
        @NotNull
        private final SortedDocValues values;
        @NotNull
        private final LongValues map;

        public SortedDocValuesSub(@NotNull MergeState.DocMap docMap, @NotNull SortedDocValues values2, @NotNull LongValues map2) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
            super(docMap);
            this.values = values2;
            this.map = map2;
            if (!(this.values.docID() == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final SortedDocValues getValues() {
            return this.values;
        }

        @NotNull
        public final LongValues getMap() {
            return this.map;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$SortedNumericDocValuesSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "values", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/index/SortedNumericDocValues;)V", "getValues", "()Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "nextDoc", "", "core"})
    private static final class SortedNumericDocValuesSub
    extends DocIDMerger.Sub {
        @NotNull
        private final SortedNumericDocValues values;

        public SortedNumericDocValuesSub(@NotNull MergeState.DocMap docMap, @NotNull SortedNumericDocValues values2) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            super(docMap);
            this.values = values2;
            if (!(this.values.docID() == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final SortedNumericDocValues getValues() {
            return this.values;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/codecs/DocValuesConsumer$SortedSetDocValuesSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "values", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "map", "Lorg/gnit/lucenekmp/util/LongValues;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/index/SortedSetDocValues;Lorg/gnit/lucenekmp/util/LongValues;)V", "getValues", "()Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "getMap", "()Lorg/gnit/lucenekmp/util/LongValues;", "nextDoc", "", "toString", "", "core"})
    private static final class SortedSetDocValuesSub
    extends DocIDMerger.Sub {
        @NotNull
        private final SortedSetDocValues values;
        @NotNull
        private final LongValues map;

        public SortedSetDocValuesSub(@NotNull MergeState.DocMap docMap, @NotNull SortedSetDocValues values2, @NotNull LongValues map2) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
            super(docMap);
            this.values = values2;
            this.map = map2;
            if (!(this.values.docID() == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final SortedSetDocValues getValues() {
            return this.values;
        }

        @NotNull
        public final LongValues getMap() {
            return this.map;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }

        @NotNull
        public String toString() {
            return "SortedSetDocValuesSub(mappedDocID=" + this.getMappedDocID() + " values=" + this.values + ")";
        }
    }
}

