/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.index.DocIDMerger;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001\u0010B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/codecs/NormsConsumer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "addNormsField", "", "field", "Lorg/gnit/lucenekmp/index/FieldInfo;", "normsProducer", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "merge", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "mergeNormsField", "mergeFieldInfo", "NumericDocValuesSub", "core"})
public abstract class NormsConsumer
implements AutoCloseable {
    protected NormsConsumer() {
    }

    public abstract void addNormsField(@NotNull FieldInfo var1, @NotNull NormsProducer var2) throws IOException;

    public final void merge(@NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        NormsProducer[] normsProducerArray = mergeState.getNormsProducers();
        int n = normsProducerArray.length;
        for (int i = 0; i < n; ++i) {
            NormsProducer normsProducer;
            NormsProducer normsProducer2 = normsProducer = normsProducerArray[i];
            if (normsProducer2 == null) continue;
            normsProducer2.checkIntegrity();
        }
        FieldInfos fieldInfos = mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        for (FieldInfo mergeFieldInfo : fieldInfos) {
            if (!mergeFieldInfo.hasNorms()) continue;
            this.mergeNormsField(mergeFieldInfo, mergeState);
        }
    }

    public final void mergeNormsField(@NotNull FieldInfo mergeFieldInfo, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeFieldInfo, (String)"mergeFieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        this.addNormsField(mergeFieldInfo, new NormsProducer(mergeFieldInfo, mergeState){
            final /* synthetic */ FieldInfo $mergeFieldInfo;
            final /* synthetic */ MergeState $mergeState;
            {
                this.$mergeFieldInfo = $mergeFieldInfo;
                this.$mergeState = $mergeState;
            }

            public NumericDocValues getNorms(FieldInfo fieldInfo) throws IOException {
                Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                if (!(fieldInfo == this.$mergeFieldInfo)) {
                    boolean $i$a$-require-NormsConsumer$mergeNormsField$1$getNorms$22 = false;
                    String $i$a$-require-NormsConsumer$mergeNormsField$1$getNorms$22 = "wrong fieldInfo";
                    throw new IllegalArgumentException($i$a$-require-NormsConsumer$mergeNormsField$1$getNorms$22.toString());
                }
                List subs = new ArrayList<E>();
                MergeState.DocMap[] docMapArray = this.$mergeState.getDocMaps();
                Intrinsics.checkNotNull((Object)docMapArray);
                if (!(docMapArray.length == this.$mergeState.getDocValuesProducers().length)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int n = this.$mergeState.getDocValuesProducers().length;
                for (int i = 0; i < n; ++i) {
                    NumericDocValues norms = null;
                    NormsProducer normsProducer = this.$mergeState.getNormsProducers()[i];
                    if (normsProducer != null) {
                        FieldInfos fieldInfos = this.$mergeState.getFieldInfos()[i];
                        Intrinsics.checkNotNull((Object)fieldInfos);
                        FieldInfo readerFieldInfo = fieldInfos.fieldInfo(this.$mergeFieldInfo.getName());
                        if (readerFieldInfo != null && readerFieldInfo.hasNorms()) {
                            norms = normsProducer.getNorms(readerFieldInfo);
                        }
                    }
                    if (norms == null) continue;
                    subs.add(new NumericDocValuesSub(this.$mergeState.getDocMaps()[i], norms));
                }
                DocIDMerger<NumericDocValuesSub> docIDMerger = DocIDMerger.Companion.of(subs, this.$mergeState.getNeedsIndexSort());
                return new NumericDocValues(docIDMerger){
                    private int docID;
                    private NumericDocValuesSub current;
                    final /* synthetic */ DocIDMerger<NumericDocValuesSub> $docIDMerger;
                    {
                        this.$docIDMerger = $docIDMerger;
                        this.docID = -1;
                    }

                    public int docID() {
                        return this.docID;
                    }

                    public int nextDoc() throws IOException {
                        int n;
                        this.current = this.$docIDMerger.next();
                        if (this.current == null) {
                            n = Integer.MAX_VALUE;
                        } else {
                            NumericDocValuesSub numericDocValuesSub = this.current;
                            Intrinsics.checkNotNull((Object)numericDocValuesSub);
                            n = numericDocValuesSub.getMappedDocID();
                        }
                        this.docID = n;
                        return this.docID;
                    }

                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public long cost() {
                        return 0L;
                    }

                    public long longValue() throws IOException {
                        NumericDocValuesSub numericDocValuesSub = this.current;
                        Intrinsics.checkNotNull((Object)numericDocValuesSub);
                        return numericDocValuesSub.getValues().longValue();
                    }
                };
            }

            public void checkIntegrity() {
            }

            public void close() {
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/codecs/NormsConsumer$NumericDocValuesSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "values", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/index/NumericDocValues;)V", "getValues", "()Lorg/gnit/lucenekmp/index/NumericDocValues;", "nextDoc", "", "core"})
    private static final class NumericDocValuesSub
    extends DocIDMerger.Sub {
        @NotNull
        private final NumericDocValues values;

        public NumericDocValuesSub(@NotNull MergeState.DocMap docMap, @NotNull NumericDocValues values2) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            super(docMap);
            this.values = values2;
            if (!(this.values.docID() == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final NumericDocValues getValues() {
            return this.values;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }
}

