/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.TermVectorsReader;
import org.gnit.lucenekmp.index.DocIDMerger;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003:\u0001*B\t\b\u0004\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u0007H\u0016J2\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H&J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u001a\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\tH&J\u0006\u0010\u0018\u001a\u00020\u0007J*\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016H&J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\tH&J$\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\"2\b\u0010\u0011\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010$\u001a\u00020%H\u0004J\b\u0010)\u001a\u00020\u0007H&\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/codecs/TermVectorsWriter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lorg/gnit/lucenekmp/util/Accountable;", "<init>", "()V", "startDocument", "", "numVectorFields", "", "finishDocument", "startField", "info", "Lorg/gnit/lucenekmp/index/FieldInfo;", "numTerms", "positions", "", "offsets", "payloads", "finishField", "startTerm", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "freq", "finishTerm", "addPosition", "position", "startOffset", "endOffset", "payload", "finish", "numDocs", "addProx", "numProx", "Lorg/gnit/lucenekmp/store/DataInput;", "merge", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "addAllDocVectors", "vectors", "Lorg/gnit/lucenekmp/index/Fields;", "close", "TermVectorsMergeSub", "core"})
public abstract class TermVectorsWriter
implements AutoCloseable,
Accountable {
    protected TermVectorsWriter() {
    }

    public abstract void startDocument(int var1) throws IOException;

    public void finishDocument() throws IOException {
    }

    public abstract void startField(@Nullable FieldInfo var1, int var2, boolean var3, boolean var4, boolean var5) throws IOException;

    public void finishField() throws IOException {
    }

    public abstract void startTerm(@Nullable BytesRef var1, int var2) throws IOException;

    public final void finishTerm() throws IOException {
    }

    public abstract void addPosition(int var1, int var2, int var3, @Nullable BytesRef var4) throws IOException;

    public abstract void finish(int var1) throws IOException;

    public void addProx(int numProx, @Nullable DataInput positions, @Nullable DataInput offsets) throws IOException {
        int position = 0;
        int lastOffset = 0;
        BytesRefBuilder payload = null;
        for (int i = 0; i < numProx; ++i) {
            int startOffset = 0;
            int endOffset = 0;
            BytesRef thisPayload = null;
            if (positions == null) {
                position = -1;
                thisPayload = null;
            } else {
                int code = positions.readVInt();
                position += code >>> 1;
                if ((code & 1) != 0) {
                    int payloadLength = positions.readVInt();
                    if (payload == null) {
                        payload = new BytesRefBuilder();
                    }
                    payload.growNoCopy(payloadLength);
                    positions.readBytes(payload.bytes(), 0, payloadLength);
                    payload.setLength(payloadLength);
                    thisPayload = payload.get();
                } else {
                    thisPayload = null;
                }
            }
            if (offsets == null) {
                startOffset = endOffset = -1;
            } else {
                startOffset = lastOffset + offsets.readVInt();
                lastOffset = endOffset = startOffset + offsets.readVInt();
            }
            this.addPosition(position, startOffset, endOffset, thisPayload);
        }
    }

    public int merge(@NotNull MergeState mergeState) throws IOException {
        TermVectorsMergeSub sub;
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        List subs = new ArrayList();
        int n = mergeState.getTermVectorsReaders().length;
        for (int i = 0; i < n; ++i) {
            TermVectorsReader reader2;
            TermVectorsReader termVectorsReader = reader2 = mergeState.getTermVectorsReaders()[i];
            if (termVectorsReader != null) {
                termVectorsReader.checkIntegrity();
            }
            MergeState.DocMap[] docMapArray = mergeState.getDocMaps();
            Intrinsics.checkNotNull((Object)docMapArray);
            subs.add(new TermVectorsMergeSub(docMapArray[i], reader2, mergeState.getMaxDocs()[i]));
        }
        DocIDMerger docIDMerger = DocIDMerger.Companion.of(subs, mergeState.getNeedsIndexSort());
        int docCount = 0;
        while ((sub = (TermVectorsMergeSub)docIDMerger.next()) != null) {
            TermVectorsReader termVectorsReader = sub.getReader();
            Fields vectors = termVectorsReader != null ? termVectorsReader.get(sub.getDocID()) : null;
            this.addAllDocVectors(vectors, mergeState);
            ++docCount;
        }
        this.finish(docCount);
        return docCount;
    }

    protected final void addAllDocVectors(@Nullable Fields vectors, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        if (vectors == null) {
            this.startDocument(0);
            this.finishDocument();
            return;
        }
        int numFields = vectors.size();
        if (numFields == -1) {
            numFields = 0;
            Iterator<String> it = vectors.iterator();
            while (it.hasNext()) {
                it.next();
                ++numFields;
            }
        }
        this.startDocument(numFields);
        String lastFieldName = null;
        TermsEnum termsEnum = null;
        PostingsEnum docsAndPositionsEnum = null;
        int fieldCount = 0;
        for (String fieldName : vectors) {
            ++fieldCount;
            FieldInfos fieldInfos = mergeState.getMergeFieldInfos();
            Intrinsics.checkNotNull((Object)fieldInfos);
            FieldInfo fieldInfo = fieldInfos.fieldInfo(fieldName);
            if (!(lastFieldName == null || fieldName.compareTo(lastFieldName) > 0)) {
                boolean $i$a$-require-TermVectorsWriter$addAllDocVectors$22 = false;
                String $i$a$-require-TermVectorsWriter$addAllDocVectors$22 = "lastFieldName=" + lastFieldName + " fieldName=" + fieldName;
                throw new IllegalArgumentException($i$a$-require-TermVectorsWriter$addAllDocVectors$22.toString());
            }
            lastFieldName = fieldName;
            Terms terms = vectors.terms(fieldName);
            if (terms == null) continue;
            boolean hasPositions = terms.hasPositions();
            boolean hasOffsets = terms.hasOffsets();
            boolean hasPayloads = terms.hasPayloads();
            if (!(!hasPayloads || hasPositions)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int numTerms = (int)terms.size();
            if (numTerms == -1) {
                numTerms = 0;
                termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    ++numTerms;
                }
            }
            this.startField(fieldInfo, numTerms, hasPositions, hasOffsets, hasPayloads);
            termsEnum = terms.iterator();
            int termCount = 0;
            while (termsEnum.next() != null) {
                ++termCount;
                int freq = (int)termsEnum.totalTermFreq();
                this.startTerm(termsEnum.term(), freq);
                if (hasPositions || hasOffsets) {
                    if ((docsAndPositionsEnum = termsEnum.postings(docsAndPositionsEnum, (short)(PostingsEnum.Companion.getOFFSETS() | PostingsEnum.Companion.getPAYLOADS()))) == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    int docID = docsAndPositionsEnum.nextDoc();
                    if (!(docID != Integer.MAX_VALUE)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!(docsAndPositionsEnum.freq() == freq)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    for (int posUpto = 0; posUpto < freq; ++posUpto) {
                        int pos = docsAndPositionsEnum.nextPosition();
                        int startOffset = docsAndPositionsEnum.startOffset();
                        int endOffset = docsAndPositionsEnum.endOffset();
                        BytesRef payload = docsAndPositionsEnum.getPayload();
                        if (!(!hasPositions || pos >= 0)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.addPosition(pos, startOffset, endOffset, payload);
                    }
                }
                this.finishTerm();
            }
            if (!(termCount == numTerms)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.finishField();
        }
        if (!(fieldCount == numFields)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.finishDocument();
    }

    @Override
    public abstract void close();

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0007H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/codecs/TermVectorsWriter$TermVectorsMergeSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "reader", "Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "maxDoc", "", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/codecs/TermVectorsReader;I)V", "getReader", "()Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "docID", "getDocID", "()I", "setDocID", "(I)V", "nextDoc", "core"})
    private static final class TermVectorsMergeSub
    extends DocIDMerger.Sub {
        @Nullable
        private final TermVectorsReader reader;
        private final int maxDoc;
        private int docID;

        public TermVectorsMergeSub(@NotNull MergeState.DocMap docMap, @Nullable TermVectorsReader reader2, int maxDoc) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            super(docMap);
            this.reader = reader2;
            this.maxDoc = maxDoc;
            this.docID = -1;
        }

        @Nullable
        public final TermVectorsReader getReader() {
            return this.reader;
        }

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }

        @Override
        public int nextDoc() {
            int n = this.docID;
            this.docID = n + 1;
            return this.docID == this.maxDoc ? Integer.MAX_VALUE : this.docID;
        }
    }
}

