/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.compressing;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.compressing.Compressor;
import org.gnit.lucenekmp.codecs.compressing.Decompressor;
import org.gnit.lucenekmp.codecs.compressing.DeflateCompressor;
import org.gnit.lucenekmp.codecs.compressing.DeflateDecompressor;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.compress.LZ4;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \n2\u00020\u0001:\u0003\b\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "", "<init>", "()V", "newCompressor", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "newDecompressor", "Lorg/gnit/lucenekmp/codecs/compressing/Decompressor;", "LZ4FastCompressor", "LZ4HighCompressor", "Companion", "core"})
public abstract class CompressionMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CompressionMode FAST = new CompressionMode(){

        public Compressor newCompressor() {
            return new LZ4FastCompressor();
        }

        public Decompressor newDecompressor() {
            return CompressionMode.access$getLZ4_DECOMPRESSOR$cp();
        }

        public String toString() {
            return "FAST";
        }
    };
    @NotNull
    private static final CompressionMode HIGH_COMPRESSION = new CompressionMode(){

        public Compressor newCompressor() {
            return new DeflateCompressor(6);
        }

        public Decompressor newDecompressor() {
            return new DeflateDecompressor();
        }

        public String toString() {
            return "HIGH_COMPRESSION";
        }
    };
    @NotNull
    private static final CompressionMode FAST_DECOMPRESSION = new CompressionMode(){

        public Compressor newCompressor() {
            return new LZ4HighCompressor();
        }

        public Decompressor newDecompressor() {
            return CompressionMode.access$getLZ4_DECOMPRESSOR$cp();
        }

        public String toString() {
            return "FAST_DECOMPRESSION";
        }
    };
    @NotNull
    private static final Decompressor LZ4_DECOMPRESSOR = new Decompressor(){

        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            int decompressedLength;
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            if (!(offset + length <= originalLength)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (bytes.getBytes().length < originalLength + 7) {
                bytes.setBytes(new byte[ArrayUtil.Companion.oversize(originalLength + 7, 1)]);
            }
            if ((decompressedLength = LZ4.INSTANCE.decompress(in, offset + length, bytes.getBytes(), 0)) > originalLength) {
                throw new CorruptIndexException("Corrupted: lengths mismatch: " + decompressedLength + " > " + originalLength, in);
            }
            bytes.setOffset(offset);
            bytes.setLength(length);
        }

        public Decompressor clone() {
            return this;
        }
    };

    protected CompressionMode() {
    }

    @NotNull
    public abstract Compressor newCompressor();

    @NotNull
    public abstract Decompressor newDecompressor();

    public static final /* synthetic */ Decompressor access$getLZ4_DECOMPRESSOR$cp() {
        return LZ4_DECOMPRESSOR;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode$Companion;", "", "<init>", "()V", "FAST", "Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "getFAST", "()Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "HIGH_COMPRESSION", "getHIGH_COMPRESSION", "FAST_DECOMPRESSION", "getFAST_DECOMPRESSION", "LZ4_DECOMPRESSOR", "Lorg/gnit/lucenekmp/codecs/compressing/Decompressor;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompressionMode getFAST() {
            return FAST;
        }

        @NotNull
        public final CompressionMode getHIGH_COMPRESSION() {
            return HIGH_COMPRESSION;
        }

        @NotNull
        public final CompressionMode getFAST_DECOMPRESSION() {
            return FAST_DECOMPRESSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode$LZ4FastCompressor;", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "<init>", "()V", "ht", "Lorg/gnit/lucenekmp/util/compress/LZ4$FastCompressionHashTable;", "compress", "", "buffersInput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "close", "core"})
    private static final class LZ4FastCompressor
    extends Compressor {
        @NotNull
        private final LZ4.FastCompressionHashTable ht = new LZ4.FastCompressionHashTable();

        @Override
        public void compress(@NotNull ByteBuffersDataInput buffersInput, @NotNull DataOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffersInput, (String)"buffersInput");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int len = (int)buffersInput.length();
            byte[] bytes = new byte[len];
            buffersInput.readBytes(bytes, 0, len);
            LZ4.INSTANCE.compress(bytes, 0, len, out, this.ht);
        }

        @Override
        public void close() throws IOException {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode$LZ4HighCompressor;", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "<init>", "()V", "ht", "Lorg/gnit/lucenekmp/util/compress/LZ4$HighCompressionHashTable;", "compress", "", "buffersInput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "close", "core"})
    private static final class LZ4HighCompressor
    extends Compressor {
        @NotNull
        private final LZ4.HighCompressionHashTable ht = new LZ4.HighCompressionHashTable();

        @Override
        public void compress(@NotNull ByteBuffersDataInput buffersInput, @NotNull DataOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffersInput, (String)"buffersInput");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int len = (int)buffersInput.length();
            byte[] bytes = new byte[len];
            buffersInput.readBytes(bytes, 0, len);
            LZ4.INSTANCE.compress(bytes, 0, len, out, this.ht);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

