/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.compressing;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.compressing.Decompressor;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0001H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/codecs/compressing/DeflateDecompressor;", "Lorg/gnit/lucenekmp/codecs/compressing/Decompressor;", "<init>", "()V", "compressed", "", "getCompressed", "()[B", "setCompressed", "([B)V", "decompress", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "originalLength", "", "offset", "length", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "clone", "core"})
public final class DeflateDecompressor
extends Decompressor {
    @NotNull
    private byte[] compressed = new byte[0];

    @NotNull
    public final byte[] getCompressed() {
        return this.compressed;
    }

    public final void setCompressed(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.compressed = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(@NotNull DataInput in, int originalLength, int offset, int length, @NotNull BytesRef bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (!(offset + length <= originalLength)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (length == 0) {
            bytes.setLength(0);
            return;
        }
        int compressedLength = in.readVInt();
        int paddedLength = compressedLength + 1;
        this.compressed = ArrayUtil.Companion.growNoCopy(this.compressed, paddedLength);
        in.readBytes(this.compressed, 0, compressedLength);
        this.compressed[compressedLength] = 0;
        Inflater decompressor = new Inflater(true);
        try {
            decompressor.setInput(this.compressed, 0, paddedLength);
            bytes.setLength(0);
            bytes.setOffset(bytes.getLength());
            bytes.setBytes(ArrayUtil.Companion.growNoCopy(bytes.getBytes(), originalLength));
            try {
                bytes.setLength(decompressor.inflate(bytes.getBytes(), bytes.getLength(), originalLength));
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            if (!decompressor.finished()) {
                throw new CorruptIndexException("Invalid decoder state: needsInput=" + decompressor.needsInput() + ", needsDict=" + decompressor.needsDictionary(), in);
            }
        }
        finally {
            decompressor.end();
        }
        if (bytes.getLength() != originalLength) {
            throw new CorruptIndexException("Lengths mismatch: " + bytes.getLength() + " != " + originalLength, in);
        }
        bytes.setOffset(offset);
        bytes.setLength(length);
    }

    @Override
    @NotNull
    public Decompressor clone() {
        return new DeflateDecompressor();
    }
}

