/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene101;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.lucene101.ForUtil;
import org.gnit.lucenekmp.internal.vectorization.PostingDecodingUtil;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/ForDeltaUtil;", "", "<init>", "()V", "tmp", "", "bitsRequired", "", "ints", "encodeDeltas", "", "bitsPerValue", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "decodeAndPrefixSum", "pdu", "Lorg/gnit/lucenekmp/internal/vectorization/PostingDecodingUtil;", "base", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nForDeltaUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForDeltaUtil.kt\norg/gnit/lucenekmp/codecs/lucene101/ForDeltaUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,553:1\n1#2:554\n*E\n"})
public final class ForDeltaUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] tmp = new int[128];
    private static final int HALF_BLOCK_SIZE = 64;
    private static final int ONE_BLOCK_SIZE_FOURTH = 32;
    private static final int TWO_BLOCK_SIZE_FOURTHS = 64;
    private static final int THREE_BLOCK_SIZE_FOURTHS = 96;

    public final int bitsRequired(@NotNull int[] ints) {
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        int or = 0;
        for (int l : ints) {
            or |= l;
        }
        if (!(or != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return PackedInts.INSTANCE.bitsRequired(or);
    }

    public final void encodeDeltas(int bitsPerValue, @NotNull int[] ints, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int primitiveSize = 0;
        if (bitsPerValue <= 3) {
            primitiveSize = 8;
            ForUtil.Companion.collapse8(ints);
        } else if (bitsPerValue <= 10) {
            primitiveSize = 16;
            ForUtil.Companion.collapse16(ints);
        } else {
            primitiveSize = 32;
        }
        ForUtil.Companion.encode(ints, bitsPerValue, primitiveSize, out, this.tmp);
    }

    public final void decodeAndPrefixSum(int bitsPerValue, @NotNull PostingDecodingUtil pdu, int base, @NotNull int[] ints) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        switch (bitsPerValue) {
            case 1: {
                ForUtil.Companion.decode1(pdu, ints);
                ForDeltaUtil.Companion.prefixSum8(ints, base);
                break;
            }
            case 2: {
                ForUtil.Companion.decode2(pdu, ints);
                ForDeltaUtil.Companion.prefixSum8(ints, base);
                break;
            }
            case 3: {
                ForUtil.Companion.decode3(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum8(ints, base);
                break;
            }
            case 4: {
                ForDeltaUtil.Companion.decode4To16(pdu, ints);
                ForDeltaUtil.Companion.prefixSum16(ints, base);
                break;
            }
            case 5: {
                ForDeltaUtil.Companion.decode5To16(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum16(ints, base);
                break;
            }
            case 6: {
                ForDeltaUtil.Companion.decode6To16(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum16(ints, base);
                break;
            }
            case 7: {
                ForDeltaUtil.Companion.decode7To16(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum16(ints, base);
                break;
            }
            case 8: {
                ForDeltaUtil.Companion.decode8To16(pdu, ints);
                ForDeltaUtil.Companion.prefixSum16(ints, base);
                break;
            }
            case 9: {
                ForUtil.Companion.decode9(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum16(ints, base);
                break;
            }
            case 10: {
                ForUtil.Companion.decode10(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum16(ints, base);
                break;
            }
            case 11: {
                ForDeltaUtil.Companion.decode11To32(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum32(ints, base);
                break;
            }
            case 12: {
                ForDeltaUtil.Companion.decode12To32(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum32(ints, base);
                break;
            }
            case 13: {
                ForDeltaUtil.Companion.decode13To32(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum32(ints, base);
                break;
            }
            case 14: {
                ForDeltaUtil.Companion.decode14To32(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum32(ints, base);
                break;
            }
            case 15: {
                ForDeltaUtil.Companion.decode15To32(pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum32(ints, base);
                break;
            }
            case 16: {
                ForDeltaUtil.Companion.decode16To32(pdu, ints);
                ForDeltaUtil.Companion.prefixSum32(ints, base);
                break;
            }
            default: {
                if (!(bitsPerValue >= 1 && bitsPerValue <= 32)) {
                    boolean bl = false;
                    String string = "Illegal number of bits per value: " + bitsPerValue;
                    throw new IllegalStateException(string.toString());
                }
                ForUtil.Companion.decodeSlow(bitsPerValue, pdu, this.tmp, ints);
                ForDeltaUtil.Companion.prefixSum32(ints, base);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u001c\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u001d\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u001e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/ForDeltaUtil$Companion;", "", "<init>", "()V", "HALF_BLOCK_SIZE", "", "ONE_BLOCK_SIZE_FOURTH", "TWO_BLOCK_SIZE_FOURTHS", "THREE_BLOCK_SIZE_FOURTHS", "prefixSum8", "", "arr", "", "base", "prefixSum16", "prefixSum32", "innerPrefixSum8", "innerPrefixSum16", "decode4To16", "pdu", "Lorg/gnit/lucenekmp/internal/vectorization/PostingDecodingUtil;", "ints", "decode5To16", "tmp", "decode6To16", "decode7To16", "decode8To16", "decode11To32", "decode12To32", "decode13To32", "decode14To32", "decode15To32", "decode16To32", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void prefixSum8(int[] arr, int base) {
            this.innerPrefixSum8(arr);
            ForUtil.Companion.expand8(arr);
            int l0 = base;
            int l1 = l0 + arr[31];
            int l2 = l1 + arr[63];
            int l3 = l2 + arr[95];
            for (int i = 0; i < 32; ++i) {
                int n = i;
                arr[n] = arr[n] + l0;
                n = 32 + i;
                arr[n] = arr[n] + l1;
                n = 64 + i;
                arr[n] = arr[n] + l2;
                n = 96 + i;
                arr[n] = arr[n] + l3;
            }
        }

        private final void prefixSum16(int[] arr, int base) {
            this.innerPrefixSum16(arr);
            ForUtil.Companion.expand16(arr);
            int l0 = base;
            int l1 = base + arr[63];
            for (int i = 0; i < 64; ++i) {
                int n = i;
                arr[n] = arr[n] + l0;
                n = 64 + i;
                arr[n] = arr[n] + l1;
            }
        }

        private final void prefixSum32(int[] arr, int base) {
            arr[0] = arr[0] + base;
            for (int i = 1; i < 128; ++i) {
                int n = i;
                arr[n] = arr[n] + arr[i - 1];
            }
        }

        private final void innerPrefixSum8(int[] arr) {
            arr[1] = arr[1] + arr[0];
            arr[2] = arr[2] + arr[1];
            arr[3] = arr[3] + arr[2];
            arr[4] = arr[4] + arr[3];
            arr[5] = arr[5] + arr[4];
            arr[6] = arr[6] + arr[5];
            arr[7] = arr[7] + arr[6];
            arr[8] = arr[8] + arr[7];
            arr[9] = arr[9] + arr[8];
            arr[10] = arr[10] + arr[9];
            arr[11] = arr[11] + arr[10];
            arr[12] = arr[12] + arr[11];
            arr[13] = arr[13] + arr[12];
            arr[14] = arr[14] + arr[13];
            arr[15] = arr[15] + arr[14];
            arr[16] = arr[16] + arr[15];
            arr[17] = arr[17] + arr[16];
            arr[18] = arr[18] + arr[17];
            arr[19] = arr[19] + arr[18];
            arr[20] = arr[20] + arr[19];
            arr[21] = arr[21] + arr[20];
            arr[22] = arr[22] + arr[21];
            arr[23] = arr[23] + arr[22];
            arr[24] = arr[24] + arr[23];
            arr[25] = arr[25] + arr[24];
            arr[26] = arr[26] + arr[25];
            arr[27] = arr[27] + arr[26];
            arr[28] = arr[28] + arr[27];
            arr[29] = arr[29] + arr[28];
            arr[30] = arr[30] + arr[29];
            arr[31] = arr[31] + arr[30];
        }

        private final void innerPrefixSum16(int[] arr) {
            arr[1] = arr[1] + arr[0];
            arr[2] = arr[2] + arr[1];
            arr[3] = arr[3] + arr[2];
            arr[4] = arr[4] + arr[3];
            arr[5] = arr[5] + arr[4];
            arr[6] = arr[6] + arr[5];
            arr[7] = arr[7] + arr[6];
            arr[8] = arr[8] + arr[7];
            arr[9] = arr[9] + arr[8];
            arr[10] = arr[10] + arr[9];
            arr[11] = arr[11] + arr[10];
            arr[12] = arr[12] + arr[11];
            arr[13] = arr[13] + arr[12];
            arr[14] = arr[14] + arr[13];
            arr[15] = arr[15] + arr[14];
            arr[16] = arr[16] + arr[15];
            arr[17] = arr[17] + arr[16];
            arr[18] = arr[18] + arr[17];
            arr[19] = arr[19] + arr[18];
            arr[20] = arr[20] + arr[19];
            arr[21] = arr[21] + arr[20];
            arr[22] = arr[22] + arr[21];
            arr[23] = arr[23] + arr[22];
            arr[24] = arr[24] + arr[23];
            arr[25] = arr[25] + arr[24];
            arr[26] = arr[26] + arr[25];
            arr[27] = arr[27] + arr[26];
            arr[28] = arr[28] + arr[27];
            arr[29] = arr[29] + arr[28];
            arr[30] = arr[30] + arr[29];
            arr[31] = arr[31] + arr[30];
            arr[32] = arr[32] + arr[31];
            arr[33] = arr[33] + arr[32];
            arr[34] = arr[34] + arr[33];
            arr[35] = arr[35] + arr[34];
            arr[36] = arr[36] + arr[35];
            arr[37] = arr[37] + arr[36];
            arr[38] = arr[38] + arr[37];
            arr[39] = arr[39] + arr[38];
            arr[40] = arr[40] + arr[39];
            arr[41] = arr[41] + arr[40];
            arr[42] = arr[42] + arr[41];
            arr[43] = arr[43] + arr[42];
            arr[44] = arr[44] + arr[43];
            arr[45] = arr[45] + arr[44];
            arr[46] = arr[46] + arr[45];
            arr[47] = arr[47] + arr[46];
            arr[48] = arr[48] + arr[47];
            arr[49] = arr[49] + arr[48];
            arr[50] = arr[50] + arr[49];
            arr[51] = arr[51] + arr[50];
            arr[52] = arr[52] + arr[51];
            arr[53] = arr[53] + arr[52];
            arr[54] = arr[54] + arr[53];
            arr[55] = arr[55] + arr[54];
            arr[56] = arr[56] + arr[55];
            arr[57] = arr[57] + arr[56];
            arr[58] = arr[58] + arr[57];
            arr[59] = arr[59] + arr[58];
            arr[60] = arr[60] + arr[59];
            arr[61] = arr[61] + arr[60];
            arr[62] = arr[62] + arr[61];
            arr[63] = arr[63] + arr[62];
        }

        private final void decode4To16(PostingDecodingUtil pdu, int[] ints) throws IOException {
            pdu.splitInts(16, ints, 12, 4, ForUtil.Companion.getMASK16_4(), ints, 48, ForUtil.Companion.getMASK16_4());
        }

        private final void decode5To16(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
            pdu.splitInts(20, ints, 11, 5, ForUtil.Companion.getMASK16_5(), tmp, 0, ForUtil.Companion.getMASK16_1());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 60;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 4;
                l0 |= tmp[tmpIdx + 1] << 3;
                l0 |= tmp[tmpIdx + 2] << 2;
                l0 |= tmp[tmpIdx + 3] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 4] << 0;
                ++iter;
                tmpIdx += 5;
                ++intsIdx;
            }
        }

        private final void decode6To16(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
            pdu.splitInts(24, ints, 10, 6, ForUtil.Companion.getMASK16_6(), tmp, 0, ForUtil.Companion.getMASK16_4());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 48;
            while (iter < 8) {
                int l0 = tmp[tmpIdx + 0] << 2;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 2 & ForUtil.Companion.getMASK16_2();
                int l1 = (tmp[tmpIdx + 1] & ForUtil.Companion.getMASK16_2()) << 4;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
                ++iter;
                tmpIdx += 3;
                intsIdx += 2;
            }
        }

        private final void decode7To16(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
            pdu.splitInts(28, ints, 9, 7, ForUtil.Companion.getMASK16_7(), tmp, 0, ForUtil.Companion.getMASK16_2());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 56;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 5;
                l0 |= tmp[tmpIdx + 1] << 3;
                l0 |= tmp[tmpIdx + 2] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 3] >>> 1 & ForUtil.Companion.getMASK16_1();
                int l1 = (tmp[tmpIdx + 3] & ForUtil.Companion.getMASK16_1()) << 6;
                l1 |= tmp[tmpIdx + 4] << 4;
                l1 |= tmp[tmpIdx + 5] << 2;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 6] << 0;
                ++iter;
                tmpIdx += 7;
                intsIdx += 2;
            }
        }

        private final void decode8To16(PostingDecodingUtil pdu, int[] ints) throws IOException {
            pdu.splitInts(32, ints, 8, 8, ForUtil.Companion.getMASK16_8(), ints, 32, ForUtil.Companion.getMASK16_8());
        }

        private final void decode11To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
            pdu.splitInts(44, ints, 21, 11, ForUtil.Companion.getMASK32_11(), tmp, 0, ForUtil.Companion.getMASK32_10());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 88;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 9 & ForUtil.Companion.getMASK32_1();
                int l1 = (tmp[tmpIdx + 1] & ForUtil.Companion.getMASK32_9()) << 2;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 8 & ForUtil.Companion.getMASK32_2();
                int l2 = (tmp[tmpIdx + 2] & ForUtil.Companion.getMASK32_8()) << 3;
                ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 7 & ForUtil.Companion.getMASK32_3();
                int l3 = (tmp[tmpIdx + 3] & ForUtil.Companion.getMASK32_7()) << 4;
                ints[intsIdx + 3] = l3 |= tmp[tmpIdx + 4] >>> 6 & ForUtil.Companion.getMASK32_4();
                int l4 = (tmp[tmpIdx + 4] & ForUtil.Companion.getMASK32_6()) << 5;
                ints[intsIdx + 4] = l4 |= tmp[tmpIdx + 5] >>> 5 & ForUtil.Companion.getMASK32_5();
                int l5 = (tmp[tmpIdx + 5] & ForUtil.Companion.getMASK32_5()) << 6;
                ints[intsIdx + 5] = l5 |= tmp[tmpIdx + 6] >>> 4 & ForUtil.Companion.getMASK32_6();
                int l6 = (tmp[tmpIdx + 6] & ForUtil.Companion.getMASK32_4()) << 7;
                ints[intsIdx + 6] = l6 |= tmp[tmpIdx + 7] >>> 3 & ForUtil.Companion.getMASK32_7();
                int l7 = (tmp[tmpIdx + 7] & ForUtil.Companion.getMASK32_3()) << 8;
                ints[intsIdx + 7] = l7 |= tmp[tmpIdx + 8] >>> 2 & ForUtil.Companion.getMASK32_8();
                int l8 = (tmp[tmpIdx + 8] & ForUtil.Companion.getMASK32_2()) << 9;
                ints[intsIdx + 8] = l8 |= tmp[tmpIdx + 9] >>> 1 & ForUtil.Companion.getMASK32_9();
                int l9 = (tmp[tmpIdx + 9] & ForUtil.Companion.getMASK32_1()) << 10;
                ints[intsIdx + 9] = l9 |= tmp[tmpIdx + 10] << 0;
                ++iter;
                tmpIdx += 11;
                intsIdx += 10;
            }
        }

        private final void decode12To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
            pdu.splitInts(48, ints, 20, 12, ForUtil.Companion.getMASK32_12(), tmp, 0, ForUtil.Companion.getMASK32_8());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 96;
            while (iter < 16) {
                int l0 = tmp[tmpIdx + 0] << 4;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 4 & ForUtil.Companion.getMASK32_4();
                int l1 = (tmp[tmpIdx + 1] & ForUtil.Companion.getMASK32_4()) << 8;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
                ++iter;
                tmpIdx += 3;
                intsIdx += 2;
            }
        }

        private final void decode13To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
            pdu.splitInts(52, ints, 19, 13, ForUtil.Companion.getMASK32_13(), tmp, 0, ForUtil.Companion.getMASK32_6());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 104;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 7;
                l0 |= tmp[tmpIdx + 1] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 5 & ForUtil.Companion.getMASK32_1();
                int l1 = (tmp[tmpIdx + 2] & ForUtil.Companion.getMASK32_5()) << 8;
                l1 |= tmp[tmpIdx + 3] << 2;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 4 & ForUtil.Companion.getMASK32_2();
                int l2 = (tmp[tmpIdx + 4] & ForUtil.Companion.getMASK32_4()) << 9;
                l2 |= tmp[tmpIdx + 5] << 3;
                ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 3 & ForUtil.Companion.getMASK32_3();
                int l3 = (tmp[tmpIdx + 6] & ForUtil.Companion.getMASK32_3()) << 10;
                l3 |= tmp[tmpIdx + 7] << 4;
                ints[intsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 2 & ForUtil.Companion.getMASK32_4();
                int l4 = (tmp[tmpIdx + 8] & ForUtil.Companion.getMASK32_2()) << 11;
                l4 |= tmp[tmpIdx + 9] << 5;
                ints[intsIdx + 4] = l4 |= tmp[tmpIdx + 10] >>> 1 & ForUtil.Companion.getMASK32_5();
                int l5 = (tmp[tmpIdx + 10] & ForUtil.Companion.getMASK32_1()) << 12;
                l5 |= tmp[tmpIdx + 11] << 6;
                ints[intsIdx + 5] = l5 |= tmp[tmpIdx + 12] << 0;
                ++iter;
                tmpIdx += 13;
                intsIdx += 6;
            }
        }

        private final void decode14To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
            pdu.splitInts(56, ints, 18, 14, ForUtil.Companion.getMASK32_14(), tmp, 0, ForUtil.Companion.getMASK32_4());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 112;
            while (iter < 8) {
                int l0 = tmp[tmpIdx + 0] << 10;
                l0 |= tmp[tmpIdx + 1] << 6;
                l0 |= tmp[tmpIdx + 2] << 2;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 3] >>> 2 & ForUtil.Companion.getMASK32_2();
                int l1 = (tmp[tmpIdx + 3] & ForUtil.Companion.getMASK32_2()) << 12;
                l1 |= tmp[tmpIdx + 4] << 8;
                l1 |= tmp[tmpIdx + 5] << 4;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 6] << 0;
                ++iter;
                tmpIdx += 7;
                intsIdx += 2;
            }
        }

        private final void decode15To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
            pdu.splitInts(60, ints, 17, 15, ForUtil.Companion.getMASK32_15(), tmp, 0, ForUtil.Companion.getMASK32_2());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 120;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 13;
                l0 |= tmp[tmpIdx + 1] << 11;
                l0 |= tmp[tmpIdx + 2] << 9;
                l0 |= tmp[tmpIdx + 3] << 7;
                l0 |= tmp[tmpIdx + 4] << 5;
                l0 |= tmp[tmpIdx + 5] << 3;
                l0 |= tmp[tmpIdx + 6] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 7] >>> 1 & ForUtil.Companion.getMASK32_1();
                int l1 = (tmp[tmpIdx + 7] & ForUtil.Companion.getMASK32_1()) << 14;
                l1 |= tmp[tmpIdx + 8] << 12;
                l1 |= tmp[tmpIdx + 9] << 10;
                l1 |= tmp[tmpIdx + 10] << 8;
                l1 |= tmp[tmpIdx + 11] << 6;
                l1 |= tmp[tmpIdx + 12] << 4;
                l1 |= tmp[tmpIdx + 13] << 2;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 14] << 0;
                ++iter;
                tmpIdx += 15;
                intsIdx += 2;
            }
        }

        private final void decode16To32(PostingDecodingUtil pdu, int[] ints) throws IOException {
            pdu.splitInts(64, ints, 16, 16, ForUtil.Companion.getMASK32_16(), ints, 64, ForUtil.Companion.getMASK32_16());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

