/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene101;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.codecs.BlockTermState;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.PostingsReaderBase;
import org.gnit.lucenekmp.codecs.lucene101.ForDeltaUtil;
import org.gnit.lucenekmp.codecs.lucene101.Lucene101PostingsFormat;
import org.gnit.lucenekmp.codecs.lucene101.PForUtil;
import org.gnit.lucenekmp.codecs.lucene101.PostingsUtil;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.Impact;
import org.gnit.lucenekmp.index.Impacts;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.internal.vectorization.PostingDecodingUtil;
import org.gnit.lucenekmp.internal.vectorization.VectorizationProvider;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.store.ByteArrayDataInput;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.VectorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0004'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J(\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J*\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\u000bH\u0016J \u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u000bH\u0016J\b\u0010$\u001a\u00020\u0010H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader;", "Lorg/gnit/lucenekmp/codecs/PostingsReaderBase;", "state", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentReadState;)V", "docIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "posIn", "payIn", "maxNumImpactsAtLevel0", "", "maxImpactNumBytesAtLevel0", "maxNumImpactsAtLevel1", "maxImpactNumBytesAtLevel1", "init", "", "termsIn", "newTermState", "Lorg/gnit/lucenekmp/codecs/BlockTermState;", "close", "decodeTerm", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "_termState", "absolute", "", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "termState", "reuse", "flags", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "checkIntegrity", "toString", "", "DeltaEncoding", "BlockPostingsEnum", "MutableImpactList", "Companion", "core"})
public final class Lucene101PostingsReader
extends PostingsReaderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private IndexInput docIn;
    @Nullable
    private IndexInput posIn;
    @Nullable
    private IndexInput payIn;
    private int maxNumImpactsAtLevel0;
    private int maxImpactNumBytesAtLevel0;
    private int maxNumImpactsAtLevel1;
    private int maxImpactNumBytesAtLevel1;
    @NotNull
    private static final VectorizationProvider VECTORIZATION_PROVIDER = VectorizationProvider.Companion.getInstance();
    @NotNull
    private static final List<Impact> DUMMY_IMPACTS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene101PostingsReader(@NotNull SegmentReadState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        String metaName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "psm");
        long expectedDocFileLength = 0L;
        long expectedPosFileLength = 0L;
        long expectedPayFileLength = 0L;
        ChecksumIndexInput metaIn = null;
        boolean success = false;
        int version = 0;
        try {
            metaIn = state2.getDirectory().openChecksumInput(metaName);
            version = CodecUtil.INSTANCE.checkIndexHeader(metaIn, "Lucene101PostingsWriterMeta", 0, 1, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            this.maxNumImpactsAtLevel0 = metaIn.readInt();
            this.maxImpactNumBytesAtLevel0 = metaIn.readInt();
            this.maxNumImpactsAtLevel1 = metaIn.readInt();
            this.maxImpactNumBytesAtLevel1 = metaIn.readInt();
            expectedDocFileLength = metaIn.readLong();
            if (state2.getFieldInfos().hasProx()) {
                expectedPosFileLength = metaIn.readLong();
                expectedPayFileLength = state2.getFieldInfos().hasPayloads() || state2.getFieldInfos().hasOffsets() ? metaIn.readLong() : -1L;
            } else {
                expectedPosFileLength = -1L;
                expectedPayFileLength = -1L;
            }
            CodecUtil.INSTANCE.checkFooter(metaIn, null);
            success = true;
        }
        catch (Throwable t2) {
            try {
                if (metaIn != null) {
                    CodecUtil.INSTANCE.checkFooter(metaIn, t2);
                    throw new AssertionError((Object)"unreachable");
                }
                throw t2;
            }
            catch (Throwable t2) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
                Intrinsics.checkNotNull((Object)metaIn);
                IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
                throw t2;
            }
        }
        ChecksumIndexInput checksumIndexInput = metaIn;
        Intrinsics.checkNotNull((Object)checksumIndexInput);
        checksumIndexInput.close();
        success = false;
        IndexInput docIn = null;
        IndexInput posIn = null;
        IndexInput payIn = null;
        String docName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "doc");
        try {
            docIn = state2.getDirectory().openInput(docName, state2.getContext().withReadAdvice(ReadAdvice.NORMAL));
            CodecUtil.INSTANCE.checkIndexHeader(docIn, "Lucene101PostingsWriterDoc", version, version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            CodecUtil.INSTANCE.retrieveChecksum(docIn, expectedDocFileLength);
            if (state2.getFieldInfos().hasProx()) {
                String proxName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "pos");
                posIn = state2.getDirectory().openInput(proxName, state2.getContext());
                CodecUtil.INSTANCE.checkIndexHeader(posIn, "Lucene101PostingsWriterPos", version, version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
                CodecUtil.INSTANCE.retrieveChecksum(posIn, expectedPosFileLength);
                if (state2.getFieldInfos().hasPayloads() || state2.getFieldInfos().hasOffsets()) {
                    String payName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "pay");
                    payIn = state2.getDirectory().openInput(payName, state2.getContext());
                    CodecUtil.INSTANCE.checkIndexHeader(payIn, "Lucene101PostingsWriterPay", version, version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
                    CodecUtil.INSTANCE.retrieveChecksum(payIn, expectedPayFileLength);
                }
            }
            this.docIn = docIn;
            this.posIn = posIn;
            this.payIn = payIn;
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
            Intrinsics.checkNotNull((Object)docIn);
            autoCloseableArray[1] = posIn;
            Intrinsics.checkNotNull(payIn);
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            throw throwable;
        }
    }

    @Override
    public void init(@NotNull IndexInput termsIn, @NotNull SegmentReadState state2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)termsIn, (String)"termsIn");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        CodecUtil.INSTANCE.checkIndexHeader(termsIn, "Lucene90PostingsWriterTerms", 0, 1, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
        int indexBlockSize = termsIn.readVInt();
        if (!(indexBlockSize == 128)) {
            boolean bl = false;
            String string = "index-time BLOCK_SIZE (" + indexBlockSize + ") != read-time BLOCK_SIZE (128)";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public BlockTermState newTermState() {
        return new Lucene101PostingsFormat.IntBlockTermState();
    }

    @Override
    public void close() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.docIn, this.posIn, this.payIn};
        IOUtils.INSTANCE.closeNullable(autoCloseableArray);
    }

    @Override
    public void decodeTerm(@NotNull DataInput in, @NotNull FieldInfo fieldInfo, @NotNull BlockTermState _termState, boolean absolute) throws IOException {
        long l;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)_termState, (String)"_termState");
        Lucene101PostingsFormat.IntBlockTermState termState2 = (Lucene101PostingsFormat.IntBlockTermState)_termState;
        if (absolute) {
            termState2.setDocStartFP(0L);
            termState2.setPosStartFP(0L);
            termState2.setPayStartFP(0L);
        }
        if (((l = in.readVLong()) & 1L) == 0L) {
            termState2.setDocStartFP(termState2.getDocStartFP() + (l >>> 1));
            if (termState2.getDocFreq() == 1) {
                termState2.setSingletonDocID(in.readVInt());
            } else {
                termState2.setSingletonDocID(-1);
            }
        } else {
            if (!(!absolute)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(termState2.getSingletonDocID() != -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            termState2.setSingletonDocID(termState2.getSingletonDocID() + (int)BitUtil.INSTANCE.zigZagDecode(l >>> 1));
        }
        if (fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            termState2.setPosStartFP(termState2.getPosStartFP() + in.readVLong());
            if (fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 || fieldInfo.hasPayloads()) {
                termState2.setPayStartFP(termState2.getPayStartFP() + in.readVLong());
            }
            if (termState2.getTotalTermFreq() > 128L) {
                termState2.setLastPosBlockOffset(in.readVLong());
            } else {
                termState2.setLastPosBlockOffset(-1L);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PostingsEnum postings(@NotNull FieldInfo fieldInfo, @NotNull BlockTermState termState2, @Nullable PostingsEnum reuse, int flags) throws IOException {
        BlockPostingsEnum blockPostingsEnum;
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)termState2, (String)"termState");
        if (reuse instanceof BlockPostingsEnum) {
            BlockPostingsEnum blockPostingsEnum2 = (BlockPostingsEnum)reuse;
            IndexInput indexInput = this.docIn;
            Intrinsics.checkNotNull((Object)indexInput);
            if (blockPostingsEnum2.canReuse(indexInput, fieldInfo, flags, false)) {
                blockPostingsEnum = (BlockPostingsEnum)reuse;
                return blockPostingsEnum.reset((Lucene101PostingsFormat.IntBlockTermState)termState2, flags);
            }
        }
        blockPostingsEnum = new BlockPostingsEnum(fieldInfo, flags, false);
        return blockPostingsEnum.reset((Lucene101PostingsFormat.IntBlockTermState)termState2, flags);
    }

    @Override
    @NotNull
    public ImpactsEnum impacts(@NotNull FieldInfo fieldInfo, @NotNull BlockTermState state2, int flags) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return new BlockPostingsEnum(fieldInfo, flags, true).reset((Lucene101PostingsFormat.IntBlockTermState)state2, flags);
    }

    @Override
    public void checkIntegrity() throws IOException {
        if (this.docIn != null) {
            IndexInput indexInput = this.docIn;
            Intrinsics.checkNotNull((Object)indexInput);
            CodecUtil.INSTANCE.checksumEntireFile(indexInput);
        }
        if (this.posIn != null) {
            IndexInput indexInput = this.posIn;
            Intrinsics.checkNotNull((Object)indexInput);
            CodecUtil.INSTANCE.checksumEntireFile(indexInput);
        }
        if (this.payIn != null) {
            IndexInput indexInput = this.payIn;
            Intrinsics.checkNotNull((Object)indexInput);
            CodecUtil.INSTANCE.checksumEntireFile(indexInput);
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(positions=" + (this.posIn != null) + ",payloads=" + (this.payIn != null) + ")";
    }

    public static final /* synthetic */ List access$getDUMMY_IMPACTS$cp() {
        return DUMMY_IMPACTS;
    }

    static {
        Object[] objectArray = new Impact[]{new Impact(Integer.MAX_VALUE, 1L)};
        DUMMY_IMPACTS = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010|\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001b\u0010}\u001a\u00060\u0000R\u00020~2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010\u0081\u0001\u001a\u00020\u0005H\u0016J\t\u0010\u0082\u0001\u001a\u00020\u0005H\u0016J\n\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\n\u0010\u0085\u0001\u001a\u00030\u0084\u0001H\u0002J\n\u0010\u0086\u0001\u001a\u00030\u0084\u0001H\u0002J\u0013\u0010\u0087\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0088\u0001\u001a\u00020\u0005H\u0002J\n\u0010\u0089\u0001\u001a\u00030\u0084\u0001H\u0002J\n\u0010\u008a\u0001\u001a\u00030\u0084\u0001H\u0002J\n\u0010\u008b\u0001\u001a\u00030\u0084\u0001H\u0002J.\u0010\u008c\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u008d\u0001\u001a\u00020\u001d2\u0007\u0010\u008e\u0001\u001a\u00020\u00052\u0007\u0010\u008f\u0001\u001a\u00020\u001d2\u0007\u0010\u0090\u0001\u001a\u00020\u0005H\u0002J\u0013\u0010\u0091\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0088\u0001\u001a\u00020\u0005H\u0002J\u0013\u0010\u0092\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0088\u0001\u001a\u00020\u0005H\u0016J\u0013\u0010\u0093\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0088\u0001\u001a\u00020\u0005H\u0002J\t\u0010\u0094\u0001\u001a\u00020\u0005H\u0016J\u0012\u0010\u0095\u0001\u001a\u00020\u00052\u0007\u0010\u0088\u0001\u001a\u00020\u0005H\u0016J%\u0010\u0096\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u00052\u0007\u0010\u0098\u0001\u001a\u00020\u00182\u0007\u0010\u0099\u0001\u001a\u00020\u0005H\u0016J\u0012\u0010\u009a\u0001\u001a\u00020\u00052\u0007\u0010\u0097\u0001\u001a\u00020\u0005H\u0002J.\u0010\u009b\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u009c\u0001\u001a\u00020\u00052\u0007\u0010\u009d\u0001\u001a\u00020\u00052\u0007\u0010\u0098\u0001\u001a\u00020\u00182\u0007\u0010\u0099\u0001\u001a\u00020\u0005H\u0002J\u0013\u0010\u009e\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0082\u0001\u001a\u00020\u0005H\u0002J\n\u0010\u009f\u0001\u001a\u00030\u0084\u0001H\u0002J\n\u0010\u00a0\u0001\u001a\u00030\u0084\u0001H\u0002J\n\u0010\u00a1\u0001\u001a\u00030\u0084\u0001H\u0002J\n\u0010\u00a2\u0001\u001a\u00030\u0084\u0001H\u0002J\n\u0010\u00a3\u0001\u001a\u00030\u0084\u0001H\u0002J\t\u0010\u00a4\u0001\u001a\u00020\u0005H\u0016J\b\u00106\u001a\u00020\u0005H\u0016J\b\u00107\u001a\u00020\u0005H\u0016J\t\u0010\u00a5\u0001\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00109\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001c\u0010C\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010;\"\u0004\bE\u0010=R\u001c\u0010F\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010@\"\u0004\bH\u0010BR\u001e\u0010I\u001a\u0004\u0018\u00010J8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0011\u0010O\u001a\u00020P\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u0011\u0010S\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\rR\u0011\u0010U\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\rR\u0011\u0010W\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\rR\u0011\u0010Y\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\rR\u0011\u0010[\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010\rR\u0011\u0010]\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\rR\u0011\u0010_\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010\rR\u0011\u0010a\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010\rR\u0011\u0010c\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010\rR\u0011\u0010e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010\rR\u0011\u0010g\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010\rR\u000e\u0010i\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010j\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010k\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010l\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010m\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010n\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010o\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010p\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010q\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010r\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010s\u001a\u0004\u0018\u00010tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010u\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010v\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010w\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010x\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010y\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010z\u001a\u0004\u0018\u00010tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010{\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u00a6\u0001\u001a\u00030\u00a7\u00018VX\u0096\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a8\u0001\u0010\u00a9\u0001\u00a8\u0006\u00aa\u0001"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader$BlockPostingsEnum;", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "flags", "", "needsImpacts", "", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader;Lorg/gnit/lucenekmp/index/FieldInfo;IZ)V", "getFlags", "()I", "getNeedsImpacts", "()Z", "forDeltaUtil", "Lorg/gnit/lucenekmp/codecs/lucene101/ForDeltaUtil;", "pforUtil", "Lorg/gnit/lucenekmp/codecs/lucene101/PForUtil;", "encoding", "Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader$DeltaEncoding;", "doc", "docBuffer", "", "docBitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "docBitSetBase", "docCumulativeWordPopCounts", "level0LastDocID", "level0DocEndFP", "", "level1LastDocID", "level1DocEndFP", "level1DocCountUpto", "docFreq", "totalTermFreq", "singletonDocID", "docCountLeft", "prevDocID", "docBufferSize", "docBufferUpto", "docIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "docInUtil", "Lorg/gnit/lucenekmp/internal/vectorization/PostingDecodingUtil;", "freqBuffer", "posDeltaBuffer", "payloadLengthBuffer", "offsetStartDeltaBuffer", "offsetLengthBuffer", "payloadBytes", "", "payloadByteUpto", "payloadLength", "lastStartOffset", "startOffset", "endOffset", "posBufferUpto", "posIn", "getPosIn", "()Lorg/gnit/lucenekmp/store/IndexInput;", "setPosIn", "(Lorg/gnit/lucenekmp/store/IndexInput;)V", "posInUtil", "getPosInUtil", "()Lorg/gnit/lucenekmp/internal/vectorization/PostingDecodingUtil;", "setPosInUtil", "(Lorg/gnit/lucenekmp/internal/vectorization/PostingDecodingUtil;)V", "payIn", "getPayIn", "setPayIn", "payInUtil", "getPayInUtil", "setPayInUtil", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setPayload", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "options", "Lorg/gnit/lucenekmp/index/IndexOptions;", "getOptions", "()Lorg/gnit/lucenekmp/index/IndexOptions;", "indexHasFreq", "getIndexHasFreq", "indexHasPos", "getIndexHasPos", "indexHasOffsets", "getIndexHasOffsets", "indexHasPayloads", "getIndexHasPayloads", "indexHasOffsetsOrPayloads", "getIndexHasOffsetsOrPayloads", "needsFreq", "getNeedsFreq", "needsPos", "getNeedsPos", "needsOffsets", "getNeedsOffsets", "needsPayloads", "getNeedsPayloads", "needsOffsetsOrPayloads", "getNeedsOffsetsOrPayloads", "needsDocsAndFreqsOnly", "getNeedsDocsAndFreqsOnly", "freqFP", "position", "posDocBufferUpto", "posPendingCount", "lastPosBlockFP", "level0PosEndFP", "level0BlockPosUpto", "level0PayEndFP", "level0BlockPayUpto", "level0SerializedImpacts", "level0Impacts", "Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader$MutableImpactList;", "level1PosEndFP", "level1BlockPosUpto", "level1PayEndFP", "level1BlockPayUpto", "level1SerializedImpacts", "level1Impacts", "needsRefilling", "canReuse", "reset", "Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader;", "termState", "Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$IntBlockTermState;", "docID", "freq", "refillFullBlock", "", "refillRemainder", "refillDocs", "skipLevel1To", "target", "doMoveToNextLevel0Block", "moveToNextLevel0Block", "readLevel0PosData", "seekPosData", "posFP", "posUpto", "payFP", "payUpto", "skipLevel0To", "advanceShallow", "doAdvanceShallow", "nextDoc", "advance", "intoBitSet", "upTo", "bitSet", "offset", "computeBufferEndBoundary", "bufferIntoBitSet", "start", "end", "skipPositions", "refillLastPositionBlock", "refillOffsetsOrPayloads", "refillPositions", "accumulatePendingPositions", "accumulatePayloadAndOffsets", "nextPosition", "cost", "impacts", "Lorg/gnit/lucenekmp/index/Impacts;", "getImpacts", "()Lorg/gnit/lucenekmp/index/Impacts;", "core"})
    public final class BlockPostingsEnum
    extends ImpactsEnum {
        private final int flags;
        private final boolean needsImpacts;
        @Nullable
        private ForDeltaUtil forDeltaUtil;
        @Nullable
        private PForUtil pforUtil;
        @Nullable
        private DeltaEncoding encoding;
        private int doc;
        @NotNull
        private final int[] docBuffer;
        @NotNull
        private final FixedBitSet docBitSet;
        private int docBitSetBase;
        @NotNull
        private final int[] docCumulativeWordPopCounts;
        private int level0LastDocID;
        private long level0DocEndFP;
        private int level1LastDocID;
        private long level1DocEndFP;
        private int level1DocCountUpto;
        private int docFreq;
        private long totalTermFreq;
        private int singletonDocID;
        private int docCountLeft;
        private int prevDocID;
        private int docBufferSize;
        private int docBufferUpto;
        @Nullable
        private IndexInput docIn;
        @Nullable
        private PostingDecodingUtil docInUtil;
        @NotNull
        private final int[] freqBuffer;
        @Nullable
        private final int[] posDeltaBuffer;
        @Nullable
        private final int[] payloadLengthBuffer;
        @Nullable
        private final int[] offsetStartDeltaBuffer;
        @Nullable
        private final int[] offsetLengthBuffer;
        @Nullable
        private byte[] payloadBytes;
        private int payloadByteUpto;
        private int payloadLength;
        private int lastStartOffset;
        private int startOffset;
        private int endOffset;
        private int posBufferUpto;
        @Nullable
        private IndexInput posIn;
        @Nullable
        private PostingDecodingUtil posInUtil;
        @Nullable
        private IndexInput payIn;
        @Nullable
        private PostingDecodingUtil payInUtil;
        @Nullable
        private BytesRef payload;
        @NotNull
        private final IndexOptions options;
        private final boolean indexHasFreq;
        private final boolean indexHasPos;
        private final boolean indexHasOffsets;
        private final boolean indexHasPayloads;
        private final boolean indexHasOffsetsOrPayloads;
        private final boolean needsFreq;
        private final boolean needsPos;
        private final boolean needsOffsets;
        private final boolean needsPayloads;
        private final boolean needsOffsetsOrPayloads;
        private final boolean needsDocsAndFreqsOnly;
        private long freqFP;
        private int position;
        private int posDocBufferUpto;
        private int posPendingCount;
        private long lastPosBlockFP;
        private long level0PosEndFP;
        private int level0BlockPosUpto;
        private long level0PayEndFP;
        private int level0BlockPayUpto;
        @Nullable
        private BytesRef level0SerializedImpacts;
        @Nullable
        private MutableImpactList level0Impacts;
        private long level1PosEndFP;
        private int level1BlockPosUpto;
        private long level1PayEndFP;
        private int level1BlockPayUpto;
        @Nullable
        private BytesRef level1SerializedImpacts;
        @Nullable
        private MutableImpactList level1Impacts;
        private boolean needsRefilling;
        @NotNull
        private final Impacts impacts;

        public BlockPostingsEnum(FieldInfo fieldInfo, int flags, boolean needsImpacts) {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            this.flags = flags;
            this.needsImpacts = needsImpacts;
            this.docBuffer = new int[128];
            this.docBitSet = new FixedBitSet(4096);
            this.docCumulativeWordPopCounts = this.docBuffer;
            this.freqBuffer = new int[128];
            this.options = fieldInfo.getIndexOptions();
            this.indexHasFreq = this.options.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = this.options.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsets = this.options.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.indexHasOffsetsOrPayloads = this.indexHasOffsets || this.indexHasPayloads;
            this.needsFreq = this.indexHasFreq && PostingsEnum.Companion.featureRequested(this.flags, PostingsEnum.Companion.getFREQS());
            this.needsPos = this.indexHasPos && PostingsEnum.Companion.featureRequested(this.flags, PostingsEnum.Companion.getPOSITIONS());
            this.needsOffsets = this.indexHasOffsets && PostingsEnum.Companion.featureRequested(this.flags, PostingsEnum.Companion.getOFFSETS());
            this.needsPayloads = this.indexHasPayloads && PostingsEnum.Companion.featureRequested(this.flags, PostingsEnum.Companion.getPAYLOADS());
            this.needsOffsetsOrPayloads = this.needsOffsets || this.needsPayloads;
            this.needsDocsAndFreqsOnly = !this.needsPos && !this.needsImpacts;
            this.impacts = new Impacts(this){
                private final ByteArrayDataInput scratch;
                final /* synthetic */ BlockPostingsEnum this$0;
                {
                    this.this$0 = $receiver;
                    this.scratch = new ByteArrayDataInput();
                }

                public int numLevels() {
                    return !this.this$0.getIndexHasFreq() || BlockPostingsEnum.access$getLevel1LastDocID$p(this.this$0) == Integer.MAX_VALUE ? 1 : 2;
                }

                public int getDocIdUpTo(int level) {
                    if (!this.this$0.getIndexHasFreq()) {
                        return Integer.MAX_VALUE;
                    }
                    if (level == 0) {
                        return BlockPostingsEnum.access$getLevel0LastDocID$p(this.this$0);
                    }
                    return level == 1 ? BlockPostingsEnum.access$getLevel1LastDocID$p(this.this$0) : Integer.MAX_VALUE;
                }

                public List<Impact> getImpacts(int level) {
                    if (this.this$0.getIndexHasFreq()) {
                        if (level == 0 && BlockPostingsEnum.access$getLevel0LastDocID$p(this.this$0) != Integer.MAX_VALUE) {
                            BytesRef bytesRef = BlockPostingsEnum.access$getLevel0SerializedImpacts$p(this.this$0);
                            Intrinsics.checkNotNull((Object)bytesRef);
                            MutableImpactList mutableImpactList = BlockPostingsEnum.access$getLevel0Impacts$p(this.this$0);
                            Intrinsics.checkNotNull((Object)mutableImpactList);
                            return this.readImpacts(bytesRef, mutableImpactList);
                        }
                        if (level == 1) {
                            BytesRef bytesRef = BlockPostingsEnum.access$getLevel1SerializedImpacts$p(this.this$0);
                            Intrinsics.checkNotNull((Object)bytesRef);
                            MutableImpactList mutableImpactList = BlockPostingsEnum.access$getLevel1Impacts$p(this.this$0);
                            Intrinsics.checkNotNull((Object)mutableImpactList);
                            return this.readImpacts(bytesRef, mutableImpactList);
                        }
                    }
                    return Lucene101PostingsReader.access$getDUMMY_IMPACTS$cp();
                }

                private final List<Impact> readImpacts(BytesRef serialized, MutableImpactList impactsList) {
                    ByteArrayDataInput scratch = this.scratch;
                    scratch.reset(serialized.getBytes(), 0, serialized.getLength());
                    Lucene101PostingsReader.Companion.readImpacts(scratch, impactsList);
                    return CollectionsKt.toMutableList((Collection)((Collection)((Object)impactsList)));
                }
            };
            if (!this.needsFreq) {
                Arrays.INSTANCE.fill(this.freqBuffer, 1);
            }
            if (this.needsFreq && this.needsImpacts) {
                this.level0SerializedImpacts = new BytesRef(Lucene101PostingsReader.this.maxImpactNumBytesAtLevel0);
                this.level1SerializedImpacts = new BytesRef(Lucene101PostingsReader.this.maxImpactNumBytesAtLevel1);
                this.level0Impacts = new MutableImpactList(Lucene101PostingsReader.this.maxNumImpactsAtLevel0);
                this.level1Impacts = new MutableImpactList(Lucene101PostingsReader.this.maxNumImpactsAtLevel1);
            } else {
                this.level0SerializedImpacts = null;
                this.level1SerializedImpacts = null;
                this.level0Impacts = null;
                this.level1Impacts = null;
            }
            if (this.needsPos) {
                IndexInput indexInput = Lucene101PostingsReader.this.posIn;
                Intrinsics.checkNotNull((Object)indexInput);
                this.posIn = indexInput.clone();
                VectorizationProvider vectorizationProvider = Companion.getVECTORIZATION_PROVIDER();
                IndexInput indexInput2 = this.posIn;
                Intrinsics.checkNotNull((Object)indexInput2);
                this.posInUtil = vectorizationProvider.newPostingDecodingUtil(indexInput2);
                this.posDeltaBuffer = new int[128];
            } else {
                this.posIn = null;
                this.posInUtil = null;
                this.posDeltaBuffer = null;
            }
            if (this.needsOffsets || this.needsPayloads) {
                IndexInput indexInput = Lucene101PostingsReader.this.payIn;
                Intrinsics.checkNotNull((Object)indexInput);
                this.payIn = indexInput.clone();
                VectorizationProvider vectorizationProvider = Companion.getVECTORIZATION_PROVIDER();
                IndexInput indexInput3 = this.payIn;
                Intrinsics.checkNotNull((Object)indexInput3);
                this.payInUtil = vectorizationProvider.newPostingDecodingUtil(indexInput3);
            } else {
                this.payIn = null;
                this.payInUtil = null;
            }
            if (this.needsOffsets) {
                this.offsetStartDeltaBuffer = new int[128];
                this.offsetLengthBuffer = new int[128];
            } else {
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.startOffset = -1;
                this.endOffset = -1;
            }
            if (this.indexHasPayloads) {
                this.payloadLengthBuffer = new int[128];
                this.payloadBytes = new byte[128];
                this.setPayload(new BytesRef());
            } else {
                this.payloadLengthBuffer = null;
                this.payloadBytes = null;
                this.setPayload(null);
            }
        }

        public final int getFlags() {
            return this.flags;
        }

        public final boolean getNeedsImpacts() {
            return this.needsImpacts;
        }

        @Nullable
        public final IndexInput getPosIn() {
            return this.posIn;
        }

        public final void setPosIn(@Nullable IndexInput indexInput) {
            this.posIn = indexInput;
        }

        @Nullable
        public final PostingDecodingUtil getPosInUtil() {
            return this.posInUtil;
        }

        public final void setPosInUtil(@Nullable PostingDecodingUtil postingDecodingUtil) {
            this.posInUtil = postingDecodingUtil;
        }

        @Nullable
        public final IndexInput getPayIn() {
            return this.payIn;
        }

        public final void setPayIn(@Nullable IndexInput indexInput) {
            this.payIn = indexInput;
        }

        @Nullable
        public final PostingDecodingUtil getPayInUtil() {
            return this.payInUtil;
        }

        public final void setPayInUtil(@Nullable PostingDecodingUtil postingDecodingUtil) {
            this.payInUtil = postingDecodingUtil;
        }

        @Override
        @Nullable
        public BytesRef getPayload() {
            return !this.needsPayloads || this.payloadLength == 0 ? null : this.getPayload();
        }

        public void setPayload(@Nullable BytesRef bytesRef) {
            this.payload = bytesRef;
        }

        @NotNull
        public final IndexOptions getOptions() {
            return this.options;
        }

        public final boolean getIndexHasFreq() {
            return this.indexHasFreq;
        }

        public final boolean getIndexHasPos() {
            return this.indexHasPos;
        }

        public final boolean getIndexHasOffsets() {
            return this.indexHasOffsets;
        }

        public final boolean getIndexHasPayloads() {
            return this.indexHasPayloads;
        }

        public final boolean getIndexHasOffsetsOrPayloads() {
            return this.indexHasOffsetsOrPayloads;
        }

        public final boolean getNeedsFreq() {
            return this.needsFreq;
        }

        public final boolean getNeedsPos() {
            return this.needsPos;
        }

        public final boolean getNeedsOffsets() {
            return this.needsOffsets;
        }

        public final boolean getNeedsPayloads() {
            return this.needsPayloads;
        }

        public final boolean getNeedsOffsetsOrPayloads() {
            return this.needsOffsetsOrPayloads;
        }

        public final boolean getNeedsDocsAndFreqsOnly() {
            return this.needsDocsAndFreqsOnly;
        }

        public final boolean canReuse(@NotNull IndexInput docIn, @NotNull FieldInfo fieldInfo, int flags, boolean needsImpacts) {
            Intrinsics.checkNotNullParameter((Object)docIn, (String)"docIn");
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            return docIn == Lucene101PostingsReader.this.docIn && this.options == fieldInfo.getIndexOptions() && this.indexHasPayloads == fieldInfo.hasPayloads() && this.flags == flags && this.needsImpacts == needsImpacts;
        }

        @NotNull
        public final BlockPostingsEnum reset(@NotNull Lucene101PostingsFormat.IntBlockTermState termState2, int flags) throws IOException {
            Intrinsics.checkNotNullParameter((Object)termState2, (String)"termState");
            this.docFreq = termState2.getDocFreq();
            this.singletonDocID = termState2.getSingletonDocID();
            if (this.docFreq > 1) {
                if (this.docIn == null) {
                    IndexInput indexInput = Lucene101PostingsReader.this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput);
                    this.docIn = indexInput.clone();
                    VectorizationProvider vectorizationProvider = Companion.getVECTORIZATION_PROVIDER();
                    IndexInput indexInput2 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput2);
                    this.docInUtil = vectorizationProvider.newPostingDecodingUtil(indexInput2);
                }
                IndexInput indexInput = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput);
                Companion.prefetchPostings(indexInput, termState2);
            }
            if (this.forDeltaUtil == null && this.docFreq >= 128) {
                this.forDeltaUtil = new ForDeltaUtil();
            }
            long l = this.totalTermFreq = this.indexHasFreq ? termState2.getTotalTermFreq() : (long)termState2.getDocFreq();
            if (this.needsFreq && this.pforUtil == null && this.totalTermFreq >= 128L) {
                this.pforUtil = new PForUtil();
            }
            long posTermStartFP = termState2.getPosStartFP();
            long payTermStartFP = termState2.getPayStartFP();
            if (this.posIn != null) {
                IndexInput indexInput = this.posIn;
                Intrinsics.checkNotNull((Object)indexInput);
                indexInput.seek(posTermStartFP);
                if (this.payIn != null) {
                    IndexInput indexInput3 = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput3);
                    indexInput3.seek(payTermStartFP);
                }
            }
            this.level1PosEndFP = posTermStartFP;
            this.level1PayEndFP = payTermStartFP;
            this.level0PosEndFP = posTermStartFP;
            this.level0PayEndFP = payTermStartFP;
            this.posPendingCount = 0;
            this.payloadByteUpto = 0;
            this.lastPosBlockFP = termState2.getTotalTermFreq() < 128L ? posTermStartFP : (termState2.getTotalTermFreq() == 128L ? -1L : posTermStartFP + termState2.getLastPosBlockOffset());
            this.level1BlockPosUpto = 0;
            this.level1BlockPayUpto = 0;
            this.level0BlockPosUpto = 0;
            this.level0BlockPayUpto = 0;
            this.posBufferUpto = 128;
            this.doc = -1;
            this.prevDocID = -1;
            this.docCountLeft = this.docFreq;
            this.freqFP = -1L;
            this.level0LastDocID = -1;
            if (this.docFreq < 4096) {
                this.level1LastDocID = Integer.MAX_VALUE;
                if (this.docFreq > 1) {
                    IndexInput indexInput = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput);
                    indexInput.seek(termState2.getDocStartFP());
                }
            } else {
                this.level1LastDocID = -1;
                this.level1DocEndFP = termState2.getDocStartFP();
            }
            this.level1DocCountUpto = 0;
            this.docBufferSize = 128;
            this.docBufferUpto = 128;
            this.posDocBufferUpto = 128;
            return this;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int freq() throws IOException {
            if (this.freqFP != -1L) {
                IndexInput indexInput = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput);
                indexInput.seek(this.freqFP);
                PForUtil pForUtil = this.pforUtil;
                Intrinsics.checkNotNull((Object)pForUtil);
                PostingDecodingUtil postingDecodingUtil = this.docInUtil;
                Intrinsics.checkNotNull((Object)postingDecodingUtil);
                pForUtil.decode(postingDecodingUtil, this.freqBuffer);
                this.freqFP = -1L;
            }
            return this.freqBuffer[this.docBufferUpto - 1];
        }

        private final void refillFullBlock() throws IOException {
            IndexInput indexInput = this.docIn;
            Intrinsics.checkNotNull((Object)indexInput);
            byte bitsPerValue = indexInput.readByte();
            if (bitsPerValue > 0) {
                ForDeltaUtil forDeltaUtil = this.forDeltaUtil;
                Intrinsics.checkNotNull((Object)forDeltaUtil);
                PostingDecodingUtil postingDecodingUtil = this.docInUtil;
                Intrinsics.checkNotNull((Object)postingDecodingUtil);
                forDeltaUtil.decodeAndPrefixSum(bitsPerValue, postingDecodingUtil, this.prevDocID, this.docBuffer);
                this.encoding = DeltaEncoding.PACKED;
            } else {
                if (!(this.level0LastDocID != Integer.MAX_VALUE)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.docBitSetBase = this.prevDocID + 1;
                int numLongs = 0;
                if (bitsPerValue == 0) {
                    numLongs = 2;
                    this.docBitSet.set(0, 128);
                } else {
                    numLongs = -bitsPerValue;
                    IndexInput indexInput2 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput2);
                    indexInput2.readLongs(this.docBitSet.getBits(), 0, numLongs);
                }
                if (this.needsFreq) {
                    int i;
                    int n = numLongs - 1;
                    for (i = 0; i < n; ++i) {
                        this.docCumulativeWordPopCounts[i] = LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.docBitSet.getBits()[i]);
                    }
                    n = numLongs - 1;
                    for (i = 1; i < n; ++i) {
                        int[] nArray = this.docCumulativeWordPopCounts;
                        int n2 = i;
                        nArray[n2] = nArray[n2] + this.docCumulativeWordPopCounts[i - 1];
                    }
                    this.docCumulativeWordPopCounts[numLongs - 1] = 128;
                    if (!(this.docCumulativeWordPopCounts[numLongs - 2] + LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.docBitSet.getBits()[numLongs - 1]) == 128)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
                this.encoding = DeltaEncoding.UNARY;
            }
            if (this.indexHasFreq) {
                if (this.needsFreq) {
                    IndexInput indexInput3 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput3);
                    this.freqFP = indexInput3.getFilePointer();
                }
                IndexInput indexInput4 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput4);
                PForUtil.Companion.skip(indexInput4);
            }
            this.docCountLeft -= 128;
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            this.posDocBufferUpto = 0;
        }

        private final void refillRemainder() throws IOException {
            if (!(this.docCountLeft >= 0 && this.docCountLeft < 128)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = (int)this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                if (!(this.freqFP == -1L)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.docCountLeft = 0;
                this.docBufferSize = 1;
            } else {
                IndexInput indexInput = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput);
                PostingsUtil.INSTANCE.readVIntBlock(indexInput, this.docBuffer, this.freqBuffer, this.docCountLeft, this.indexHasFreq, this.needsFreq);
                Companion.prefixSum(this.docBuffer, this.docCountLeft, this.prevDocID);
                this.docBuffer[this.docCountLeft] = Integer.MAX_VALUE;
                this.freqFP = -1L;
                this.docBufferSize = this.docCountLeft;
                this.docCountLeft = 0;
            }
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            this.posDocBufferUpto = 0;
            this.encoding = DeltaEncoding.PACKED;
            if (!(this.docBuffer[this.docBufferSize] == Integer.MAX_VALUE)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final void refillDocs() throws IOException {
            if (!(this.docCountLeft >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.docCountLeft >= 128) {
                this.refillFullBlock();
            } else {
                this.refillRemainder();
            }
        }

        private final void skipLevel1To(int target) throws IOException {
            do {
                this.prevDocID = this.level1LastDocID;
                this.level0LastDocID = this.level1LastDocID;
                IndexInput indexInput = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput);
                indexInput.seek(this.level1DocEndFP);
                this.level0PosEndFP = this.level1PosEndFP;
                this.level0BlockPosUpto = this.level1BlockPosUpto;
                this.level0PayEndFP = this.level1PayEndFP;
                this.level0BlockPayUpto = this.level1BlockPayUpto;
                this.docCountLeft = this.docFreq - this.level1DocCountUpto;
                this.level1DocCountUpto += 4096;
                if (this.docCountLeft < 4096) {
                    this.level1LastDocID = Integer.MAX_VALUE;
                    break;
                }
                IndexInput indexInput2 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput2);
                this.level1LastDocID += indexInput2.readVInt();
                IndexInput indexInput3 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput3);
                long delta = indexInput3.readVLong();
                IndexInput indexInput4 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput4);
                this.level1DocEndFP = delta + indexInput4.getFilePointer();
                if (!this.indexHasFreq) continue;
                IndexInput indexInput5 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput5);
                long l = indexInput5.readShort();
                IndexInput indexInput6 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput6);
                long skip1EndFP = l + indexInput6.getFilePointer();
                IndexInput indexInput7 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput7);
                short numImpactBytes = indexInput7.readShort();
                if (this.needsImpacts && this.level1LastDocID >= target) {
                    IndexInput indexInput8 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput8);
                    BytesRef bytesRef = this.level1SerializedImpacts;
                    Intrinsics.checkNotNull((Object)bytesRef);
                    indexInput8.readBytes(bytesRef.getBytes(), 0, numImpactBytes);
                    BytesRef bytesRef2 = this.level1SerializedImpacts;
                    Intrinsics.checkNotNull((Object)bytesRef2);
                    bytesRef2.setLength(numImpactBytes);
                } else {
                    IndexInput indexInput9 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput9);
                    indexInput9.skipBytes(numImpactBytes);
                }
                if (this.indexHasPos) {
                    IndexInput indexInput10 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput10);
                    this.level1PosEndFP += indexInput10.readVLong();
                    IndexInput indexInput11 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput11);
                    this.level1BlockPosUpto = indexInput11.readByte();
                    if (this.indexHasOffsetsOrPayloads) {
                        IndexInput indexInput12 = this.docIn;
                        Intrinsics.checkNotNull((Object)indexInput12);
                        this.level1PayEndFP += indexInput12.readVLong();
                        IndexInput indexInput13 = this.docIn;
                        Intrinsics.checkNotNull((Object)indexInput13);
                        this.level1BlockPayUpto = indexInput13.readVInt();
                    }
                }
                IndexInput indexInput14 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput14);
                if (indexInput14.getFilePointer() == skip1EndFP) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            } while (this.level1LastDocID < target);
        }

        private final void doMoveToNextLevel0Block() throws IOException {
            if (!(this.doc == this.level0LastDocID)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.posIn != null) {
                IndexInput indexInput = this.posIn;
                Intrinsics.checkNotNull((Object)indexInput);
                if (this.level0PosEndFP >= indexInput.getFilePointer()) {
                    IndexInput indexInput2 = this.posIn;
                    Intrinsics.checkNotNull((Object)indexInput2);
                    indexInput2.seek(this.level0PosEndFP);
                    this.posPendingCount = this.level0BlockPosUpto;
                    if (this.payIn != null) {
                        IndexInput indexInput3 = this.payIn;
                        Intrinsics.checkNotNull((Object)indexInput3);
                        if (!(this.level0PayEndFP >= indexInput3.getFilePointer())) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        IndexInput indexInput4 = this.payIn;
                        Intrinsics.checkNotNull((Object)indexInput4);
                        indexInput4.seek(this.level0PayEndFP);
                        this.payloadByteUpto = this.level0BlockPayUpto;
                    }
                    this.posBufferUpto = 128;
                } else {
                    if (!(this.freqFP == -1L)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.posPendingCount += Companion.sumOverRange(this.freqBuffer, this.posDocBufferUpto, 128);
                }
            }
            if (this.docCountLeft >= 128) {
                IndexInput indexInput = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput);
                indexInput.readVLong();
                IndexInput indexInput5 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput5);
                int docDelta = Companion.readVInt15(indexInput5);
                this.level0LastDocID += docDelta;
                IndexInput indexInput6 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput6);
                long blockLength = Companion.readVLong15(indexInput6);
                IndexInput indexInput7 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput7);
                this.level0DocEndFP = indexInput7.getFilePointer() + blockLength;
                if (this.indexHasFreq) {
                    IndexInput indexInput8 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput8);
                    int numImpactBytes = indexInput8.readVInt();
                    if (this.needsImpacts) {
                        IndexInput indexInput9 = this.docIn;
                        Intrinsics.checkNotNull((Object)indexInput9);
                        BytesRef bytesRef = this.level0SerializedImpacts;
                        Intrinsics.checkNotNull((Object)bytesRef);
                        indexInput9.readBytes(bytesRef.getBytes(), 0, numImpactBytes);
                        BytesRef bytesRef2 = this.level0SerializedImpacts;
                        Intrinsics.checkNotNull((Object)bytesRef2);
                        bytesRef2.setLength(numImpactBytes);
                    } else {
                        IndexInput indexInput10 = this.docIn;
                        Intrinsics.checkNotNull((Object)indexInput10);
                        indexInput10.skipBytes(numImpactBytes);
                    }
                    if (this.indexHasPos) {
                        IndexInput indexInput11 = this.docIn;
                        Intrinsics.checkNotNull((Object)indexInput11);
                        this.level0PosEndFP += indexInput11.readVLong();
                        IndexInput indexInput12 = this.docIn;
                        Intrinsics.checkNotNull((Object)indexInput12);
                        this.level0BlockPosUpto = indexInput12.readByte();
                        if (this.indexHasOffsetsOrPayloads) {
                            IndexInput indexInput13 = this.docIn;
                            Intrinsics.checkNotNull((Object)indexInput13);
                            this.level0PayEndFP += indexInput13.readVLong();
                            IndexInput indexInput14 = this.docIn;
                            Intrinsics.checkNotNull((Object)indexInput14);
                            this.level0BlockPayUpto = indexInput14.readVInt();
                        }
                    }
                }
                this.refillFullBlock();
            } else {
                this.level0LastDocID = Integer.MAX_VALUE;
                this.refillRemainder();
            }
        }

        private final void moveToNextLevel0Block() throws IOException {
            if (this.doc == this.level1LastDocID) {
                this.skipLevel1To(this.doc + 1);
            }
            this.prevDocID = this.level0LastDocID;
            if (this.needsDocsAndFreqsOnly && this.docCountLeft >= 128) {
                IndexInput indexInput = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput);
                long level0NumBytes = indexInput.readVLong();
                IndexInput indexInput2 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput2);
                long level0End = indexInput2.getFilePointer() + level0NumBytes;
                IndexInput indexInput3 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput3);
                this.level0LastDocID += Companion.readVInt15(indexInput3);
                IndexInput indexInput4 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput4);
                indexInput4.seek(level0End);
                this.refillFullBlock();
            } else {
                this.doMoveToNextLevel0Block();
            }
        }

        private final void readLevel0PosData() throws IOException {
            IndexInput indexInput = this.docIn;
            Intrinsics.checkNotNull((Object)indexInput);
            this.level0PosEndFP += indexInput.readVLong();
            IndexInput indexInput2 = this.docIn;
            Intrinsics.checkNotNull((Object)indexInput2);
            this.level0BlockPosUpto = indexInput2.readByte();
            if (this.indexHasOffsetsOrPayloads) {
                IndexInput indexInput3 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput3);
                this.level0PayEndFP += indexInput3.readVLong();
                IndexInput indexInput4 = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput4);
                this.level0BlockPayUpto = indexInput4.readVInt();
            }
        }

        private final void seekPosData(long posFP, int posUpto, long payFP, int payUpto) throws IOException {
            IndexInput indexInput = this.posIn;
            Intrinsics.checkNotNull((Object)indexInput);
            if (posFP >= indexInput.getFilePointer()) {
                IndexInput indexInput2 = this.posIn;
                Intrinsics.checkNotNull((Object)indexInput2);
                indexInput2.seek(posFP);
                this.posPendingCount = posUpto;
                if (this.payIn != null) {
                    IndexInput indexInput3 = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput3);
                    if (!(this.level0PayEndFP >= indexInput3.getFilePointer())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    IndexInput indexInput4 = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput4);
                    indexInput4.seek(payFP);
                    this.payloadByteUpto = payUpto;
                }
                this.posBufferUpto = 128;
            } else {
                this.posPendingCount += Companion.sumOverRange(this.freqBuffer, this.posDocBufferUpto, 128);
            }
        }

        private final void skipLevel0To(int target) throws IOException {
            int payUpto;
            long payFP;
            int posUpto;
            long posFP;
            block10: {
                posFP = 0L;
                posUpto = 0;
                payFP = 0L;
                payUpto = 0;
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    posFP = this.level0PosEndFP;
                    posUpto = this.level0BlockPosUpto;
                    payFP = this.level0PayEndFP;
                    payUpto = this.level0BlockPayUpto;
                    if (this.docCountLeft < 128) break;
                    IndexInput indexInput = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput);
                    long numSkipBytes = indexInput.readVLong();
                    IndexInput indexInput2 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput2);
                    long skip0End = indexInput2.getFilePointer() + numSkipBytes;
                    IndexInput indexInput3 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput3);
                    int docDelta = Companion.readVInt15(indexInput3);
                    this.level0LastDocID += docDelta;
                    boolean found = target <= this.level0LastDocID;
                    IndexInput indexInput4 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput4);
                    long blockLength = Companion.readVLong15(indexInput4);
                    IndexInput indexInput5 = this.docIn;
                    Intrinsics.checkNotNull((Object)indexInput5);
                    this.level0DocEndFP = indexInput5.getFilePointer() + blockLength;
                    if (this.indexHasFreq) {
                        if (!found && !this.needsPos) {
                            IndexInput indexInput6 = this.docIn;
                            Intrinsics.checkNotNull((Object)indexInput6);
                            indexInput6.seek(skip0End);
                        } else {
                            IndexInput indexInput7 = this.docIn;
                            Intrinsics.checkNotNull((Object)indexInput7);
                            int numImpactBytes = indexInput7.readVInt();
                            if (this.needsImpacts && found) {
                                IndexInput indexInput8 = this.docIn;
                                Intrinsics.checkNotNull((Object)indexInput8);
                                BytesRef bytesRef = this.level0SerializedImpacts;
                                Intrinsics.checkNotNull((Object)bytesRef);
                                indexInput8.readBytes(bytesRef.getBytes(), 0, numImpactBytes);
                                BytesRef bytesRef2 = this.level0SerializedImpacts;
                                Intrinsics.checkNotNull((Object)bytesRef2);
                                bytesRef2.setLength(numImpactBytes);
                            } else {
                                IndexInput indexInput9 = this.docIn;
                                Intrinsics.checkNotNull((Object)indexInput9);
                                indexInput9.skipBytes(numImpactBytes);
                            }
                            if (this.needsPos) {
                                this.readLevel0PosData();
                            } else {
                                IndexInput indexInput10 = this.docIn;
                                Intrinsics.checkNotNull((Object)indexInput10);
                                indexInput10.seek(skip0End);
                            }
                        }
                    }
                    if (!found) {
                        IndexInput indexInput11 = this.docIn;
                        Intrinsics.checkNotNull((Object)indexInput11);
                        indexInput11.seek(this.level0DocEndFP);
                        this.docCountLeft -= 128;
                        continue;
                    }
                    break block10;
                    break;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
            if (this.posIn != null) {
                this.seekPosData(posFP, posUpto, payFP, payUpto);
            }
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.level0LastDocID) {
                this.doAdvanceShallow(target);
                this.needsRefilling = true;
            }
        }

        private final void doAdvanceShallow(int target) throws IOException {
            if (target > this.level1LastDocID) {
                this.skipLevel1To(target);
            } else if (this.needsRefilling) {
                IndexInput indexInput = this.docIn;
                Intrinsics.checkNotNull((Object)indexInput);
                indexInput.seek(this.level0DocEndFP);
                this.docCountLeft -= 128;
            }
            this.skipLevel0To(target);
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc == this.level0LastDocID || this.needsRefilling) {
                if (this.needsRefilling) {
                    this.refillDocs();
                    this.needsRefilling = false;
                } else {
                    this.moveToNextLevel0Block();
                }
            }
            DeltaEncoding deltaEncoding = this.encoding;
            switch (deltaEncoding == null ? -1 : WhenMappings.$EnumSwitchMapping$0[deltaEncoding.ordinal()]) {
                case 1: {
                    this.doc = this.docBuffer[this.docBufferUpto];
                    break;
                }
                case 2: {
                    int next = this.docBitSet.nextSetBit(this.doc - this.docBitSetBase + 1);
                    if (!(next != Integer.MAX_VALUE)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.doc = this.docBitSetBase + next;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown encoding: " + this.encoding);
                }
            }
            ++this.docBufferUpto;
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target > this.level0LastDocID || this.needsRefilling) {
                if (target > this.level0LastDocID) {
                    this.doAdvanceShallow(target);
                }
                this.refillDocs();
                this.needsRefilling = false;
            }
            DeltaEncoding deltaEncoding = this.encoding;
            switch (deltaEncoding == null ? -1 : WhenMappings.$EnumSwitchMapping$0[deltaEncoding.ordinal()]) {
                case 1: {
                    int next = VectorUtil.INSTANCE.findNextGEQ(this.docBuffer, target, this.docBufferUpto, this.docBufferSize);
                    this.doc = this.docBuffer[next];
                    this.docBufferUpto = next + 1;
                    break;
                }
                case 2: {
                    int next = this.docBitSet.nextSetBit(target - this.docBitSetBase);
                    if (!(next != Integer.MAX_VALUE)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.doc = this.docBitSetBase + next;
                    if (this.needsFreq) {
                        int wordIndex = next >> 6;
                        this.docBufferUpto = 1 + this.docCumulativeWordPopCounts[wordIndex] - LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.docBitSet.getBits()[wordIndex] >>> next);
                        break;
                    }
                    this.docBufferUpto = 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown encoding: " + this.encoding);
                }
            }
            return this.doc;
        }

        @Override
        public void intoBitSet(int upTo, @NotNull FixedBitSet bitSet, int offset) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
            if (this.doc >= upTo) {
                return;
            }
            bitSet.set(this.doc - offset);
            block4: while (true) {
                if (this.doc == this.level0LastDocID) {
                    this.moveToNextLevel0Block();
                }
                DeltaEncoding deltaEncoding = this.encoding;
                switch (deltaEncoding == null ? -1 : WhenMappings.$EnumSwitchMapping$0[deltaEncoding.ordinal()]) {
                    case 1: {
                        int start = this.docBufferUpto;
                        int end = this.computeBufferEndBoundary(upTo);
                        if (end != 0) {
                            this.bufferIntoBitSet(start, end, bitSet, offset);
                            this.doc = this.docBuffer[end - 1];
                        }
                        this.docBufferUpto = end;
                        if (end == 128) continue block4;
                        this.nextDoc();
                        if (!(this.doc >= upTo)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        return;
                    }
                    case 2: {
                        int sourceFrom = this.docBufferUpto == 0 ? 0 : this.doc - this.docBitSetBase + 1;
                        int destFrom = this.docBitSetBase - offset + sourceFrom;
                        if (!(this.level0LastDocID != Integer.MAX_VALUE)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        int sourceTo = Math.min(upTo, this.level0LastDocID + 1) - this.docBitSetBase;
                        if (sourceTo > sourceFrom) {
                            FixedBitSet.Companion.orRange(this.docBitSet, sourceFrom, bitSet, destFrom, sourceTo - sourceFrom);
                        }
                        if (this.docBitSetBase + sourceTo <= this.level0LastDocID) {
                            this.advance(this.docBitSetBase + sourceTo);
                            return;
                        }
                        this.doc = this.level0LastDocID;
                        this.docBufferUpto = 128;
                        continue block4;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown encoding: " + this.encoding);
        }

        private final int computeBufferEndBoundary(int upTo) {
            return this.docBufferSize != 0 && this.docBuffer[this.docBufferSize - 1] < upTo ? this.docBufferSize : VectorUtil.INSTANCE.findNextGEQ(this.docBuffer, upTo, this.docBufferUpto, this.docBufferSize);
        }

        private final void bufferIntoBitSet(int start, int end, FixedBitSet bitSet, int offset) throws IOException {
            for (int i = start; i < end; ++i) {
                int doc = this.docBuffer[i];
                bitSet.set(doc - offset);
            }
        }

        private final void skipPositions(int freq) throws IOException {
            int toSkip = this.posPendingCount - freq;
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < leftInBlock) {
                int end = this.posBufferUpto + toSkip;
                if (this.needsPayloads) {
                    Intrinsics.checkNotNull((Object)this.payloadLengthBuffer);
                    this.payloadByteUpto += Companion.sumOverRange(this.payloadLengthBuffer, this.posBufferUpto, end);
                }
                this.posBufferUpto = end;
            } else {
                toSkip -= leftInBlock;
                while (toSkip >= 128) {
                    IndexInput indexInput = this.posIn;
                    Intrinsics.checkNotNull((Object)indexInput);
                    if (!(indexInput.getFilePointer() != this.lastPosBlockFP)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    IndexInput indexInput2 = this.posIn;
                    Intrinsics.checkNotNull((Object)indexInput2);
                    PForUtil.Companion.skip(indexInput2);
                    if (this.payIn != null) {
                        if (this.indexHasPayloads) {
                            IndexInput indexInput3 = this.payIn;
                            Intrinsics.checkNotNull((Object)indexInput3);
                            PForUtil.Companion.skip(indexInput3);
                            IndexInput indexInput4 = this.payIn;
                            Intrinsics.checkNotNull((Object)indexInput4);
                            int numBytes = indexInput4.readVInt();
                            IndexInput indexInput5 = this.payIn;
                            Intrinsics.checkNotNull((Object)indexInput5);
                            IndexInput indexInput6 = this.payIn;
                            Intrinsics.checkNotNull((Object)indexInput6);
                            indexInput5.seek(indexInput6.getFilePointer() + (long)numBytes);
                        }
                        if (this.indexHasOffsets) {
                            IndexInput indexInput7 = this.payIn;
                            Intrinsics.checkNotNull((Object)indexInput7);
                            PForUtil.Companion.skip(indexInput7);
                            IndexInput indexInput8 = this.payIn;
                            Intrinsics.checkNotNull((Object)indexInput8);
                            PForUtil.Companion.skip(indexInput8);
                        }
                    }
                    toSkip -= 128;
                }
                this.refillPositions();
                if (this.needsPayloads) {
                    Intrinsics.checkNotNull((Object)this.payloadLengthBuffer);
                    this.payloadByteUpto = Companion.sumOverRange(this.payloadLengthBuffer, 0, toSkip);
                }
                this.posBufferUpto = toSkip;
            }
        }

        private final void refillLastPositionBlock() throws IOException {
            int count = (int)(this.totalTermFreq % (long)128);
            int payloadLength = 0;
            int offsetLength = 0;
            this.payloadByteUpto = 0;
            for (int i = 0; i < count; ++i) {
                IndexInput indexInput = this.posIn;
                Intrinsics.checkNotNull((Object)indexInput);
                int code = indexInput.readVInt();
                if (this.indexHasPayloads) {
                    if ((code & 1) != 0) {
                        IndexInput indexInput2 = this.posIn;
                        Intrinsics.checkNotNull((Object)indexInput2);
                        payloadLength = indexInput2.readVInt();
                    }
                    if (this.payloadLengthBuffer != null) {
                        this.payloadLengthBuffer[i] = payloadLength;
                        Intrinsics.checkNotNull((Object)this.posDeltaBuffer);
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            Intrinsics.checkNotNull((Object)this.payloadBytes);
                            if (this.payloadByteUpto + payloadLength > this.payloadBytes.length) {
                                Intrinsics.checkNotNull((Object)this.payloadBytes);
                                this.payloadBytes = ArrayUtil.Companion.grow(this.payloadBytes, this.payloadByteUpto + payloadLength);
                            }
                            IndexInput indexInput3 = this.posIn;
                            Intrinsics.checkNotNull((Object)indexInput3);
                            Intrinsics.checkNotNull((Object)this.payloadBytes);
                            indexInput3.readBytes(this.payloadBytes, this.payloadByteUpto, payloadLength);
                            this.payloadByteUpto += payloadLength;
                        }
                    } else {
                        IndexInput indexInput4 = this.posIn;
                        Intrinsics.checkNotNull((Object)indexInput4);
                        indexInput4.skipBytes(payloadLength);
                    }
                } else {
                    Intrinsics.checkNotNull((Object)this.posDeltaBuffer);
                    this.posDeltaBuffer[i] = code;
                }
                if (!this.indexHasOffsets) continue;
                IndexInput indexInput5 = this.posIn;
                Intrinsics.checkNotNull((Object)indexInput5);
                int deltaCode = indexInput5.readVInt();
                if ((deltaCode & 1) != 0) {
                    IndexInput indexInput6 = this.posIn;
                    Intrinsics.checkNotNull((Object)indexInput6);
                    offsetLength = indexInput6.readVInt();
                }
                if (this.offsetStartDeltaBuffer == null) continue;
                this.offsetStartDeltaBuffer[i] = deltaCode >>> 1;
                Intrinsics.checkNotNull((Object)this.offsetLengthBuffer);
                this.offsetLengthBuffer[i] = offsetLength;
            }
            this.payloadByteUpto = 0;
        }

        private final void refillOffsetsOrPayloads() throws IOException {
            if (this.indexHasPayloads) {
                if (this.needsPayloads) {
                    PForUtil pForUtil = this.pforUtil;
                    Intrinsics.checkNotNull((Object)pForUtil);
                    PostingDecodingUtil postingDecodingUtil = this.payInUtil;
                    Intrinsics.checkNotNull((Object)postingDecodingUtil);
                    Intrinsics.checkNotNull((Object)this.payloadLengthBuffer);
                    pForUtil.decode(postingDecodingUtil, this.payloadLengthBuffer);
                    IndexInput indexInput = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput);
                    int numBytes = indexInput.readVInt();
                    Intrinsics.checkNotNull((Object)this.payloadBytes);
                    if (numBytes > this.payloadBytes.length) {
                        Intrinsics.checkNotNull((Object)this.payloadBytes);
                        this.payloadBytes = ArrayUtil.Companion.growNoCopy(this.payloadBytes, numBytes);
                    }
                    IndexInput indexInput2 = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput2);
                    Intrinsics.checkNotNull((Object)this.payloadBytes);
                    indexInput2.readBytes(this.payloadBytes, 0, numBytes);
                } else if (this.payIn != null) {
                    IndexInput indexInput = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput);
                    PForUtil.Companion.skip(indexInput);
                    IndexInput indexInput3 = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput3);
                    int numBytes = indexInput3.readVInt();
                    IndexInput indexInput4 = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput4);
                    IndexInput indexInput5 = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput5);
                    indexInput4.seek(indexInput5.getFilePointer() + (long)numBytes);
                }
                this.payloadByteUpto = 0;
            }
            if (this.indexHasOffsets) {
                if (this.needsOffsets) {
                    PForUtil pForUtil = this.pforUtil;
                    Intrinsics.checkNotNull((Object)pForUtil);
                    PostingDecodingUtil postingDecodingUtil = this.payInUtil;
                    Intrinsics.checkNotNull((Object)postingDecodingUtil);
                    Intrinsics.checkNotNull((Object)this.offsetStartDeltaBuffer);
                    pForUtil.decode(postingDecodingUtil, this.offsetStartDeltaBuffer);
                    PForUtil pForUtil2 = this.pforUtil;
                    Intrinsics.checkNotNull((Object)pForUtil2);
                    PostingDecodingUtil postingDecodingUtil2 = this.payInUtil;
                    Intrinsics.checkNotNull((Object)postingDecodingUtil2);
                    Intrinsics.checkNotNull((Object)this.offsetLengthBuffer);
                    pForUtil2.decode(postingDecodingUtil2, this.offsetLengthBuffer);
                } else if (this.payIn != null) {
                    IndexInput indexInput = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput);
                    PForUtil.Companion.skip(indexInput);
                    IndexInput indexInput6 = this.payIn;
                    Intrinsics.checkNotNull((Object)indexInput6);
                    PForUtil.Companion.skip(indexInput6);
                }
            }
        }

        private final void refillPositions() throws IOException {
            IndexInput indexInput = this.posIn;
            Intrinsics.checkNotNull((Object)indexInput);
            if (indexInput.getFilePointer() == this.lastPosBlockFP) {
                this.refillLastPositionBlock();
                return;
            }
            PForUtil pForUtil = this.pforUtil;
            Intrinsics.checkNotNull((Object)pForUtil);
            PostingDecodingUtil postingDecodingUtil = this.posInUtil;
            Intrinsics.checkNotNull((Object)postingDecodingUtil);
            Intrinsics.checkNotNull((Object)this.posDeltaBuffer);
            pForUtil.decode(postingDecodingUtil, this.posDeltaBuffer);
            if (this.indexHasOffsetsOrPayloads) {
                this.refillOffsetsOrPayloads();
            }
        }

        private final void accumulatePendingPositions() throws IOException {
            int freq = this.freq();
            this.posPendingCount += Companion.sumOverRange(this.freqBuffer, this.posDocBufferUpto, this.docBufferUpto);
            this.posDocBufferUpto = this.docBufferUpto;
            if (!(this.posPendingCount > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.posPendingCount > freq) {
                this.skipPositions(freq);
                this.posPendingCount = freq;
            }
        }

        private final void accumulatePayloadAndOffsets() {
            if (this.needsPayloads) {
                Intrinsics.checkNotNull((Object)this.payloadLengthBuffer);
                this.payloadLength = this.payloadLengthBuffer[this.posBufferUpto];
                BytesRef bytesRef = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef);
                Intrinsics.checkNotNull((Object)this.payloadBytes);
                bytesRef.setBytes(this.payloadBytes);
                BytesRef bytesRef2 = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef2);
                bytesRef2.setOffset(this.payloadByteUpto);
                BytesRef bytesRef3 = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef3);
                bytesRef3.setLength(this.payloadLength);
                this.payloadByteUpto += this.payloadLength;
            }
            if (this.needsOffsets) {
                Intrinsics.checkNotNull((Object)this.offsetStartDeltaBuffer);
                this.startOffset = this.lastStartOffset + this.offsetStartDeltaBuffer[this.posBufferUpto];
                Intrinsics.checkNotNull((Object)this.offsetLengthBuffer);
                this.endOffset = this.startOffset + this.offsetLengthBuffer[this.posBufferUpto];
                this.lastStartOffset = this.startOffset;
            }
        }

        @Override
        public int nextPosition() throws IOException {
            if (!this.needsPos) {
                return -1;
            }
            if (!(this.posDocBufferUpto <= this.docBufferUpto)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.posDocBufferUpto != this.docBufferUpto) {
                this.accumulatePendingPositions();
                this.position = 0;
                this.lastStartOffset = 0;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            Intrinsics.checkNotNull((Object)this.posDeltaBuffer);
            this.position += this.posDeltaBuffer[this.posBufferUpto];
            if (this.needsOffsetsOrPayloads) {
                this.accumulatePayloadAndOffsets();
            }
            int n = this.posBufferUpto;
            this.posBufferUpto = n + 1;
            n = this.posPendingCount;
            this.posPendingCount = n + -1;
            return this.position;
        }

        @Override
        public int startOffset() {
            if (!this.needsOffsets) {
                return -1;
            }
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            if (!this.needsOffsets) {
                return -1;
            }
            return this.endOffset;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }

        @Override
        @NotNull
        public Impacts getImpacts() {
            if (!this.needsImpacts) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.impacts;
        }

        public static final /* synthetic */ int access$getLevel1LastDocID$p(BlockPostingsEnum $this) {
            return $this.level1LastDocID;
        }

        public static final /* synthetic */ int access$getLevel0LastDocID$p(BlockPostingsEnum $this) {
            return $this.level0LastDocID;
        }

        public static final /* synthetic */ BytesRef access$getLevel0SerializedImpacts$p(BlockPostingsEnum $this) {
            return $this.level0SerializedImpacts;
        }

        public static final /* synthetic */ MutableImpactList access$getLevel0Impacts$p(BlockPostingsEnum $this) {
            return $this.level0Impacts;
        }

        public static final /* synthetic */ BytesRef access$getLevel1SerializedImpacts$p(BlockPostingsEnum $this) {
            return $this.level1SerializedImpacts;
        }

        public static final /* synthetic */ MutableImpactList access$getLevel1Impacts$p(BlockPostingsEnum $this) {
            return $this.level1Impacts;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DeltaEncoding.values().length];
                try {
                    nArray[DeltaEncoding.PACKED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeltaEncoding.UNARY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\"2\u0006\u0010#\u001a\u00020!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader$Companion;", "", "<init>", "()V", "VECTORIZATION_PROVIDER", "Lorg/gnit/lucenekmp/internal/vectorization/VectorizationProvider;", "getVECTORIZATION_PROVIDER", "()Lorg/gnit/lucenekmp/internal/vectorization/VectorizationProvider;", "DUMMY_IMPACTS", "", "Lorg/gnit/lucenekmp/index/Impact;", "prefixSum", "", "buffer", "", "count", "", "base", "", "sumOverRange", "arr", "start", "end", "readVInt15", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "readVLong15", "prefetchPostings", "docIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "state", "Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$IntBlockTermState;", "readImpacts", "Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader$MutableImpactList;", "Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "reuse", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VectorizationProvider getVECTORIZATION_PROVIDER() {
            return VECTORIZATION_PROVIDER;
        }

        public final void prefixSum(@NotNull int[] buffer, int count, long base) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer[0] = buffer[0] + (int)base;
            for (int i = 1; i < count; ++i) {
                int n = i;
                buffer[n] = buffer[n] + buffer[i - 1];
            }
        }

        private final int sumOverRange(int[] arr, int start, int end) {
            int res = 0;
            for (int i = start; i < end; ++i) {
                res += arr[i];
            }
            return res;
        }

        public final int readVInt15(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            int s = in.readShort();
            return s >= 0 ? s : s & Short.MAX_VALUE | in.readVInt() << 15;
        }

        public final long readVLong15(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            short s = in.readShort();
            return s >= 0 ? (long)s : (long)s & 0x7FFFL | in.readVLong() << 15;
        }

        private final void prefetchPostings(IndexInput docIn, Lucene101PostingsFormat.IntBlockTermState state2) throws IOException {
            if (!(state2.getDocFreq() > 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (docIn.getFilePointer() != state2.getDocStartFP()) {
                docIn.prefetch(state2.getDocStartFP(), 1L);
            }
        }

        @NotNull
        public final MutableImpactList readImpacts(@NotNull ByteArrayDataInput in, @NotNull MutableImpactList reuse) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)reuse, (String)"reuse");
            int freq = 0;
            long norm = 0L;
            int length = 0;
            while (in.getPosition() < in.length()) {
                Impact impact;
                int freqDelta = in.readVInt();
                if ((freqDelta & 1) != 0) {
                    freq += 1 + (freqDelta >>> 1);
                    try {
                        norm += 1L + in.readZLong();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    freq += 1 + (freqDelta >>> 1);
                    long e = norm;
                    norm = e + 1L;
                }
                Intrinsics.checkNotNull((Object)reuse.getImpacts()[length]);
                impact.setFreq(freq);
                impact.setNorm(norm);
                ++length;
            }
            reuse.setSize(length);
            return reuse;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader$DeltaEncoding;", "", "<init>", "(Ljava/lang/String;I)V", "PACKED", "UNARY", "core"})
    private static final class DeltaEncoding
    extends Enum<DeltaEncoding> {
        public static final /* enum */ DeltaEncoding PACKED = new DeltaEncoding();
        public static final /* enum */ DeltaEncoding UNARY = new DeltaEncoding();
        private static final /* synthetic */ DeltaEncoding[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DeltaEncoding[] values() {
            return (DeltaEncoding[])$VALUES.clone();
        }

        public static DeltaEncoding valueOf(String value) {
            return Enum.valueOf(DeltaEncoding.class, value);
        }

        @NotNull
        public static EnumEntries<DeltaEncoding> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = deltaEncodingArray = new DeltaEncoding[]{DeltaEncoding.PACKED, DeltaEncoding.UNARY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00060\u0003j\u0002`\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0006H\u0096\u0002R\u001a\u0010\t\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\bR\u001b\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000e\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsReader$MutableImpactList;", "Lkotlin/collections/AbstractList;", "Lorg/gnit/lucenekmp/index/Impact;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "capacity", "", "<init>", "(I)V", "size", "getSize", "()I", "setSize", "impacts", "", "getImpacts", "()[Lorg/gnit/lucenekmp/index/Impact;", "[Lorg/gnit/lucenekmp/index/Impact;", "get", "index", "core"})
    public static final class MutableImpactList
    extends AbstractList<Impact>
    implements RandomAccess {
        private int size;
        @NotNull
        private final Impact[] impacts;

        public MutableImpactList(int capacity) {
            this.impacts = new Impact[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.impacts[i] = new Impact(Integer.MAX_VALUE, 1L);
            }
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int n) {
            this.size = n;
        }

        @NotNull
        public final Impact[] getImpacts() {
            return this.impacts;
        }

        @NotNull
        public Impact get(int index) {
            Impact impact = this.impacts[index];
            Intrinsics.checkNotNull((Object)impact);
            return impact;
        }
    }
}

