/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene101;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.GroupVIntUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ.\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/PostingsUtil;", "", "<init>", "()V", "readVIntBlock", "", "docIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "docBuffer", "", "freqBuffer", "num", "", "indexHasFreq", "", "decodeFreq", "writeVIntBlock", "docOut", "Lorg/gnit/lucenekmp/store/DataOutput;", "writeFreqs", "core"})
public final class PostingsUtil {
    @NotNull
    public static final PostingsUtil INSTANCE = new PostingsUtil();

    private PostingsUtil() {
    }

    public final void readVIntBlock(@NotNull IndexInput docIn, @NotNull int[] docBuffer, @NotNull int[] freqBuffer, int num, boolean indexHasFreq, boolean decodeFreq) throws IOException {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)docIn, (String)"docIn");
                Intrinsics.checkNotNullParameter((Object)docBuffer, (String)"docBuffer");
                Intrinsics.checkNotNullParameter((Object)freqBuffer, (String)"freqBuffer");
                GroupVIntUtil.INSTANCE.readGroupVInts((DataInput)docIn, docBuffer, num);
                if (!indexHasFreq || !decodeFreq) break block2;
                for (int i = 0; i < num; ++i) {
                    freqBuffer[i] = docBuffer[i] & 1;
                    docBuffer[i] = docBuffer[i] >>> 1;
                    if (freqBuffer[i] != 0) continue;
                    freqBuffer[i] = docIn.readVInt();
                }
                break block3;
            }
            if (!indexHasFreq) break block3;
            for (int i = 0; i < num; ++i) {
                docBuffer[i] = docBuffer[i] >>> 1;
            }
        }
    }

    public final void writeVIntBlock(@NotNull DataOutput docOut, @NotNull int[] docBuffer, @NotNull int[] freqBuffer, int num, boolean writeFreqs) throws IOException {
        int i;
        Intrinsics.checkNotNullParameter((Object)docOut, (String)"docOut");
        Intrinsics.checkNotNullParameter((Object)docBuffer, (String)"docBuffer");
        Intrinsics.checkNotNullParameter((Object)freqBuffer, (String)"freqBuffer");
        if (writeFreqs) {
            for (i = 0; i < num; ++i) {
                docBuffer[i] = docBuffer[i] << 1 | (freqBuffer[i] == 1 ? 1 : 0);
            }
        }
        docOut.writeGroupVInts(docBuffer, num);
        if (writeFreqs) {
            for (i = 0; i < num; ++i) {
                int freq = freqBuffer[i];
                if (freq == 1) continue;
                docOut.writeVInt(freq);
            }
        }
    }
}

