/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.compressing.Decompressor;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J0\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/DeflateWithPresetDictDecompressor;", "Lorg/gnit/lucenekmp/codecs/compressing/Decompressor;", "<init>", "()V", "compressed", "", "getCompressed", "()[B", "setCompressed", "([B)V", "doDecompress", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "decompressor", "Ljava/util/zip/Inflater;", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "decompress", "originalLength", "", "offset", "length", "clone", "core"})
public final class DeflateWithPresetDictDecompressor
extends Decompressor {
    @NotNull
    private byte[] compressed = new byte[0];

    @NotNull
    public final byte[] getCompressed() {
        return this.compressed;
    }

    public final void setCompressed(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.compressed = byArray;
    }

    private final void doDecompress(DataInput in, Inflater decompressor, BytesRef bytes) throws IOException {
        int compressedLength = in.readVInt();
        if (compressedLength == 0) {
            return;
        }
        int paddedLength = compressedLength + 1;
        this.compressed = ArrayUtil.Companion.grow(this.compressed, paddedLength);
        in.readBytes(this.compressed, 0, compressedLength);
        this.compressed[compressedLength] = 0;
        decompressor.setInput(this.compressed, 0, paddedLength);
        try {
            bytes.setLength(bytes.getLength() + decompressor.inflate(bytes.getBytes(), bytes.getLength(), bytes.getBytes().length - bytes.getLength()));
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        if (!decompressor.finished()) {
            throw new CorruptIndexException("Invalid decoder state: needsInput=" + decompressor.needsInput() + ", needsDict=" + decompressor.needsDictionary(), in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doDecompress(@NotNull DataInput in, @NotNull BytesRef bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Inflater decompressor = new Inflater(true);
        try {
            this.doDecompress(in, decompressor, bytes);
        }
        finally {
            decompressor.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(@NotNull DataInput in, int originalLength, int offset, int length, @NotNull BytesRef bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (!(offset + length <= originalLength)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (length == 0) {
            bytes.setLength(0);
            return;
        }
        int dictLength = in.readVInt();
        int blockLength = in.readVInt();
        bytes.setBytes(ArrayUtil.Companion.growNoCopy(bytes.getBytes(), dictLength));
        bytes.setLength(0);
        bytes.setOffset(bytes.getLength());
        Inflater decompressor = new Inflater(true);
        try {
            this.doDecompress(in, decompressor, bytes);
            if (dictLength != bytes.getLength()) {
                throw new CorruptIndexException("Unexpected dict length", in);
            }
            int offsetInBlock = dictLength;
            int offsetInBytesRef = offset;
            while (offsetInBlock + blockLength < offset) {
                int compressedLength = in.readVInt();
                in.skipBytes(compressedLength);
                offsetInBlock += blockLength;
                offsetInBytesRef -= blockLength;
            }
            while (offsetInBlock < offset + length) {
                bytes.setBytes(ArrayUtil.Companion.grow(bytes.getBytes(), bytes.getLength() + blockLength));
                decompressor.reset();
                decompressor.setDictionary(bytes.getBytes(), 0, dictLength);
                this.doDecompress(in, decompressor, bytes);
                offsetInBlock += blockLength;
            }
            bytes.setOffset(offsetInBytesRef);
            bytes.setLength(length);
            if (!bytes.isValid()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        finally {
            decompressor.end();
        }
    }

    @Override
    @NotNull
    public Decompressor clone() {
        return new DeflateWithPresetDictDecompressor();
    }
}

