/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.codecs.lucene90.IndexedDISI;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.EmptyDocValuesProducer;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.internal.hppc.LongHashSet;
import org.gnit.lucenekmp.internal.hppc.LongIntHashMap;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.SortedSetSelector;
import org.gnit.lucenekmp.store.ByteArrayDataOutput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.ByteBuffersIndexOutput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.LongsRef;
import org.gnit.lucenekmp.util.MathUtil;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.compress.LZ4;
import org.gnit.lucenekmp.util.packed.DirectMonotonicWriter;
import org.gnit.lucenekmp.util.packed.DirectWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 P2\u00020\u0001:\u0003NOPB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010%\u001a\u00020\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J \u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0002J:\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u0002012\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0018\u00107\u001a\u0002012\u0006\u0010.\u001a\u00020/2\u0006\u00104\u001a\u000201H\u0002J(\u00108\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020*2\u0006\u00109\u001a\u00020\u00052\u0006\u00104\u001a\u0002012\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010=\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010>\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010?\u001a\u00020,H\u0002J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020AH\u0002J \u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020GH\u0002J\u0018\u0010H\u001a\u00020D2\u0006\u0010C\u001a\u00020D2\u0006\u0010I\u001a\u00020\u0005H\u0002J\u0010\u0010J\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020AH\u0002J\u0018\u0010K\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010L\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010M\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer;", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "skipIndexIntervalSize", "", "dataCodec", "", "dataExtension", "metaCodec", "metaExtension", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "data", "Lorg/gnit/lucenekmp/store/IndexOutput;", "getData", "()Lorg/gnit/lucenekmp/store/IndexOutput;", "setData", "(Lorg/gnit/lucenekmp/store/IndexOutput;)V", "meta", "getMeta", "setMeta", "maxDoc", "getMaxDoc", "()I", "setMaxDoc", "(I)V", "termsDictBuffer", "", "close", "", "addNumericField", "field", "Lorg/gnit/lucenekmp/index/FieldInfo;", "valuesProducer", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "writeSkipIndex", "writeLevels", "accumulators", "", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer$SkipAccumulator;", "writeValues", "", "ords", "", "writeValuesSingleBlock", "values", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "numValues", "", "numBitsPerValue", "min", "gcd", "encode", "Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;", "writeValuesMultipleBlocks", "writeBlock", "length", "buffer", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "addBinaryField", "addSortedField", "doAddSortedField", "addTypeByte", "addTermsDict", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "compressAndGetTermsDictBlockLength", "bufferedOutput", "Lorg/gnit/lucenekmp/store/ByteArrayDataOutput;", "dictLength", "ht", "Lorg/gnit/lucenekmp/util/compress/LZ4$FastCompressionHashTable;", "maybeGrowBuffer", "termLength", "writeTermsIndex", "addSortedNumericField", "doAddSortedNumericField", "addSortedSetField", "MinMaxTracker", "SkipAccumulator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90DocValuesConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90DocValuesConsumer.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1039:1\n1#2:1040\n*E\n"})
public final class Lucene90DocValuesConsumer
extends DocValuesConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private IndexOutput data;
    @Nullable
    private IndexOutput meta;
    private int maxDoc;
    @NotNull
    private byte[] termsDictBuffer;
    private int skipIndexIntervalSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90DocValuesConsumer(@NotNull SegmentWriteState state2, int skipIndexIntervalSize, @NotNull String dataCodec, @NotNull String dataExtension, @NotNull String metaCodec, @NotNull String metaExtension) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dataCodec, (String)"dataCodec");
        Intrinsics.checkNotNullParameter((Object)dataExtension, (String)"dataExtension");
        Intrinsics.checkNotNullParameter((Object)metaCodec, (String)"metaCodec");
        Intrinsics.checkNotNullParameter((Object)metaExtension, (String)"metaExtension");
        this.termsDictBuffer = new byte[16384];
        boolean success = false;
        try {
            String dataName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), dataExtension);
            IndexOutput indexOutput = this.data = state2.getDirectory().createOutput(dataName, state2.getContext());
            Intrinsics.checkNotNull((Object)indexOutput);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput, dataCodec, 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            String metaName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), metaExtension);
            IndexOutput indexOutput2 = this.meta = state2.getDirectory().createOutput(metaName, state2.getContext());
            Intrinsics.checkNotNull((Object)indexOutput2);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput2, metaCodec, 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            this.maxDoc = state2.getSegmentInfo().maxDoc();
            this.skipIndexIntervalSize = skipIndexIntervalSize;
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
    }

    @Nullable
    public final IndexOutput getData() {
        return this.data;
    }

    public final void setData(@Nullable IndexOutput indexOutput) {
        this.data = indexOutput;
    }

    @Nullable
    public final IndexOutput getMeta() {
        return this.meta;
    }

    public final void setMeta(@Nullable IndexOutput indexOutput) {
        this.meta = indexOutput;
    }

    public final int getMaxDoc() {
        return this.maxDoc;
    }

    public final void setMaxDoc(int n) {
        this.maxDoc = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean success = false;
        try {
            if (this.meta != null) {
                IndexOutput indexOutput = this.meta;
                Intrinsics.checkNotNull((Object)indexOutput);
                indexOutput.writeInt(-1);
                IndexOutput indexOutput2 = this.meta;
                Intrinsics.checkNotNull((Object)indexOutput2);
                CodecUtil.INSTANCE.writeFooter(indexOutput2);
            }
            if (this.data != null) {
                IndexOutput indexOutput = this.data;
                Intrinsics.checkNotNull((Object)indexOutput);
                CodecUtil.INSTANCE.writeFooter(indexOutput);
            }
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
            Intrinsics.checkNotNull((Object)this.data);
            Intrinsics.checkNotNull((Object)this.meta);
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            this.meta = this.data = null;
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        Intrinsics.checkNotNull((Object)this.data);
        Intrinsics.checkNotNull((Object)this.meta);
        IOUtils.INSTANCE.close(autoCloseableArray);
        this.meta = this.data = null;
    }

    @Override
    public void addNumericField(@NotNull FieldInfo field, @NotNull DocValuesProducer valuesProducer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)valuesProducer, (String)"valuesProducer");
        IndexOutput indexOutput = this.meta;
        if (indexOutput != null) {
            indexOutput.writeInt(field.getNumber());
        }
        IndexOutput indexOutput2 = this.meta;
        if (indexOutput2 != null) {
            indexOutput2.writeByte((byte)0);
        }
        DocValuesProducer producer2 = new EmptyDocValuesProducer(valuesProducer){
            final /* synthetic */ DocValuesProducer $valuesProducer;
            {
                this.$valuesProducer = $valuesProducer;
            }

            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return DocValues.INSTANCE.singleton(this.$valuesProducer.getNumeric(field));
            }
        };
        if (field.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
            this.writeSkipIndex(field, producer2);
        }
        this.writeValues(field, producer2, false);
    }

    private final void writeSkipIndex(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        block14: {
            if (!(field.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IndexOutput indexOutput = this.data;
            Intrinsics.checkNotNull((Object)indexOutput);
            long start = indexOutput.getFilePointer();
            SortedNumericDocValues values2 = valuesProducer.getSortedNumeric(field);
            long globalMaxValue = Long.MIN_VALUE;
            long globalMinValue = Long.MAX_VALUE;
            int globalDocCount = 0;
            int maxDocId = -1;
            List accumulators = new ArrayList();
            SkipAccumulator accumulator = null;
            int maxAccumulators = 512;
            int doc = values2.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                long firstValue = values2.nextValue();
                if (accumulator != null && accumulator.isDone(this.skipIndexIntervalSize, values2.docValueCount(), firstValue, doc)) {
                    globalMaxValue = java.lang.Math.max(globalMaxValue, accumulator.getMaxValue());
                    globalMinValue = java.lang.Math.min(globalMinValue, accumulator.getMinValue());
                    globalDocCount += accumulator.getDocCount();
                    maxDocId = accumulator.getMaxDocID();
                    accumulator = null;
                    if (accumulators.size() == maxAccumulators) {
                        this.writeLevels(accumulators);
                        accumulators.clear();
                    }
                }
                if (accumulator == null) {
                    accumulator = new SkipAccumulator(doc);
                    accumulators.add(accumulator);
                }
                accumulator.nextDoc(doc);
                accumulator.accumulate(firstValue);
                int end = values2.docValueCount();
                for (int i = 1; i < end; ++i) {
                    accumulator.accumulate(values2.nextValue());
                }
                doc = values2.nextDoc();
            }
            if (!accumulators.isEmpty()) {
                SkipAccumulator skipAccumulator = accumulator;
                Intrinsics.checkNotNull(skipAccumulator);
                globalMaxValue = java.lang.Math.max(globalMaxValue, skipAccumulator.getMaxValue());
                globalMinValue = java.lang.Math.min(globalMinValue, accumulator.getMinValue());
                globalDocCount += accumulator.getDocCount();
                maxDocId = accumulator.getMaxDocID();
                this.writeLevels(accumulators);
            }
            IndexOutput indexOutput2 = this.meta;
            if (indexOutput2 != null) {
                indexOutput2.writeLong(start);
            }
            IndexOutput indexOutput3 = this.meta;
            if (indexOutput3 != null) {
                IndexOutput indexOutput4 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput4);
                indexOutput3.writeLong(indexOutput4.getFilePointer() - start);
            }
            if (!(globalDocCount == 0 || globalMaxValue >= globalMinValue)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IndexOutput indexOutput5 = this.meta;
            if (indexOutput5 != null) {
                indexOutput5.writeLong(globalMaxValue);
            }
            IndexOutput indexOutput6 = this.meta;
            if (indexOutput6 != null) {
                indexOutput6.writeLong(globalMinValue);
            }
            if (!(globalDocCount <= maxDocId + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IndexOutput indexOutput7 = this.meta;
            if (indexOutput7 != null) {
                indexOutput7.writeInt(globalDocCount);
            }
            IndexOutput indexOutput8 = this.meta;
            if (indexOutput8 == null) break block14;
            indexOutput8.writeInt(maxDocId);
        }
    }

    private final void writeLevels(List<SkipAccumulator> accumulators) throws IOException {
        List accumulatorsLevels = new ArrayList(4);
        accumulatorsLevels.add(accumulators);
        for (int i = 0; i < 3; ++i) {
            accumulatorsLevels.add(Lucene90DocValuesConsumer.Companion.buildLevel((List)accumulatorsLevels.get(i)));
        }
        int totalAccumulators = accumulators.size();
        for (int index = 0; index < totalAccumulators; ++index) {
            int levels = Lucene90DocValuesConsumer.Companion.getLevels(index, totalAccumulators);
            IndexOutput indexOutput = this.data;
            if (indexOutput != null) {
                indexOutput.writeByte((byte)levels);
            }
            for (int level = levels - 1; -1 < level; --level) {
                SkipAccumulator accumulator = (SkipAccumulator)((List)accumulatorsLevels.get(level)).get(index >> 3 * level);
                IndexOutput indexOutput2 = this.data;
                if (indexOutput2 != null) {
                    indexOutput2.writeInt(accumulator.getMaxDocID());
                }
                IndexOutput indexOutput3 = this.data;
                if (indexOutput3 != null) {
                    indexOutput3.writeInt(accumulator.getMinDocID());
                }
                IndexOutput indexOutput4 = this.data;
                if (indexOutput4 != null) {
                    indexOutput4.writeLong(accumulator.getMaxValue());
                }
                IndexOutput indexOutput5 = this.data;
                if (indexOutput5 != null) {
                    indexOutput5.writeLong(accumulator.getMinValue());
                }
                IndexOutput indexOutput6 = this.data;
                if (indexOutput6 == null) continue;
                indexOutput6.writeInt(accumulator.getDocCount());
            }
        }
    }

    private final long[] writeValues(FieldInfo field, DocValuesProducer valuesProducer, boolean ords) throws IOException {
        SortedNumericDocValues values2 = valuesProducer.getSortedNumeric(field);
        long firstValue = values2.nextDoc() != Integer.MAX_VALUE ? values2.nextValue() : 0L;
        values2 = valuesProducer.getSortedNumeric(field);
        int numDocsWithValue = 0;
        MinMaxTracker minMax = new MinMaxTracker();
        MinMaxTracker blockMinMax = new MinMaxTracker();
        long gcd = 0L;
        LongHashSet uniqueValues = ords ? null : new LongHashSet();
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values2.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = values2.nextValue();
                if (gcd != 1L) {
                    gcd = v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL ? 1L : MathUtil.INSTANCE.gcd(gcd, v - firstValue);
                }
                blockMinMax.update(v);
                if (blockMinMax.getNumValues() == 16384L) {
                    minMax.update(blockMinMax);
                    blockMinMax.nextBlock();
                }
                if (uniqueValues == null || !uniqueValues.add(v) || uniqueValues.size() <= 256) continue;
                uniqueValues = null;
            }
            ++numDocsWithValue;
            doc = values2.nextDoc();
        }
        minMax.update(blockMinMax);
        minMax.finish();
        blockMinMax.finish();
        if (ords && minMax.getNumValues() > 0L) {
            if (!(minMax.getMin() == 0L)) {
                boolean $i$a$-check-Lucene90DocValuesConsumer$writeValues$32 = false;
                String $i$a$-check-Lucene90DocValuesConsumer$writeValues$32 = "The min value for ordinals should always be 0, got " + minMax.getMin();
                throw new IllegalStateException($i$a$-check-Lucene90DocValuesConsumer$writeValues$32.toString());
            }
            if (!(minMax.getMax() == 0L || gcd == 1L)) {
                boolean bl = false;
                String string = "GCD compression should never be used on ordinals, found gcd=" + gcd;
                throw new IllegalStateException(string.toString());
            }
        }
        long numValues = minMax.getNumValues();
        long min = minMax.getMin();
        long max = minMax.getMax();
        if (!(blockMinMax.getSpaceInBits() <= minMax.getSpaceInBits())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (numDocsWithValue == 0) {
            IndexOutput indexOutput = this.meta;
            if (indexOutput != null) {
                indexOutput.writeLong(-2L);
            }
            IndexOutput indexOutput2 = this.meta;
            if (indexOutput2 != null) {
                indexOutput2.writeLong(0L);
            }
            IndexOutput indexOutput3 = this.meta;
            if (indexOutput3 != null) {
                indexOutput3.writeShort((short)-1);
            }
            IndexOutput indexOutput4 = this.meta;
            if (indexOutput4 != null) {
                indexOutput4.writeByte((byte)-1);
            }
        } else if (numDocsWithValue == this.maxDoc) {
            IndexOutput indexOutput = this.meta;
            if (indexOutput != null) {
                indexOutput.writeLong(-1L);
            }
            IndexOutput indexOutput5 = this.meta;
            if (indexOutput5 != null) {
                indexOutput5.writeLong(0L);
            }
            IndexOutput indexOutput6 = this.meta;
            if (indexOutput6 != null) {
                indexOutput6.writeShort((short)-1);
            }
            IndexOutput indexOutput7 = this.meta;
            if (indexOutput7 != null) {
                indexOutput7.writeByte((byte)-1);
            }
        } else {
            IndexOutput indexOutput = this.data;
            Intrinsics.checkNotNull((Object)indexOutput);
            long offset = indexOutput.getFilePointer();
            IndexOutput indexOutput8 = this.meta;
            if (indexOutput8 != null) {
                indexOutput8.writeLong(offset);
            }
            values2 = valuesProducer.getSortedNumeric(field);
            DocIdSetIterator docIdSetIterator = values2;
            IndexOutput indexOutput9 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput9);
            short jumpTableEntryCount = IndexedDISI.Companion.writeBitSet(docIdSetIterator, indexOutput9, (byte)9);
            IndexOutput indexOutput10 = this.meta;
            if (indexOutput10 != null) {
                IndexOutput indexOutput11 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput11);
                indexOutput10.writeLong(indexOutput11.getFilePointer() - offset);
            }
            IndexOutput indexOutput12 = this.meta;
            if (indexOutput12 != null) {
                indexOutput12.writeShort(jumpTableEntryCount);
            }
            IndexOutput indexOutput13 = this.meta;
            if (indexOutput13 != null) {
                indexOutput13.writeByte((byte)9);
            }
        }
        IndexOutput indexOutput = this.meta;
        if (indexOutput != null) {
            indexOutput.writeLong(numValues);
        }
        int numBitsPerValue = 0;
        boolean doBlocks = false;
        LongIntHashMap encode = null;
        if (min >= max) {
            numBitsPerValue = 0;
            IndexOutput indexOutput14 = this.meta;
            if (indexOutput14 != null) {
                indexOutput14.writeInt(-1);
            }
        } else if (uniqueValues != null && uniqueValues.size() > 1 && DirectWriter.Companion.unsignedBitsRequired(uniqueValues.size() - 1) < DirectWriter.Companion.unsignedBitsRequired((max - min) / gcd)) {
            numBitsPerValue = DirectWriter.Companion.unsignedBitsRequired(uniqueValues.size() - 1);
            long[] sortedUniqueValues = uniqueValues.toArray();
            Arrays.INSTANCE.sort(sortedUniqueValues);
            IndexOutput indexOutput15 = this.meta;
            if (indexOutput15 != null) {
                indexOutput15.writeInt(sortedUniqueValues.length);
            }
            for (long v : sortedUniqueValues) {
                IndexOutput indexOutput16 = this.meta;
                if (indexOutput16 == null) continue;
                indexOutput16.writeLong(v);
            }
            encode = new LongIntHashMap();
            int n = sortedUniqueValues.length;
            for (int i = 0; i < n; ++i) {
                encode.put(sortedUniqueValues[i], i);
            }
            min = 0L;
            gcd = 1L;
        } else {
            uniqueValues = null;
            boolean bl = doBlocks = minMax.getSpaceInBits() > 0L && (double)blockMinMax.getSpaceInBits() / (double)minMax.getSpaceInBits() <= 0.9;
            if (doBlocks) {
                numBitsPerValue = 255;
                IndexOutput indexOutput17 = this.meta;
                if (indexOutput17 != null) {
                    indexOutput17.writeInt(-16);
                }
            } else {
                numBitsPerValue = DirectWriter.Companion.unsignedBitsRequired((max - min) / gcd);
                if (gcd == 1L && min > 0L && DirectWriter.Companion.unsignedBitsRequired(max) == DirectWriter.Companion.unsignedBitsRequired(max - min)) {
                    min = 0L;
                }
                IndexOutput indexOutput18 = this.meta;
                if (indexOutput18 != null) {
                    indexOutput18.writeInt(-1);
                }
            }
        }
        IndexOutput indexOutput19 = this.meta;
        if (indexOutput19 != null) {
            indexOutput19.writeByte((byte)numBitsPerValue);
        }
        IndexOutput indexOutput20 = this.meta;
        if (indexOutput20 != null) {
            indexOutput20.writeLong(min);
        }
        IndexOutput indexOutput21 = this.meta;
        if (indexOutput21 != null) {
            indexOutput21.writeLong(gcd);
        }
        IndexOutput indexOutput22 = this.data;
        Intrinsics.checkNotNull((Object)indexOutput22);
        long startOffset = indexOutput22.getFilePointer();
        IndexOutput indexOutput23 = this.meta;
        if (indexOutput23 != null) {
            indexOutput23.writeLong(startOffset);
        }
        long jumpTableOffset = -1L;
        if (doBlocks) {
            jumpTableOffset = this.writeValuesMultipleBlocks(valuesProducer.getSortedNumeric(field), gcd);
        } else if (numBitsPerValue != 0) {
            this.writeValuesSingleBlock(valuesProducer.getSortedNumeric(field), numValues, numBitsPerValue, min, gcd, encode);
        }
        IndexOutput indexOutput24 = this.meta;
        if (indexOutput24 != null) {
            IndexOutput indexOutput25 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput25);
            indexOutput24.writeLong(indexOutput25.getFilePointer() - startOffset);
        }
        IndexOutput indexOutput26 = this.meta;
        if (indexOutput26 != null) {
            indexOutput26.writeLong(jumpTableOffset);
        }
        long[] lArray = new long[]{numDocsWithValue, numValues};
        return lArray;
    }

    private final void writeValuesSingleBlock(SortedNumericDocValues values2, long numValues, int numBitsPerValue, long min, long gcd, LongIntHashMap encode) throws IOException {
        IndexOutput indexOutput = this.data;
        Intrinsics.checkNotNull((Object)indexOutput);
        DirectWriter writer = DirectWriter.Companion.getInstance(indexOutput, numValues, numBitsPerValue);
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values2.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = values2.nextValue();
                if (encode == null) {
                    writer.add((v - min) / gcd);
                    continue;
                }
                writer.add(encode.get(v));
            }
            doc = values2.nextDoc();
        }
        writer.finish();
    }

    private final long writeValuesMultipleBlocks(SortedNumericDocValues values2, long gcd) throws IOException {
        long offsetsOrigo;
        block4: {
            long[] offsets = new long[ArrayUtil.Companion.oversize(1, 8)];
            int offsetsIndex = 0;
            long[] buffer = new long[16384];
            ByteBuffersDataOutput encodeBuffer = ByteBuffersDataOutput.Companion.newResettableInstance();
            int upTo = 0;
            int doc = values2.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int count = values2.docValueCount();
                for (int i = 0; i < count; ++i) {
                    buffer[upTo++] = values2.nextValue();
                    if (upTo != 16384) continue;
                    offsets = ArrayUtil.Companion.grow(offsets, offsetsIndex + 1);
                    int n = offsetsIndex++;
                    IndexOutput indexOutput = this.data;
                    Intrinsics.checkNotNull((Object)indexOutput);
                    offsets[n] = indexOutput.getFilePointer();
                    this.writeBlock(buffer, 16384, gcd, encodeBuffer);
                    upTo = 0;
                }
                doc = values2.nextDoc();
            }
            if (upTo > 0) {
                offsets = ArrayUtil.Companion.grow(offsets, offsetsIndex + 1);
                int n = offsetsIndex++;
                IndexOutput indexOutput = this.data;
                Intrinsics.checkNotNull((Object)indexOutput);
                offsets[n] = indexOutput.getFilePointer();
                this.writeBlock(buffer, upTo, gcd, encodeBuffer);
            }
            IndexOutput indexOutput = this.data;
            Intrinsics.checkNotNull((Object)indexOutput);
            offsetsOrigo = indexOutput.getFilePointer();
            int n = offsetsIndex;
            for (int i = 0; i < n; ++i) {
                IndexOutput indexOutput2 = this.data;
                if (indexOutput2 == null) continue;
                indexOutput2.writeLong(offsets[i]);
            }
            IndexOutput indexOutput3 = this.data;
            if (indexOutput3 == null) break block4;
            indexOutput3.writeLong(offsetsOrigo);
        }
        return offsetsOrigo;
    }

    private final void writeBlock(long[] values2, int length, long gcd, ByteBuffersDataOutput buffer) throws IOException {
        if (!(length > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long min = values2[0];
        long max = values2[0];
        for (int i = 1; i < length; ++i) {
            long v = values2[i];
            if (!(Math.INSTANCE.floorMod(values2[i] - min, gcd) == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            min = java.lang.Math.min(min, v);
            max = java.lang.Math.max(max, v);
        }
        if (min == max) {
            IndexOutput indexOutput = this.data;
            if (indexOutput != null) {
                indexOutput.writeByte((byte)0);
            }
            IndexOutput indexOutput2 = this.data;
            if (indexOutput2 != null) {
                indexOutput2.writeLong(min);
            }
        } else {
            int bitsPerValue = DirectWriter.Companion.unsignedBitsRequired((max - min) / gcd);
            buffer.reset();
            if (!(buffer.size() == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            DirectWriter w = DirectWriter.Companion.getInstance(buffer, length, bitsPerValue);
            for (int i = 0; i < length; ++i) {
                w.add((values2[i] - min) / gcd);
            }
            w.finish();
            IndexOutput indexOutput = this.data;
            if (indexOutput != null) {
                indexOutput.writeByte((byte)bitsPerValue);
            }
            IndexOutput indexOutput3 = this.data;
            if (indexOutput3 != null) {
                indexOutput3.writeLong(min);
            }
            IndexOutput indexOutput4 = this.data;
            if (indexOutput4 != null) {
                indexOutput4.writeInt(Math.INSTANCE.toIntExact(buffer.size()));
            }
            IndexOutput indexOutput5 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput5);
            buffer.copyTo(indexOutput5);
        }
    }

    @Override
    public void addBinaryField(@NotNull FieldInfo field, @NotNull DocValuesProducer valuesProducer) throws IOException {
        block30: {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)valuesProducer, (String)"valuesProducer");
            IndexOutput indexOutput = this.meta;
            if (indexOutput != null) {
                indexOutput.writeInt(field.getNumber());
            }
            IndexOutput indexOutput2 = this.meta;
            if (indexOutput2 != null) {
                indexOutput2.writeByte((byte)1);
            }
            BinaryDocValues values2 = valuesProducer.getBinary(field);
            IndexOutput indexOutput3 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput3);
            long start = indexOutput3.getFilePointer();
            IndexOutput indexOutput4 = this.meta;
            if (indexOutput4 != null) {
                indexOutput4.writeLong(start);
            }
            int numDocsWithField = 0;
            int minLength = Integer.MAX_VALUE;
            int maxLength = 0;
            int doc = values2.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef v;
                ++numDocsWithField;
                Intrinsics.checkNotNull((Object)values2.binaryValue());
                int length = v.getLength();
                IndexOutput indexOutput5 = this.data;
                if (indexOutput5 != null) {
                    indexOutput5.writeBytes(v.getBytes(), v.getOffset(), v.getLength());
                }
                minLength = java.lang.Math.min(length, minLength);
                maxLength = java.lang.Math.max(length, maxLength);
                doc = values2.nextDoc();
            }
            if (!(numDocsWithField <= this.maxDoc)) {
                String length = "Failed requirement.";
                throw new IllegalArgumentException(length.toString());
            }
            IndexOutput indexOutput6 = this.meta;
            if (indexOutput6 != null) {
                IndexOutput indexOutput7 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput7);
                indexOutput6.writeLong(indexOutput7.getFilePointer() - start);
            }
            if (numDocsWithField == 0) {
                IndexOutput indexOutput8 = this.meta;
                if (indexOutput8 != null) {
                    indexOutput8.writeLong(-2L);
                }
                IndexOutput indexOutput9 = this.meta;
                if (indexOutput9 != null) {
                    indexOutput9.writeLong(0L);
                }
                IndexOutput indexOutput10 = this.meta;
                if (indexOutput10 != null) {
                    indexOutput10.writeShort((short)-1);
                }
                IndexOutput indexOutput11 = this.meta;
                if (indexOutput11 != null) {
                    indexOutput11.writeByte((byte)-1);
                }
            } else if (numDocsWithField == this.maxDoc) {
                IndexOutput indexOutput12 = this.meta;
                if (indexOutput12 != null) {
                    indexOutput12.writeLong(-1L);
                }
                IndexOutput indexOutput13 = this.meta;
                if (indexOutput13 != null) {
                    indexOutput13.writeLong(0L);
                }
                IndexOutput indexOutput14 = this.meta;
                if (indexOutput14 != null) {
                    indexOutput14.writeShort((short)-1);
                }
                IndexOutput indexOutput15 = this.meta;
                if (indexOutput15 != null) {
                    indexOutput15.writeByte((byte)-1);
                }
            } else {
                IndexOutput indexOutput16 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput16);
                long offset = indexOutput16.getFilePointer();
                IndexOutput indexOutput17 = this.meta;
                if (indexOutput17 != null) {
                    indexOutput17.writeLong(offset);
                }
                values2 = valuesProducer.getBinary(field);
                DocIdSetIterator docIdSetIterator = values2;
                IndexOutput indexOutput18 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput18);
                short jumpTableEntryCount = IndexedDISI.Companion.writeBitSet(docIdSetIterator, indexOutput18, (byte)9);
                IndexOutput indexOutput19 = this.meta;
                if (indexOutput19 != null) {
                    IndexOutput indexOutput20 = this.data;
                    Intrinsics.checkNotNull((Object)indexOutput20);
                    indexOutput19.writeLong(indexOutput20.getFilePointer() - offset);
                }
                IndexOutput indexOutput21 = this.meta;
                if (indexOutput21 != null) {
                    indexOutput21.writeShort(jumpTableEntryCount);
                }
                IndexOutput indexOutput22 = this.meta;
                if (indexOutput22 != null) {
                    indexOutput22.writeByte((byte)9);
                }
            }
            IndexOutput indexOutput23 = this.meta;
            if (indexOutput23 != null) {
                indexOutput23.writeInt(numDocsWithField);
            }
            IndexOutput indexOutput24 = this.meta;
            if (indexOutput24 != null) {
                indexOutput24.writeInt(minLength);
            }
            IndexOutput indexOutput25 = this.meta;
            if (indexOutput25 != null) {
                indexOutput25.writeInt(maxLength);
            }
            if (maxLength <= minLength) break block30;
            IndexOutput indexOutput26 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput26);
            start = indexOutput26.getFilePointer();
            IndexOutput indexOutput27 = this.meta;
            if (indexOutput27 != null) {
                indexOutput27.writeLong(start);
            }
            IndexOutput indexOutput28 = this.meta;
            if (indexOutput28 != null) {
                indexOutput28.writeVInt(16);
            }
            IndexOutput indexOutput29 = this.meta;
            Intrinsics.checkNotNull((Object)indexOutput29);
            IndexOutput indexOutput30 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput30);
            DirectMonotonicWriter writer = DirectMonotonicWriter.Companion.getInstance(indexOutput29, indexOutput30, (long)numDocsWithField + 1L, 16);
            long addr = 0L;
            writer.add(addr);
            values2 = valuesProducer.getBinary(field);
            int doc2 = values2.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                BytesRef bytesRef = values2.binaryValue();
                Intrinsics.checkNotNull((Object)bytesRef);
                writer.add(addr += (long)bytesRef.getLength());
                doc2 = values2.nextDoc();
            }
            writer.finish();
            IndexOutput indexOutput31 = this.meta;
            if (indexOutput31 != null) {
                IndexOutput indexOutput32 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput32);
                indexOutput31.writeLong(indexOutput32.getFilePointer() - start);
            }
        }
    }

    @Override
    public void addSortedField(@NotNull FieldInfo field, @NotNull DocValuesProducer valuesProducer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)valuesProducer, (String)"valuesProducer");
        IndexOutput indexOutput = this.meta;
        if (indexOutput != null) {
            indexOutput.writeInt(field.getNumber());
        }
        IndexOutput indexOutput2 = this.meta;
        if (indexOutput2 != null) {
            indexOutput2.writeByte((byte)2);
        }
        this.doAddSortedField(field, valuesProducer, false);
    }

    private final void doAddSortedField(FieldInfo field, DocValuesProducer valuesProducer, boolean addTypeByte) throws IOException {
        DocValuesProducer producer2 = new EmptyDocValuesProducer(valuesProducer){
            final /* synthetic */ DocValuesProducer $valuesProducer;
            {
                this.$valuesProducer = $valuesProducer;
            }

            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                SortedDocValues sorted = this.$valuesProducer.getSorted(field);
                NumericDocValues sortedOrds2 = new NumericDocValues(sorted){
                    final /* synthetic */ SortedDocValues $sorted;
                    {
                        this.$sorted = $sorted;
                    }

                    public long longValue() throws IOException {
                        return this.$sorted.ordValue();
                    }

                    public boolean advanceExact(int target) throws IOException {
                        return this.$sorted.advanceExact(target);
                    }

                    public int docID() {
                        return this.$sorted.docID();
                    }

                    public int nextDoc() throws IOException {
                        return this.$sorted.nextDoc();
                    }

                    public int advance(int target) throws IOException {
                        return this.$sorted.advance(target);
                    }

                    public long cost() {
                        return this.$sorted.cost();
                    }
                };
                return DocValues.INSTANCE.singleton(sortedOrds2);
            }
        };
        if (field.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
            this.writeSkipIndex(field, producer2);
        }
        if (addTypeByte) {
            IndexOutput indexOutput = this.meta;
            if (indexOutput != null) {
                indexOutput.writeByte((byte)0);
            }
        }
        this.writeValues(field, producer2, true);
        this.addTermsDict(DocValues.INSTANCE.singleton(valuesProducer.getSorted(field)));
    }

    private final void addTermsDict(SortedSetDocValues values2) throws IOException {
        int uncompressedLength;
        long size2 = values2.getValueCount();
        IndexOutput indexOutput = this.meta;
        if (indexOutput != null) {
            indexOutput.writeVLong(size2);
        }
        int blockMask = 63;
        int shift = 6;
        IndexOutput indexOutput2 = this.meta;
        if (indexOutput2 != null) {
            indexOutput2.writeInt(16);
        }
        ByteBuffersDataOutput addressBuffer = new ByteBuffersDataOutput(0, 0, null, null, 15, null);
        ByteBuffersIndexOutput addressOutput = new ByteBuffersIndexOutput(addressBuffer, "temp", "temp");
        long numBlocks = size2 + (long)blockMask >>> shift;
        IndexOutput indexOutput3 = this.meta;
        Intrinsics.checkNotNull((Object)indexOutput3);
        DirectMonotonicWriter writer = DirectMonotonicWriter.Companion.getInstance(indexOutput3, addressOutput, numBlocks, 16);
        BytesRefBuilder previous = new BytesRefBuilder();
        long ord = 0L;
        IndexOutput indexOutput4 = this.data;
        Intrinsics.checkNotNull((Object)indexOutput4);
        long start = indexOutput4.getFilePointer();
        int maxLength = 0;
        int maxBlockLength = 0;
        TermsEnum iterator2 = values2.termsEnum();
        LZ4.FastCompressionHashTable ht = new LZ4.FastCompressionHashTable();
        ByteArrayDataOutput bufferedOutput = new ByteArrayDataOutput(this.termsDictBuffer);
        int dictLength = 0;
        BytesRef term = iterator2.next();
        while (term != null) {
            if ((ord & (long)blockMask) == 0L) {
                if (ord != 0L) {
                    uncompressedLength = this.compressAndGetTermsDictBlockLength(bufferedOutput, dictLength, ht);
                    maxBlockLength = java.lang.Math.max(maxBlockLength, uncompressedLength);
                    ByteArrayDataOutput.reset$default(bufferedOutput, this.termsDictBuffer, 0, 0, 6, null);
                }
                IndexOutput indexOutput5 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput5);
                writer.add(indexOutput5.getFilePointer() - start);
                IndexOutput indexOutput6 = this.data;
                if (indexOutput6 != null) {
                    indexOutput6.writeVInt(term.getLength());
                }
                IndexOutput indexOutput7 = this.data;
                if (indexOutput7 != null) {
                    indexOutput7.writeBytes(term.getBytes(), term.getOffset(), term.getLength());
                }
                bufferedOutput = this.maybeGrowBuffer(bufferedOutput, term.getLength());
                bufferedOutput.writeBytes(term.getBytes(), term.getOffset(), term.getLength());
                dictLength = term.getLength();
            } else {
                int prefixLength = StringHelper.INSTANCE.bytesDifference(previous.get(), term);
                int suffixLength = term.getLength() - prefixLength;
                if (!(suffixLength > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                bufferedOutput = this.maybeGrowBuffer(bufferedOutput, suffixLength + 11);
                bufferedOutput.writeByte((byte)(java.lang.Math.min(prefixLength, 15) | java.lang.Math.min(15, suffixLength - 1) << 4));
                if (prefixLength >= 15) {
                    bufferedOutput.writeVInt(prefixLength - 15);
                }
                if (suffixLength >= 16) {
                    bufferedOutput.writeVInt(suffixLength - 16);
                }
                bufferedOutput.writeBytes(term.getBytes(), term.getOffset() + prefixLength, suffixLength);
            }
            maxLength = java.lang.Math.max(maxLength, term.getLength());
            previous.copyBytes(term);
            ++ord;
            term = iterator2.next();
        }
        if (bufferedOutput.getPosition() > dictLength) {
            uncompressedLength = this.compressAndGetTermsDictBlockLength(bufferedOutput, dictLength, ht);
            maxBlockLength = java.lang.Math.max(maxBlockLength, uncompressedLength);
        }
        writer.finish();
        IndexOutput indexOutput8 = this.meta;
        if (indexOutput8 != null) {
            indexOutput8.writeInt(maxLength);
        }
        IndexOutput indexOutput9 = this.meta;
        if (indexOutput9 != null) {
            indexOutput9.writeInt(maxBlockLength);
        }
        IndexOutput indexOutput10 = this.meta;
        if (indexOutput10 != null) {
            indexOutput10.writeLong(start);
        }
        IndexOutput indexOutput11 = this.meta;
        if (indexOutput11 != null) {
            IndexOutput indexOutput12 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput12);
            indexOutput11.writeLong(indexOutput12.getFilePointer() - start);
        }
        IndexOutput indexOutput13 = this.data;
        Intrinsics.checkNotNull((Object)indexOutput13);
        start = indexOutput13.getFilePointer();
        IndexOutput indexOutput14 = this.data;
        Intrinsics.checkNotNull((Object)indexOutput14);
        addressBuffer.copyTo(indexOutput14);
        IndexOutput indexOutput15 = this.meta;
        if (indexOutput15 != null) {
            indexOutput15.writeLong(start);
        }
        IndexOutput indexOutput16 = this.meta;
        if (indexOutput16 != null) {
            IndexOutput indexOutput17 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput17);
            indexOutput16.writeLong(indexOutput17.getFilePointer() - start);
        }
        this.writeTermsIndex(values2);
    }

    private final int compressAndGetTermsDictBlockLength(ByteArrayDataOutput bufferedOutput, int dictLength, LZ4.FastCompressionHashTable ht) throws IOException {
        int uncompressedLength = bufferedOutput.getPosition() - dictLength;
        IndexOutput indexOutput = this.data;
        if (indexOutput != null) {
            indexOutput.writeVInt(uncompressedLength);
        }
        IndexOutput indexOutput2 = this.data;
        Intrinsics.checkNotNull((Object)indexOutput2);
        LZ4.INSTANCE.compressWithDictionary(this.termsDictBuffer, 0, dictLength, uncompressedLength, indexOutput2, ht);
        return uncompressedLength;
    }

    private final ByteArrayDataOutput maybeGrowBuffer(ByteArrayDataOutput bufferedOutput, int termLength) {
        int originalLength;
        ByteArrayDataOutput bufferedOutput2 = bufferedOutput;
        int pos = bufferedOutput2.getPosition();
        if (pos + termLength >= (originalLength = this.termsDictBuffer.length) - 1) {
            this.termsDictBuffer = ArrayUtil.Companion.grow(this.termsDictBuffer, originalLength + termLength);
            bufferedOutput2 = new ByteArrayDataOutput(this.termsDictBuffer, pos, this.termsDictBuffer.length - pos);
        }
        return bufferedOutput2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeTermsIndex(SortedSetDocValues values2) throws IOException {
        long size2 = values2.getValueCount();
        IndexOutput indexOutput = this.meta;
        if (indexOutput != null) {
            indexOutput.writeInt(10);
        }
        long start = 0L;
        IndexOutput indexOutput2 = this.data;
        Intrinsics.checkNotNull((Object)indexOutput2);
        start = indexOutput2.getFilePointer();
        long numBlocks = 1L + (size2 + (long)1023 >>> 10);
        ByteBuffersDataOutput addressBuffer = new ByteBuffersDataOutput(0, 0, null, null, 15, null);
        DirectMonotonicWriter writer = null;
        AutoCloseable autoCloseable = new ByteBuffersIndexOutput(addressBuffer, "temp", "temp");
        Throwable throwable = null;
        try {
            Unit unit;
            ByteBuffersIndexOutput addressOutput = (ByteBuffersIndexOutput)autoCloseable;
            boolean bl = false;
            IndexOutput indexOutput3 = this.meta;
            Intrinsics.checkNotNull((Object)indexOutput3);
            writer = DirectMonotonicWriter.Companion.getInstance(indexOutput3, addressOutput, numBlocks, 16);
            TermsEnum iterator2 = values2.termsEnum();
            BytesRefBuilder previous = new BytesRefBuilder();
            long offset = 0L;
            long ord = 0L;
            BytesRef term = iterator2.next();
            while (term != null) {
                if ((ord & 0x3FFL) == 0L) {
                    writer.add(offset);
                    int sortKeyLength = ord == 0L ? 0 : StringHelper.INSTANCE.sortKeyLength(previous.get(), term);
                    offset += (long)sortKeyLength;
                    IndexOutput indexOutput4 = this.data;
                    if (indexOutput4 != null) {
                        indexOutput4.writeBytes(term.getBytes(), term.getOffset(), sortKeyLength);
                    }
                } else if ((ord & 0x3FFL) == 1023L) {
                    previous.copyBytes(term);
                }
                ++ord;
                term = iterator2.next();
            }
            writer.add(offset);
            writer.finish();
            IndexOutput indexOutput5 = this.meta;
            if (indexOutput5 != null) {
                indexOutput5.writeLong(start);
            }
            IndexOutput indexOutput6 = this.meta;
            if (indexOutput6 != null) {
                IndexOutput indexOutput7 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput7);
                indexOutput6.writeLong(indexOutput7.getFilePointer() - start);
            }
            IndexOutput indexOutput8 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput8);
            start = indexOutput8.getFilePointer();
            IndexOutput indexOutput9 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput9);
            addressBuffer.copyTo(indexOutput9);
            IndexOutput indexOutput10 = this.meta;
            if (indexOutput10 != null) {
                indexOutput10.writeLong(start);
            }
            IndexOutput indexOutput11 = this.meta;
            if (indexOutput11 != null) {
                IndexOutput indexOutput12 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput12);
                indexOutput11.writeLong(indexOutput12.getFilePointer() - start);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void addSortedNumericField(@NotNull FieldInfo field, @NotNull DocValuesProducer valuesProducer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)valuesProducer, (String)"valuesProducer");
        IndexOutput indexOutput = this.meta;
        if (indexOutput != null) {
            indexOutput.writeInt(field.getNumber());
        }
        IndexOutput indexOutput2 = this.meta;
        if (indexOutput2 != null) {
            indexOutput2.writeByte((byte)4);
        }
        this.doAddSortedNumericField(field, valuesProducer, false);
    }

    private final void doAddSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer, boolean ords) throws IOException {
        block9: {
            int numDocsWithField;
            long[] stats;
            long numValues;
            if (field.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
                this.writeSkipIndex(field, valuesProducer);
            }
            if (ords) {
                IndexOutput indexOutput = this.meta;
                if (indexOutput != null) {
                    indexOutput.writeByte((byte)1);
                }
            }
            if (!((numValues = (stats = this.writeValues(field, valuesProducer, ords))[1]) >= (long)(numDocsWithField = Math.INSTANCE.toIntExact(stats[0])))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IndexOutput indexOutput = this.meta;
            if (indexOutput != null) {
                indexOutput.writeInt(numDocsWithField);
            }
            if (numValues <= (long)numDocsWithField) break block9;
            IndexOutput indexOutput2 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput2);
            long start = indexOutput2.getFilePointer();
            IndexOutput indexOutput3 = this.meta;
            if (indexOutput3 != null) {
                indexOutput3.writeLong(start);
            }
            IndexOutput indexOutput4 = this.meta;
            if (indexOutput4 != null) {
                indexOutput4.writeVInt(16);
            }
            IndexOutput indexOutput5 = this.meta;
            Intrinsics.checkNotNull((Object)indexOutput5);
            IndexOutput indexOutput6 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput6);
            DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.Companion.getInstance(indexOutput5, indexOutput6, (long)numDocsWithField + 1L, 16);
            long addr = 0L;
            addressesWriter.add(addr);
            SortedNumericDocValues values2 = valuesProducer.getSortedNumeric(field);
            int doc = values2.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                addressesWriter.add(addr += (long)values2.docValueCount());
                doc = values2.nextDoc();
            }
            addressesWriter.finish();
            IndexOutput indexOutput7 = this.meta;
            if (indexOutput7 != null) {
                IndexOutput indexOutput8 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput8);
                indexOutput7.writeLong(indexOutput8.getFilePointer() - start);
            }
        }
    }

    @Override
    public void addSortedSetField(@NotNull FieldInfo field, @NotNull DocValuesProducer valuesProducer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)valuesProducer, (String)"valuesProducer");
        IndexOutput indexOutput = this.meta;
        if (indexOutput != null) {
            indexOutput.writeInt(field.getNumber());
        }
        IndexOutput indexOutput2 = this.meta;
        if (indexOutput2 != null) {
            indexOutput2.writeByte((byte)3);
        }
        if (Lucene90DocValuesConsumer.Companion.isSingleValued(valuesProducer.getSortedSet(field))) {
            this.doAddSortedField(field, new EmptyDocValuesProducer(valuesProducer){
                final /* synthetic */ DocValuesProducer $valuesProducer;
                {
                    this.$valuesProducer = $valuesProducer;
                }

                public SortedDocValues getSorted(FieldInfo field) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    return SortedSetSelector.INSTANCE.wrap(this.$valuesProducer.getSortedSet(field), SortedSetSelector.Type.MIN);
                }
            }, true);
            return;
        }
        this.doAddSortedNumericField(field, new EmptyDocValuesProducer(valuesProducer){
            final /* synthetic */ DocValuesProducer $valuesProducer;
            {
                this.$valuesProducer = $valuesProducer;
            }

            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                SortedSetDocValues values2 = this.$valuesProducer.getSortedSet(field);
                return new SortedNumericDocValues(values2){
                    private long[] ords;
                    private int i;
                    private int docValueCount;
                    final /* synthetic */ SortedSetDocValues $values;
                    {
                        this.$values = $values;
                        this.ords = LongsRef.Companion.getEMPTY_LONGS();
                    }

                    public final long[] getOrds() {
                        return this.ords;
                    }

                    public final void setOrds(long[] lArray) {
                        Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
                        this.ords = lArray;
                    }

                    public final int getI() {
                        return this.i;
                    }

                    public final void setI(int n) {
                        this.i = n;
                    }

                    public final int getDocValueCount() {
                        return this.docValueCount;
                    }

                    public final void setDocValueCount(int n) {
                        this.docValueCount = n;
                    }

                    public long nextValue() throws IOException {
                        int n = this.i;
                        this.i = n + 1;
                        return this.ords[n];
                    }

                    public int docValueCount() {
                        return this.docValueCount;
                    }

                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public int docID() {
                        return this.$values.docID();
                    }

                    public int nextDoc() throws IOException {
                        int doc = this.$values.nextDoc();
                        if (doc != Integer.MAX_VALUE) {
                            this.docValueCount = this.$values.docValueCount();
                            this.ords = ArrayUtil.Companion.grow(this.ords, this.docValueCount);
                            int n = this.docValueCount;
                            for (int j = 0; j < n; ++j) {
                                this.ords[j] = this.$values.nextOrd();
                            }
                            this.i = 0;
                        }
                        return doc;
                    }

                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public long cost() {
                        return this.$values.cost();
                    }
                };
            }
        }, true);
        this.addTermsDict(valuesProducer.getSortedSet(field));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer$Companion;", "", "<init>", "()V", "buildLevel", "", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer$SkipAccumulator;", "accumulators", "getLevels", "", "index", "size", "isSingleValued", "", "values", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final List<SkipAccumulator> buildLevel(List<SkipAccumulator> accumulators) {
            int levelSize = 8;
            List collector2 = new ArrayList();
            for (int i = 0; i < accumulators.size() - levelSize + 1; i += levelSize) {
                collector2.add(SkipAccumulator.Companion.merge(accumulators, i, levelSize));
            }
            return collector2;
        }

        private final int getLevels(int index, int size2) {
            if (IntExtKt.numberOfTrailingZeros(IntCompanionObject.INSTANCE, index) >= 3) {
                int left = size2 - index;
                for (int level = 3; 0 < level; --level) {
                    int numberIntervals = 1 << 3 * level;
                    if (left < numberIntervals || index % numberIntervals != 0) continue;
                    return level + 1;
                }
            }
            return 1;
        }

        private final boolean isSingleValued(SortedSetDocValues values2) throws IOException {
            if (DocValues.INSTANCE.unwrapSingleton(values2) != null) {
                return true;
            }
            if (!(values2.docID() == -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int doc = values2.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int docValueCount = values2.docValueCount();
                if (!(docValueCount > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (docValueCount > 1) {
                    return false;
                }
                doc = values2.nextDoc();
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0014J\u0006\u0010\u0019\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer$MinMaxTracker;", "", "<init>", "()V", "min", "", "getMin", "()J", "setMin", "(J)V", "max", "getMax", "setMax", "numValues", "getNumValues", "setNumValues", "spaceInBits", "getSpaceInBits", "setSpaceInBits", "reset", "", "update", "v", "other", "finish", "nextBlock", "core"})
    private static final class MinMaxTracker {
        private long min;
        private long max;
        private long numValues;
        private long spaceInBits;

        public MinMaxTracker() {
            this.reset();
            this.spaceInBits = 0L;
        }

        public final long getMin() {
            return this.min;
        }

        public final void setMin(long l) {
            this.min = l;
        }

        public final long getMax() {
            return this.max;
        }

        public final void setMax(long l) {
            this.max = l;
        }

        public final long getNumValues() {
            return this.numValues;
        }

        public final void setNumValues(long l) {
            this.numValues = l;
        }

        public final long getSpaceInBits() {
            return this.spaceInBits;
        }

        public final void setSpaceInBits(long l) {
            this.spaceInBits = l;
        }

        public final void reset() {
            this.min = Long.MAX_VALUE;
            this.max = Long.MIN_VALUE;
            this.numValues = 0L;
        }

        public final void update(long v) {
            this.min = java.lang.Math.min(this.min, v);
            this.max = java.lang.Math.max(this.max, v);
            ++this.numValues;
        }

        public final void update(@NotNull MinMaxTracker other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.min = java.lang.Math.min(this.min, other.min);
            this.max = java.lang.Math.max(this.max, other.max);
            this.numValues += other.numValues;
        }

        public final void finish() {
            if (this.max > this.min) {
                this.spaceInBits += (long)DirectWriter.Companion.unsignedBitsRequired(this.max - this.min) * this.numValues;
            }
        }

        public final void nextBlock() {
            this.finish();
            this.reset();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0003R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0005R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\u0005R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer$SkipAccumulator;", "", "minDocID", "", "<init>", "(I)V", "getMinDocID", "()I", "setMinDocID", "maxDocID", "getMaxDocID", "setMaxDocID", "docCount", "getDocCount", "setDocCount", "minValue", "", "getMinValue", "()J", "setMinValue", "(J)V", "maxValue", "getMaxValue", "setMaxValue", "isDone", "", "skipIndexIntervalSize", "valueCount", "nextValue", "nextDoc", "accumulate", "", "value", "other", "docID", "Companion", "core"})
    private static final class SkipAccumulator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int minDocID;
        private int maxDocID;
        private int docCount;
        private long minValue;
        private long maxValue;

        public SkipAccumulator(int minDocID) {
            this.minDocID = minDocID;
            this.minValue = Long.MAX_VALUE;
            this.maxValue = Long.MIN_VALUE;
        }

        public final int getMinDocID() {
            return this.minDocID;
        }

        public final void setMinDocID(int n) {
            this.minDocID = n;
        }

        public final int getMaxDocID() {
            return this.maxDocID;
        }

        public final void setMaxDocID(int n) {
            this.maxDocID = n;
        }

        public final int getDocCount() {
            return this.docCount;
        }

        public final void setDocCount(int n) {
            this.docCount = n;
        }

        public final long getMinValue() {
            return this.minValue;
        }

        public final void setMinValue(long l) {
            this.minValue = l;
        }

        public final long getMaxValue() {
            return this.maxValue;
        }

        public final void setMaxValue(long l) {
            this.maxValue = l;
        }

        public final boolean isDone(int skipIndexIntervalSize, int valueCount, long nextValue, int nextDoc) {
            if (this.docCount < skipIndexIntervalSize) {
                return false;
            }
            return valueCount > 1 || this.minValue != this.maxValue || this.minValue != nextValue || this.docCount != nextDoc - this.minDocID;
        }

        public final void accumulate(long value) {
            this.minValue = java.lang.Math.min(this.minValue, value);
            this.maxValue = java.lang.Math.max(this.maxValue, value);
        }

        public final void accumulate(@NotNull SkipAccumulator other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!(this.minDocID <= other.minDocID && this.maxDocID < other.maxDocID)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.maxDocID = other.maxDocID;
            this.minValue = java.lang.Math.min(this.minValue, other.minValue);
            this.maxValue = java.lang.Math.max(this.maxValue, other.maxValue);
            this.docCount += other.docCount;
        }

        public final void nextDoc(int docID) {
            this.maxDocID = docID;
            ++this.docCount;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer$SkipAccumulator$Companion;", "", "<init>", "()V", "merge", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesConsumer$SkipAccumulator;", "list", "", "index", "", "length", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SkipAccumulator merge(@NotNull List<SkipAccumulator> list, int index, int length) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                SkipAccumulator acc = new SkipAccumulator(list.get(index).getMinDocID());
                for (int i = 0; i < length; ++i) {
                    acc.accumulate(list.get(index + i));
                }
                return acc;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

