/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.codecs.DocValuesFormat;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.codecs.lucene90.Lucene90DocValuesConsumer;
import org.gnit.lucenekmp.codecs.lucene90.Lucene90DocValuesProducer;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesFormat;", "Lorg/gnit/lucenekmp/codecs/DocValuesFormat;", "skipIndexIntervalSize", "", "<init>", "(I)V", "fieldsConsumer", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "fieldsProducer", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90DocValuesFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90DocValuesFormat.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class Lucene90DocValuesFormat
extends DocValuesFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int skipIndexIntervalSize;
    @NotNull
    public static final String DATA_CODEC = "Lucene90DocValuesData";
    @NotNull
    public static final String DATA_EXTENSION = "dvd";
    @NotNull
    public static final String META_CODEC = "Lucene90DocValuesMetadata";
    @NotNull
    public static final String META_EXTENSION = "dvm";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final byte NUMERIC = 0;
    public static final byte BINARY = 1;
    public static final byte SORTED = 2;
    public static final byte SORTED_SET = 3;
    public static final byte SORTED_NUMERIC = 4;
    public static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    public static final int NUMERIC_BLOCK_SHIFT = 14;
    public static final int NUMERIC_BLOCK_SIZE = 16384;
    public static final int TERMS_DICT_BLOCK_LZ4_SHIFT = 6;
    public static final int TERMS_DICT_BLOCK_LZ4_SIZE = 64;
    public static final int TERMS_DICT_BLOCK_LZ4_MASK = 63;
    public static final int TERMS_DICT_REVERSE_INDEX_SHIFT = 10;
    public static final int TERMS_DICT_REVERSE_INDEX_SIZE = 1024;
    public static final int TERMS_DICT_REVERSE_INDEX_MASK = 1023;
    private static final int DEFAULT_SKIP_INDEX_INTERVAL_SIZE = 4096;
    private static final long SKIP_INDEX_INTERVAL_BYTES = 29L;
    public static final int SKIP_INDEX_LEVEL_SHIFT = 3;
    public static final int SKIP_INDEX_MAX_LEVEL = 4;
    @NotNull
    private static final long[] SKIP_INDEX_JUMP_LENGTH_PER_LEVEL = new long[4];

    @JvmOverloads
    public Lucene90DocValuesFormat(int skipIndexIntervalSize) {
        super("Lucene90");
        if (!(skipIndexIntervalSize >= 2)) {
            boolean bl = false;
            String string = "skipIndexIntervalSize must be > 1, got [" + skipIndexIntervalSize + "]";
            throw new IllegalArgumentException(string.toString());
        }
        this.skipIndexIntervalSize = skipIndexIntervalSize;
    }

    public /* synthetic */ Lucene90DocValuesFormat(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        this(n);
    }

    @Override
    @NotNull
    public DocValuesConsumer fieldsConsumer(@NotNull SegmentWriteState state2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return new Lucene90DocValuesConsumer(state2, this.skipIndexIntervalSize, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    @Override
    @NotNull
    public DocValuesProducer fieldsProducer(@NotNull SegmentReadState state2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return new Lucene90DocValuesProducer(state2, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    @JvmOverloads
    public Lucene90DocValuesFormat() {
        this(0, 1, null);
    }

    static {
        Lucene90DocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[0] = 24L;
        for (int level = 1; level < 4; ++level) {
            Lucene90DocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level] = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level - 1];
            long[] lArray = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL;
            int n = level;
            lArray[n] = lArray[n] + (long)(1 << level * 3) * 29L;
            lArray = SKIP_INDEX_JUMP_LENGTH_PER_LEVEL;
            n = level;
            lArray[n] = lArray[n] - (long)(1 << (level - 1) * 3);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesFormat$Companion;", "", "<init>", "()V", "DATA_CODEC", "", "DATA_EXTENSION", "META_CODEC", "META_EXTENSION", "VERSION_START", "", "VERSION_CURRENT", "NUMERIC", "", "BINARY", "SORTED", "SORTED_SET", "SORTED_NUMERIC", "DIRECT_MONOTONIC_BLOCK_SHIFT", "NUMERIC_BLOCK_SHIFT", "NUMERIC_BLOCK_SIZE", "TERMS_DICT_BLOCK_LZ4_SHIFT", "TERMS_DICT_BLOCK_LZ4_SIZE", "TERMS_DICT_BLOCK_LZ4_MASK", "TERMS_DICT_REVERSE_INDEX_SHIFT", "TERMS_DICT_REVERSE_INDEX_SIZE", "TERMS_DICT_REVERSE_INDEX_MASK", "DEFAULT_SKIP_INDEX_INTERVAL_SIZE", "SKIP_INDEX_INTERVAL_BYTES", "", "SKIP_INDEX_LEVEL_SHIFT", "SKIP_INDEX_MAX_LEVEL", "SKIP_INDEX_JUMP_LENGTH_PER_LEVEL", "", "getSKIP_INDEX_JUMP_LENGTH_PER_LEVEL", "()[J", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final long[] getSKIP_INDEX_JUMP_LENGTH_PER_LEVEL() {
            return SKIP_INDEX_JUMP_LENGTH_PER_LEVEL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

