/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.LiveDocsFormat;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90LiveDocsFormat;", "Lorg/gnit/lucenekmp/codecs/LiveDocsFormat;", "<init>", "()V", "readLiveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "info", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "readFixedBitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "input", "Lorg/gnit/lucenekmp/store/IndexInput;", "length", "", "writeLiveDocs", "", "bits", "newDelCount", "writeBits", "output", "Lorg/gnit/lucenekmp/store/IndexOutput;", "files", "", "", "Companion", "core"})
public final class Lucene90LiveDocsFormat
extends LiveDocsFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXTENSION = "liv";
    @NotNull
    private static final String CODEC_NAME = "Lucene90LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bits readLiveDocs(@NotNull Directory dir, @NotNull SegmentCommitInfo info, @NotNull IOContext context) throws IOException {
        block13: {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            long gen = info.getDelGen();
            String string = IndexFileNames.INSTANCE.fileNameFromGeneration(info.getInfo().getName(), EXTENSION, gen);
            Intrinsics.checkNotNull((Object)string);
            String name = string;
            int length = info.getInfo().maxDoc();
            AutoCloseable autoCloseable = dir.openChecksumInput(name);
            Throwable throwable = null;
            try {
                Bits bits;
                ChecksumIndexInput input = (ChecksumIndexInput)autoCloseable;
                boolean bl = false;
                Throwable priorE = null;
                try {
                    DataInput dataInput = input;
                    byte[] byArray = info.getInfo().getId();
                    String string2 = Long.toString(gen, CharsKt.checkRadix((int)RangesKt.coerceIn((int)36, (int)2, (int)36)));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    CodecUtil.INSTANCE.checkIndexHeader(dataInput, CODEC_NAME, 0, 0, byArray, string2);
                    FixedBitSet fbs = this.readFixedBitSet(input, length);
                    if (fbs.length() - fbs.cardinality() != info.getDelCount()) {
                        throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info.getDelCount(), input);
                    }
                    bits = fbs.asReadOnlyBits();
                }
                catch (Throwable exception) {
                    try {
                        try {
                            priorE = exception;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            CodecUtil.INSTANCE.checkFooter(input, priorE);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block13;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
                CodecUtil.INSTANCE.checkFooter(input, priorE);
                Bits bits2 = bits;
                return bits2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        throw new AssertionError();
    }

    private final FixedBitSet readFixedBitSet(IndexInput input, int length) throws IOException {
        long[] data = new long[FixedBitSet.Companion.bits2words(length)];
        input.readLongs(data, 0, data.length);
        return new FixedBitSet(data, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLiveDocs(@NotNull Bits bits, @NotNull Directory dir, @NotNull SegmentCommitInfo info, int newDelCount, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long gen = info.getNextDelGen();
        String name = IndexFileNames.INSTANCE.fileNameFromGeneration(info.getInfo().getName(), EXTENSION, gen);
        int delCount = 0;
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        AutoCloseable autoCloseable = dir.createOutput(string, context);
        Throwable throwable = null;
        try {
            IndexOutput output = (IndexOutput)autoCloseable;
            boolean bl = false;
            DataOutput dataOutput = output;
            byte[] byArray = info.getInfo().getId();
            String string2 = Long.toString(gen, CharsKt.checkRadix((int)RangesKt.coerceIn((int)36, (int)2, (int)36)));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            CodecUtil.INSTANCE.writeIndexHeader(dataOutput, CODEC_NAME, 0, byArray, string2);
            delCount = this.writeBits(output, bits);
            CodecUtil.INSTANCE.writeFooter(output);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        if (delCount != info.getDelCount() + newDelCount) {
            throw new CorruptIndexException("bits.deleted=" + delCount + " info.delcount=" + info.getDelCount() + " newdelcount=" + newDelCount, name, null, 4, null);
        }
    }

    private final int writeBits(IndexOutput output, Bits bits) throws IOException {
        int delCount = 0;
        int longCount = FixedBitSet.Companion.bits2words(bits.length());
        for (int i = 0; i < longCount; ++i) {
            int j;
            long currentBits = 0L;
            int end = Math.min(j + 63, bits.length() - 1);
            for (j = i << 6; j <= end; ++j) {
                if (bits.get(j)) {
                    currentBits |= 1L << j;
                    continue;
                }
                ++delCount;
            }
            output.writeLong(currentBits);
        }
        return delCount;
    }

    @Override
    public void files(@NotNull SegmentCommitInfo info, @NotNull Collection<String> files) throws IOException {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (info.hasDeletions()) {
            String string = IndexFileNames.INSTANCE.fileNameFromGeneration(info.getInfo().getName(), EXTENSION, info.getDelGen());
            Intrinsics.checkNotNull((Object)string);
            files.add(string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90LiveDocsFormat$Companion;", "", "<init>", "()V", "EXTENSION", "", "CODEC_NAME", "VERSION_START", "", "VERSION_CURRENT", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

