/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.PointsReader;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.internal.hppc.IntObjectHashMap;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.bkd.BKDReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90PointsReader;", "Lorg/gnit/lucenekmp/codecs/PointsReader;", "readState", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentReadState;)V", "indexIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "dataIn", "readers", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "Lorg/gnit/lucenekmp/index/PointValues;", "getValues", "fieldName", "", "checkIntegrity", "", "close", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90PointsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90PointsReader.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90PointsReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class Lucene90PointsReader
extends PointsReader {
    @NotNull
    private final SegmentReadState readState;
    @NotNull
    private IndexInput indexIn;
    @NotNull
    private IndexInput dataIn;
    @NotNull
    private final IntObjectHashMap<PointValues> readers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90PointsReader(@NotNull SegmentReadState readState) {
        Intrinsics.checkNotNullParameter((Object)readState, (String)"readState");
        this.readState = readState;
        this.readers = new IntObjectHashMap();
        String metaFileName = IndexFileNames.INSTANCE.segmentFileName(this.readState.getSegmentInfo().getName(), this.readState.getSegmentSuffix(), "kdm");
        String indexFileName = IndexFileNames.INSTANCE.segmentFileName(this.readState.getSegmentInfo().getName(), this.readState.getSegmentSuffix(), "kdi");
        String dataFileName = IndexFileNames.INSTANCE.segmentFileName(this.readState.getSegmentInfo().getName(), this.readState.getSegmentSuffix(), "kdd");
        boolean success = false;
        try {
            this.indexIn = this.readState.getDirectory().openInput(indexFileName, this.readState.getContext().withReadAdvice(ReadAdvice.RANDOM_PRELOAD));
            CodecUtil.INSTANCE.checkIndexHeader(this.indexIn, "Lucene90PointsFormatIndex", 0, 0, this.readState.getSegmentInfo().getId(), this.readState.getSegmentSuffix());
            CodecUtil.INSTANCE.retrieveChecksum(this.indexIn);
            this.dataIn = this.readState.getDirectory().openInput(dataFileName, this.readState.getContext().withReadAdvice(ReadAdvice.NORMAL));
            CodecUtil.INSTANCE.checkIndexHeader(this.dataIn, "Lucene90PointsFormatData", 0, 0, this.readState.getSegmentInfo().getId(), this.readState.getSegmentSuffix());
            CodecUtil.INSTANCE.retrieveChecksum(this.dataIn);
            long indexLength = 0L;
            indexLength = -1L;
            long dataLength = 0L;
            dataLength = -1L;
            AutoCloseable autoCloseable = this.readState.getDirectory().openChecksumInput(metaFileName);
            Throwable throwable = null;
            try {
                ChecksumIndexInput metaIn = (ChecksumIndexInput)autoCloseable;
                boolean bl = false;
                Throwable priorE = null;
                try {
                    int fieldNumber;
                    CodecUtil.INSTANCE.checkIndexHeader(metaIn, "Lucene90PointsFormatMeta", 0, 0, this.readState.getSegmentInfo().getId(), this.readState.getSegmentSuffix());
                    while ((fieldNumber = metaIn.readInt()) != -1) {
                        if (fieldNumber < 0) {
                            throw new CorruptIndexException("Illegal field number: " + fieldNumber, metaIn);
                        }
                        PointValues reader2 = new BKDReader(metaIn, this.indexIn, this.dataIn);
                        this.readers.put(fieldNumber, reader2);
                    }
                    indexLength = metaIn.readLong();
                    dataLength = metaIn.readLong();
                }
                catch (Throwable t) {
                    priorE = t;
                }
                finally {
                    CodecUtil.INSTANCE.checkFooter(metaIn, priorE);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            CodecUtil.INSTANCE.retrieveChecksum(this.indexIn, indexLength);
            CodecUtil.INSTANCE.retrieveChecksum(this.dataIn, dataLength);
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
    }

    @Override
    @NotNull
    public PointValues getValues(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        FieldInfo fieldInfo = this.readState.getFieldInfos().fieldInfo(fieldName);
        if (fieldInfo == null) {
            boolean bl = false;
            String string = "field=\"" + fieldName + "\" is unrecognized";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(fieldInfo.getPointDimensionCount() != 0)) {
            boolean bl = false;
            String string = "field=\"" + fieldName + "\" did not index point values";
            throw new IllegalArgumentException(string.toString());
        }
        PointValues pointValues = this.readers.get(fieldInfo.getNumber());
        Intrinsics.checkNotNull((Object)pointValues);
        return pointValues;
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.INSTANCE.checksumEntireFile(this.indexIn);
        CodecUtil.INSTANCE.checksumEntireFile(this.dataIn);
    }

    @Override
    public void close() throws IOException {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.indexIn, this.dataIn};
        IOUtils.INSTANCE.close(autoCloseableArray);
        this.readers.clear();
    }
}

