/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.blocktree;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.IntersectTermsEnum;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.SegmentTermsEnum;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.Stats;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.store.ByteArrayDataInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.automaton.ByteRunnable;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.gnit.lucenekmp.util.automaton.TransitionAccessor;
import org.gnit.lucenekmp.util.fst.ByteSequenceOutputs;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.OffHeapFSTStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 C2\u00020\u0001:\u0001CBi\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\t\u0012\u0006\u0010\u0013\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000206H\u0016J\b\u00108\u001a\u000206H\u0016J\b\u00109\u001a\u000206H\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0007H\u0016J\u001a\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010A\u001a\u00020BH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0016\u0010-\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010!R\u0016\u0010/\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010!R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006D"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/FieldReader;", "Lorg/gnit/lucenekmp/index/Terms;", "parent", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsReader;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "numTerms", "", "rootCode", "Lorg/gnit/lucenekmp/util/BytesRef;", "sumTotalTermFreq", "sumDocFreq", "docCount", "", "indexStartFP", "metaIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "indexIn", "minTerm", "maxTerm", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsReader;Lorg/gnit/lucenekmp/index/FieldInfo;JLorg/gnit/lucenekmp/util/BytesRef;JJIJLorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/util/BytesRef;Lorg/gnit/lucenekmp/util/BytesRef;)V", "getNumTerms", "()J", "getFieldInfo", "()Lorg/gnit/lucenekmp/index/FieldInfo;", "getSumTotalTermFreq", "getSumDocFreq", "getDocCount", "()I", "rootBlockFP", "getRootBlockFP", "getRootCode", "()Lorg/gnit/lucenekmp/util/BytesRef;", "getMinTerm", "getMaxTerm", "getParent", "()Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsReader;", "index", "Lorg/gnit/lucenekmp/util/fst/FST;", "getIndex", "()Lorg/gnit/lucenekmp/util/fst/FST;", "readVLongOutput", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "min", "getMin", "max", "getMax", "stats", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Stats;", "getStats", "()Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Stats;", "hasFreqs", "", "hasOffsets", "hasPositions", "hasPayloads", "iterator", "Lorg/gnit/lucenekmp/index/TermsEnum;", "size", "intersect", "compiled", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "startTerm", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFieldReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldReader.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/FieldReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public final class FieldReader
extends Terms {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long numTerms;
    @NotNull
    private final FieldInfo fieldInfo;
    private final long sumTotalTermFreq;
    private final long sumDocFreq;
    private final int docCount;
    private final long rootBlockFP;
    @NotNull
    private final BytesRef rootCode;
    @Nullable
    private final BytesRef minTerm;
    @Nullable
    private final BytesRef maxTerm;
    @NotNull
    private final Lucene90BlockTreeTermsReader parent;
    @NotNull
    private final FST<BytesRef> index;

    public FieldReader(@NotNull Lucene90BlockTreeTermsReader parent, @NotNull FieldInfo fieldInfo, long numTerms, @NotNull BytesRef rootCode, long sumTotalTermFreq, long sumDocFreq, int docCount, long indexStartFP, @NotNull IndexInput metaIn, @NotNull IndexInput indexIn, @NotNull BytesRef minTerm, @NotNull BytesRef maxTerm) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)rootCode, (String)"rootCode");
        Intrinsics.checkNotNullParameter((Object)metaIn, (String)"metaIn");
        Intrinsics.checkNotNullParameter((Object)indexIn, (String)"indexIn");
        Intrinsics.checkNotNullParameter((Object)minTerm, (String)"minTerm");
        Intrinsics.checkNotNullParameter((Object)maxTerm, (String)"maxTerm");
        if (!(numTerms > 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.rootBlockFP = this.readVLongOutput(new ByteArrayDataInput(rootCode.getBytes(), rootCode.getOffset(), rootCode.getLength())) >>> 2;
        FST.FSTMetadata metadata = FST.Companion.readMetadata(metaIn, ByteSequenceOutputs.Companion.getSingleton());
        FST fST = FST.Companion.fromFSTReader(metadata, new OffHeapFSTStore(indexIn, indexStartFP, metadata));
        Intrinsics.checkNotNull(fST);
        this.index = fST;
        BytesRef emptyOutput = (BytesRef)metadata.getEmptyOutput();
        if (!Intrinsics.areEqual((Object)rootCode, (Object)emptyOutput)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.rootCode = emptyOutput;
    }

    public final long getNumTerms() {
        return this.numTerms;
    }

    @NotNull
    public final FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    @Override
    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    @Override
    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    @Override
    public int getDocCount() {
        return this.docCount;
    }

    public final long getRootBlockFP() {
        return this.rootBlockFP;
    }

    @NotNull
    public final BytesRef getRootCode() {
        return this.rootCode;
    }

    @Nullable
    public final BytesRef getMinTerm() {
        return this.minTerm;
    }

    @Nullable
    public final BytesRef getMaxTerm() {
        return this.maxTerm;
    }

    @NotNull
    public final Lucene90BlockTreeTermsReader getParent() {
        return this.parent;
    }

    @NotNull
    public final FST<BytesRef> getIndex() {
        return this.index;
    }

    public final long readVLongOutput(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        return this.parent.getVersion() >= 1 ? Companion.readMSBVLong(in) : in.readVLong();
    }

    @Override
    @Nullable
    public BytesRef getMin() {
        BytesRef bytesRef = this.minTerm;
        if (bytesRef == null) {
            bytesRef = super.getMin();
        }
        return bytesRef;
    }

    @Override
    @Nullable
    public BytesRef getMax() {
        BytesRef bytesRef = this.maxTerm;
        if (bytesRef == null) {
            bytesRef = super.getMax();
        }
        return bytesRef;
    }

    @Override
    @NotNull
    public final Stats getStats() {
        return new SegmentTermsEnum(this).computeBlockStats();
    }

    @Override
    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    @Override
    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    @Override
    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    @Override
    @NotNull
    public TermsEnum iterator() throws IOException {
        return new SegmentTermsEnum(this);
    }

    @Override
    public long size() {
        return this.numTerms;
    }

    @Override
    @NotNull
    public TermsEnum intersect(@NotNull CompiledAutomaton compiled, @Nullable BytesRef startTerm) throws IOException {
        Intrinsics.checkNotNullParameter((Object)compiled, (String)"compiled");
        if (!(compiled.getType() == CompiledAutomaton.AUTOMATON_TYPE.NORMAL)) {
            boolean bl = false;
            String string = "please use CompiledAutomaton.getTermsEnum instead";
            throw new IllegalArgumentException(string.toString());
        }
        TransitionAccessor transitionAccessor = compiled.getTransitionAccessor();
        Intrinsics.checkNotNull((Object)transitionAccessor);
        ByteRunnable byteRunnable = compiled.getByteRunnable();
        Intrinsics.checkNotNull((Object)byteRunnable);
        BytesRef bytesRef = compiled.getCommonSuffixRef();
        Intrinsics.checkNotNull((Object)bytesRef);
        return new IntersectTermsEnum(this, transitionAccessor, byteRunnable, bytesRef, startTerm);
    }

    @NotNull
    public String toString() {
        return "BlockTreeTerms(seg=" + this.parent.getSegment() + " terms=" + this.numTerms + ",postings=" + this.getSumDocFreq() + ",positions=" + this.getSumTotalTermFreq() + ",docs=" + this.getDocCount() + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/FieldReader$Companion;", "", "<init>", "()V", "readMSBVLong", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final long readMSBVLong(@NotNull DataInput in) throws IOException {
            byte b;
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            long l = 0L;
            do {
                b = in.readByte();
                l = l << 7 | (long)b & 0x7FL;
            } while ((b & 0x80) != 0);
            return l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

