/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.blocktree;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.BlockTermState;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.CompressionAlgorithm;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.IntersectTermsEnum;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.SegmentTermsEnum;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.store.ByteArrayDataInput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.gnit.lucenekmp.util.fst.FST;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010u\u001a\u00020vJ\u000e\u0010w\u001a\u00020v2\u0006\u0010x\u001a\u00020^J\u000e\u0010w\u001a\u00020v2\u0006\u0010y\u001a\u00020zJ\u0015\u0010w\u001a\u00020v2\b\u0010{\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010|J\u0006\u0010}\u001a\u00020FJ\u0006\u0010~\u001a\u00020vJ\u0006\u0010\u007f\u001a\u00020FJ\u0007\u0010\u0082\u0001\u001a\u00020vR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR$\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\t\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\t\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\t\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010&\"\u0004\b/\u0010(R\u0011\u00100\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010,R\u001a\u00102\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010&\"\u0004\b4\u0010(R\u001a\u00105\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\t\"\u0004\b7\u0010\u001cR\u0011\u00108\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010,R\u0011\u0010:\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010,R\u001a\u0010<\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\t\"\u0004\b>\u0010\u001cR\u001a\u0010?\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\t\"\u0004\bA\u0010\u001cR\u001a\u0010B\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\t\"\u0004\bD\u0010\u001cR\u001a\u0010E\u001a\u00020FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010G\"\u0004\bK\u0010IR\u001a\u0010L\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\t\"\u0004\bN\u0010\u001cR\u001a\u0010O\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\t\"\u0004\bQ\u0010\u001cR\u0011\u0010R\u001a\u00020S\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010UR\u001a\u0010V\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010\t\"\u0004\bX\u0010\u001cR\u001a\u0010Y\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\t\"\u0004\b[\u0010\u001cR\"\u0010\\\u001a\n\u0012\u0004\u0012\u00020^\u0018\u00010]X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR\u0011\u0010c\u001a\u00020d\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010fR\u001a\u0010g\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010&\"\u0004\bi\u0010(R\u0011\u0010j\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010,R\u001a\u0010l\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010\t\"\u0004\bn\u0010\u001cR\u001a\u0010o\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010\t\"\u0004\bq\u0010\u001cR\u001a\u0010r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010\t\"\u0004\bt\u0010\u001cR\u0013\u0010\u0080\u0001\u001a\u00020\u00058F\u00a2\u0006\u0007\u001a\u0005\b\u0081\u0001\u0010\t\u00a8\u0006\u0083\u0001"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/IntersectTermsEnumFrame;", "", "ite", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/IntersectTermsEnum;", "ord", "", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/IntersectTermsEnum;I)V", "getOrd", "()I", "fp", "", "getFp", "()J", "setFp", "(J)V", "fpOrig", "getFpOrig", "setFpOrig", "fpEnd", "getFpEnd", "setFpEnd", "lastSubFP", "getLastSubFP", "setLastSubFP", "state", "getState", "setState", "(I)V", "lastState", "getLastState", "setLastState", "metaDataUpto", "getMetaDataUpto", "setMetaDataUpto", "suffixBytes", "", "getSuffixBytes", "()[B", "setSuffixBytes", "([B)V", "suffixesReader", "Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "getSuffixesReader", "()Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "suffixLengthBytes", "getSuffixLengthBytes", "setSuffixLengthBytes", "suffixLengthsReader", "getSuffixLengthsReader", "statBytes", "getStatBytes", "setStatBytes", "statsSingletonRunLength", "getStatsSingletonRunLength", "setStatsSingletonRunLength", "statsReader", "getStatsReader", "floorDataReader", "getFloorDataReader", "prefix", "getPrefix", "setPrefix", "entCount", "getEntCount", "setEntCount", "nextEnt", "getNextEnt", "setNextEnt", "isLastInFloor", "", "()Z", "setLastInFloor", "(Z)V", "isLeafBlock", "setLeafBlock", "numFollowFloorBlocks", "getNumFollowFloorBlocks", "setNumFollowFloorBlocks", "nextFloorLabel", "getNextFloorLabel", "setNextFloorLabel", "transition", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "getTransition", "()Lorg/gnit/lucenekmp/util/automaton/Transition;", "transitionIndex", "getTransitionIndex", "setTransitionIndex", "transitionCount", "getTransitionCount", "setTransitionCount", "arc", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "Lorg/gnit/lucenekmp/util/BytesRef;", "getArc", "()Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "setArc", "(Lorg/gnit/lucenekmp/util/fst/FST$Arc;)V", "termState", "Lorg/gnit/lucenekmp/codecs/BlockTermState;", "getTermState", "()Lorg/gnit/lucenekmp/codecs/BlockTermState;", "bytes", "getBytes", "setBytes", "bytesReader", "getBytesReader", "outputNum", "getOutputNum", "setOutputNum", "startBytePos", "getStartBytePos", "setStartBytePos", "suffix", "getSuffix", "setSuffix", "loadNextFloorBlock", "", "load", "frameIndexData", "outputAccumulator", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum$OutputAccumulator;", "blockCode", "(Ljava/lang/Long;)V", "next", "nextLeaf", "nextNonLeaf", "termBlockOrd", "getTermBlockOrd", "decodeMetaData", "core"})
@SourceDebugExtension(value={"SMAP\nIntersectTermsEnumFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntersectTermsEnumFrame.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/IntersectTermsEnumFrame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1#2:320\n*E\n"})
public final class IntersectTermsEnumFrame {
    @NotNull
    private final IntersectTermsEnum ite;
    private final int ord;
    private long fp;
    private long fpOrig;
    private long fpEnd;
    private long lastSubFP;
    private int state;
    private int lastState;
    private int metaDataUpto;
    @NotNull
    private byte[] suffixBytes;
    @NotNull
    private final ByteArrayDataInput suffixesReader;
    @NotNull
    private byte[] suffixLengthBytes;
    @NotNull
    private final ByteArrayDataInput suffixLengthsReader;
    @NotNull
    private byte[] statBytes;
    private int statsSingletonRunLength;
    @NotNull
    private final ByteArrayDataInput statsReader;
    @NotNull
    private final ByteArrayDataInput floorDataReader;
    private int prefix;
    private int entCount;
    private int nextEnt;
    private boolean isLastInFloor;
    private boolean isLeafBlock;
    private int numFollowFloorBlocks;
    private int nextFloorLabel;
    @NotNull
    private final Transition transition;
    private int transitionIndex;
    private int transitionCount;
    @Nullable
    private FST.Arc<BytesRef> arc;
    @NotNull
    private final BlockTermState termState;
    @NotNull
    private byte[] bytes;
    @NotNull
    private final ByteArrayDataInput bytesReader;
    private int outputNum;
    private int startBytePos;
    private int suffix;

    public IntersectTermsEnumFrame(@NotNull IntersectTermsEnum ite, int ord) {
        Intrinsics.checkNotNullParameter((Object)ite, (String)"ite");
        this.ite = ite;
        this.ord = ord;
        this.suffixBytes = new byte[128];
        this.suffixesReader = new ByteArrayDataInput();
        this.statBytes = new byte[64];
        this.statsReader = new ByteArrayDataInput();
        this.floorDataReader = new ByteArrayDataInput();
        this.transition = new Transition();
        this.termState = this.ite.getFr().getParent().getPostingsReader().newTermState();
        this.bytes = new byte[32];
        this.bytesReader = new ByteArrayDataInput();
        this.termState.setTotalTermFreq(-1L);
        this.suffixLengthBytes = new byte[32];
        this.suffixLengthsReader = new ByteArrayDataInput();
    }

    public final int getOrd() {
        return this.ord;
    }

    public final long getFp() {
        return this.fp;
    }

    public final void setFp(long l) {
        this.fp = l;
    }

    public final long getFpOrig() {
        return this.fpOrig;
    }

    public final void setFpOrig(long l) {
        this.fpOrig = l;
    }

    public final long getFpEnd() {
        return this.fpEnd;
    }

    public final void setFpEnd(long l) {
        this.fpEnd = l;
    }

    public final long getLastSubFP() {
        return this.lastSubFP;
    }

    public final void setLastSubFP(long l) {
        this.lastSubFP = l;
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int state2) {
        this.setState(state2);
        this.transitionIndex = 0;
        this.transitionCount = this.ite.getAutomaton().getNumTransitions(state2);
        if (this.transitionCount != 0) {
            this.ite.getAutomaton().initTransition(state2, this.transition);
            this.ite.getAutomaton().getNextTransition(this.transition);
        } else {
            this.transition.setMin(-1);
            this.transition.setMax(-1);
        }
    }

    public final int getLastState() {
        return this.lastState;
    }

    public final void setLastState(int n) {
        this.lastState = n;
    }

    public final int getMetaDataUpto() {
        return this.metaDataUpto;
    }

    public final void setMetaDataUpto(int n) {
        this.metaDataUpto = n;
    }

    @NotNull
    public final byte[] getSuffixBytes() {
        return this.suffixBytes;
    }

    public final void setSuffixBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.suffixBytes = byArray;
    }

    @NotNull
    public final ByteArrayDataInput getSuffixesReader() {
        return this.suffixesReader;
    }

    @NotNull
    public final byte[] getSuffixLengthBytes() {
        return this.suffixLengthBytes;
    }

    public final void setSuffixLengthBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.suffixLengthBytes = byArray;
    }

    @NotNull
    public final ByteArrayDataInput getSuffixLengthsReader() {
        return this.suffixLengthsReader;
    }

    @NotNull
    public final byte[] getStatBytes() {
        return this.statBytes;
    }

    public final void setStatBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.statBytes = byArray;
    }

    public final int getStatsSingletonRunLength() {
        return this.statsSingletonRunLength;
    }

    public final void setStatsSingletonRunLength(int n) {
        this.statsSingletonRunLength = n;
    }

    @NotNull
    public final ByteArrayDataInput getStatsReader() {
        return this.statsReader;
    }

    @NotNull
    public final ByteArrayDataInput getFloorDataReader() {
        return this.floorDataReader;
    }

    public final int getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(int n) {
        this.prefix = n;
    }

    public final int getEntCount() {
        return this.entCount;
    }

    public final void setEntCount(int n) {
        this.entCount = n;
    }

    public final int getNextEnt() {
        return this.nextEnt;
    }

    public final void setNextEnt(int n) {
        this.nextEnt = n;
    }

    public final boolean isLastInFloor() {
        return this.isLastInFloor;
    }

    public final void setLastInFloor(boolean bl) {
        this.isLastInFloor = bl;
    }

    public final boolean isLeafBlock() {
        return this.isLeafBlock;
    }

    public final void setLeafBlock(boolean bl) {
        this.isLeafBlock = bl;
    }

    public final int getNumFollowFloorBlocks() {
        return this.numFollowFloorBlocks;
    }

    public final void setNumFollowFloorBlocks(int n) {
        this.numFollowFloorBlocks = n;
    }

    public final int getNextFloorLabel() {
        return this.nextFloorLabel;
    }

    public final void setNextFloorLabel(int n) {
        this.nextFloorLabel = n;
    }

    @NotNull
    public final Transition getTransition() {
        return this.transition;
    }

    public final int getTransitionIndex() {
        return this.transitionIndex;
    }

    public final void setTransitionIndex(int n) {
        this.transitionIndex = n;
    }

    public final int getTransitionCount() {
        return this.transitionCount;
    }

    public final void setTransitionCount(int n) {
        this.transitionCount = n;
    }

    @Nullable
    public final FST.Arc<BytesRef> getArc() {
        return this.arc;
    }

    public final void setArc(@Nullable FST.Arc<BytesRef> arc) {
        this.arc = arc;
    }

    @NotNull
    public final BlockTermState getTermState() {
        return this.termState;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final void setBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.bytes = byArray;
    }

    @NotNull
    public final ByteArrayDataInput getBytesReader() {
        return this.bytesReader;
    }

    public final int getOutputNum() {
        return this.outputNum;
    }

    public final void setOutputNum(int n) {
        this.outputNum = n;
    }

    public final int getStartBytePos() {
        return this.startBytePos;
    }

    public final void setStartBytePos(int n) {
        this.startBytePos = n;
    }

    public final int getSuffix() {
        return this.suffix;
    }

    public final void setSuffix(int n) {
        this.suffix = n;
    }

    public final void loadNextFloorBlock() throws IOException {
        if (!(this.numFollowFloorBlocks > 0)) {
            boolean bl = false;
            String string = "nextFloorLabel=" + this.nextFloorLabel;
            throw new IllegalArgumentException(string.toString());
        }
        do {
            this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
            int n = this.numFollowFloorBlocks;
            this.numFollowFloorBlocks = n + -1;
            int n2 = this.nextFloorLabel = this.numFollowFloorBlocks != 0 ? (int)(this.floorDataReader.readByte() & 0xFFFFFFFF) : 256;
        } while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.getMin());
        this.load((Long)null);
    }

    public final void load(@NotNull BytesRef frameIndexData) throws IOException {
        Intrinsics.checkNotNullParameter((Object)frameIndexData, (String)"frameIndexData");
        this.floorDataReader.reset(frameIndexData.getBytes(), frameIndexData.getOffset(), frameIndexData.getLength());
        this.load(this.ite.getFr().readVLongOutput(this.floorDataReader));
    }

    public final void load(@NotNull SegmentTermsEnum.OutputAccumulator outputAccumulator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputAccumulator, (String)"outputAccumulator");
        outputAccumulator.prepareRead();
        long code = this.ite.getFr().readVLongOutput(outputAccumulator);
        outputAccumulator.setFloorData(this.floorDataReader);
        this.load(code);
    }

    public final void load(@Nullable Long blockCode) throws IOException {
        boolean allEqual;
        if (blockCode != null && (blockCode & 1L) != 0L) {
            this.numFollowFloorBlocks = this.floorDataReader.readVInt();
            this.nextFloorLabel = (byte)(this.floorDataReader.readByte() & 0xFFFFFFFF);
            if (!this.ite.getRunAutomaton().isAccept(this.state) && this.transitionCount != 0) {
                if (!(this.transitionIndex == 0)) {
                    boolean $i$a$-require-IntersectTermsEnumFrame$load$22 = false;
                    String $i$a$-require-IntersectTermsEnumFrame$load$22 = "transitionIndex=" + this.transitionIndex;
                    throw new IllegalArgumentException($i$a$-require-IntersectTermsEnumFrame$load$22.toString());
                }
                while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.getMin()) {
                    this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
                    int n = this.numFollowFloorBlocks;
                    this.numFollowFloorBlocks = n + -1;
                    this.nextFloorLabel = this.numFollowFloorBlocks != 0 ? (int)(this.floorDataReader.readByte() & 0xFFFFFFFF) : 256;
                }
            }
        }
        this.ite.getIn().seek(this.fp);
        int code = this.ite.getIn().readVInt();
        this.entCount = code >>> 1;
        if (!(this.entCount > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.isLastInFloor = (code & 1) != 0;
        long codeL = this.ite.getIn().readVLong();
        this.isLeafBlock = (codeL & 4L) != 0L;
        int numSuffixBytes = (int)(codeL >>> 3);
        if (this.suffixBytes.length < numSuffixBytes) {
            this.suffixBytes = new byte[ArrayUtil.Companion.oversize(numSuffixBytes, 1)];
        }
        CompressionAlgorithm compressionAlg = null;
        try {
            compressionAlg = CompressionAlgorithm.Companion.byCode((int)codeL & 3);
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new CorruptIndexException(string, this.ite.getIn(), (Throwable)e);
        }
        compressionAlg.read(this.ite.getIn(), this.suffixBytes, numSuffixBytes);
        this.suffixesReader.reset(this.suffixBytes, 0, numSuffixBytes);
        int numSuffixLengthBytes = this.ite.getIn().readVInt();
        boolean bl = allEqual = (numSuffixLengthBytes & 1) != 0;
        if (this.suffixLengthBytes.length < (numSuffixLengthBytes >>>= 1)) {
            this.suffixLengthBytes = new byte[ArrayUtil.Companion.oversize(numSuffixLengthBytes, 1)];
        }
        if (allEqual) {
            Arrays.INSTANCE.fill(this.suffixLengthBytes, 0, numSuffixLengthBytes, this.ite.getIn().readByte());
        } else {
            this.ite.getIn().readBytes(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        }
        this.suffixLengthsReader.reset(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        int numBytes = this.ite.getIn().readVInt();
        if (this.statBytes.length < numBytes) {
            this.statBytes = new byte[ArrayUtil.Companion.oversize(numBytes, 1)];
        }
        this.ite.getIn().readBytes(this.statBytes, 0, numBytes);
        this.statsReader.reset(this.statBytes, 0, numBytes);
        this.statsSingletonRunLength = 0;
        this.metaDataUpto = 0;
        this.termState.setTermBlockOrd(0);
        this.nextEnt = 0;
        numBytes = this.ite.getIn().readVInt();
        if (this.bytes.length < numBytes) {
            this.bytes = new byte[ArrayUtil.Companion.oversize(numBytes, 1)];
        }
        this.ite.getIn().readBytes(this.bytes, 0, numBytes);
        this.bytesReader.reset(this.bytes, 0, numBytes);
        if (!this.isLastInFloor) {
            this.fpEnd = this.ite.getIn().getFilePointer();
        }
    }

    public final boolean next() {
        if (this.isLeafBlock) {
            this.nextLeaf();
            return false;
        }
        return this.nextNonLeaf();
    }

    public final void nextLeaf() {
        if (!(this.nextEnt != -1 && this.nextEnt < this.entCount)) {
            boolean bl = false;
            String string = "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.nextEnt;
        this.nextEnt = n + 1;
        this.suffix = this.suffixLengthsReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes(this.suffix);
    }

    public final boolean nextNonLeaf() {
        if (!(this.nextEnt != -1 && this.nextEnt < this.entCount)) {
            boolean bl = false;
            String string = "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.nextEnt;
        this.nextEnt = n + 1;
        int code = this.suffixLengthsReader.readVInt();
        this.suffix = code >>> 1;
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes(this.suffix);
        if ((code & 1) == 0) {
            BlockTermState blockTermState = this.termState;
            int n2 = blockTermState.getTermBlockOrd();
            blockTermState.setTermBlockOrd(n2 + 1);
            return false;
        }
        this.lastSubFP = this.fp - this.suffixLengthsReader.readVLong();
        return true;
    }

    public final int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.termState.getTermBlockOrd();
    }

    public final void decodeMetaData() throws IOException {
        int limit = this.getTermBlockOrd();
        boolean absolute = this.metaDataUpto == 0;
        if (!(limit > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (this.metaDataUpto < limit) {
            int n;
            if (this.statsSingletonRunLength > 0) {
                this.termState.setDocFreq(1);
                this.termState.setTotalTermFreq(1L);
                n = this.statsSingletonRunLength;
                this.statsSingletonRunLength = n + -1;
            } else {
                int token = this.statsReader.readVInt();
                if ((token & 1) == 1) {
                    this.termState.setDocFreq(1);
                    this.termState.setTotalTermFreq(1L);
                    this.statsSingletonRunLength = token >>> 1;
                } else {
                    this.termState.setDocFreq(token >>> 1);
                    if (this.ite.getFr().getFieldInfo().getIndexOptions() == IndexOptions.DOCS) {
                        this.termState.setTotalTermFreq(this.termState.getDocFreq());
                    } else {
                        this.termState.setTotalTermFreq((long)this.termState.getDocFreq() + this.statsReader.readVLong());
                    }
                }
            }
            this.ite.getFr().getParent().getPostingsReader().decodeTerm(this.bytesReader, this.ite.getFr().getFieldInfo(), this.termState, absolute);
            n = this.metaDataUpto;
            this.metaDataUpto = n + 1;
            absolute = false;
        }
        this.termState.setTermBlockOrd(this.metaDataUpto);
    }
}

