/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.blocktree;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.BlockTermState;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.FieldReader;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.SegmentTermsEnumFrame;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.Stats;
import org.gnit.lucenekmp.index.BaseTermsEnum;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.PrintStream;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.ByteArrayDataInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.IOBooleanSupplier;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001SB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u001fH\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u00103\u001a\u00020\u001fH\u0002J&\u00105\u001a\u00020\u00102\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+2\u0006\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020\u001fJ\u001e\u00105\u001a\u00020\u00102\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+2\u0006\u00108\u001a\u00020\u001fJ&\u00105\u001a\u00020\u00102\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+2\u0006\u00109\u001a\u00020:2\u0006\u00108\u001a\u00020\u001fJ\b\u0010;\u001a\u00020\u0019H\u0002J\b\u0010<\u001a\u00020\u0019H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\u0019H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020,H\u0016J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010?\u001a\u00020,H\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010?\u001a\u00020,H\u0016J\u0010\u0010D\u001a\u00020/2\u0006\u0010E\u001a\u00020FH\u0002J\n\u0010G\u001a\u0004\u0018\u00010,H\u0016J\b\u0010$\u001a\u00020,H\u0016J\b\u0010H\u001a\u00020\u001fH\u0016J\b\u0010I\u001a\u00020:H\u0016J\u001a\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010K2\u0006\u0010M\u001a\u00020\u001fH\u0016J\u0010\u0010N\u001a\u00020O2\u0006\u0010M\u001a\u00020\u001fH\u0016J\u0018\u0010A\u001a\u00020/2\u0006\u0010?\u001a\u00020,2\u0006\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020QH\u0016J\u0010\u0010A\u001a\u00020/2\u0006\u00103\u001a\u00020:H\u0016J\b\u00103\u001a\u00020:H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020,\u0018\u00010+0\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010-\u00a8\u0006T"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum;", "Lorg/gnit/lucenekmp/index/BaseTermsEnum;", "fr", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/FieldReader;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/FieldReader;)V", "getFr", "()Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/FieldReader;", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "getIn", "()Lorg/gnit/lucenekmp/store/IndexInput;", "setIn", "(Lorg/gnit/lucenekmp/store/IndexInput;)V", "stack", "", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnumFrame;", "[Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnumFrame;", "staticFrame", "currentFrame", "getCurrentFrame", "()Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnumFrame;", "setCurrentFrame", "(Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnumFrame;)V", "termExists", "", "getTermExists", "()Z", "setTermExists", "(Z)V", "targetBeforeCurrentLength", "", "outputAccumulator", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum$OutputAccumulator;", "validIndexPrefix", "eof", "term", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "getTerm", "()Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "fstReader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "arcs", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "Lorg/gnit/lucenekmp/util/BytesRef;", "[Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "initIndexInput", "", "computeBlockStats", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Stats;", "getFrame", "ord", "getArc", "pushFrame", "arc", "frameData", "length", "fp", "", "clearEOF", "setEOF", "prepareSeekExact", "Lorg/gnit/lucenekmp/util/IOBooleanSupplier;", "target", "prefetch", "seekExact", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "printSeekState", "out", "Lorg/gnit/lucenekmp/jdkport/PrintStream;", "next", "docFreq", "totalTermFreq", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "flags", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "otherState", "Lorg/gnit/lucenekmp/index/TermState;", "termState", "OutputAccumulator", "core"})
@SourceDebugExtension(value={"SMAP\nSegmentTermsEnum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentTermsEnum.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1223:1\n1#2:1224\n*E\n"})
public final class SegmentTermsEnum
extends BaseTermsEnum {
    @NotNull
    private final FieldReader fr;
    @Nullable
    private IndexInput in;
    @NotNull
    private SegmentTermsEnumFrame[] stack;
    @NotNull
    private final SegmentTermsEnumFrame staticFrame;
    @NotNull
    private SegmentTermsEnumFrame currentFrame;
    private boolean termExists;
    private int targetBeforeCurrentLength;
    @NotNull
    private final OutputAccumulator outputAccumulator;
    private int validIndexPrefix;
    private boolean eof;
    @NotNull
    private final BytesRefBuilder term;
    @Nullable
    private final FST.BytesReader fstReader;
    @NotNull
    private FST.Arc<BytesRef>[] arcs;

    public SegmentTermsEnum(@NotNull FieldReader fr) {
        Intrinsics.checkNotNullParameter((Object)fr, (String)"fr");
        this.fr = fr;
        this.outputAccumulator = new OutputAccumulator();
        this.term = new BytesRefBuilder();
        this.arcs = new FST.Arc[1];
        this.stack = new SegmentTermsEnumFrame[0];
        this.staticFrame = new SegmentTermsEnumFrame(this, -1);
        this.fstReader = this.fr.getIndex() == null ? null : this.fr.getIndex().getBytesReader();
        int n = this.arcs.length;
        for (int arcIdx = 0; arcIdx < n; ++arcIdx) {
            this.arcs[arcIdx] = new FST.Arc();
        }
        this.currentFrame = this.staticFrame;
        FST.Arc<BytesRef> arc = null;
        if (this.fr.getIndex() != null) {
            FST<BytesRef> fST = this.fr.getIndex();
            FST.Arc<BytesRef> arc2 = this.arcs[0];
            Intrinsics.checkNotNull(arc2);
            arc = fST.getFirstArc(arc2);
            if (!arc.isFinal()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        } else {
            arc = null;
        }
        this.validIndexPrefix = 0;
    }

    @NotNull
    public final FieldReader getFr() {
        return this.fr;
    }

    @Nullable
    public final IndexInput getIn() {
        return this.in;
    }

    public final void setIn(@Nullable IndexInput indexInput) {
        this.in = indexInput;
    }

    @NotNull
    public final SegmentTermsEnumFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public final void setCurrentFrame(@NotNull SegmentTermsEnumFrame segmentTermsEnumFrame) {
        Intrinsics.checkNotNullParameter((Object)segmentTermsEnumFrame, (String)"<set-?>");
        this.currentFrame = segmentTermsEnumFrame;
    }

    public final boolean getTermExists() {
        return this.termExists;
    }

    public final void setTermExists(boolean bl) {
        this.termExists = bl;
    }

    @NotNull
    public final BytesRefBuilder getTerm() {
        return this.term;
    }

    public final void initIndexInput() {
        if (this.in == null) {
            this.in = this.fr.getParent().getTermsIn().clone();
        }
    }

    @NotNull
    public final Stats computeBlockStats() throws IOException {
        Stats stats = new Stats(this.fr.getParent().getSegment(), this.fr.getFieldInfo().getName());
        if (this.fr.getIndex() != null) {
            stats.setIndexNumBytes(this.fr.getIndex().ramBytesUsed());
        }
        this.currentFrame = this.staticFrame;
        FST.Arc<BytesRef> arc = null;
        if (this.fr.getIndex() != null) {
            FST<BytesRef> fST = this.fr.getIndex();
            FST.Arc<BytesRef> arc2 = this.arcs[0];
            Intrinsics.checkNotNull(arc2);
            arc = fST.getFirstArc(arc2);
            if (!arc.isFinal()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        } else {
            arc = null;
        }
        FST.Arc<BytesRef> arc3 = arc;
        Intrinsics.checkNotNull(arc3);
        this.currentFrame = this.pushFrame(arc3, this.fr.getRootCode(), 0);
        this.currentFrame.setFpOrig(this.currentFrame.getFp());
        this.currentFrame.loadBlock();
        this.validIndexPrefix = 0;
        stats.startBlock(this.currentFrame, !this.currentFrame.isLastInFloor());
        while (true) {
            if (this.currentFrame.getNextEnt() == this.currentFrame.getEntCount()) {
                stats.endBlock(this.currentFrame);
                if (!this.currentFrame.isLastInFloor()) {
                    this.currentFrame.loadNextFloorBlock();
                    stats.startBlock(this.currentFrame, true);
                } else {
                    if (this.currentFrame.getOrd() == 0) break;
                    long lastFP = this.currentFrame.getFpOrig();
                    Intrinsics.checkNotNull((Object)this.stack[this.currentFrame.getOrd() - 1]);
                    this.currentFrame = this.currentFrame;
                    if (lastFP == this.currentFrame.getLastSubFP()) continue;
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            while (this.currentFrame.next()) {
                this.currentFrame = this.pushFrame(null, this.currentFrame.getLastSubFP(), this.term.length());
                this.currentFrame.setFpOrig(this.currentFrame.getFp());
                this.currentFrame.loadBlock();
                stats.startBlock(this.currentFrame, !this.currentFrame.isLastInFloor());
            }
            stats.term(this.term.get());
        }
        stats.finish();
        this.currentFrame = this.staticFrame;
        if (this.fr.getIndex() != null) {
            FST<BytesRef> fST = this.fr.getIndex();
            FST.Arc<BytesRef> arc4 = this.arcs[0];
            Intrinsics.checkNotNull(arc4);
            arc = fST.getFirstArc(arc4);
            if (!arc.isFinal()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        } else {
            arc = null;
        }
        this.currentFrame = this.pushFrame(arc, this.fr.getRootCode(), 0);
        this.currentFrame.rewind();
        this.currentFrame.loadBlock();
        this.validIndexPrefix = 0;
        this.term.clear();
        return stats;
    }

    private final SegmentTermsEnumFrame getFrame(int ord) throws IOException {
        if (ord >= this.stack.length) {
            SegmentTermsEnumFrame[] next = new SegmentTermsEnumFrame[ArrayUtil.Companion.oversize(1 + ord, 4)];
            System.INSTANCE.arraycopyKtNullable(this.stack, 0, next, 0, this.stack.length);
            int n = next.length;
            for (int stackOrd = this.stack.length; stackOrd < n; ++stackOrd) {
                next[stackOrd] = new SegmentTermsEnumFrame(this, stackOrd);
            }
            this.stack = next;
        }
        SegmentTermsEnumFrame segmentTermsEnumFrame = this.stack[ord];
        Intrinsics.checkNotNull((Object)segmentTermsEnumFrame);
        if (!(segmentTermsEnumFrame.getOrd() == ord)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SegmentTermsEnumFrame segmentTermsEnumFrame2 = this.stack[ord];
        Intrinsics.checkNotNull((Object)segmentTermsEnumFrame2);
        return segmentTermsEnumFrame2;
    }

    private final FST.Arc<BytesRef> getArc(int ord) {
        if (ord >= this.arcs.length) {
            FST.Arc[] next = new FST.Arc[ArrayUtil.Companion.oversize(1 + ord, 4)];
            System.INSTANCE.arraycopyKtNullable(this.arcs, 0, next, 0, this.arcs.length);
            int n = next.length;
            for (int arcOrd = this.arcs.length; arcOrd < n; ++arcOrd) {
                next[arcOrd] = new FST.Arc();
            }
            this.arcs = next;
        }
        FST.Arc<BytesRef> arc = this.arcs[ord];
        Intrinsics.checkNotNull(arc);
        return arc;
    }

    @NotNull
    public final SegmentTermsEnumFrame pushFrame(@Nullable FST.Arc<BytesRef> arc, @NotNull BytesRef frameData, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)frameData, (String)"frameData");
        this.outputAccumulator.reset();
        this.outputAccumulator.push(frameData);
        return this.pushFrame(arc, length);
    }

    @NotNull
    public final SegmentTermsEnumFrame pushFrame(@Nullable FST.Arc<BytesRef> arc, int length) throws IOException {
        this.outputAccumulator.prepareRead();
        long code = this.fr.readVLongOutput(this.outputAccumulator);
        long fpSeek = code >>> 2;
        SegmentTermsEnumFrame f = this.getFrame(1 + this.currentFrame.getOrd());
        f.setHasTerms((code & 2L) != 0L);
        f.setHasTermsOrig(f.getHasTerms());
        f.setFloor((code & 1L) != 0L);
        if (f.isFloor()) {
            f.setFloorData(this.outputAccumulator);
        }
        this.pushFrame(arc, fpSeek, length);
        return f;
    }

    @NotNull
    public final SegmentTermsEnumFrame pushFrame(@Nullable FST.Arc<BytesRef> arc, long fp, int length) throws IOException {
        SegmentTermsEnumFrame f = this.getFrame(1 + this.currentFrame.getOrd());
        f.setArc(arc);
        if (f.getFpOrig() == fp && f.getNextEnt() != -1) {
            if (f.getOrd() > this.targetBeforeCurrentLength) {
                f.rewind();
            }
            if (!(length == f.getPrefixLength())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        } else {
            f.setNextEnt(-1);
            f.setPrefixLength(length);
            f.getState().setTermBlockOrd(0);
            f.setFp(fp);
            f.setFpOrig(f.getFp());
            f.setLastSubFP(-1L);
        }
        return f;
    }

    private final boolean clearEOF() {
        this.eof = false;
        return true;
    }

    private final boolean setEOF() {
        this.eof = true;
        return true;
    }

    private final IOBooleanSupplier prepareSeekExact(BytesRef target, boolean prefetch) throws IOException {
        block29: {
            block30: {
                if (this.fr.getIndex() == null) {
                    boolean $i$a$-checkNotNull-SegmentTermsEnum$prepareSeekExact$22 = false;
                    String $i$a$-checkNotNull-SegmentTermsEnum$prepareSeekExact$22 = "terms index was not loaded";
                    throw new IllegalStateException($i$a$-checkNotNull-SegmentTermsEnum$prepareSeekExact$22.toString());
                }
                if (this.fr.size() <= 0L) break block29;
                BytesRef bytesRef = this.fr.getMin();
                Intrinsics.checkNotNull((Object)bytesRef);
                if (target.compareTo(bytesRef) < 0) break block30;
                BytesRef bytesRef2 = this.fr.getMax();
                Intrinsics.checkNotNull((Object)bytesRef2);
                if (target.compareTo(bytesRef2) <= 0) break block29;
            }
            return null;
        }
        this.term.grow(1 + target.getLength());
        if (!this.clearEOF()) {
            String $i$a$-checkNotNull-SegmentTermsEnum$prepareSeekExact$22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-checkNotNull-SegmentTermsEnum$prepareSeekExact$22.toString());
        }
        FST.Arc<BytesRef> arc = null;
        int targetUpto = 0;
        this.targetBeforeCurrentLength = this.currentFrame.getOrd();
        this.outputAccumulator.reset();
        if (this.currentFrame != this.staticFrame) {
            FST.Arc<BytesRef> arc2 = this.arcs[0];
            Intrinsics.checkNotNull(arc2);
            arc = arc2;
            if (!arc.isFinal()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BytesRef bytesRef = arc.output();
            Intrinsics.checkNotNull((Object)bytesRef);
            this.outputAccumulator.push(bytesRef);
            targetUpto = 0;
            SegmentTermsEnumFrame lastFrame = this.stack[0];
            if (!(this.validIndexPrefix <= this.term.length())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int targetLimit = Math.min(target.getLength(), this.validIndexPrefix);
            int cmp = 0;
            while (targetUpto < targetLimit && (cmp = (byte)(this.term.byteAt(targetUpto) & 0xFFFFFFFF) - (byte)(target.getBytes()[target.getOffset() + targetUpto] & 0xFFFFFFFF)) == 0) {
                Intrinsics.checkNotNull(this.arcs[1 + targetUpto]);
                if (!(arc.label() == (byte)(target.getBytes()[target.getOffset() + targetUpto] & 0xFFFFFFFF))) {
                    boolean bl = false;
                    String string = "arc.label=" + (char)arc.label() + " targetLabel=" + (char)(target.getBytes()[target.getOffset() + targetUpto] & 0xFFFFFFFF);
                    throw new IllegalArgumentException(string.toString());
                }
                BytesRef bytesRef3 = arc.output();
                Intrinsics.checkNotNull((Object)bytesRef3);
                this.outputAccumulator.push(bytesRef3);
                if (arc.isFinal()) {
                    SegmentTermsEnumFrame segmentTermsEnumFrame = lastFrame;
                    Intrinsics.checkNotNull((Object)segmentTermsEnumFrame);
                    lastFrame = this.stack[1 + segmentTermsEnumFrame.getOrd()];
                }
                int n = targetUpto;
                targetUpto = n + 1;
            }
            if (cmp == 0) {
                cmp = Arrays.INSTANCE.compareUnsigned(this.term.bytes(), targetUpto, this.term.length(), target.getBytes(), target.getOffset() + targetUpto, target.getOffset() + target.getLength());
            }
            if (cmp < 0) {
                SegmentTermsEnumFrame segmentTermsEnumFrame = lastFrame;
                Intrinsics.checkNotNull((Object)segmentTermsEnumFrame);
                this.currentFrame = segmentTermsEnumFrame;
            } else if (cmp > 0) {
                SegmentTermsEnumFrame segmentTermsEnumFrame = lastFrame;
                Intrinsics.checkNotNull((Object)segmentTermsEnumFrame);
                this.targetBeforeCurrentLength = segmentTermsEnumFrame.getOrd();
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                if (!(this.term.length() == target.getLength())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.termExists) {
                    return SegmentTermsEnum::prepareSeekExact$lambda$2;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            FST<BytesRef> fST = this.fr.getIndex();
            FST.Arc<BytesRef> arc3 = this.arcs[0];
            Intrinsics.checkNotNull(arc3);
            arc = fST.getFirstArc(arc3);
            if (!arc.isFinal()) {
                String targetLimit = "Failed requirement.";
                throw new IllegalArgumentException(targetLimit.toString());
            }
            if (arc.output() == null) {
                String targetLimit = "Required value was null.";
                throw new IllegalStateException(targetLimit.toString());
            }
            BytesRef bytesRef = arc.output();
            Intrinsics.checkNotNull((Object)bytesRef);
            this.outputAccumulator.push(bytesRef);
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            BytesRef bytesRef4 = arc.nextFinalOutput();
            Intrinsics.checkNotNull((Object)bytesRef4);
            this.outputAccumulator.push(bytesRef4);
            this.currentFrame = this.pushFrame(arc, 0);
            BytesRef bytesRef5 = arc.nextFinalOutput();
            Intrinsics.checkNotNull((Object)bytesRef5);
            this.outputAccumulator.pop(bytesRef5);
        }
        while (targetUpto < target.getLength()) {
            byte targetLabel = (byte)(target.getBytes()[target.getOffset() + targetUpto] & 0xFFFFFFFF);
            FST<BytesRef> fST = this.fr.getIndex();
            FST.Arc<BytesRef> arc4 = this.getArc(1 + targetUpto);
            FST.BytesReader bytesReader = this.fstReader;
            Intrinsics.checkNotNull((Object)bytesReader);
            FST.Arc<BytesRef> nextArc = fST.findTargetArc(targetLabel, arc, arc4, bytesReader);
            if (nextArc == null) {
                this.validIndexPrefix = this.currentFrame.getPrefixLength();
                this.currentFrame.scanToFloorFrame(target);
                if (!this.currentFrame.getHasTerms()) {
                    this.termExists = false;
                    this.term.setByteAt(targetUpto, targetLabel);
                    this.term.setLength(1 + targetUpto);
                    return null;
                }
                if (prefetch) {
                    this.currentFrame.prefetchBlock();
                }
                return () -> SegmentTermsEnum.prepareSeekExact$lambda$3(this, target);
            }
            arc = nextArc;
            this.term.setByteAt(targetUpto, targetLabel);
            if (arc.output() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            BytesRef bytesRef = arc.output();
            Intrinsics.checkNotNull((Object)bytesRef);
            this.outputAccumulator.push(bytesRef);
            int n = targetUpto;
            targetUpto = n + 1;
            if (!arc.isFinal()) continue;
            BytesRef bytesRef6 = arc.nextFinalOutput();
            Intrinsics.checkNotNull((Object)bytesRef6);
            this.outputAccumulator.push(bytesRef6);
            this.currentFrame = this.pushFrame(arc, targetUpto);
            BytesRef bytesRef7 = arc.nextFinalOutput();
            Intrinsics.checkNotNull((Object)bytesRef7);
            this.outputAccumulator.pop(bytesRef7);
        }
        this.validIndexPrefix = this.currentFrame.getPrefixLength();
        this.currentFrame.scanToFloorFrame(target);
        if (!this.currentFrame.getHasTerms()) {
            this.termExists = false;
            this.term.setLength(targetUpto);
            return null;
        }
        if (prefetch) {
            this.currentFrame.prefetchBlock();
        }
        return () -> SegmentTermsEnum.prepareSeekExact$lambda$4(this, target);
    }

    @Override
    @Nullable
    public IOBooleanSupplier prepareSeekExact(@NotNull BytesRef target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.prepareSeekExact(target, true);
    }

    @Override
    public boolean seekExact(@NotNull BytesRef target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        IOBooleanSupplier termExistsSupplier = this.prepareSeekExact(target, false);
        return termExistsSupplier != null && termExistsSupplier.get();
    }

    @Override
    @NotNull
    public TermsEnum.SeekStatus seekCeil(@NotNull BytesRef target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.fr.getIndex() == null) {
            boolean $i$a$-checkNotNull-SegmentTermsEnum$seekCeil$22 = false;
            String $i$a$-checkNotNull-SegmentTermsEnum$seekCeil$22 = "terms index was not loaded";
            throw new IllegalStateException($i$a$-checkNotNull-SegmentTermsEnum$seekCeil$22.toString());
        }
        this.term.grow(1 + target.getLength());
        if (!this.clearEOF()) {
            String $i$a$-checkNotNull-SegmentTermsEnum$seekCeil$22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-checkNotNull-SegmentTermsEnum$seekCeil$22.toString());
        }
        FST.Arc<BytesRef> arc = null;
        int targetUpto = 0;
        this.targetBeforeCurrentLength = this.currentFrame.getOrd();
        this.outputAccumulator.reset();
        if (this.currentFrame != this.staticFrame) {
            FST.Arc<BytesRef> arc2 = this.arcs[0];
            Intrinsics.checkNotNull(arc2);
            arc = arc2;
            if (!arc.isFinal()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BytesRef bytesRef = arc.output();
            Intrinsics.checkNotNull((Object)bytesRef);
            this.outputAccumulator.push(bytesRef);
            targetUpto = 0;
            SegmentTermsEnumFrame lastFrame = this.stack[0];
            if (!(this.validIndexPrefix <= this.term.length())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int targetLimit = Math.min(target.getLength(), this.validIndexPrefix);
            int cmp = 0;
            while (targetUpto < targetLimit && (cmp = (byte)(this.term.byteAt(targetUpto) & 0xFFFFFFFF) - (byte)(target.getBytes()[target.getOffset() + targetUpto] & 0xFFFFFFFF)) == 0) {
                Intrinsics.checkNotNull(this.arcs[1 + targetUpto]);
                if (!(arc.label() == (byte)(target.getBytes()[target.getOffset() + targetUpto] & 0xFFFFFFFF))) {
                    boolean bl = false;
                    String string = "arc.label=" + (char)arc.label() + " targetLabel=" + (char)(target.getBytes()[target.getOffset() + targetUpto] & 0xFFFFFFFF);
                    throw new IllegalArgumentException(string.toString());
                }
                BytesRef bytesRef2 = arc.output();
                Intrinsics.checkNotNull((Object)bytesRef2);
                this.outputAccumulator.push(bytesRef2);
                if (arc.isFinal()) {
                    SegmentTermsEnumFrame segmentTermsEnumFrame = lastFrame;
                    Intrinsics.checkNotNull((Object)segmentTermsEnumFrame);
                    lastFrame = this.stack[1 + segmentTermsEnumFrame.getOrd()];
                }
                int n = targetUpto;
                targetUpto = n + 1;
            }
            if (cmp == 0) {
                cmp = Arrays.INSTANCE.compareUnsigned(this.term.bytes(), targetUpto, this.term.length(), target.getBytes(), target.getOffset() + targetUpto, target.getOffset() + target.getLength());
            }
            if (cmp < 0) {
                SegmentTermsEnumFrame segmentTermsEnumFrame = lastFrame;
                Intrinsics.checkNotNull((Object)segmentTermsEnumFrame);
                this.currentFrame = segmentTermsEnumFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = 0;
                SegmentTermsEnumFrame segmentTermsEnumFrame = lastFrame;
                Intrinsics.checkNotNull((Object)segmentTermsEnumFrame);
                this.currentFrame = segmentTermsEnumFrame;
                this.currentFrame.rewind();
            } else {
                if (!(this.term.length() == target.getLength())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.termExists) {
                    return TermsEnum.SeekStatus.FOUND;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            FST<BytesRef> fST = this.fr.getIndex();
            FST.Arc<BytesRef> arc3 = this.arcs[0];
            Intrinsics.checkNotNull(arc3);
            arc = fST.getFirstArc(arc3);
            if (!arc.isFinal()) {
                String targetLimit = "Failed requirement.";
                throw new IllegalArgumentException(targetLimit.toString());
            }
            if (arc.output() == null) {
                String targetLimit = "Required value was null.";
                throw new IllegalStateException(targetLimit.toString());
            }
            BytesRef bytesRef = arc.output();
            Intrinsics.checkNotNull((Object)bytesRef);
            this.outputAccumulator.push(bytesRef);
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            BytesRef bytesRef3 = arc.nextFinalOutput();
            Intrinsics.checkNotNull((Object)bytesRef3);
            this.outputAccumulator.push(bytesRef3);
            this.currentFrame = this.pushFrame(arc, 0);
            BytesRef bytesRef4 = arc.nextFinalOutput();
            Intrinsics.checkNotNull((Object)bytesRef4);
            this.outputAccumulator.pop(bytesRef4);
        }
        while (targetUpto < target.getLength()) {
            byte targetLabel = (byte)(target.getBytes()[target.getOffset() + targetUpto] & 0xFFFFFFFF);
            FST<BytesRef> fST = this.fr.getIndex();
            FST.Arc<BytesRef> arc4 = this.getArc(1 + targetUpto);
            FST.BytesReader bytesReader = this.fstReader;
            Intrinsics.checkNotNull((Object)bytesReader);
            FST.Arc<BytesRef> nextArc = fST.findTargetArc(targetLabel, arc, arc4, bytesReader);
            if (nextArc == null) {
                this.validIndexPrefix = this.currentFrame.getPrefixLength();
                this.currentFrame.scanToFloorFrame(target);
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, false);
                if (result == TermsEnum.SeekStatus.END) {
                    this.term.copyBytes(target);
                    this.termExists = false;
                    return this.next() != null ? TermsEnum.SeekStatus.NOT_FOUND : TermsEnum.SeekStatus.END;
                }
                return result;
            }
            this.term.setByteAt(targetUpto, targetLabel);
            arc = nextArc;
            if (arc.output() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            BytesRef bytesRef = arc.output();
            Intrinsics.checkNotNull((Object)bytesRef);
            this.outputAccumulator.push(bytesRef);
            int n = targetUpto;
            targetUpto = n + 1;
            if (!arc.isFinal()) continue;
            BytesRef bytesRef5 = arc.nextFinalOutput();
            Intrinsics.checkNotNull((Object)bytesRef5);
            this.outputAccumulator.push(bytesRef5);
            this.currentFrame = this.pushFrame(arc, targetUpto);
            BytesRef bytesRef6 = arc.nextFinalOutput();
            Intrinsics.checkNotNull((Object)bytesRef6);
            this.outputAccumulator.pop(bytesRef6);
        }
        this.validIndexPrefix = this.currentFrame.getPrefixLength();
        this.currentFrame.scanToFloorFrame(target);
        this.currentFrame.loadBlock();
        TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, false);
        if (result == TermsEnum.SeekStatus.END) {
            this.term.copyBytes(target);
            this.termExists = false;
            return this.next() != null ? TermsEnum.SeekStatus.NOT_FOUND : TermsEnum.SeekStatus.END;
        }
        return result;
    }

    private final void printSeekState(PrintStream out) throws IOException {
        if (Intrinsics.areEqual((Object)this.currentFrame, (Object)this.staticFrame)) {
            out.println("  no prior seek");
        } else {
            out.println("  prior seek state:");
            int ord = 0;
            boolean isSeekFrame = false;
            isSeekFrame = true;
            while (true) {
                SegmentTermsEnumFrame f;
                if (this.getFrame(ord) == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                BytesRef prefix = new BytesRef(this.term.get().getBytes(), 0, f.getPrefixLength());
                if (f.getNextEnt() == -1) {
                    out.println("    frame " + (isSeekFrame ? "(seek)" : "(next)") + " ord=" + ord + " fp=" + f.getFp() + (String)(f.isFloor() ? " (fpOrig=" + f.getFpOrig() + ")" : "") + " prefixLen=" + f.getPrefixLength() + " prefix=" + prefix + (String)(f.getNextEnt() == -1 ? "" : " (of " + f.getEntCount() + ")") + " hasTerms=" + f.getHasTerms() + " isFloor=" + f.isFloor() + " code=" + ((f.getFp() << 2) + (long)(f.getHasTerms() ? 2 : 0) + (long)(f.isFloor() ? 1 : 0)) + " isLastInFloor=" + f.isLastInFloor() + " mdUpto=" + f.getMetaDataUpto() + " tbOrd=" + f.getTermBlockOrd());
                } else {
                    out.println("    frame " + (isSeekFrame ? "(seek, loaded)" : "(next, loaded)") + " ord=" + ord + " fp=" + f.getFp() + (String)(f.isFloor() ? " (fpOrig=" + f.getFpOrig() + ")" : "") + " prefixLen=" + f.getPrefixLength() + " prefix=" + prefix + " nextEnt=" + f.getNextEnt() + (String)(f.getNextEnt() == -1 ? "" : " (of " + f.getEntCount() + ")") + " hasTerms=" + f.getHasTerms() + " isFloor=" + f.isFloor() + " code=" + ((f.getFp() << 2) + (long)(f.getHasTerms() ? 2 : 0) + (long)(f.isFloor() ? 1 : 0)) + " lastSubFP=" + f.getLastSubFP() + " isLastInFloor=" + f.isLastInFloor() + " mdUpto=" + f.getMetaDataUpto() + " tbOrd=" + f.getTermBlockOrd());
                }
                if (this.fr.getIndex() != null) {
                    long code;
                    ByteArrayDataInput reader2;
                    long codeOrig;
                    BytesRef output;
                    if (!(!isSeekFrame || f.getArc() != null)) {
                        boolean $i$a$-require-SegmentTermsEnum$printSeekState$22 = false;
                        String $i$a$-require-SegmentTermsEnum$printSeekState$22 = "isSeekFrame=" + isSeekFrame + " f.arc=" + f.getArc();
                        throw new IllegalArgumentException($i$a$-require-SegmentTermsEnum$printSeekState$22.toString());
                    }
                    if (f.getPrefixLength() > 0 && isSeekFrame) {
                        FST.Arc<BytesRef> arc = f.getArc();
                        Intrinsics.checkNotNull(arc);
                        if (arc.label() != (byte)(this.term.byteAt(f.getPrefixLength() - 1) & 0xFFFFFFFF)) {
                            FST.Arc<BytesRef> arc2 = f.getArc();
                            Intrinsics.checkNotNull(arc2);
                            out.println("      broken seek state: arc.label=" + (char)arc2.label() + " vs term byte=" + (char)(this.term.byteAt(f.getPrefixLength() - 1) & 0xFFFFFFFF));
                            throw new RuntimeException("seek state is broken");
                        }
                    }
                    if ((output = Util.INSTANCE.get(this.fr.getIndex(), prefix)) == null) {
                        out.println("      broken seek state: prefix is not final in index");
                        throw new RuntimeException("seek state is broken");
                    }
                    if (isSeekFrame && !f.isFloor() && (codeOrig = this.fr.readVLongOutput(reader2 = new ByteArrayDataInput(output.getBytes(), output.getOffset(), output.getLength()))) != (code = f.getFp() << 2 | (f.getHasTerms() ? 2L : 0L) | (f.isFloor() ? 1L : 0L))) {
                        out.println("      broken seek state: output code=" + codeOrig + " doesn't match frame code=" + code);
                        throw new RuntimeException("seek state is broken");
                    }
                }
                if (Intrinsics.areEqual((Object)f, (Object)this.currentFrame)) break;
                if (f.getPrefixLength() == this.validIndexPrefix) {
                    isSeekFrame = false;
                }
                ++ord;
            }
        }
    }

    @Override
    @Nullable
    public BytesRef next() throws IOException {
        boolean result;
        if (this.in == null) {
            FST.Arc<BytesRef> arc = null;
            if (this.fr.getIndex() != null) {
                FST<BytesRef> fST = this.fr.getIndex();
                FST.Arc<BytesRef> arc2 = this.arcs[0];
                Intrinsics.checkNotNull(arc2);
                arc = fST.getFirstArc(arc2);
                if (!arc.isFinal()) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            } else {
                arc = null;
            }
            this.currentFrame = this.pushFrame(arc, this.fr.getRootCode(), 0);
            this.currentFrame.loadBlock();
        }
        this.targetBeforeCurrentLength = this.currentFrame.getOrd();
        if (!(!this.eof)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.currentFrame == this.staticFrame && !(result = this.seekExact(this.term.get()))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (this.currentFrame.getNextEnt() == this.currentFrame.getEntCount()) {
            if (!this.currentFrame.isLastInFloor()) {
                this.currentFrame.loadNextFloorBlock();
                break;
            }
            if (this.currentFrame.getOrd() == 0) {
                if (!this.setEOF()) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.term.clear();
                this.validIndexPrefix = 0;
                this.currentFrame.rewind();
                this.termExists = false;
                return null;
            }
            long lastFP = this.currentFrame.getFpOrig();
            Intrinsics.checkNotNull((Object)this.stack[this.currentFrame.getOrd() - 1]);
            this.currentFrame = this.currentFrame;
            if (this.currentFrame.getNextEnt() == -1 || this.currentFrame.getLastSubFP() != lastFP) {
                this.currentFrame.scanToFloorFrame(this.term.get());
                this.currentFrame.loadBlock();
                this.currentFrame.scanToSubBlock(lastFP);
            }
            this.validIndexPrefix = Math.min(this.validIndexPrefix, this.currentFrame.getPrefixLength());
        }
        while (this.currentFrame.next()) {
            this.currentFrame = this.pushFrame(null, this.currentFrame.getLastSubFP(), this.term.length());
            this.currentFrame.loadBlock();
        }
        return this.term.get();
    }

    @Override
    @NotNull
    public BytesRef term() {
        if (!(!this.eof)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.term.get();
    }

    @Override
    public int docFreq() throws IOException {
        if (!(!this.eof)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentFrame.decodeMetaData();
        return this.currentFrame.getState().getDocFreq();
    }

    @Override
    public long totalTermFreq() throws IOException {
        if (!(!this.eof)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentFrame.decodeMetaData();
        return this.currentFrame.getState().getTotalTermFreq();
    }

    @Override
    @NotNull
    public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) throws IOException {
        if (!(!this.eof)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentFrame.decodeMetaData();
        return this.fr.getParent().getPostingsReader().postings(this.fr.getFieldInfo(), this.currentFrame.getState(), reuse, flags);
    }

    @Override
    @NotNull
    public ImpactsEnum impacts(int flags) throws IOException {
        if (!(!this.eof)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentFrame.decodeMetaData();
        return this.fr.getParent().getPostingsReader().impacts(this.fr.getFieldInfo(), this.currentFrame.getState(), flags);
    }

    @Override
    public void seekExact(@NotNull BytesRef target, @NotNull TermState otherState) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)otherState, (String)"otherState");
        if (!this.clearEOF()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (target.compareTo(this.term.get()) != 0 || !this.termExists) {
            if (!(otherState instanceof BlockTermState)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.currentFrame = this.staticFrame;
            this.currentFrame.getState().copyFrom(otherState);
            this.term.copyBytes(target);
            this.currentFrame.setMetaDataUpto(this.currentFrame.getTermBlockOrd());
            if (!(this.currentFrame.getMetaDataUpto() > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.validIndexPrefix = 0;
        }
    }

    @Override
    @NotNull
    public TermState termState() throws IOException {
        if (!(!this.eof)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentFrame.decodeMetaData();
        TermState ts = this.currentFrame.getState().clone();
        return ts;
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    private static final boolean prepareSeekExact$lambda$2() {
        return true;
    }

    private static final boolean prepareSeekExact$lambda$3(SegmentTermsEnum this$0, BytesRef $target) {
        this$0.currentFrame.loadBlock();
        TermsEnum.SeekStatus result = this$0.currentFrame.scanToTerm($target, true);
        return result == TermsEnum.SeekStatus.FOUND;
    }

    private static final boolean prepareSeekExact$lambda$4(SegmentTermsEnum this$0, BytesRef $target) {
        this$0.currentFrame.loadBlock();
        TermsEnum.SeekStatus result = this$0.currentFrame.scanToTerm($target, true);
        return result == TermsEnum.SeekStatus.FOUND;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020\u001eJ\u0006\u0010$\u001a\u00020\u001eJ\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0012H\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0016R$\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum$OutputAccumulator;", "Lorg/gnit/lucenekmp/store/DataInput;", "<init>", "()V", "outputs", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "getOutputs", "()[Lorg/gnit/lucenekmp/util/BytesRef;", "setOutputs", "([Lorg/gnit/lucenekmp/util/BytesRef;)V", "[Lorg/gnit/lucenekmp/util/BytesRef;", "current", "getCurrent", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setCurrent", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "num", "", "getNum", "()I", "setNum", "(I)V", "outputIndex", "getOutputIndex", "setOutputIndex", "index", "getIndex", "setIndex", "push", "", "output", "pop", "cnt", "outputCount", "reset", "prepareRead", "setFloorData", "floorData", "Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "readByte", "", "readBytes", "b", "", "offset", "len", "skipBytes", "numBytes", "", "core"})
    @SourceDebugExtension(value={"SMAP\nSegmentTermsEnum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentTermsEnum.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum$OutputAccumulator\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,1223:1\n217#2,5:1224\n189#2,2:1229\n222#2:1231\n*S KotlinDebug\n*F\n+ 1 SegmentTermsEnum.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum$OutputAccumulator\n*L\n1154#1:1224,5\n1154#1:1229,2\n1154#1:1231\n*E\n"})
    public static final class OutputAccumulator
    extends DataInput {
        @NotNull
        private BytesRef[] outputs = new BytesRef[16];
        @Nullable
        private BytesRef current;
        private int num;
        private int outputIndex;
        private int index;

        @NotNull
        public final BytesRef[] getOutputs() {
            return this.outputs;
        }

        public final void setOutputs(@NotNull BytesRef[] bytesRefArray) {
            Intrinsics.checkNotNullParameter((Object)bytesRefArray, (String)"<set-?>");
            this.outputs = bytesRefArray;
        }

        @Nullable
        public final BytesRef getCurrent() {
            return this.current;
        }

        public final void setCurrent(@Nullable BytesRef bytesRef) {
            this.current = bytesRef;
        }

        public final int getNum() {
            return this.num;
        }

        public final void setNum(int n) {
            this.num = n;
        }

        public final int getOutputIndex() {
            return this.outputIndex;
        }

        public final void setOutputIndex(int n) {
            this.outputIndex = n;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        /*
         * WARNING - void declaration
         */
        public final void push(@NotNull BytesRef output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            if (output != Lucene90BlockTreeTermsReader.Companion.getNO_OUTPUT()) {
                BytesRef[] bytesRefArray;
                void array$iv;
                void minSize$iv;
                if (!(output.getLength() > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                ArrayUtil.Companion companion = ArrayUtil.Companion;
                BytesRef[] bytesRefArray2 = this.outputs;
                int n = this.num + 1;
                OutputAccumulator outputAccumulator = this;
                boolean $i$f$growNullable = false;
                if (minSize$iv < 0) {
                    throw new Exception("size must be positive (got " + (int)minSize$iv + "): likely integer overflow?");
                }
                if (((void)array$iv).length < minSize$iv) {
                    void array$iv$iv;
                    void this_$iv;
                    int newLength$iv = this_$iv.oversize((int)minSize$iv, 4);
                    void var7_10 = this_$iv;
                    void var8_11 = array$iv;
                    int newLength$iv$iv = newLength$iv;
                    boolean $i$f$growExactNullable = false;
                    if (newLength$iv$iv < ((void)array$iv$iv).length) {
                        throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
                    }
                    BytesRef[] bytesRefArray3 = new BytesRef[newLength$iv$iv];
                    for (int i = 0; i < newLength$iv$iv; ++i) {
                        int n2 = i;
                        bytesRefArray3[n2] = n2 < ((void)array$iv$iv).length ? array$iv$iv[n2] : null;
                    }
                    bytesRefArray = bytesRefArray3;
                } else {
                    bytesRefArray = bytesRefArray2;
                }
                outputAccumulator.outputs = bytesRefArray;
                int n3 = this.num;
                this.num = n3 + 1;
                this.outputs[n3] = output;
            }
        }

        public final void pop(@NotNull BytesRef output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            if (output != Lucene90BlockTreeTermsReader.Companion.getNO_OUTPUT()) {
                if (!(this.num > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(this.outputs[this.num - 1] == output)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int n = this.num;
                this.num = n + -1;
            }
        }

        public final void pop(int cnt) {
            if (!(this.num >= cnt)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.num -= cnt;
        }

        public final int outputCount() {
            return this.num;
        }

        public final void reset() {
            this.num = 0;
        }

        public final void prepareRead() {
            this.index = 0;
            this.outputIndex = 0;
            this.current = this.outputs[0];
        }

        public final void setFloorData(@NotNull ByteArrayDataInput floorData) {
            Intrinsics.checkNotNullParameter((Object)floorData, (String)"floorData");
            if (!(this.outputIndex == this.num - 1)) {
                boolean bl = false;
                String string = "floor data should be stored in last arc, get outputIndex: " + this.outputIndex + ", num: " + this.num;
                throw new IllegalArgumentException(string.toString());
            }
            BytesRef bytesRef = this.outputs[this.outputIndex];
            Intrinsics.checkNotNull((Object)bytesRef);
            BytesRef output = bytesRef;
            floorData.reset(output.getBytes(), output.getOffset() + this.index, output.getLength() - this.index);
        }

        @Override
        public byte readByte() throws IOException {
            BytesRef bytesRef = this.current;
            Intrinsics.checkNotNull((Object)bytesRef);
            if (this.index >= bytesRef.getLength()) {
                ++this.outputIndex;
                this.current = this.outputs[this.outputIndex];
                this.index = 0;
            }
            BytesRef bytesRef2 = this.current;
            Intrinsics.checkNotNull((Object)bytesRef2);
            byte[] byArray = bytesRef2.getBytes();
            BytesRef bytesRef3 = this.current;
            Intrinsics.checkNotNull((Object)bytesRef3);
            int n = this.index;
            this.index = n + 1;
            return byArray[bytesRef3.getOffset() + n];
        }

        @Override
        public void readBytes(@NotNull byte[] b, int offset, int len) throws IOException {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            throw new UnsupportedOperationException();
        }

        @Override
        public void skipBytes(long numBytes) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

