/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.blocktree;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.BlockTermState;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.CompressionAlgorithm;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.SegmentTermsEnum;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.ByteArrayDataInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.fst.FST;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b2\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020pJ\u0006\u0010q\u001a\u00020\u0005J\u0006\u0010r\u001a\u00020nJ\u0006\u0010s\u001a\u00020nJ\u0006\u0010t\u001a\u00020nJ\u0006\u0010u\u001a\u00020nJ\u0006\u0010v\u001a\u00020\u000bJ\u0006\u0010w\u001a\u00020nJ\u0006\u0010x\u001a\u00020\u000bJ\u000e\u0010y\u001a\u00020n2\u0006\u0010z\u001a\u00020\u0017J\u0006\u0010{\u001a\u00020nJ\u0010\u0010|\u001a\u00020\u000b2\u0006\u0010z\u001a\u00020\u0017H\u0002J\u000e\u0010}\u001a\u00020n2\u0006\u0010~\u001a\u00020\u001dJ\u0018\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010z\u001a\u00020\u00172\u0007\u0010\u0081\u0001\u001a\u00020\u000bJ\u0019\u0010\u008b\u0001\u001a\u00030\u0080\u00012\u0006\u0010z\u001a\u00020\u00172\u0007\u0010\u0081\u0001\u001a\u00020\u000bJ\u0019\u0010\u008c\u0001\u001a\u00030\u0080\u00012\u0006\u0010z\u001a\u00020\u00172\u0007\u0010\u0081\u0001\u001a\u00020\u000bJ\u0019\u0010\u008d\u0001\u001a\u00030\u0080\u00012\u0006\u0010z\u001a\u00020\u00172\u0007\u0010\u0081\u0001\u001a\u00020\u000bJ\t\u0010\u008e\u0001\u001a\u00020nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u000fR\"\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010.\"\u0004\b7\u00100R\u0011\u00108\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00104R\u001a\u0010:\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010.\"\u0004\b<\u00100R\u001a\u0010=\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\t\"\u0004\b?\u0010@R\u0011\u0010A\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00104R\u001a\u0010C\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\t\"\u0004\bE\u0010@R\u0011\u0010F\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u00104R\u001a\u0010H\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\t\"\u0004\bJ\u0010@R\u001a\u0010K\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\t\"\u0004\bM\u0010@R\u001a\u0010N\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010\t\"\u0004\bP\u0010@R\u001a\u0010Q\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\r\"\u0004\bR\u0010\u000fR\u001a\u0010S\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\r\"\u0004\bT\u0010\u000fR\u001a\u0010U\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\r\"\u0004\bW\u0010\u000fR\u001a\u0010X\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u001f\"\u0004\bZ\u0010!R\u001a\u0010[\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\t\"\u0004\b]\u0010@R\u001a\u0010^\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010\t\"\u0004\b`\u0010@R\u001a\u0010a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\t\"\u0004\bc\u0010@R\u0011\u0010d\u001a\u00020e\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010gR\u001a\u0010h\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010.\"\u0004\bj\u00100R\u0011\u0010k\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u00104R\u000f\u0010\u0082\u0001\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0083\u0001\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0084\u0001\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0085\u0001\u001a\u00030\u0086\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001\u00a8\u0006\u008f\u0001"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnumFrame;", "", "ste", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum;", "ord", "", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum;I)V", "getOrd", "()I", "hasTerms", "", "getHasTerms", "()Z", "setHasTerms", "(Z)V", "hasTermsOrig", "getHasTermsOrig", "setHasTermsOrig", "isFloor", "setFloor", "arc", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "Lorg/gnit/lucenekmp/util/BytesRef;", "getArc", "()Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "setArc", "(Lorg/gnit/lucenekmp/util/fst/FST$Arc;)V", "fp", "", "getFp", "()J", "setFp", "(J)V", "fpOrig", "getFpOrig", "setFpOrig", "fpEnd", "getFpEnd", "setFpEnd", "totalSuffixBytes", "getTotalSuffixBytes", "setTotalSuffixBytes", "suffixBytes", "", "getSuffixBytes", "()[B", "setSuffixBytes", "([B)V", "suffixesReader", "Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "getSuffixesReader", "()Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "suffixLengthBytes", "getSuffixLengthBytes", "setSuffixLengthBytes", "suffixLengthsReader", "getSuffixLengthsReader", "statBytes", "getStatBytes", "setStatBytes", "statsSingletonRunLength", "getStatsSingletonRunLength", "setStatsSingletonRunLength", "(I)V", "statsReader", "getStatsReader", "rewindPos", "getRewindPos", "setRewindPos", "floorDataReader", "getFloorDataReader", "prefixLength", "getPrefixLength", "setPrefixLength", "entCount", "getEntCount", "setEntCount", "nextEnt", "getNextEnt", "setNextEnt", "isLastInFloor", "setLastInFloor", "isLeafBlock", "setLeafBlock", "allEqual", "getAllEqual", "setAllEqual", "lastSubFP", "getLastSubFP", "setLastSubFP", "nextFloorLabel", "getNextFloorLabel", "setNextFloorLabel", "numFollowFloorBlocks", "getNumFollowFloorBlocks", "setNumFollowFloorBlocks", "metaDataUpto", "getMetaDataUpto", "setMetaDataUpto", "state", "Lorg/gnit/lucenekmp/codecs/BlockTermState;", "getState", "()Lorg/gnit/lucenekmp/codecs/BlockTermState;", "bytes", "getBytes", "setBytes", "bytesReader", "getBytesReader", "setFloorData", "", "outputAccumulator", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnum$OutputAccumulator;", "getTermBlockOrd", "loadNextFloorBlock", "prefetchBlock", "loadBlock", "rewind", "next", "nextLeaf", "nextNonLeaf", "scanToFloorFrame", "target", "decodeMetaData", "prefixMatches", "scanToSubBlock", "subFP", "scanToTerm", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "exactOnly", "startBytePos", "suffixLength", "subCode", "compressionAlg", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/CompressionAlgorithm;", "getCompressionAlg", "()Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/CompressionAlgorithm;", "setCompressionAlg", "(Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/CompressionAlgorithm;)V", "scanToTermLeaf", "binarySearchTermLeaf", "scanToTermNonLeaf", "fillTerm", "core"})
@SourceDebugExtension(value={"SMAP\nSegmentTermsEnumFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentTermsEnumFrame.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnumFrame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,861:1\n1#2:862\n*E\n"})
public final class SegmentTermsEnumFrame {
    @NotNull
    private final SegmentTermsEnum ste;
    private final int ord;
    private boolean hasTerms;
    private boolean hasTermsOrig;
    private boolean isFloor;
    @Nullable
    private FST.Arc<BytesRef> arc;
    private long fp;
    private long fpOrig;
    private long fpEnd;
    private long totalSuffixBytes;
    @NotNull
    private byte[] suffixBytes;
    @NotNull
    private final ByteArrayDataInput suffixesReader;
    @NotNull
    private byte[] suffixLengthBytes;
    @NotNull
    private final ByteArrayDataInput suffixLengthsReader;
    @NotNull
    private byte[] statBytes;
    private int statsSingletonRunLength;
    @NotNull
    private final ByteArrayDataInput statsReader;
    private int rewindPos;
    @NotNull
    private final ByteArrayDataInput floorDataReader;
    private int prefixLength;
    private int entCount;
    private int nextEnt;
    private boolean isLastInFloor;
    private boolean isLeafBlock;
    private boolean allEqual;
    private long lastSubFP;
    private int nextFloorLabel;
    private int numFollowFloorBlocks;
    private int metaDataUpto;
    @NotNull
    private final BlockTermState state;
    @NotNull
    private byte[] bytes;
    @NotNull
    private final ByteArrayDataInput bytesReader;
    private int startBytePos;
    private int suffixLength;
    private long subCode;
    @NotNull
    private CompressionAlgorithm compressionAlg;

    public SegmentTermsEnumFrame(@NotNull SegmentTermsEnum ste, int ord) {
        Intrinsics.checkNotNullParameter((Object)ste, (String)"ste");
        this.ste = ste;
        this.ord = ord;
        this.suffixBytes = new byte[128];
        this.suffixesReader = new ByteArrayDataInput();
        this.statBytes = new byte[64];
        this.statsReader = new ByteArrayDataInput();
        this.floorDataReader = new ByteArrayDataInput();
        this.state = this.ste.getFr().getParent().getPostingsReader().newTermState();
        this.bytes = new byte[32];
        this.bytesReader = new ByteArrayDataInput();
        this.compressionAlg = CompressionAlgorithm.NO_COMPRESSION;
        this.state.setTotalTermFreq(-1L);
        this.suffixLengthBytes = new byte[32];
        this.suffixLengthsReader = new ByteArrayDataInput();
    }

    public final int getOrd() {
        return this.ord;
    }

    public final boolean getHasTerms() {
        return this.hasTerms;
    }

    public final void setHasTerms(boolean bl) {
        this.hasTerms = bl;
    }

    public final boolean getHasTermsOrig() {
        return this.hasTermsOrig;
    }

    public final void setHasTermsOrig(boolean bl) {
        this.hasTermsOrig = bl;
    }

    public final boolean isFloor() {
        return this.isFloor;
    }

    public final void setFloor(boolean bl) {
        this.isFloor = bl;
    }

    @Nullable
    public final FST.Arc<BytesRef> getArc() {
        return this.arc;
    }

    public final void setArc(@Nullable FST.Arc<BytesRef> arc) {
        this.arc = arc;
    }

    public final long getFp() {
        return this.fp;
    }

    public final void setFp(long l) {
        this.fp = l;
    }

    public final long getFpOrig() {
        return this.fpOrig;
    }

    public final void setFpOrig(long l) {
        this.fpOrig = l;
    }

    public final long getFpEnd() {
        return this.fpEnd;
    }

    public final void setFpEnd(long l) {
        this.fpEnd = l;
    }

    public final long getTotalSuffixBytes() {
        return this.totalSuffixBytes;
    }

    public final void setTotalSuffixBytes(long l) {
        this.totalSuffixBytes = l;
    }

    @NotNull
    public final byte[] getSuffixBytes() {
        return this.suffixBytes;
    }

    public final void setSuffixBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.suffixBytes = byArray;
    }

    @NotNull
    public final ByteArrayDataInput getSuffixesReader() {
        return this.suffixesReader;
    }

    @NotNull
    public final byte[] getSuffixLengthBytes() {
        return this.suffixLengthBytes;
    }

    public final void setSuffixLengthBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.suffixLengthBytes = byArray;
    }

    @NotNull
    public final ByteArrayDataInput getSuffixLengthsReader() {
        return this.suffixLengthsReader;
    }

    @NotNull
    public final byte[] getStatBytes() {
        return this.statBytes;
    }

    public final void setStatBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.statBytes = byArray;
    }

    public final int getStatsSingletonRunLength() {
        return this.statsSingletonRunLength;
    }

    public final void setStatsSingletonRunLength(int n) {
        this.statsSingletonRunLength = n;
    }

    @NotNull
    public final ByteArrayDataInput getStatsReader() {
        return this.statsReader;
    }

    public final int getRewindPos() {
        return this.rewindPos;
    }

    public final void setRewindPos(int n) {
        this.rewindPos = n;
    }

    @NotNull
    public final ByteArrayDataInput getFloorDataReader() {
        return this.floorDataReader;
    }

    public final int getPrefixLength() {
        return this.prefixLength;
    }

    public final void setPrefixLength(int n) {
        this.prefixLength = n;
    }

    public final int getEntCount() {
        return this.entCount;
    }

    public final void setEntCount(int n) {
        this.entCount = n;
    }

    public final int getNextEnt() {
        return this.nextEnt;
    }

    public final void setNextEnt(int n) {
        this.nextEnt = n;
    }

    public final boolean isLastInFloor() {
        return this.isLastInFloor;
    }

    public final void setLastInFloor(boolean bl) {
        this.isLastInFloor = bl;
    }

    public final boolean isLeafBlock() {
        return this.isLeafBlock;
    }

    public final void setLeafBlock(boolean bl) {
        this.isLeafBlock = bl;
    }

    public final boolean getAllEqual() {
        return this.allEqual;
    }

    public final void setAllEqual(boolean bl) {
        this.allEqual = bl;
    }

    public final long getLastSubFP() {
        return this.lastSubFP;
    }

    public final void setLastSubFP(long l) {
        this.lastSubFP = l;
    }

    public final int getNextFloorLabel() {
        return this.nextFloorLabel;
    }

    public final void setNextFloorLabel(int n) {
        this.nextFloorLabel = n;
    }

    public final int getNumFollowFloorBlocks() {
        return this.numFollowFloorBlocks;
    }

    public final void setNumFollowFloorBlocks(int n) {
        this.numFollowFloorBlocks = n;
    }

    public final int getMetaDataUpto() {
        return this.metaDataUpto;
    }

    public final void setMetaDataUpto(int n) {
        this.metaDataUpto = n;
    }

    @NotNull
    public final BlockTermState getState() {
        return this.state;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final void setBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.bytes = byArray;
    }

    @NotNull
    public final ByteArrayDataInput getBytesReader() {
        return this.bytesReader;
    }

    public final void setFloorData(@NotNull SegmentTermsEnum.OutputAccumulator outputAccumulator) {
        Intrinsics.checkNotNullParameter((Object)outputAccumulator, (String)"outputAccumulator");
        outputAccumulator.setFloorData(this.floorDataReader);
        this.rewindPos = this.floorDataReader.getPosition();
        this.numFollowFloorBlocks = this.floorDataReader.readVInt();
        this.nextFloorLabel = (byte)(this.floorDataReader.readByte() & 0xFFFFFFFF);
    }

    public final int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.state.getTermBlockOrd();
    }

    public final void loadNextFloorBlock() throws IOException {
        if (!(this.arc == null || this.isFloor)) {
            boolean bl = false;
            String string = "arc=" + this.arc + " isFloor=" + this.isFloor;
            throw new IllegalArgumentException(string.toString());
        }
        this.fp = this.fpEnd;
        this.nextEnt = -1;
        this.loadBlock();
    }

    public final void prefetchBlock() throws IOException {
        if (this.nextEnt != -1) {
            return;
        }
        this.ste.initIndexInput();
        IndexInput indexInput = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput);
        indexInput.prefetch(this.fp, 1L);
    }

    public final void loadBlock() throws IOException {
        this.ste.initIndexInput();
        if (this.nextEnt != -1) {
            return;
        }
        IndexInput indexInput = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput);
        indexInput.seek(this.fp);
        IndexInput indexInput2 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput2);
        int code = indexInput2.readVInt();
        this.entCount = code >>> 1;
        if (!(this.entCount > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.isLastInFloor = (code & 1) != 0;
        if (!(this.arc == null || this.isLastInFloor || this.isFloor)) {
            boolean bl = false;
            String string = "fp=" + this.fp + " arc=" + this.arc + " isFloor=" + this.isFloor + " isLastInFloor=" + this.isLastInFloor;
            throw new IllegalArgumentException(string.toString());
        }
        IndexInput indexInput3 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput3);
        long startSuffixFP = indexInput3.getFilePointer();
        IndexInput indexInput4 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput4);
        long codeL = indexInput4.readVLong();
        this.isLeafBlock = (codeL & 4L) != 0L;
        int numSuffixBytes = (int)(codeL >>> 3);
        if (this.suffixBytes.length < numSuffixBytes) {
            this.suffixBytes = new byte[ArrayUtil.Companion.oversize(numSuffixBytes, 1)];
        }
        try {
            this.compressionAlg = CompressionAlgorithm.Companion.byCode((int)codeL & 3);
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            IndexInput indexInput5 = this.ste.getIn();
            Intrinsics.checkNotNull((Object)indexInput5);
            throw new CorruptIndexException(string, indexInput5, (Throwable)e);
        }
        IndexInput indexInput6 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput6);
        this.compressionAlg.read(indexInput6, this.suffixBytes, numSuffixBytes);
        this.suffixesReader.reset(this.suffixBytes, 0, numSuffixBytes);
        IndexInput indexInput7 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput7);
        int numSuffixLengthBytes = indexInput7.readVInt();
        boolean bl = this.allEqual = (numSuffixLengthBytes & 1) != 0;
        if (this.suffixLengthBytes.length < (numSuffixLengthBytes >>>= 1)) {
            this.suffixLengthBytes = new byte[ArrayUtil.Companion.oversize(numSuffixLengthBytes, 1)];
        }
        if (this.allEqual) {
            IndexInput indexInput8 = this.ste.getIn();
            Intrinsics.checkNotNull((Object)indexInput8);
            Arrays.INSTANCE.fill(this.suffixLengthBytes, 0, numSuffixLengthBytes, indexInput8.readByte());
        } else {
            IndexInput indexInput9 = this.ste.getIn();
            Intrinsics.checkNotNull((Object)indexInput9);
            indexInput9.readBytes(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        }
        this.suffixLengthsReader.reset(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        IndexInput indexInput10 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput10);
        this.totalSuffixBytes = indexInput10.getFilePointer() - startSuffixFP;
        IndexInput indexInput11 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput11);
        int numBytes = indexInput11.readVInt();
        if (this.statBytes.length < numBytes) {
            this.statBytes = new byte[ArrayUtil.Companion.oversize(numBytes, 1)];
        }
        IndexInput indexInput12 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput12);
        indexInput12.readBytes(this.statBytes, 0, numBytes);
        this.statsReader.reset(this.statBytes, 0, numBytes);
        this.statsSingletonRunLength = 0;
        this.metaDataUpto = 0;
        this.state.setTermBlockOrd(0);
        this.nextEnt = 0;
        this.lastSubFP = -1L;
        IndexInput indexInput13 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput13);
        numBytes = indexInput13.readVInt();
        if (this.bytes.length < numBytes) {
            this.bytes = new byte[ArrayUtil.Companion.oversize(numBytes, 1)];
        }
        IndexInput indexInput14 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput14);
        indexInput14.readBytes(this.bytes, 0, numBytes);
        this.bytesReader.reset(this.bytes, 0, numBytes);
        IndexInput indexInput15 = this.ste.getIn();
        Intrinsics.checkNotNull((Object)indexInput15);
        this.fpEnd = indexInput15.getFilePointer();
    }

    public final void rewind() {
        this.fp = this.fpOrig;
        this.nextEnt = -1;
        this.hasTerms = this.hasTermsOrig;
        if (this.isFloor) {
            this.floorDataReader.setPosition(this.rewindPos);
            this.numFollowFloorBlocks = this.floorDataReader.readVInt();
            if (!(this.numFollowFloorBlocks > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.nextFloorLabel = (byte)(this.floorDataReader.readByte() & 0xFFFFFFFF);
        }
    }

    public final boolean next() throws IOException {
        if (this.isLeafBlock) {
            this.nextLeaf();
            return false;
        }
        return this.nextNonLeaf();
    }

    public final void nextLeaf() {
        if (!(this.nextEnt != -1 && this.nextEnt < this.entCount)) {
            boolean bl = false;
            String string = "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.nextEnt;
        this.nextEnt = n + 1;
        this.suffixLength = this.suffixLengthsReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.ste.getTerm().setLength(this.prefixLength + this.suffixLength);
        this.ste.getTerm().grow(this.ste.getTerm().length());
        this.suffixesReader.readBytes(this.ste.getTerm().bytes(), this.prefixLength, this.suffixLength);
        this.ste.setTermExists(true);
    }

    public final boolean nextNonLeaf() throws IOException {
        while (this.nextEnt == this.entCount) {
            if (!(this.arc == null || this.isFloor && !this.isLastInFloor)) {
                boolean $i$a$-require-SegmentTermsEnumFrame$nextNonLeaf$32 = false;
                String $i$a$-require-SegmentTermsEnumFrame$nextNonLeaf$32 = "isFloor=" + this.isFloor + " isLastInFloor=" + this.isLastInFloor;
                throw new IllegalArgumentException($i$a$-require-SegmentTermsEnumFrame$nextNonLeaf$32.toString());
            }
            this.loadNextFloorBlock();
            if (!this.isLeafBlock) continue;
            this.nextLeaf();
            return false;
        }
        if (!(this.nextEnt != -1 && this.nextEnt < this.entCount)) {
            boolean bl = false;
            String string = "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.nextEnt;
        this.nextEnt = n + 1;
        int code = this.suffixLengthsReader.readVInt();
        this.suffixLength = code >>> 1;
        this.startBytePos = this.suffixesReader.getPosition();
        this.ste.getTerm().setLength(this.prefixLength + this.suffixLength);
        this.ste.getTerm().grow(this.ste.getTerm().length());
        this.suffixesReader.readBytes(this.ste.getTerm().bytes(), this.prefixLength, this.suffixLength);
        if ((code & 1) == 0) {
            this.ste.setTermExists(true);
            this.subCode = 0L;
            BlockTermState blockTermState = this.state;
            int n2 = blockTermState.getTermBlockOrd();
            blockTermState.setTermBlockOrd(n2 + 1);
            return false;
        }
        this.ste.setTermExists(false);
        this.subCode = this.suffixLengthsReader.readVLong();
        this.lastSubFP = this.fp - this.subCode;
        return true;
    }

    public final void scanToFloorFrame(@NotNull BytesRef target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.isFloor || target.getLength() <= this.prefixLength) {
            return;
        }
        byte targetLabel = (byte)(target.getBytes()[target.getOffset() + this.prefixLength] & 0xFFFFFFFF);
        if (targetLabel < this.nextFloorLabel) {
            return;
        }
        if (!(this.numFollowFloorBlocks != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long newFP = this.fpOrig;
        do {
            long code = this.floorDataReader.readVLong();
            newFP = this.fpOrig + (code >>> 1);
            this.hasTerms = (code & 1L) != 0L;
            this.isLastInFloor = this.numFollowFloorBlocks == 1;
            int n = this.numFollowFloorBlocks;
            this.numFollowFloorBlocks = n + -1;
            if (this.isLastInFloor) {
                this.nextFloorLabel = 256;
                break;
            }
            this.nextFloorLabel = (byte)(this.floorDataReader.readByte() & 0xFFFFFFFF);
        } while (targetLabel >= this.nextFloorLabel);
        if (newFP != this.fp) {
            this.nextEnt = -1;
            this.fp = newFP;
        }
    }

    public final void decodeMetaData() throws IOException {
        int limit = this.getTermBlockOrd();
        boolean absolute = this.metaDataUpto == 0;
        if (!(limit > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (this.metaDataUpto < limit) {
            int n;
            if (this.statsSingletonRunLength > 0) {
                this.state.setDocFreq(1);
                this.state.setTotalTermFreq(1L);
                n = this.statsSingletonRunLength;
                this.statsSingletonRunLength = n + -1;
            } else {
                int token = this.statsReader.readVInt();
                if ((token & 1) == 1) {
                    this.state.setDocFreq(1);
                    this.state.setTotalTermFreq(1L);
                    this.statsSingletonRunLength = token >>> 1;
                } else {
                    this.state.setDocFreq(token >>> 1);
                    if (this.ste.getFr().getFieldInfo().getIndexOptions() == IndexOptions.DOCS) {
                        this.state.setTotalTermFreq(this.state.getDocFreq());
                    } else {
                        this.state.setTotalTermFreq((long)this.state.getDocFreq() + this.statsReader.readVLong());
                    }
                }
            }
            this.ste.getFr().getParent().getPostingsReader().decodeTerm(this.bytesReader, this.ste.getFr().getFieldInfo(), this.state, absolute);
            n = this.metaDataUpto;
            this.metaDataUpto = n + 1;
            absolute = false;
        }
        this.state.setTermBlockOrd(this.metaDataUpto);
    }

    private final boolean prefixMatches(BytesRef target) {
        int n = this.prefixLength;
        for (int bytePos = 0; bytePos < n; ++bytePos) {
            if (target.getBytes()[target.getOffset() + bytePos] == this.ste.getTerm().byteAt(bytePos)) continue;
            return false;
        }
        return true;
    }

    public final void scanToSubBlock(long subFP) {
        if (!(!this.isLeafBlock)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.lastSubFP == subFP) {
            return;
        }
        if (!(subFP < this.fp)) {
            boolean bl = false;
            String string = "fp=" + this.fp + " subFP=" + subFP;
            throw new IllegalArgumentException(string.toString());
        }
        long targetSubCode = this.fp - subFP;
        while (true) {
            if (!(this.nextEnt < this.entCount)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = this.nextEnt;
            this.nextEnt = n + 1;
            int code = this.suffixLengthsReader.readVInt();
            this.suffixesReader.skipBytes((long)code >>> 1);
            if ((code & 1) != 0) {
                long subCode = this.suffixLengthsReader.readVLong();
                if (targetSubCode != subCode) continue;
                this.lastSubFP = subFP;
                return;
            }
            BlockTermState blockTermState = this.state;
            int n2 = blockTermState.getTermBlockOrd();
            blockTermState.setTermBlockOrd(n2 + 1);
        }
    }

    @NotNull
    public final TermsEnum.SeekStatus scanToTerm(@NotNull BytesRef target, boolean exactOnly) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.isLeafBlock ? (this.allEqual ? this.binarySearchTermLeaf(target, exactOnly) : this.scanToTermLeaf(target, exactOnly)) : this.scanToTermNonLeaf(target, exactOnly);
    }

    @NotNull
    public final CompressionAlgorithm getCompressionAlg() {
        return this.compressionAlg;
    }

    public final void setCompressionAlg(@NotNull CompressionAlgorithm compressionAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)compressionAlgorithm), (String)"<set-?>");
        this.compressionAlg = compressionAlgorithm;
    }

    @NotNull
    public final TermsEnum.SeekStatus scanToTermLeaf(@NotNull BytesRef target, boolean exactOnly) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(this.nextEnt != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.ste.setTermExists(true);
        this.subCode = 0L;
        if (this.nextEnt == this.entCount) {
            if (exactOnly) {
                this.fillTerm();
            }
            return TermsEnum.SeekStatus.END;
        }
        if (!this.prefixMatches(target)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        do {
            int n = this.nextEnt;
            this.nextEnt = n + 1;
            this.suffixLength = this.suffixLengthsReader.readVInt();
            this.startBytePos = this.suffixesReader.getPosition();
            this.suffixesReader.skipBytes(this.suffixLength);
            int cmp = Arrays.INSTANCE.compareUnsigned(this.suffixBytes, this.startBytePos, this.startBytePos + this.suffixLength, target.getBytes(), target.getOffset() + this.prefixLength, target.getOffset() + target.getLength());
            if (cmp < 0) continue;
            if (cmp > 0) {
                this.fillTerm();
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        } while (this.nextEnt < this.entCount);
        if (exactOnly) {
            this.fillTerm();
        }
        return TermsEnum.SeekStatus.END;
    }

    @NotNull
    public final TermsEnum.SeekStatus binarySearchTermLeaf(@NotNull BytesRef target, boolean exactOnly) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(this.nextEnt != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.ste.setTermExists(true);
        this.subCode = 0L;
        if (this.nextEnt == this.entCount) {
            if (exactOnly) {
                this.fillTerm();
            }
            return TermsEnum.SeekStatus.END;
        }
        if (!this.prefixMatches(target)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.suffixLength = this.suffixLengthsReader.readVInt();
        int start = this.nextEnt;
        int end = this.entCount - 1;
        int cmp = 0;
        while (start <= end) {
            int mid = start + end >>> 1;
            this.nextEnt = mid + 1;
            this.startBytePos = mid * this.suffixLength;
            cmp = Arrays.INSTANCE.compareUnsigned(this.suffixBytes, this.startBytePos, this.startBytePos + this.suffixLength, target.getBytes(), target.getOffset() + this.prefixLength, target.getOffset() + target.getLength());
            if (cmp < 0) {
                start = mid + 1;
                continue;
            }
            if (cmp > 0) {
                end = mid - 1;
                continue;
            }
            this.suffixesReader.setPosition(this.startBytePos + this.suffixLength);
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        }
        TermsEnum.SeekStatus seekStatus = null;
        if (end < this.entCount - 1) {
            seekStatus = TermsEnum.SeekStatus.NOT_FOUND;
            if (cmp < 0) {
                this.startBytePos += this.suffixLength;
                int n = this.nextEnt;
                this.nextEnt = n + 1;
            }
            this.suffixesReader.setPosition(this.startBytePos + this.suffixLength);
            this.fillTerm();
        } else {
            seekStatus = TermsEnum.SeekStatus.END;
            this.suffixesReader.setPosition(this.startBytePos + this.suffixLength);
            if (exactOnly) {
                this.fillTerm();
            }
        }
        return seekStatus;
    }

    @NotNull
    public final TermsEnum.SeekStatus scanToTermNonLeaf(@NotNull BytesRef target, boolean exactOnly) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(this.nextEnt != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.nextEnt == this.entCount) {
            if (exactOnly) {
                this.fillTerm();
                this.ste.setTermExists(this.subCode == 0L);
            }
            return TermsEnum.SeekStatus.END;
        }
        if (!this.prefixMatches(target)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (this.nextEnt < this.entCount) {
            int cmp;
            int n = this.nextEnt;
            this.nextEnt = n + 1;
            int code = this.suffixLengthsReader.readVInt();
            this.suffixLength = code >>> 1;
            this.startBytePos = this.suffixesReader.getPosition();
            this.suffixesReader.skipBytes(this.suffixLength);
            this.ste.setTermExists((code & 1) == 0);
            if (this.ste.getTermExists()) {
                BlockTermState blockTermState = this.state;
                int n2 = blockTermState.getTermBlockOrd();
                blockTermState.setTermBlockOrd(n2 + 1);
                this.subCode = 0L;
            } else {
                this.subCode = this.suffixLengthsReader.readVLong();
                this.lastSubFP = this.fp - this.subCode;
            }
            if ((cmp = Arrays.INSTANCE.compareUnsigned(this.suffixBytes, this.startBytePos, this.startBytePos + this.suffixLength, target.getBytes(), target.getOffset() + this.prefixLength, target.getOffset() + target.getLength())) < 0) continue;
            if (cmp > 0) {
                this.fillTerm();
                if (!exactOnly && !this.ste.getTermExists()) {
                    this.ste.setCurrentFrame(this.ste.pushFrame(null, this.ste.getCurrentFrame().lastSubFP, this.prefixLength + this.suffixLength));
                    this.ste.getCurrentFrame().loadBlock();
                    while (this.ste.getCurrentFrame().next()) {
                        this.ste.setCurrentFrame(this.ste.pushFrame(null, this.ste.getCurrentFrame().lastSubFP, this.ste.getTerm().length()));
                        this.ste.getCurrentFrame().loadBlock();
                    }
                }
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            if (!this.ste.getTermExists()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        }
        if (exactOnly) {
            this.fillTerm();
        }
        return TermsEnum.SeekStatus.END;
    }

    private final void fillTerm() {
        int termLength = this.prefixLength + this.suffixLength;
        this.ste.getTerm().setLength(termLength);
        this.ste.getTerm().grow(termLength);
        System.INSTANCE.arraycopy(this.suffixBytes, this.startBytePos, this.ste.getTerm().bytes(), this.prefixLength, this.suffixLength);
    }
}

